<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw cockpit`
Cockpit API.
  
- [Managed alerts management commands](#managed-alerts-management-commands)
  - [Disable the sending of managed alerts for the specified Project's Cockpit](#disable-the-sending-of-managed-alerts-for-the-specified-project's-cockpit)
  - [Enable the sending of managed alerts for the specified Project's Cockpit](#enable-the-sending-of-managed-alerts-for-the-specified-project's-cockpit)
  - [Trigger a test alert to all of the Cockpit's receivers](#trigger-a-test-alert-to-all-of-the-cockpit's-receivers)
- [Cockpit management commands](#cockpit-management-commands)
  - [Activate the Cockpit of the specified Project ID](#activate-the-cockpit-of-the-specified-project-id)
  - [Deactivate the Cockpit of the specified Project ID](#deactivate-the-cockpit-of-the-specified-project-id)
  - [Retrieve the Cockpit of the specified Project ID](#retrieve-the-cockpit-of-the-specified-project-id)
  - [Wait for a cockpit to reach a stable state (installation)](#wait-for-a-cockpit-to-reach-a-stable-state-(installation))
- [Contacts management commands](#contacts-management-commands)
  - [Create a contact point to receive alerts for the default receiver](#create-a-contact-point-to-receive-alerts-for-the-default-receiver)
  - [Delete a contact point for the default receiver](#delete-a-contact-point-for-the-default-receiver)
  - [Get a list of contact points for the Cockpit associated with the specified Project ID](#get-a-list-of-contact-points-for-the-cockpit-associated-with-the-specified-project-id)
- [Datasource management commands](#datasource-management-commands)
- [Grafana user management commands](#grafana-user-management-commands)
  - [Create a Grafana user for your Cockpit's Grafana instance. Make sure you save the automatically-generated password and the Grafana user ID](#create-a-grafana-user-for-your-cockpit's-grafana-instance.-make-sure-you-save-the-automatically-generated-password-and-the-grafana-user-id)
  - [Delete a Grafana user from a Grafana instance, specified by the Cockpit's Project ID and the Grafana user ID](#delete-a-grafana-user-from-a-grafana-instance,-specified-by-the-cockpit's-project-id-and-the-grafana-user-id)
  - [Get a list of Grafana users who are able to connect to the Cockpit's Grafana instance](#get-a-list-of-grafana-users-who-are-able-to-connect-to-the-cockpit's-grafana-instance)
  - [Reset a Grafana user's password specified by the Cockpit's Project ID and the Grafana user ID](#reset-a-grafana-user's-password-specified-by-the-cockpit's-project-id-and-the-grafana-user-id)
- [Pricing plans management commands](#pricing-plans-management-commands)
  - [Get a list of all pricing plans available](#get-a-list-of-all-pricing-plans-available)
  - [Select your chosen pricing plan for your Cockpit, specifying the Cockpit's Project ID and the pricing plan's ID in the request](#select-your-chosen-pricing-plan-for-your-cockpit,-specifying-the-cockpit's-project-id-and-the-pricing-plan's-id-in-the-request)
- [Product dashboards management commands](#product-dashboards-management-commands)
- [Token management commands](#token-management-commands)
  - [Create a token associated with the specified Project ID](#create-a-token-associated-with-the-specified-project-id)
  - [Delete the token associated with the specified token ID](#delete-the-token-associated-with-the-specified-token-id)
  - [Retrieve the token associated with the specified token ID](#retrieve-the-token-associated-with-the-specified-token-id)
  - [Get a list of tokens associated with the specified Project ID](#get-a-list-of-tokens-associated-with-the-specified-project-id)

  
## Managed alerts management commands

Managed alerts management commands.


### Disable the sending of managed alerts for the specified Project's Cockpit

Disable the sending of managed alerts for the specified Project's Cockpit.

**Usage:**

```
scw cockpit alert disable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Enable the sending of managed alerts for the specified Project's Cockpit

Enable the sending of managed alerts for the specified Project's Cockpit.

**Usage:**

```
scw cockpit alert enable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Trigger a test alert to all of the Cockpit's receivers

Trigger a test alert to all of the Cockpit's receivers.

**Usage:**

```
scw cockpit alert test [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



## Cockpit management commands

Cockpit management commands.


### Activate the Cockpit of the specified Project ID

Activate the Cockpit of the specified Project ID.

**Usage:**

```
scw cockpit cockpit activate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Deactivate the Cockpit of the specified Project ID

Deactivate the Cockpit of the specified Project ID.

**Usage:**

```
scw cockpit cockpit deactivate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Retrieve the Cockpit of the specified Project ID

Retrieve the Cockpit of the specified Project ID.

**Usage:**

```
scw cockpit cockpit get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Wait for a cockpit to reach a stable state (installation)

Wait for a cockpit to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the cockpit.

**Usage:**

```
scw cockpit cockpit wait <project-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id | Required | The ID of the project the cockpit is attached to |
| timeout | Default: `3m0s` | Timeout of the wait |


**Examples:**


Wait for a cockpit to reach a stable state
```
scw cockpit cockpit wait 11111111-1111-1111-1111-111111111111
```




## Contacts management commands

Contacts management commands.


### Create a contact point to receive alerts for the default receiver

Create a contact point to receive alerts for the default receiver.

**Usage:**

```
scw cockpit contact create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| contact-point.email.to |  |  |



### Delete a contact point for the default receiver

Delete a contact point for the default receiver.

**Usage:**

```
scw cockpit contact delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| contact-point.email.to |  |  |



### Get a list of contact points for the Cockpit associated with the specified Project ID

Get a list of contact points for the Cockpit associated with the specified Project ID.

**Usage:**

```
scw cockpit contact list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



## Datasource management commands

Datasource management commands.

Datasource management commands.

**Usage:**

```
scw cockpit datasource
```



## Grafana user management commands

Grafana user management commands.


### Create a Grafana user for your Cockpit's Grafana instance. Make sure you save the automatically-generated password and the Grafana user ID

Create a Grafana user for your Cockpit's Grafana instance. Make sure you save the automatically-generated password and the Grafana user ID.

**Usage:**

```
scw cockpit grafana-user create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| login |  | Username of the Grafana user |
| role | One of: `unknown_role`, `editor`, `viewer` | Role assigned to the Grafana user |



### Delete a Grafana user from a Grafana instance, specified by the Cockpit's Project ID and the Grafana user ID

Delete a Grafana user from a Grafana instance, specified by the Cockpit's Project ID and the Grafana user ID.

**Usage:**

```
scw cockpit grafana-user delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| grafana-user-id | Required | ID of the Grafana user |



### Get a list of Grafana users who are able to connect to the Cockpit's Grafana instance

Get a list of Grafana users who are able to connect to the Cockpit's Grafana instance.

**Usage:**

```
scw cockpit grafana-user list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `login_asc`, `login_desc` |  |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Reset a Grafana user's password specified by the Cockpit's Project ID and the Grafana user ID

Reset a Grafana user's password specified by the Cockpit's Project ID and the Grafana user ID.

**Usage:**

```
scw cockpit grafana-user reset-password [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| grafana-user-id | Required | ID of the Grafana user |



## Pricing plans management commands

Pricing plans management commands.


### Get a list of all pricing plans available

Get a list of all pricing plans available.

**Usage:**

```
scw cockpit plan list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `name_asc`, `name_desc` |  |



### Select your chosen pricing plan for your Cockpit, specifying the Cockpit's Project ID and the pricing plan's ID in the request

Select your chosen pricing plan for your Cockpit, specifying the Cockpit's Project ID and the pricing plan's ID in the request.

**Usage:**

```
scw cockpit plan select [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| plan-id |  | ID of the pricing plan |



## Product dashboards management commands

Product dashboards management commands.

Product dashboards management commands.

**Usage:**

```
scw cockpit product-dashboards
```



## Token management commands

Token management commands.


### Create a token associated with the specified Project ID

Create a token associated with the specified Project ID.

**Usage:**

```
scw cockpit token create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Default: `<generated>` | Name of the token |
| scopes.query-metrics |  | Permission to fetch metrics |
| scopes.write-metrics |  | Permission to write metrics |
| scopes.setup-metrics-rules |  | Permission to setup metrics rules |
| scopes.query-logs |  | Permission to fetch logs |
| scopes.write-logs |  | Permission to write logs |
| scopes.setup-logs-rules |  | Permission to set up logs rules |
| scopes.setup-alerts |  | Permission to set up alerts |
| scopes.query-traces |  | Permission to fetch traces |
| scopes.write-traces |  | Permission to write traces |



### Delete the token associated with the specified token ID

Delete the token associated with the specified token ID.

**Usage:**

```
scw cockpit token delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required | ID of the token |



### Retrieve the token associated with the specified token ID

Retrieve the token associated with the specified token ID.

**Usage:**

```
scw cockpit token get <token-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required | ID of the token |



### Get a list of tokens associated with the specified Project ID

Get a list of tokens associated with the specified Project ID.

**Usage:**

```
scw cockpit token list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | How the response is ordered |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



