<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw dns`
Manage your DNS zones and records.
  
- [TLS certificate management](#tls-certificate-management)
  - [Create or return the zone TLS certificate](#create-or-return-the-zone-tls-certificate)
  - [Delete an TLS certificate](#delete-an-tls-certificate)
  - [Get the zone TLS certificate if it exists](#get-the-zone-tls-certificate-if-it-exists)
  - [List all user TLS certificates](#list-all-user-tls-certificates)
- [DNS records management](#dns-records-management)
  - [Add a new DNS record](#add-a-new-dns-record)
  - [Update DNS zone records](#update-dns-zone-records)
  - [Clear DNS zone records](#clear-dns-zone-records)
  - [Delete a DNS record](#delete-a-dns-record)
  - [List DNS zone records](#list-dns-zone-records)
  - [List DNS zone nameservers](#list-dns-zone-nameservers)
  - [Update a DNS record](#update-a-dns-record)
  - [Update DNS zone nameservers](#update-dns-zone-nameservers)
- [Transaction SIGnature key management](#transaction-signature-key-management)
  - [Delete the DNS zone TSIG Key](#delete-the-dns-zone-tsig-key)
  - [Get the DNS zone TSIG Key](#get-the-dns-zone-tsig-key)
- [DNS zones version management](#dns-zones-version-management)
  - [Get DNS zone version diff](#get-dns-zone-version-diff)
  - [List DNS zone versions](#list-dns-zone-versions)
  - [Restore DNS zone version](#restore-dns-zone-version)
  - [List DNS zone version records](#list-dns-zone-version-records)
- [DNS Zones management](#dns-zones-management)
  - [Clone a DNS zone](#clone-a-dns-zone)
  - [Create a DNS zone](#create-a-dns-zone)
  - [Delete DNS zone](#delete-dns-zone)
  - [Export raw DNS zone](#export-raw-dns-zone)
  - [Import raw DNS zone](#import-raw-dns-zone)
  - [List DNS zones](#list-dns-zones)
  - [Refresh DNS zone](#refresh-dns-zone)
  - [Update a DNS zone](#update-a-dns-zone)

  
## TLS certificate management

TLS certificate management.


### Create or return the zone TLS certificate

Create or return the zone TLS certificate.

**Usage:**

```
scw dns certificate create <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |
| alternative-dns-zones.{index} |  |  |



### Delete an TLS certificate

Delete an TLS certificate.

**Usage:**

```
scw dns certificate delete <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |



### Get the zone TLS certificate if it exists

Get the zone TLS certificate if it exists.

**Usage:**

```
scw dns certificate get <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |



### List all user TLS certificates

List all user TLS certificates.

**Usage:**

```
scw dns certificate list <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |
| project-id |  |  |



## DNS records management

DNS records management.


### Add a new DNS record



**Usage:**

```
scw dns record add <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone in which to add the record |
| data | Required |  |
| name |  |  |
| priority |  |  |
| ttl | Required<br />Default: `3600` |  |
| type | Required<br />One of: `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR` |  |
| comment |  |  |
| geo-ip-config.matches.{index}.countries.{index} |  |  |
| geo-ip-config.matches.{index}.continents.{index} |  |  |
| geo-ip-config.matches.{index}.data |  |  |
| geo-ip-config.default |  |  |
| http-service-config.ips.{index} |  |  |
| http-service-config.must-contain |  |  |
| http-service-config.url |  |  |
| http-service-config.user-agent |  |  |
| http-service-config.strategy | One of: `random`, `hashed` |  |
| weighted-config.weighted-ips.{index}.ip |  |  |
| weighted-config.weighted-ips.{index}.weight |  |  |
| view-config.views.{index}.subnet |  |  |
| view-config.views.{index}.data |  |  |


**Examples:**


Add a CNAME
```
scw dns record add my-domain.tld data=www name=www2 type=CNAME
```

Add an IP
```
scw dns record add my-domain.tld data=1.2.3.4 name=vpn type=A
```




### Update DNS zone records

Only available with default NS.<br/>
Send a list of actions and records.

Action can be:
 - add:
  - Add new record
  - Can be more specific and add a new IP to an existing A record for example
 - set:
  - Edit a record
  - Can be more specific and edit an IP from an existing A record for example
 - delete:
  - Delete a record
  - Can be more specific and delete an IP from an existing A record for example
 - clear:
  - Delete all records from a DNS zone

All edits will be versioned.

**Usage:**

```
scw dns record bulk-update <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | The DNS zone where the DNS zone records will be updated |
| changes.{index}.add.records.{index}.data |  |  |
| changes.{index}.add.records.{index}.name |  |  |
| changes.{index}.add.records.{index}.priority |  |  |
| changes.{index}.add.records.{index}.ttl |  |  |
| changes.{index}.add.records.{index}.type | One of: `unknown`, `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR`, `DNAME` |  |
| changes.{index}.add.records.{index}.comment |  |  |
| changes.{index}.add.records.{index}.geo-ip-config.matches.{index}.countries.{index} |  |  |
| changes.{index}.add.records.{index}.geo-ip-config.matches.{index}.continents.{index} |  |  |
| changes.{index}.add.records.{index}.geo-ip-config.matches.{index}.data |  |  |
| changes.{index}.add.records.{index}.geo-ip-config.default |  |  |
| changes.{index}.add.records.{index}.http-service-config.ips.{index} |  |  |
| changes.{index}.add.records.{index}.http-service-config.must-contain |  |  |
| changes.{index}.add.records.{index}.http-service-config.url |  |  |
| changes.{index}.add.records.{index}.http-service-config.user-agent |  |  |
| changes.{index}.add.records.{index}.http-service-config.strategy | One of: `random`, `hashed`, `all` |  |
| changes.{index}.add.records.{index}.weighted-config.weighted-ips.{index}.ip |  |  |
| changes.{index}.add.records.{index}.weighted-config.weighted-ips.{index}.weight |  |  |
| changes.{index}.add.records.{index}.view-config.views.{index}.subnet |  |  |
| changes.{index}.add.records.{index}.view-config.views.{index}.data |  |  |
| changes.{index}.add.records.{index}.id |  |  |
| changes.{index}.set.id |  |  |
| changes.{index}.set.id-fields.name |  |  |
| changes.{index}.set.id-fields.type | One of: `unknown`, `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR`, `DNAME` |  |
| changes.{index}.set.id-fields.data |  |  |
| changes.{index}.set.id-fields.ttl |  |  |
| changes.{index}.set.records.{index}.data |  |  |
| changes.{index}.set.records.{index}.name |  |  |
| changes.{index}.set.records.{index}.priority |  |  |
| changes.{index}.set.records.{index}.ttl |  |  |
| changes.{index}.set.records.{index}.type | One of: `unknown`, `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR`, `DNAME` |  |
| changes.{index}.set.records.{index}.comment |  |  |
| changes.{index}.set.records.{index}.geo-ip-config.matches.{index}.countries.{index} |  |  |
| changes.{index}.set.records.{index}.geo-ip-config.matches.{index}.continents.{index} |  |  |
| changes.{index}.set.records.{index}.geo-ip-config.matches.{index}.data |  |  |
| changes.{index}.set.records.{index}.geo-ip-config.default |  |  |
| changes.{index}.set.records.{index}.http-service-config.ips.{index} |  |  |
| changes.{index}.set.records.{index}.http-service-config.must-contain |  |  |
| changes.{index}.set.records.{index}.http-service-config.url |  |  |
| changes.{index}.set.records.{index}.http-service-config.user-agent |  |  |
| changes.{index}.set.records.{index}.http-service-config.strategy | One of: `random`, `hashed`, `all` |  |
| changes.{index}.set.records.{index}.weighted-config.weighted-ips.{index}.ip |  |  |
| changes.{index}.set.records.{index}.weighted-config.weighted-ips.{index}.weight |  |  |
| changes.{index}.set.records.{index}.view-config.views.{index}.subnet |  |  |
| changes.{index}.set.records.{index}.view-config.views.{index}.data |  |  |
| changes.{index}.set.records.{index}.id |  |  |
| changes.{index}.delete.id |  |  |
| changes.{index}.delete.id-fields.name |  |  |
| changes.{index}.delete.id-fields.type | One of: `unknown`, `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR`, `DNAME` |  |
| changes.{index}.delete.id-fields.data |  |  |
| changes.{index}.delete.id-fields.ttl |  |  |
| return-all-records |  | Whether or not to return all the records |
| disallow-new-zone-creation |  | Forbid the creation of the target zone if not existing (default action is yes) |
| serial |  | Don't use the autoincremenent serial but the provided one (0 to keep the same) |



### Clear DNS zone records

Only available with default NS.<br/>
Delete all the records from a DNS zone.
All edits will be versioned.

**Usage:**

```
scw dns record clear <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | The DNS zone to clear |



### Delete a DNS record



**Usage:**

```
scw dns record delete <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone in which to delete the record |
| data |  |  |
| name |  |  |
| ttl |  |  |
| type | Required<br />One of: `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR` |  |


**Examples:**


Delete a CNAME
```
scw dns record delete my-domain.tld name=www type=CNAME
```

Delete a single IP from a record with more than one
```
scw dns record delete my-domain.tld data=1.2.3.4 name=vpn type=A
```




### List DNS zone records

Returns a list of DNS records of a DNS zone with default NS.
You can filter the records by type and name.

**Usage:**

```
scw dns record list <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | The project ID on which to filter the returned DNS zone records |
| order-by | One of: `name_asc`, `name_desc` | The sort order of the returned DNS zone records |
| dns-zone | Required | The DNS zone on which to filter the returned DNS zone records |
| name |  | The name on which to filter the returned DNS zone records |
| type | One of: `unknown`, `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR`, `DNAME` | The record type on which to filter the returned DNS zone records |
| id |  | The record ID on which to filter the returned DNS zone records |



### List DNS zone nameservers

Returns a list of Nameservers and their optional glue records for a DNS zone.

**Usage:**

```
scw dns record list-nameservers <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | The project ID on which to filter the returned DNS zone nameservers |
| dns-zone | Required | The DNS zone on which to filter the returned DNS zone nameservers |



### Update a DNS record

This command will replace all the data for this record with the given values.

**Usage:**

```
scw dns record set <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone in which to set the record |
| values.{index} | Required | A list of values for replacing the record data. (multiple values cannot be used for all type) |
| name | Required |  |
| priority |  |  |
| ttl | Required<br />Default: `3600` |  |
| type | Required<br />One of: `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR` |  |
| comment |  |  |
| geo-ip-config.matches.{index}.countries.{index} |  |  |
| geo-ip-config.matches.{index}.continents.{index} |  |  |
| geo-ip-config.matches.{index}.data |  |  |
| geo-ip-config.default |  |  |
| http-service-config.ips.{index} |  |  |
| http-service-config.must-contain |  |  |
| http-service-config.url |  |  |
| http-service-config.user-agent |  |  |
| http-service-config.strategy | One of: `random`, `hashed` |  |
| weighted-config.weighted-ips.{index}.ip |  |  |
| weighted-config.weighted-ips.{index}.weight |  |  |
| view-config.views.{index}.subnet |  |  |
| view-config.views.{index}.data |  |  |


**Examples:**


Add or replace a CNAME
```
scw dns record set my-domain.tld values.0=www name=www2 type=CNAME
```

Add or replace a list of IP
```
scw dns record set my-domain.tld values.0=1.2.3.4 values.1=1.2.3.5 name=vpn type=A
```




### Update DNS zone nameservers

Update DNS zone nameservers and set optional glue records.

**Usage:**

```
scw dns record update-nameservers <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | The DNS zone where the DNS zone nameservers will be updated |
| ns.{index}.name |  |  |
| ns.{index}.ip.{index} |  |  |



## Transaction SIGnature key management

Transaction SIGnature key management.


### Delete the DNS zone TSIG Key

Delete the DNS zone TSIG Key.

**Usage:**

```
scw dns tsig-key delete <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |



### Get the DNS zone TSIG Key

Get the DNS zone TSIG Key to allow AXFR request.

**Usage:**

```
scw dns tsig-key get <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |



## DNS zones version management

DNS zones version management.


### Get DNS zone version diff

Get all differences from a previous DNS zone version.

**Usage:**

```
scw dns version diff <dns-zone-version-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone-version-id | Required |  |



### List DNS zone versions

Get a list of DNS zone versions.<br/>
The maximum version count is 100.<br/>
If the count reaches this limit, the oldest version will be deleted after each new modification.

**Usage:**

```
scw dns version list <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |



### Restore DNS zone version

Restore and activate a previous DNS zone version.

**Usage:**

```
scw dns version restore <dns-zone-version-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone-version-id | Required |  |



### List DNS zone version records

Get a list of records from a previous DNS zone version.

**Usage:**

```
scw dns version show <dns-zone-version-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone-version-id | Required |  |



## DNS Zones management

DNS Zones management.


### Clone a DNS zone

Clone an existed DNS zone with all its records into a new one.

**Usage:**

```
scw dns zone clone [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | The DNS zone to clone |
| dest-dns-zone | Required | The destinaton DNS zone |
| overwrite |  | Whether or not the destination DNS zone will be overwritten |
| project-id |  | The project ID of the destination DNS zone |



### Create a DNS zone

Create a new DNS zone.

**Usage:**

```
scw dns zone create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain | Required | The domain of the DNS zone to create |
| subdomain | Required | The subdomain of the DNS zone to create |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Delete DNS zone

Delete a DNS zone and all it's records.

**Usage:**

```
scw dns zone delete <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | The DNS zone to delete |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Export raw DNS zone

Get a DNS zone in a given format with default NS.

**Usage:**

```
scw dns zone export <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | The DNS zone to export |
| format | Default: `bind`<br />One of: `unknown_raw_format`, `bind` | Format for DNS zone |



### Import raw DNS zone

Import and replace records from a given provider format with default NS.

**Usage:**

```
scw dns zone import <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | The DNS zone to import |
| ~~content~~ | Deprecated |  |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| ~~format~~ | Deprecated<br />One of: `unknown_raw_format`, `bind` |  |
| bind-source.content |  |  |
| axfr-source.name-server |  |  |
| axfr-source.tsig-key.name |  |  |
| axfr-source.tsig-key.key |  |  |
| axfr-source.tsig-key.algorithm |  |  |



### List DNS zones

Returns a list of manageable DNS zones.
You can filter the DNS zones by domain name.

**Usage:**

```
scw dns zone list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | The project ID on which to filter the returned DNS zones |
| order-by | One of: `domain_asc`, `domain_desc`, `subdomain_asc`, `subdomain_desc` | The sort order of the returned DNS zones |
| domain |  | The domain on which to filter the returned DNS zones |
| dns-zone |  | The DNS zone on which to filter the returned DNS zones |
| organization-id |  | The organization ID on which to filter the returned DNS zones |



### Refresh DNS zone

Refresh SOA DNS zone.
You can recreate the given DNS zone and its sub DNS zone if needed.

**Usage:**

```
scw dns zone refresh <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | The DNS zone to refresh |
| recreate-dns-zone |  | Whether or not to recreate the DNS zone |
| recreate-sub-dns-zone |  | Whether or not to recreate the sub DNS zone |



### Update a DNS zone

Update the name and/or the organizations for a DNS zone.

**Usage:**

```
scw dns zone update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | The DNS zone to update |
| new-dns-zone | Required | The new DNS zone |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



