package docgen

const tplStr = `


{{- define "namespace" -}}
{{ template "do_not_edit" }}
# Documentation for {{ bq }}scw {{ .Cmd.Namespace }}{{ bq }}
{{ remove_escape_sequence (.Cmd.Long | default .Cmd.Short) }}
  
{{ range $resourceName, $resource := .Resources -}}
- [{{ $resource.Cmd.Short }}](#{{ anchor $resource.Cmd.Short }})
{{- range $verbName, $cmd := $resource.Verbs }}
  - [{{ $cmd.Short }}](#{{ anchor $cmd.Short }})
{{- end }}
{{ end }}
  
{{ range $resourceName, $resource := .Resources -}}
## {{ $resource.Cmd.Short }}

{{ $resource.Cmd.Long }}

{{ if $resource.Verbs | len -}}
{{ range $verbName, $cmd := $resource.Verbs }}
### {{ $cmd.Short }}

{{ template "cmd" (map "Cmd" $cmd "Data" $) }}

{{ end -}}
{{- else -}}
{{ template "cmd"  (map "Cmd" $resource.Cmd "Data" $) }}

{{ end }}
{{ end }}
{{- end -}}

{{- define "cmd" -}}
{{ .Cmd.Long }}

**Usage:**

{{ bbq }}
{{ .Cmd.GetUsage "scw" .Data.Commands }}
{{ bbq }}
{{ if .Cmd.ArgSpecs }}

**Args:**

| Name |   | Description |
|------|---|-------------|
{{ range $arg := .Cmd.ArgSpecs -}}
| {{ $arg.Name }} | {{ arg_spec_flag $arg }} | {{ $arg.Short }} |
{{ end -}}
{{- end -}}
{{- if .Cmd.Examples }}

**Examples:**

{{ range $example := .Cmd.Examples }}
{{ $example.Short }}
{{ bbq }}
{{ $example.GetCommandLine "scw" $.Cmd }}
{{ bbq }}
{{ end }}
{{ end }}
{{- end -}}

{{- define "do_not_edit" -}}
  <!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
{{- end -}}

`
