<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw rdb`
Database RDB API
  
- [Access Control List (ACL) management commands](#access-control-list-(acl)-management-commands)
  - [Add an ACL instance to a given instance](#add-an-acl-instance-to-a-given-instance)
  - [Delete ACL rules of a given instance](#delete-acl-rules-of-a-given-instance)
  - [List ACL rules of a given instance](#list-acl-rules-of-a-given-instance)
- [Backup management commands](#backup-management-commands)
  - [Create a database backup](#create-a-database-backup)
  - [Delete a database backup](#delete-a-database-backup)
  - [Export a database backup](#export-a-database-backup)
  - [Get a database backup](#get-a-database-backup)
  - [List database backups](#list-database-backups)
  - [Restore a database backup](#restore-a-database-backup)
  - [Update a database backup](#update-a-database-backup)
- [Instance TLS certificate management commands](#instance-tls-certificate-management-commands)
  - [Get the TLS certificate of an instance](#get-the-tls-certificate-of-an-instance)
- [Database management commands](#database-management-commands)
  - [Create a database in a given instance](#create-a-database-in-a-given-instance)
  - [Delete a database in a given instance](#delete-a-database-in-a-given-instance)
  - [List all database in a given instance](#list-all-database-in-a-given-instance)
- [Database engines commands](#database-engines-commands)
  - [List available database engines](#list-available-database-engines)
- [Instance management commands](#instance-management-commands)
  - [Clone an instance](#clone-an-instance)
  - [Create an instance](#create-an-instance)
  - [Delete an instance](#delete-an-instance)
  - [Get an instance](#get-an-instance)
  - [List instances](#list-instances)
  - [Get instance metrics](#get-instance-metrics)
  - [Update an instance](#update-an-instance)
  - [Upgrade an instance to an higher instance type](#upgrade-an-instance-to-an-higher-instance-type)
  - [Wait for an instance to reach a stable state](#wait-for-an-instance-to-reach-a-stable-state)
- [Instance logs management commands](#instance-logs-management-commands)
  - [List available logs of a given instance](#list-available-logs-of-a-given-instance)
  - [Prepare logs of a given instance](#prepare-logs-of-a-given-instance)
- [Node types management commands](#node-types-management-commands)
  - [List available node types](#list-available-node-types)
- [User privileges management commands](#user-privileges-management-commands)
  - [List privileges of a given user in a given database in a given instance](#list-privileges-of-a-given-user-in-a-given-database-in-a-given-instance)
  - [Set privileges of a given user in a given database in a given instance](#set-privileges-of-a-given-user-in-a-given-database-in-a-given-instance)
- [Settings management commands](#settings-management-commands)
  - [Add an instance setting](#add-an-instance-setting)
  - [Delete an instance setting](#delete-an-instance-setting)
- [User management commands](#user-management-commands)
  - [Create an user in a given instance](#create-an-user-in-a-given-instance)
  - [Delete an user in a given instance](#delete-an-user-in-a-given-instance)
  - [List users of a given instance](#list-users-of-a-given-instance)
  - [Update an user in a given instance](#update-an-user-in-a-given-instance)

  
## Access Control List (ACL) management commands

Network Access Control List allows to control network in and out traffic by setting up ACL rules.



### Add an ACL instance to a given instance

Add an ACL instance to a given instance.

**Usage:**

```
scw rdb acl add <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance you want to add acl rules to |
| rules.{index}.ip |  |  |
| rules.{index}.description |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Delete ACL rules of a given instance

Delete ACL rules of a given instance.

**Usage:**

```
scw rdb acl delete <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance you want to delete an ACL rules from |
| acl-rule-ips.{index} |  | ACL rules IP present on the instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### List ACL rules of a given instance

List ACL rules of a given instance.

**Usage:**

```
scw rdb acl list <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## Backup management commands

Save and restore backups of your database instance.



### Create a database backup

Create a database backup.

**Usage:**

```
scw rdb backup create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id |  | UUID of the instance |
| database-name |  | Name of the database you want to make a backup of |
| name |  | Name of the backup |
| expires-at |  | Expiration date (Format ISO 8601) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Delete a database backup

Delete a database backup.

**Usage:**

```
scw rdb backup delete <database-backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| database-backup-id | Required | UUID of the database backup to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Export a database backup

Export a database backup.

**Usage:**

```
scw rdb backup export <database-backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| database-backup-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Get a database backup

Get a database backup.

**Usage:**

```
scw rdb backup get <database-backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| database-backup-id | Required | UUID of the database backup |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### List database backups

List database backups.

**Usage:**

```
scw rdb backup list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the database backups |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `status_asc`, `status_desc` | Criteria to use when ordering database backups listing |
| instance-id |  | UUID of the instance |
| organization-id |  | Organization ID the database backups belongs to |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Restore a database backup

Restore a database backup.

**Usage:**

```
scw rdb backup restore <database-backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| database-name |  | Defines the destination database in order to restore into a specified database, the default destination is set to the origin database of the backup |
| database-backup-id | Required | Backup of a logical database |
| instance-id | Required | Defines the rdb instance where the backup has to be restored |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Update a database backup

Update a database backup.

**Usage:**

```
scw rdb backup update <database-backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| database-backup-id | Required | UUID of the database backup to update |
| name |  | Name of the Database Backup |
| expires-at |  | Expiration date (Format ISO 8601) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## Instance TLS certificate management commands

Instance TLS certificate management commands.


### Get the TLS certificate of an instance

Get the TLS certificate of an instance.

**Usage:**

```
scw rdb certificate get <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## Database management commands

Manage logical databases on your instance



### Create a database in a given instance

Create a database in a given instance.

**Usage:**

```
scw rdb database create <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance where to create the database |
| name |  | Name of the database |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Delete a database in a given instance

Delete a database in a given instance.

**Usage:**

```
scw rdb database delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance where to delete the database |
| name | Required | Name of the database to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### List all database in a given instance

List all database in a given instance.

**Usage:**

```
scw rdb database list <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the database |
| managed |  | Whether or not the database is managed |
| owner |  | User that owns this database |
| order-by | One of: `name_asc`, `name_desc`, `size_asc`, `size_desc` | Criteria to use when ordering database listing |
| instance-id | Required | UUID of the instance to list database of |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## Database engines commands

Software that stores and retrieves data from a database. Each database engine has a name and versions.



### List available database engines

List available database engines.

**Usage:**

```
scw rdb engine list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## Instance management commands

A Database Instance is composed of one or more Nodes, depending of the is_ha_cluster setting. Autohealing is enabled by default for HA clusters. Database automated backup is enabled by default in order to prevent data loss.



### Clone an instance

Clone an instance.

**Usage:**

```
scw rdb instance clone <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance you want to clone |
| name |  | Name of the clone instance |
| node-type |  | Node type of the clone |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Create an instance

Create an instance.

**Usage:**

```
scw rdb instance create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required | Name of the instance |
| engine | Required | Database engine of the database (PostgreSQL, MySQL, ...) |
| user-name | Required | Name of the user created when the instance is created |
| password | Required | Password of the user |
| node-type | Required<br />Default: `DB-DEV-S`<br />One of: `DB-DEV-S`, `DB-DEV-M`, `DB-DEV-L`, `DB-DEV-XL`, `DB-GP-XS`, `DB-GP-S`, `DB-GP-M`, `DB-GP-L`, `DB-GP-XL` | Type of node to use for the instance |
| is-ha-cluster |  | Whether or not High-Availability is enabled |
| disable-backup |  | Whether or not backups are disabled |
| tags.{index} |  | Tags to apply to the instance |
| organization-id |  | Organization ID to use. If none is passed will use default organization ID from the config |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Delete an instance

Delete an instance.

**Usage:**

```
scw rdb instance delete <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Get an instance

Get an instance.

**Usage:**

```
scw rdb instance get <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### List instances

List instances.

**Usage:**

```
scw rdb instance list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tags.{index} |  | List instance that have a given tags |
| name |  | List instance that match a given name pattern |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `region`, `status_asc`, `status_desc` | Criteria to use when ordering instance listing |
| organization-id |  | Organization ID to list the instance of |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Get instance metrics

Get database instance metrics.

**Usage:**

```
scw rdb instance metrics <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance |
| start-date |  | Start date to gather metrics from |
| end-date |  | End date to gather metrics from |
| metric-name |  | Name of the metric to gather |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Update an instance

Update an instance.

**Usage:**

```
scw rdb instance update <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backup-schedule-frequency |  | In hours |
| backup-schedule-retention |  | In days |
| is-backup-schedule-disabled |  | Whether or not the backup schedule is disabled |
| name |  | Name of the instance |
| instance-id | Required | UUID of the instance to update |
| tags.{index} |  | Tags of a given instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Upgrade an instance to an higher instance type

Upgrade your current `node_type` or enable high availability on your standalone database instance.

**Usage:**

```
scw rdb instance upgrade <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required |  |
| node-type | One of: `DB-DEV-S`, `DB-DEV-M`, `DB-DEV-L`, `DB-DEV-XL`, `DB-GP-XS`, `DB-GP-S`, `DB-GP-M`, `DB-GP-L`, `DB-GP-XL` |  |
| enable-ha |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Wait for an instance to reach a stable state

Wait for an instance to reach a stable state. This is similar to using --wait flag.

**Usage:**

```
scw rdb instance wait <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | ID of the instance you want to wait for. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Wait for an instance to reach a stable state
```
scw rdb instance wait 11111111-1111-1111-1111-111111111111
```




## Instance logs management commands

Instance logs management commands.


### List available logs of a given instance

List available logs of a given instance.

**Usage:**

```
scw rdb log list <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required |  |
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Prepare logs of a given instance

Prepare your instance logs. Logs will be grouped on a minimum interval of a day.

**Usage:**

```
scw rdb log prepare <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance you want logs of |
| start-date |  | Start datetime of your log. Format: `{year}-{month}-{day}T{hour}:{min}:{sec}[.{frac_sec}]Z` |
| end-date |  | End datetime of your log. Format: `{year}-{month}-{day}T{hour}:{min}:{sec}[.{frac_sec}]Z` |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## Node types management commands

Node types powering your instance



### List available node types

List available node types.

**Usage:**

```
scw rdb node-type list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| include-disabled-types |  | Whether or not to include disabled types |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## User privileges management commands

Define some privileges to a user on a specific database.



### List privileges of a given user in a given database in a given instance

List privileges of a given user in a given database in a given instance.

**Usage:**

```
scw rdb privilege list <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `user_name_asc`, `user_name_desc`, `database_name_asc`, `database_name_desc` | Criteria to use when ordering privileges listing |
| database-name |  | Name of the database |
| instance-id | Required | UUID of the instance |
| user-name |  | Name of the user |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Set privileges of a given user in a given database in a given instance

Set privileges of a given user in a given database in a given instance.

**Usage:**

```
scw rdb privilege set <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance |
| database-name |  | Name of the database |
| user-name |  | Name of the user |
| permission | One of: `readonly`, `readwrite`, `all`, `custom`, `none` | Permission to set (Read, Read/Write, All, Custom) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## Settings management commands

Instance Settings are tunables of Database Engines. Available settings depend on the database engine and its version.



### Add an instance setting

Add an instance setting.

**Usage:**

```
scw rdb settings add <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance you want to add settings to |
| settings.{index}.name |  |  |
| settings.{index}.value |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Delete an instance setting

Delete an instance setting.

**Usage:**

```
scw rdb settings delete <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance to delete settings from |
| setting-names.{index} |  | Settings names to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



## User management commands

Manage users on your instance



### Create an user in a given instance

Create an user in a given instance.

**Usage:**

```
scw rdb user create <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance you want to create a user in |
| name |  | Name of the user you want to create |
| password |  | Password of the user you want to create |
| is-admin |  | Whether the user you want to create will have administrative privileges |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Delete an user in a given instance

Delete an user in a given instance.

**Usage:**

```
scw rdb user delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance to delete a user from |
| name | Required | Name of the user |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### List users of a given instance

List users of a given instance.

**Usage:**

```
scw rdb user list <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the user |
| order-by | One of: `name_asc`, `name_desc`, `is_admin_asc`, `is_admin_desc` | Criteria to use when ordering users listing |
| instance-id | Required | UUID of the instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Update an user in a given instance

Update an user in a given instance.

**Usage:**

```
scw rdb user update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the instance the user belongs to |
| name | Required | Name of the database user |
| password |  | Password of the database user |
| is-admin |  | Whether or not this user got administrative privileges |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



