<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw k8s`
Kapsule API
  
- [Kapsule cluster management commands](#kapsule-cluster-management-commands)
  - [Create a new cluster](#create-a-new-cluster)
  - [Delete a cluster](#delete-a-cluster)
  - [Get a cluster](#get-a-cluster)
  - [List all the clusters](#list-all-the-clusters)
  - [List available versions for a cluster](#list-available-versions-for-a-cluster)
  - [Reset the admin token of a cluster](#reset-the-admin-token-of-a-cluster)
  - [Update a cluster](#update-a-cluster)
  - [Upgrade a cluster](#upgrade-a-cluster)
  - [Wait for a cluster to reach a stable state](#wait-for-a-cluster-to-reach-a-stable-state)
- [Manage your Kubernetes Kapsule cluster's kubeconfig files](#manage-your-kubernetes-kapsule-cluster's-kubeconfig-files)
  - [Retrieve a kubeconfig](#retrieve-a-kubeconfig)
  - [Install a kubeconfig](#install-a-kubeconfig)
  - [Uninstall a kubeconfig](#uninstall-a-kubeconfig)
- [Kapsule node management commands](#kapsule-node-management-commands)
  - [Get a node in a cluster](#get-a-node-in-a-cluster)
  - [List all the nodes in a cluster](#list-all-the-nodes-in-a-cluster)
  - [Reboot a node in a cluster](#reboot-a-node-in-a-cluster)
  - [Replace a node in a cluster](#replace-a-node-in-a-cluster)
  - [Wait for a node to reach a stable state](#wait-for-a-node-to-reach-a-stable-state)
- [Kapsule pool management commands](#kapsule-pool-management-commands)
  - [Create a new pool in a cluster](#create-a-new-pool-in-a-cluster)
  - [Delete a pool in a cluster](#delete-a-pool-in-a-cluster)
  - [Get a pool in a cluster](#get-a-pool-in-a-cluster)
  - [List all the pools in a cluster](#list-all-the-pools-in-a-cluster)
  - [Update a pool in a cluster](#update-a-pool-in-a-cluster)
  - [Upgrade a pool in a cluster](#upgrade-a-pool-in-a-cluster)
  - [Wait for a pool to reach a stable state](#wait-for-a-pool-to-reach-a-stable-state)
- [Available Kubernetes version commands](#available-kubernetes-version-commands)
  - [Get details about a specific version](#get-details-about-a-specific-version)
  - [List all available versions](#list-all-available-versions)

  
## Kapsule cluster management commands

A cluster is a fully managed Kubernetes cluster.

It is composed of different pools, each pool containing the same kind of nodes.



### Create a new cluster

This method allows to create a new Kubernetes cluster on an account.

**Usage:**

```
scw k8s cluster create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required | The name of the cluster |
| description |  | The description of the cluster |
| tags.{index} |  | The tags associated with the cluster |
| version | Required | The Kubernetes version of the cluster |
| cni | Required<br />One of: `unknown_cni`, `cilium`, `calico`, `weave`, `flannel` | The Container Network Interface (CNI) plugin that will run in the cluster |
| enable-dashboard |  | The enablement of the Kubernetes Dashboard in the cluster |
| ingress | One of: `unknown_ingress`, `none`, `nginx`, `traefik`, `traefik2` | The Ingress Controller that will run in the cluster |
| pools.{index}.name |  |  |
| pools.{index}.node-type | Required | The node type is the type of Scaleway Instance wanted for the pool |
| pools.{index}.placement-group-id |  | The placement group ID in which all the nodes of the pool will be created |
| pools.{index}.autoscaling |  | The enablement of the autoscaling feature for the pool |
| pools.{index}.size | Required | The size (number of nodes) of the pool |
| pools.{index}.min-size |  | The minimun size of the pool |
| pools.{index}.max-size |  | The maximum size of the pool |
| pools.{index}.container-runtime | One of: `unknown_runtime`, `docker`, `containerd`, `crio` | The container runtime for the nodes of the pool |
| pools.{index}.autohealing |  | The enablement of the autohealing feature for the pool |
| pools.{index}.tags.{index} |  | The tags associated with the pool |
| autoscaler-config.scale-down-disabled |  | Disable the cluster autoscaler |
| autoscaler-config.scale-down-delay-after-add |  | How long after scale up that scale down evaluation resumes |
| autoscaler-config.estimator | One of: `unknown_estimator`, `binpacking` | Type of resource estimator to be used in scale up |
| autoscaler-config.expander | One of: `unknown_expander`, `random`, `most_pods`, `least_waste`, `priority` | Type of node group expander to be used in scale up |
| autoscaler-config.ignore-daemonsets-utilization |  | Ignore DaemonSet pods when calculating resource utilization for scaling down |
| autoscaler-config.balance-similar-node-groups |  | Detect similar node groups and balance the number of nodes between them |
| autoscaler-config.expendable-pods-priority-cutoff |  | Pods with priority below cutoff will be expendable |
| autoscaler-config.scale-down-unneeded-time |  | How long a node should be unneeded before it is eligible for scale down |
| auto-upgrade.enable |  | Whether or not auto upgrade is enabled for the cluster |
| auto-upgrade.maintenance-window.start-hour |  | The start hour of the 2-hour maintenance window |
| auto-upgrade.maintenance-window.day | One of: `any`, `monday`, `tuesday`, `wednesday`, `thursday`, `friday`, `saturday`, `sunday` | The day of the week for the maintenance window |
| feature-gates.{index} |  | List of feature gates to enable |
| admission-plugins.{index} |  | List of admission plugins to enable |
| organization-id |  | Organization ID to use. If none is passed will use default organization ID from the config |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Create a Kubernetes cluster named foo with cilium as CNI, in version 1.17.4 and with a pool named default composed of 3 DEV1-M
```
scw k8s cluster create name=foo version=1.17.4 pools.0.size=3 pools.0.node-type=DEV1-M pools.0.name=default
```

Create a Kubernetes cluster named bar, tagged, calico as CNI, in version 1.17.4 and with a tagged pool named default composed of 2 RENDER-S and autohealing and autoscaling enabled (between 1 and 10 nodes)
```
scw k8s cluster create name=bar version=1.17.4 tags.0=tag1 tags.1=tag2 cni=cilium pools.0.size=2 pools.0.node-type=RENDER-S pools.0.min-size=1 pools.0.max-size=10 pools.0.autohealing=true pools.0.autoscaling=true pools.0.tags.0=pooltag1 pools.0.tags.1=pooltag2 pools.0.name=default
```




### Delete a cluster

This method allows to delete a specific cluster and all its associated pools and nodes. Note that this method will not delete any Load Balancers or Block Volumes that are associated with the cluster.

**Usage:**

```
scw k8s cluster delete <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | The ID of the cluster to delete |
| with-additional-resources |  | Set true if you want to delete all volumes (including retain volume type) and loadbalancers whose name start with cluster ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Delete a given cluster
```
scw k8s cluster delete 11111111-1111-1111-111111111111
```




### Get a cluster

This method allows to get details about a specific Kubernetes cluster.

**Usage:**

```
scw k8s cluster get <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | The ID of the requested cluster |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Get a given cluster
```
scw k8s cluster get 11111111-1111-1111-111111111111
```




### List all the clusters

This method allows to list all the existing Kubernetes clusters in an account.

**Usage:**

```
scw k8s cluster list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc`, `name_asc`, `name_desc`, `status_asc`, `status_desc`, `version_asc`, `version_desc` | The sort order of the returned clusters |
| name |  | The name on which to filter the returned clusters |
| status | One of: `unknown`, `creating`, `ready`, `deleting`, `deleted`, `updating`, `locked`, `pool_required` | The status on which to filter the returned clusters |
| organization-id |  | The organization ID on which to filter the returned clusters |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


List all the clusters on your default region
```
scw k8s cluster list
```

List the ready clusters on your default region
```
scw k8s cluster list status=ready
```

List the clusters that match the given name on fr-par ('cluster1' will return 'cluster100' and 'cluster1' but not 'foo')
```
scw k8s cluster list region=fr-par name=cluster1
```




### List available versions for a cluster

This method allows to list the versions that a specific Kubernetes cluster is allowed to upgrade to. Note that it will be every patch version greater than the actual one as well a one minor version ahead of the actual one. Upgrades skipping a minor version will not work.

**Usage:**

```
scw k8s cluster list-available-versions <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | The ID of the cluster which the available Kuberentes versions will be listed from |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


List all available versions for a given cluster to upgrade to
```
scw k8s cluster list-available-versions 11111111-1111-1111-111111111111
```




### Reset the admin token of a cluster

This method allows to reset the admin token for a specific Kubernetes cluster. This will invalidate the old admin token (which will not be usable after) and create a new one. Note that the redownload of the kubeconfig will be necessary to keep interacting with the cluster (if the old admin token was used).

**Usage:**

```
scw k8s cluster reset-admin-token <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | The ID of the cluster of which the admin token will be renewed |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Reset the admin token for a given cluster
```
scw k8s cluster reset-admin-token 11111111-1111-1111-111111111111
```




### Update a cluster

This method allows to update a specific Kubernetes cluster. Note that this method is not made to upgrade a Kubernetes cluster.

**Usage:**

```
scw k8s cluster update <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | The ID of the cluster to update |
| name |  | The new name of the cluster |
| description |  | The new description of the cluster |
| tags.{index} |  | The new tags associated with the cluster |
| autoscaler-config.scale-down-disabled |  | Disable the cluster autoscaler |
| autoscaler-config.scale-down-delay-after-add |  | How long after scale up that scale down evaluation resumes |
| autoscaler-config.estimator | One of: `unknown_estimator`, `binpacking` | Type of resource estimator to be used in scale up |
| autoscaler-config.expander | One of: `unknown_expander`, `random`, `most_pods`, `least_waste`, `priority` | Type of node group expander to be used in scale up |
| autoscaler-config.ignore-daemonsets-utilization |  | Ignore DaemonSet pods when calculating resource utilization for scaling down |
| autoscaler-config.balance-similar-node-groups |  | Detect similar node groups and balance the number of nodes between them |
| autoscaler-config.expendable-pods-priority-cutoff |  | Pods with priority below cutoff will be expendable |
| autoscaler-config.scale-down-unneeded-time |  | How long a node should be unneeded before it is eligible for scale down |
| enable-dashboard |  | The new value of the Kubernetes Dashboard enablement |
| ingress | One of: `unknown_ingress`, `none`, `nginx`, `traefik`, `traefik2` | The new Ingress Controller for the cluster |
| auto-upgrade.enable |  | Whether or not auto upgrade is enabled for the cluster |
| auto-upgrade.maintenance-window.start-hour |  | The start hour of the 2-hour maintenance window |
| auto-upgrade.maintenance-window.day | One of: `any`, `monday`, `tuesday`, `wednesday`, `thursday`, `friday`, `saturday`, `sunday` | The day of the week for the maintenance window |
| feature-gates.{index} |  | List of feature gates to enable |
| admission-plugins.{index} |  | List of admission plugins to enable |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Enable dashboard on a given cluster
```
scw k8s cluster update 11111111-1111-1111-111111111111 enable-dashboard=true
```

Add TTLAfterFinished and ServiceNodeExclusion as feature gates on a given cluster
```
scw k8s cluster update 11111111-1111-1111-111111111111 feature-gates.0=TTLAfterFinished feature-gates.1=ServiceNodeExclusion
```




### Upgrade a cluster

This method allows to upgrade a specific Kubernetes cluster and/or its associated pools to a specific and supported Kubernetes version.

**Usage:**

```
scw k8s cluster upgrade <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | The ID of the cluster to upgrade |
| version | Required | The new Kubernetes version of the cluster |
| upgrade-pools |  | The enablement of the pools upgrade |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Upgrade a given cluster to Kubernetes version 1.17.4 (without upgrading the pools)
```
scw k8s cluster upgrade 11111111-1111-1111-111111111111 version=1.17.4
```

Upgrade a given cluster to Kubernetes version 1.17.4 (and upgrade the pools)
```
scw k8s cluster upgrade 11111111-1111-1111-111111111111 version=1.17.4 upgrade-pools=true
```




### Wait for a cluster to reach a stable state

Wait for server to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the server.

**Usage:**

```
scw k8s cluster wait <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | ID of the cluster. |
| wait-for-pools |  | Wait for pools to be ready. |
| region | Default: `fr-par` | Region to target. If none is passed will use default region from the config |


**Examples:**


Wait for a cluster to reach a stable state
```
scw k8s cluster wait 11111111-1111-1111-1111-111111111111
```




## Manage your Kubernetes Kapsule cluster's kubeconfig files




### Retrieve a kubeconfig

Retrieve the kubeconfig for a specified cluster.

**Usage:**

```
scw k8s kubeconfig get <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | Cluster ID from which to retrieve the kubeconfig |
| region | Default: `fr-par` | Region to target. If none is passed will use default region from the config |



### Install a kubeconfig

Retrieve the kubeconfig for a specified cluster and write it on disk. 
It will merge the new kubeconfig in the file pointed by the KUBECONFIG variable. If empty it will default to $HOME/.kube/config.

**Usage:**

```
scw k8s kubeconfig install <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | Cluster ID from which to retrieve the kubeconfig |
| keep-current-context |  | Whether or not to keep the current kubeconfig context unmodified |
| region | Default: `fr-par` | Region to target. If none is passed will use default region from the config |


**Examples:**


Install the kubeconfig for a given cluster and using the new context
```
scw k8s kubeconfig install 11111111-1111-1111-1111-111111111111
```




### Uninstall a kubeconfig

Remove specified cluster from kubeconfig file specified by the KUBECONFIG env, if empty it will default to $HOME/.kube/config.
If the current context points to this cluster, it will be set to an empty context.

**Usage:**

```
scw k8s kubeconfig uninstall <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | Cluster ID from which to uninstall the kubeconfig |


**Examples:**


Uninstall the kubeconfig for a given cluster
```
scw k8s kubeconfig uninstall 11111111-1111-1111-1111-111111111111
```




## Kapsule node management commands

A node (short for worker node) is an abstraction for a Scaleway Instance.
It is part of a pool and is instantiated by Scaleway, making Kubernetes software installed and configured automatically on it.
Please note that Kubernetes nodes cannot be accessed with ssh.



### Get a node in a cluster

This method allows to get details about a specific Kubernetes node.

**Usage:**

```
scw k8s node get <node-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| node-id | Required | The ID of the requested node |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Get a given node
```
scw k8s node get 11111111-1111-1111-111111111111
```




### List all the nodes in a cluster

This method allows to list all the existing nodes for a specific Kubernetes cluster.

**Usage:**

```
scw k8s node list <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | The cluster ID from which the nodes will be listed from |
| pool-id |  | The pool ID on which to filter the returned nodes |
| order-by | One of: `created_at_asc`, `created_at_desc` | The sort order of the returned nodes |
| name |  | The name on which to filter the returned nodes |
| status | One of: `unknown`, `creating`, `not_ready`, `ready`, `deleting`, `deleted`, `locked`, `rebooting`, `creation_error` | The status on which to filter the returned nodes |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


List all the nodes in the given cluster
```
scw k8s node list 11111111-1111-1111-111111111111
```

List all the nodes in the pool 2222222222222-2222-222222222222 in the given cluster
```
scw k8s node list 11111111-1111-1111-111111111111 pool-id=2222222222222-2222-222222222222
```

List all ready nodes in the given cluster
```
scw k8s node list 11111111-1111-1111-111111111111 status=ready
```




### Reboot a node in a cluster

This method allows to reboot a specific node. This node will frist be cordoned, meaning that scheduling will be disabled. Then the existing pods on the node will be drained and reschedule onto another schedulable node. Note that when there is not enough space to reschedule all the pods (in a one node cluster for instance), you may experience some disruption of your applications.

**Usage:**

```
scw k8s node reboot <node-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| node-id | Required | The ID of the node to reboot |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Reboot a given node
```
scw k8s node reboot 11111111-1111-1111-111111111111
```




### Replace a node in a cluster

This method allows to replace a specific node. The node will be set cordoned, meaning that scheduling will be disabled. Then the existing pods on the node will be drained and reschedule onto another schedulable node. Then the node will be deleted, and a new one will be created after the deletion. Note that when there is not enough space to reschedule all the pods (in a one node cluster for instance), you may experience some disruption of your applications.

**Usage:**

```
scw k8s node replace <node-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| node-id | Required | The ID of the node to replace |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Replace a given node
```
scw k8s node replace 11111111-1111-1111-111111111111
```




### Wait for a node to reach a stable state

Wait for a node to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the node.

**Usage:**

```
scw k8s node wait <node-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| node-id | Required | ID of the node. |
| region | Default: `fr-par` | Region to target. If none is passed will use default region from the config |


**Examples:**


Wait for a node to reach a stable state
```
scw k8s node wait 11111111-1111-1111-1111-111111111111
```




## Kapsule pool management commands

A pool is a set of identical Nodes. A pool has a name, a size (its current number of nodes), nodes number limits (min, max) and a Scaleway instance type.
Changing those limits increases/decreases the size of a pool. Thus, when autoscaling is enabled, the pool will grow or shrink inside those limits, depending on its load.
A "default pool" is automatically created with every cluster.



### Create a new pool in a cluster

This method allows to create a new pool in a specific Kubernetes cluster.

**Usage:**

```
scw k8s pool create <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | The ID of the cluster in which the pool will be created |
| name | Required | The name of the pool |
| node-type | Required | The node type is the type of Scaleway Instance wanted for the pool |
| placement-group-id |  | The placement group ID in which all the nodes of the pool will be created |
| autoscaling |  | The enablement of the autoscaling feature for the pool |
| size | Required | The size (number of nodes) of the pool |
| min-size |  | The minimun size of the pool |
| max-size |  | The maximum size of the pool |
| container-runtime | One of: `unknown_runtime`, `docker`, `containerd`, `crio` | The container runtime for the nodes of the pool |
| autohealing |  | The enablement of the autohealing feature for the pool |
| tags.{index} |  | The tags associated with the pool |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Create a pool named bar with 2 DEV1-XL on a given cluster
```
scw k8s pool create 11111111-1111-1111-111111111111 name=bar node-type=DEV1-XL size=2
```

Create a pool named fish with 5 GP1-L with autoscaling enabled within 0 and 10 nodes, autohealing enabled, and containerd as the container runtime on a given cluster
```
scw k8s pool create 11111111-1111-1111-111111111111 name=fish node-type=GP1-L size=5 min-size=0 max-size=10 autoscaling=true autohealing=true container-runtime=containerd
```

Create a tagged pool named turtle with 1 GP1-S which is using the already created placement group 2222222222222-2222-222222222222 for all the nodes in the pool on a given cluster
```
scw k8s pool create 11111111-1111-1111-111111111111 name=turtle node-type=GP1-S size=1 placement-group-id=2222222222222-2222-222222222222 tags.0=turtle tags.1=placement-group
```




### Delete a pool in a cluster

This method allows to delete a specific pool from a cluster, deleting all the nodes associated with it.

**Usage:**

```
scw k8s pool delete <pool-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pool-id | Required | The ID of the pool to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Delete a given pool
```
scw k8s pool delete 11111111-1111-1111-111111111111
```




### Get a pool in a cluster

This method allows to get details about a specific pool.

**Usage:**

```
scw k8s pool get <pool-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pool-id | Required | The ID of the requested pool |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Get a given pool
```
scw k8s pool get 11111111-1111-1111-111111111111
```




### List all the pools in a cluster

This method allows to list all the existing pools for a specific Kubernetes cluster.

**Usage:**

```
scw k8s pool list <cluster-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cluster-id | Required | The ID of the cluster from which the pools will be listed from |
| order-by | One of: `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc`, `name_asc`, `name_desc`, `status_asc`, `status_desc`, `version_asc`, `version_desc` | The sort order of the returned pools |
| name |  | The name on which to filter the returned pools |
| status | One of: `unknown`, `ready`, `deleting`, `deleted`, `scaling`, `warning`, `locked`, `upgrading` | The status on which to filter the returned pools |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


List all pools for a given cluster
```
scw k8s pool list 11111111-1111-1111-111111111111
```

List all scaling pools for a given cluster
```
scw k8s pool list 11111111-1111-1111-111111111111 status=scaling
```

List all pools for a given cluster that contain the word foo in the pool name
```
scw k8s pool list 11111111-1111-1111-111111111111 name=foo
```

List all pools for a given cluster and order them by ascending creation date
```
scw k8s pool list 11111111-1111-1111-111111111111 order-by=created_at_asc
```




### Update a pool in a cluster

This method allows to update some attributes of a specific pool such as the size, the autoscaling enablement, the tags, ...

**Usage:**

```
scw k8s pool update <pool-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pool-id | Required | The ID of the pool to update |
| autoscaling |  | The new value for the enablement of autoscaling for the pool |
| size |  | The new size for the pool |
| min-size |  | The new minimun size for the pool |
| max-size |  | The new maximum size for the pool |
| autohealing |  | The new value for the enablement of autohealing for the pool |
| tags.{index} |  | The new tags associated with the pool |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Enable autoscaling on a given pool
```
scw k8s pool update 11111111-1111-1111-111111111111 autoscaling=true
```

Reduce the size and max size of a given pool to 4
```
scw k8s pool update 11111111-1111-1111-111111111111 size=4 max-size=4
```

Change the tags of the given pool
```
scw k8s pool update 11111111-1111-1111-111111111111 tags.0=my tags.1=new tags.2=pool
```




### Upgrade a pool in a cluster

This method allows to upgrade the Kubernetes version of a specific pool. Note that this will work when the targeted version is the same than the version of the cluster.

**Usage:**

```
scw k8s pool upgrade <pool-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pool-id | Required | The ID of the pool to upgrade |
| version | Required | The new Kubernetes version for the pool |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Upgrade a given pool to the Kubernetes version 1.17.4
```
scw k8s pool upgrade 11111111-1111-1111-111111111111 version=1.17.4
```




### Wait for a pool to reach a stable state

Wait for a pool to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the node.

**Usage:**

```
scw k8s pool wait <pool-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pool-id | Required | ID of the pool. |
| region | Default: `fr-par` | Region to target. If none is passed will use default region from the config |


**Examples:**


Wait for a pool to reach a stable state
```
scw k8s pool wait 11111111-1111-1111-1111-111111111111
```




## Available Kubernetes version commands

A version is a vanilla Kubernetes version like `x.y.z`.
It is composed of a major version x, a minor version y and a patch version z.
Scaleway's managed Kubernetes, Kapsule, will at least support the last patch version for the last three minor release.

Also each version have a different set of container runtimes, CNIs, ingresses, feature gates and admission plugins available.



### Get details about a specific version

This method allows to get a specific Kubernetes version and the details about the version.

**Usage:**

```
scw k8s version get <version-name ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| version-name | Required | The requested version name |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Get the Kubernetes version 1.18.0
```
scw k8s version get 1.18.0
```




### List all available versions

This method allows to list all available versions for the creation of a new Kubernetes cluster.

**Usage:**

```
scw k8s version list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


List all available Kubernetes version in Kapsule
```
scw k8s version list
```




