<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw instance`
Instance API
  
- [Image management commands](#image-management-commands)
  - [Create an instance image](#create-an-instance-image)
  - [Delete an instance image](#delete-an-instance-image)
  - [Get an instance image](#get-an-instance-image)
  - [List instance images](#list-instance-images)
  - [Wait for image to reach a stable state](#wait-for-image-to-reach-a-stable-state)
- [IP management commands](#ip-management-commands)
  - [Reserve a flexible IP](#reserve-a-flexible-ip)
  - [Delete a flexible IP](#delete-a-flexible-ip)
  - [Get a flexible IP](#get-a-flexible-ip)
  - [List all flexible IPs](#list-all-flexible-ips)
  - [Update a flexible IP](#update-a-flexible-ip)
- [Placement group management commands](#placement-group-management-commands)
  - [Create a placement group](#create-a-placement-group)
  - [Delete the given placement group](#delete-the-given-placement-group)
  - [Get a placement group](#get-a-placement-group)
  - [List placement groups](#list-placement-groups)
  - [Update a placement group](#update-a-placement-group)
- [Security group management commands](#security-group-management-commands)
  - [Remove all rules of a security group](#remove-all-rules-of-a-security-group)
  - [Create a security group](#create-a-security-group)
  - [Delete a security group](#delete-a-security-group)
  - [Get a security group](#get-a-security-group)
  - [List security groups](#list-security-groups)
  - [Update security group](#update-security-group)
- [Server management commands](#server-management-commands)
  - [Attach a volume to a server](#attach-a-volume-to-a-server)
  - [Backup server](#backup-server)
  - [Connect to the serial console of an instance](#connect-to-the-serial-console-of-an-instance)
  - [Create server](#create-server)
  - [Delete server](#delete-server)
  - [Detach a volume from its server](#detach-a-volume-from-its-server)
  - [Get a server](#get-a-server)
  - [List all servers](#list-all-servers)
  - [Reboot server](#reboot-server)
  - [SSH into a server](#ssh-into-a-server)
  - [Put server in standby mode](#put-server-in-standby-mode)
  - [Power on server](#power-on-server)
  - [Power off server](#power-off-server)
  - [Terminate server](#terminate-server)
  - [Update a server](#update-a-server)
  - [Wait for server to reach a stable state](#wait-for-server-to-reach-a-stable-state)
- [Server type management commands](#server-type-management-commands)
  - [List server types](#list-server-types)
- [Snapshot management commands](#snapshot-management-commands)
  - [Create a snapshot from a given volume](#create-a-snapshot-from-a-given-volume)
  - [Delete a snapshot](#delete-a-snapshot)
  - [Get a snapshot](#get-a-snapshot)
  - [List snapshots](#list-snapshots)
  - [Wait for snapshot to reach a stable state](#wait-for-snapshot-to-reach-a-stable-state)
- [User data management commands](#user-data-management-commands)
  - [Delete user data](#delete-user-data)
  - [Get user data](#get-user-data)
  - [List user data](#list-user-data)
  - [Add/Set user data](#addset-user-data)
- [Volume management commands](#volume-management-commands)
  - [Create a volume](#create-a-volume)
  - [Delete a volume](#delete-a-volume)
  - [Get a volume](#get-a-volume)
  - [List volumes](#list-volumes)
  - [Update a volume](#update-a-volume)
- [Volume type management commands](#volume-type-management-commands)
  - [List volumes types](#list-volumes-types)

  
## Image management commands

Images are backups of your instances.
You can reuse that image to restore your data or create a series of instances with a predefined configuration.

An image is a complete backup of your server including all volumes.



### Create an instance image

Create an instance image.

**Usage:**

```
scw instance image create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Name of the image |
| snapshot-id | Required | UUID of the snapshot that will be used as root volume in the image |
| arch | Required<br />One of: `x86_64`, `arm` | Architecture of the image |
| default-bootscript |  | Default bootscript of the image |
| additional-snapshots.{key}.id |  | UUID of the snapshot to add |
| additional-snapshots.{key}.name |  | Name of the additional snapshot |
| additional-snapshots.{key}.size |  | Size of the additional snapshot |
| additional-snapshots.{key}.volume-type | One of: `l_ssd`, `b_ssd` | Underlying volume type of the additional snapshot |
| additional-snapshots.{key}.organization-id |  | Organization ID that own the additional snapshot |
| public |  | True to create a public image |
| organization-id |  | Organization ID to use. If none is passed will use default organization ID from the config |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create an image named 'foobar' for x86_64 instances from the given root_volume ID (root_volume ID needs to be a snapshot UUID)
```
scw instance image create name=foobar root-volume=11111111-1111-1111-1111-111111111111 arch=x86_64
```




### Delete an instance image

Delete the image with the given ID.

**Usage:**

```
scw instance image delete <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required |  |
| with-snapshots |  | Delete the snapshots attached to this image |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete an image in the default zone with the given ID
```
scw instance image delete 11111111-1111-1111-1111-111111111111
```

Delete an image in fr-par-1 zone with the given ID
```
scw instance image delete 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Get an instance image

Get details of an image with the given ID.

**Usage:**

```
scw instance image get <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get an image in the default zone with the given ID
```
scw instance image get 11111111-1111-1111-1111-111111111111
```

Get an image in fr-par-1 zone with the given ID
```
scw instance image get 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### List instance images

List all images available in an account.

**Usage:**

```
scw instance image list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  |  |
| public |  |  |
| arch |  |  |
| organization-id |  |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all public images in the default zone
```
scw instance image list
```




### Wait for image to reach a stable state

Wait for image to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the image.

**Usage:**

```
scw instance image wait <image-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image-id | Required | ID of the image. |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Wait for a image to reach a stable state
```
scw instance image wait 11111111-1111-1111-1111-111111111111
```




## IP management commands

A flexible IP address is an IP address which you hold independently of any server.
You can attach it to any of your servers and do live migration of the IP address between your servers.

Be aware that attaching a flexible IP address to a server will remove the previous public IP address of the server and cut any ongoing public connection to the server.



### Reserve a flexible IP

Reserve a flexible IP.

**Usage:**

```
scw instance ip create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | The project ID the IP is reserved in |
| server |  | UUID of the server you want to attach the IP to |
| tags.{index} |  | An array of keywords you want to tag this IP with |
| organization-id |  | Organization ID to use. If none is passed will use default organization ID from the config |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create an IP in the default zone
```
scw instance ip create
```

Create an IP in fr-par-1 zone
```
scw instance ip create zone=fr-par-1
```

Create an IP and attach it to the given server
```
scw instance ip create server=11111111-1111-1111-1111-111111111111
```




### Delete a flexible IP

Delete the IP with the given ID.

**Usage:**

```
scw instance ip delete <ip ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip | Required | The ID or the address of the IP to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete an IP in the default zone with the given ID
```
scw instance ip delete 11111111-1111-1111-1111-111111111111
```

Delete an IP in fr-par-1 zone with the given ID
```
scw instance ip delete 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```

Delete an IP using directly the given IP address
```
scw instance ip delete 51.15.253.183
```




### Get a flexible IP

Get details of an IP with the given ID or address.

**Usage:**

```
scw instance ip get <ip ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip | Required | The IP ID or address to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get an IP in the default zone with the given ID
```
scw instance ip get 11111111-1111-1111-1111-111111111111
```

Get an IP in fr-par-1 zone with the given ID
```
scw instance ip get 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```

Get an IP using directly the given IP address
```
scw instance ip get
```




### List all flexible IPs

List all flexible IPs.

**Usage:**

```
scw instance ip list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project |  | The project ID the IPs are reserved in |
| name |  | Filter on the IP address (Works as a LIKE operation on the IP address) |
| organization-id |  | The organization ID the IPs are reserved in |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all IPs in the default zone
```
scw instance ip list
```

List all IPs in fr-par-1 zone
```
scw instance ip list zone=fr-par-1
```




### Update a flexible IP

Update a flexible IP.

**Usage:**

```
scw instance ip update <ip ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip | Required | IP ID or IP address |
| reverse |  | Reverse domain name |
| tags.{index} |  | An array of keywords you want to tag this IP with |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Update an IP in the default zone with the given ID
```
scw instance ip update 11111111-1111-1111-1111-111111111111 reverse=example.com
```

Update an IP in fr-par-1 zone with the given ID
```
scw instance ip update 11111111-1111-1111-1111-111111111111 zone=fr-par-1 reverse=example.com
```

Update an IP using directly the given IP address
```
scw instance ip update 51.15.253.183 reverse=example.com
```




## Placement group management commands

Placement groups allow the user to express a preference regarding
the physical position of a group of instances. It'll let the user
choose to either group instances on the same physical hardware for
best network throughput and low latency or to spread instances on
far away hardware to reduce the risk of physical failure.

The operating mode is selected by a `policy_type`. Two policy
types are available:
  - `low_latency` will group instances on the same hypervisors
  - `max_availability` will spread instances on far away hypervisors

The `policy_type` is set by default to `max_availability`.

For each policy types, one of the two `policy_mode` may be selected:
  - `optional` will start your instances even if the constraint is not respected
  - `enforced` guarantee that if the instance starts, the constraint is respected

The `policy_mode` is set by default to `optional`.



### Create a placement group

Create a new placement group.

**Usage:**

```
scw instance placement-group create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Name of the placement group |
| policy-mode | One of: `optional`, `enforced` |  |
| policy-type | One of: `max_availability`, `low_latency` |  |
| organization-id |  | Organization ID to use. If none is passed will use default organization ID from the config |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create a placement group with default name
```
scw instance placement-group create
```

Create a placement group with the given name
```
scw instance placement-group create name=foobar
```

Create an enforced placement group
```
scw instance placement-group create policy-mode=enforced
```

Create an optional placement group
```
scw instance placement-group create policy-mode=optional
```

Create an optional low latency placement group
```
scw instance placement-group create policy-mode=optional policy-type=low_latency
```

Create an enforced low latency placement group
```
scw instance placement-group create policy-mode=enforced policy-type=low_latency
```




### Delete the given placement group

Delete the given placement group.

**Usage:**

```
scw instance placement-group delete <placement-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| placement-group-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete a placement group in the default zone with the given ID
```
scw instance placement-group delete 11111111-1111-1111-1111-111111111111
```

Delete a placement group in fr-par-1 zone with the given ID
```
scw instance placement-group delete 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Get a placement group

Get the given placement group.

**Usage:**

```
scw instance placement-group get <placement-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| placement-group-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a placement group with the given ID
```
scw instance placement-group get 6c15f411-3b6f-402d-8eba-ae24ef9254e9
```




### List placement groups

List all placement groups.

**Usage:**

```
scw instance placement-group list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Filter placement groups by name (for eg. "cluster1" will return "cluster100" and "cluster1" but not "foo") |
| organization-id |  | List only placement groups of this organization |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all placement groups in the default zone
```
scw instance placement-group list
```

List placement groups that match a given name ('cluster1' will return 'cluster100' and 'cluster1' but not 'foo')
```
scw instance placement-group list name=cluster1
```




### Update a placement group

Update one or more parameter of the given placement group.

**Usage:**

```
scw instance placement-group update <placement-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| placement-group-id | Required | UUID of the placement group |
| name |  | Name of the placement group |
| policy-mode | One of: `optional`, `enforced` |  |
| policy-type | One of: `max_availability`, `low_latency` |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Update the name of a placement group
```
scw instance placement-group update 95053f33-cd3c-4cdc-b2b0-57d2dda97b13 name=foobar
```

Update the policy mode of a placement group (All instances in your placement group MUST be shutdown)
```
scw instance placement-group update 1f883434-8c2d-40f0-b686-d0754b3a7bc0 policy-mode=enforced
```

Update the policy type of a placement group (All instances in your placement group MUST be shutdown)
```
scw instance placement-group update 0954ec26-9917-47b6-8c5c-7bc81d7bb9d2 policy-type=low_latency
```




## Security group management commands

A security group is a set of firewall rules on a set of instances.
Security groups enable to create rules that either drop or allow incoming traffic from certain ports of your instances.

Security Groups are stateful by default which means return traffic is automatically allowed, regardless of any rules.
As a contrary, you have to switch in a stateless mode to define explicitly allowed.



### Remove all rules of a security group



**Usage:**

```
scw instance security-group clear [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required | ID of the security group to reset. |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Remove all rules of the given security group
```
scw instance security-group clear security-group-id=11111111-1111-1111-1111-111111111111
```




### Create a security group

Create a security group.

**Usage:**

```
scw instance security-group create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name of the security group |
| description |  | Description of the security group |
| organization-default | Default: `false` | Whether this security group becomes the default security group for new instances |
| stateful | Default: `true` | Whether the security group is stateful or not |
| inbound-default-policy | Default: `accept`<br />One of: `accept`, `drop` | Default policy for inbound rules |
| outbound-default-policy | Default: `accept`<br />One of: `accept`, `drop` | Default policy for outbound rules |
| organization-id |  | Organization ID to use. If none is passed will use default organization ID from the config |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create a Security Group with the given name and description
```
scw instance security-group create name=foobar description=foobar foobar
```

Create a Security Group that will be applied as a default on instances of your organization
```
scw instance security-group create organization-default=true
```

Create a Security Group that will have a default drop inbound policy (Traffic your instance receive)
```
scw instance security-group create inbound-default-policy=drop
```

Create a Security Group that will have a default drop outbound policy (Traffic your instance transmit)
```
scw instance security-group create outbound-default-policy=drop
```

Create a stateless Security Group
```
scw instance security-group create
```




### Delete a security group

Delete a security group.

**Usage:**

```
scw instance security-group delete <security-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete a security group with the given ID
```
scw instance security-group delete 69e17c83-9945-47ac-8b29-8c1ad050ee83
```




### Get a security group

Get the details of a Security Group with the given ID.

**Usage:**

```
scw instance security-group get <security-group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a security group with the given ID
```
scw instance security-group get a3244331-5d32-4e36-9bf9-b60233e201c7
```




### List security groups

List all security groups available in an account.

**Usage:**

```
scw instance security-group list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the security group |
| organization-id |  | The security group organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all security groups that match the given name
```
scw instance security-group list name=foobar
```




### Update security group

Update security group.

**Usage:**

```
scw instance security-group update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| security-group-id | Required | ID of the security group to update |
| name |  |  |
| description |  |  |
| stateful |  |  |
| inbound-default-policy | One of: `accept`, `drop` |  |
| outbound-default-policy | One of: `accept`, `drop` |  |
| organization-default |  |  |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Set the default outbound policy as drop
```
scw instance security-group update security-group-id=11111111-1111-1111-1111-111111111111 outbound-default-policy=drop
```

Set the given security group as the default for the organization
```
scw instance security-group update security-group-id=11111111-1111-1111-1111-111111111111 organization-default=true
```

Change the name of the given security group
```
scw instance security-group update security-group-id=11111111-1111-1111-1111-111111111111 name=foobar
```

Change the description of the given security group
```
scw instance security-group update security-group-id=11111111-1111-1111-1111-111111111111 description=foobar
```

Enable stateful security group
```
scw instance security-group update security-group-id=11111111-1111-1111-1111-111111111111 stateful=true
```

Set the default inbound policy as drop
```
scw instance security-group update security-group-id=11111111-1111-1111-1111-111111111111 inbound-default-policy=drop
```




## Server management commands

Server types are denomination of the different instances we provide.
Scaleway offers **Virtual Cloud** and **dedicated GPU** instances.

**Virtual Cloud Instances**

Virtual cloud instances are offering the best performance/price ratio for most workloads. Different CPU architectures are proposed: The **Development** and **General Purpose** ranges are based on AMD EPYC CPUs. The **ARM64** range is based on Cavium Thunder X ARM CPUs.

* The **Development** instances range provides stable and consistent performance for development needs.
  Spin up a development or test environment within seconds.
  Refer to the [Development Instance offer details](https://www.scaleway.com/en/development-instances/) for more information.

* The **General Purpose** instances range is the solution for demanding workloads.
  Powerful AMD EPYC CPUs back those instances and offer up to 48 Cores, 256GB of RAM and 600GB of replicated local NVMe SSD storage.
  Refer to the [General Purpose offer details](https://www.scaleway.com/en/general-purpose-instances/) for more information.

* The **ARM** instances range is based on Cavium ThunderX SoCs and provides up to 64 Cores ARM 64bit, 128GB of RAM and 1TB SSD storage.
  Refer to the [ARM offer details](https://www.scaleway.com/en/arm-instances) for more information.

**Dedicated GPU Instances**

GPU instances are very powerful compute instances, providing lots of RAM, vCPU, and storage.

They are equipped with Nvidia Tesla P100 GPUs, which are designed for handling rapidly, a massive amount of data.
They are useful for heavy data processing, artificial intelligence and machine learning, video encoding, rendering, and so on.
The GPU is dedicated to each instance and directly exposed through PCI-e.
For more information, refer to [GPU Instances](https://www.scaleway.com/en/gpu-instances/).



### Attach a volume to a server



**Usage:**

```
scw instance server attach-volume [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| volume-id | Required | ID of the volume to attach |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Attach a volume to a server
```
scw instance server attach-volume server-id=11111111-1111-1111-1111-111111111111 volume-id=22222222-1111-5555-2222-666666111111
```




### Backup server

Create a new image based on the server.

This command:
  - creates a snapshot of all attached volumes.
  - creates an image based on all these snapshots.

Once your image is ready you will be able to create a new server based on this image.


**Usage:**

```
scw instance server backup <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to backup. |
| name | Default: `<generated>` | Name of your backup. |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create a new image based on a server
```
scw instance server backup 11111111-1111-1111-1111-111111111111
```




### Connect to the serial console of an instance



**Usage:**

```
scw instance server console <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to connect to |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |



### Create server

Create an instance server.

**Usage:**

```
scw instance server create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| image | Required | Image ID or label of the server |
| type | Default: `DEV1-S`<br />One of: `GP1-XS`, `GP1-S`, `GP1-M`, `GP1-L`, `GP1-XL`, `DEV1-S`, `DEV1-M`, `DEV1-L`, `DEV1-XL`, `RENDER-S` | Server commercial type |
| name | Default: `<generated>` | Server name |
| root-volume |  | Local root volume of the server |
| additional-volumes.{index} |  | Additional local and block volumes attached to your server |
| ip | Default: `new` | Either an IP, an IP ID, 'new' to create a new IP, 'dynamic' to use a dynamic IP or 'none' for no public IP (new | dynamic | none | <id> | <address>) |
| tags.{index} |  | Server tags |
| ipv6 |  | Enable IPv6 |
| stopped |  | Do not start server after its creation |
| security-group-id |  | The security group ID it use for this server |
| placement-group-id |  | The placement group ID in witch the server has to be created |
| bootscript-id |  | The bootscript ID to use, if empty the local boot will be used |
| cloud-init |  | The cloud-init script to use |
| organization-id |  | Organization ID to use. If none is passed will use default organization ID from the config |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create and start an instance on Ubuntu Focal
```
scw instance server create image=ubuntu_focal
```

Create a GP1-XS instance, give it a name and add tags
```
scw instance server create image=ubuntu_focal type=GP1-XS name=foo tags.0=prod tags.1=blue
```

Create an instance with 2 additional block volumes (50GB and 100GB)
```
scw instance server create image=ubuntu_focal additional-volumes.0=block:50GB additional-volumes.1=block:100GB
```

Create an instance with 2 local volumes (10GB and 10GB)
```
scw instance server create image=ubuntu_focal root-volume=local:10GB additional-volumes.0=local:10GB
```

Use an existing IP
```
ip=$(scw instance ip create | grep id | awk '{ print $2 }')
scw instance server create image=ubuntu_focal ip=$ip
```




### Delete server

Delete a server with the given ID.

**Usage:**

```
scw instance server delete <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required |  |
| with-volumes | Default: `none`<br />One of: `none`, `local`, `block`, `root`, `all` | Delete the volumes attached to the server |
| with-ip |  | Delete the IP attached to the server |
| force-shutdown |  | Force shutdown of the instance server before deleting it |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete a server in the default zone with a given id
```
scw instance server delete 11111111-1111-1111-1111-111111111111
```

Delete a server in fr-par-1 zone with a given id
```
scw instance server delete 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Detach a volume from its server



**Usage:**

```
scw instance server detach-volume [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | ID of the volume to detach |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Detach a volume from its server
```
scw instance server detach-volume volume-id=22222222-1111-5555-2222-666666111111
```




### Get a server

Get the details of a specified Server.

**Usage:**

```
scw instance server get <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a server with the given ID
```
scw instance server get 94ededdf-358d-4019-9886-d754f8a2e78d
```




### List all servers

List all servers.

**Usage:**

```
scw instance server list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Filter servers by name (for eg. "server1" will return "server100" and "server1" but not "foo") |
| private-ip |  | List servers by private_ip |
| without-ip |  | List servers that are not attached to a public IP |
| commercial-type |  | List servers of this commercial type |
| state | One of: `running`, `stopped`, `stopped in place`, `starting`, `stopping`, `locked` | List servers in this state |
| tags.{index} |  | List servers with these exact tags |
| organization-id |  | List only servers of this organization |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all servers on your default zone
```
scw instance server list
```

List servers of this commercial type
```
scw instance server list commercial-type=DEV1-S
```

List servers that are not attached to a public IP
```
scw instance server list without-ip=true
```

List servers that match the given name ('server1' will return 'server100' and 'server1' but not 'foo')
```
scw instance server list name=server1
```




### Reboot server



**Usage:**

```
scw instance server reboot <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Reboot a server in the default zone with a given id
```
scw instance server reboot 11111111-1111-1111-1111-111111111111
```

Reboot a server in fr-par-1 zone with a given id
```
scw instance server reboot 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### SSH into a server

Connect to distant server via the SSH protocol.

**Usage:**

```
scw instance server ssh <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to SSH into |
| username | Default: `root` | Username used for the SSH connection |
| port | Default: `22` | Port used for the SSH connection |
| command |  | Command to execute on the remote server |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |



### Put server in standby mode



**Usage:**

```
scw instance server standby <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Put in standby a server in the default zone with a given id
```
scw instance server standby 11111111-1111-1111-1111-111111111111
```

Put in standby a server in fr-par-1 zone with a given id
```
scw instance server standby 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Power on server



**Usage:**

```
scw instance server start <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Start a server in the default zone with a given id
```
scw instance server start 11111111-1111-1111-1111-111111111111
```

Start a server in fr-par-1 zone with a given id
```
scw instance server start 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Power off server



**Usage:**

```
scw instance server stop <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Stop a server in the default zone with a given id
```
scw instance server stop 11111111-1111-1111-1111-111111111111
```

Stop a server in fr-par-1 zone with a given id
```
scw instance server stop 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Terminate server

Terminates a server with the given ID and all of its volumes.

**Usage:**

```
scw instance server terminate <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required |  |
| with-ip |  | Delete the IP attached to the server |
| with-block | Default: `prompt`<br />One of: `prompt`, `true`, `false` | Delete the Block Storage volumes attached to the server |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Terminate a server in the default zone with a given id
```
scw instance server terminate 11111111-1111-1111-1111-111111111111
```

Terminate a server in fr-par-1 zone with a given id
```
scw instance server terminate 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```

Terminate a server and also delete its flexible IPs
```
scw instance server terminate 11111111-1111-1111-1111-111111111111 with-ip=true
```




### Update a server

Update a server.

**Usage:**

```
scw instance server update <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the server |
| name |  | Name of the server |
| ip |  | IP that should be attached to the server (use ip=none to detach) |
| cloud-init |  | The cloud-init script to use |
| boot-type | One of: `local`, `bootscript`, `rescue` |  |
| tags.{index} |  | Tags of the server |
| bootscript |  |  |
| dynamic-ip-required |  |  |
| enable-ipv6 |  |  |
| protected |  |  |
| security-group-id |  |  |
| volume-ids.{index} |  | Will update ALL volume IDs at once, including the root volume of the server (use volume-ids=none to detach all volumes) |
| placement-group-id |  | Placement group ID if server must be part of a placement group |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Update the name of a given server
```
scw instance server update 11111111-1111-1111-1111-111111111111 name=foobar
```

Put a given instance in rescue mode (reboot is required to access rescue mode)
```
scw instance server update 11111111-1111-1111-1111-111111111111 boot-type=rescue
```

Overwrite tags of a given server
```
scw instance server update 11111111-1111-1111-1111-111111111111 tags.0=foo tags.1=bar
```

Enable IPv6 on a given server
```
scw instance server update 11111111-1111-1111-1111-111111111111 enable-ipv6=true
```

Apply the given security group to a given server
```
scw instance server update
```

Put a given server in the given placement group. Server must be off
```
scw instance server update
```




### Wait for server to reach a stable state

Wait for server to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the server.

**Usage:**

```
scw instance server wait <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Wait for a server to reach a stable state
```
scw instance server wait 11111111-1111-1111-1111-111111111111
```




## Server type management commands

Server types will answer with all instance types available in a given zone.
Each of these types will contains all the features of the instance (CPU, RAM, Storage) with their associated pricing.



### List server types

Get server types technical details.

**Usage:**

```
scw instance server-type list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all server-types in the default zone
```
scw instance server-type list
```

List all server-types in fr-par-1 zone
```
scw instance server-type list zone=fr-par-1
```




## Snapshot management commands

Snapshots contain the data of a specific volume at a particular point in time.
The data can include the instance's operating system,
configuration information or files stored on the volume.

A snapshot can be done from a specific volume (for example you
have a server with a volume containing the OS and another one
containing the application data, and you want to use different
snapshot strategies on both volumes).

Snapshots only work on `l_ssd` volume type at the moment. `b_ssd`
snapshots will be available starting 2020.



### Create a snapshot from a given volume

Create a snapshot from a given volume.

**Usage:**

```
scw instance snapshot create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Name of the snapshot |
| volume-id | Required | UUID of the volume |
| organization-id |  | Organization ID to use. If none is passed will use default organization ID from the config |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create a snapshot in the default zone from the given volume ID
```
scw instance snapshot create volume-id=11111111-1111-1111-1111-111111111111
```

Create a snapshot in fr-par-1 zone from the given volume ID
```
scw instance snapshot create zone=fr-par-1 volume-id=11111111-1111-1111-1111-111111111111
```

Create a named snapshot from the given volume ID
```
scw instance snapshot create name=foobar volume-id=11111111-1111-1111-1111-111111111111
```




### Delete a snapshot

Delete the snapshot with the given ID.

**Usage:**

```
scw instance snapshot delete <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete a snapshot in the default zone with the given ID
```
scw instance snapshot delete 11111111-1111-1111-1111-111111111111
```

Delete a snapshot in fr-par-1 zone with the given ID
```
scw instance snapshot delete 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### Get a snapshot

Get details of a snapshot with the given ID.

**Usage:**

```
scw instance snapshot get <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a snapshot in the default zone with the given ID
```
scw instance snapshot get 11111111-1111-1111-1111-111111111111
```

Get a snapshot in fr-par-1 zone with the given ID
```
scw instance snapshot get 11111111-1111-1111-1111-111111111111 zone=fr-par-1
```




### List snapshots

List snapshots.

**Usage:**

```
scw instance snapshot list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  |  |
| organization-id |  |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all snapshots in the default zone
```
scw instance snapshot list
```

List all snapshots in fr-par-1 zone
```
scw instance snapshot list zone=fr-par-1
```




### Wait for snapshot to reach a stable state

Wait for snapshot to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the snapshot.

**Usage:**

```
scw instance snapshot wait <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | ID of the snapshot. |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Wait for a snapshot to reach a stable state
```
scw instance snapshot wait 11111111-1111-1111-1111-111111111111
```




## User data management commands

User data is a key value store API you can use to provide data from and to your server without authentication.

As an example of use, Scaleway images contain the script scw-generate-ssh-keys which generates SSH server’s host keys then stores their fingerprints as user data under the key “ssh-host-fingerprints”.
This way, we ensure they are really connecting to their Scaleway instance and they are not victim of a man-in-the-middle attack.

There are two endpoints to access user data:
 - **From a running instance**, by using the metadata API at http://169.254.42.42/user_data.
   To enhance security, we only allow user data viewing and editing as root.
   To know if the query is issued by the root user, we only accept queries made from a local port below 1024 (by default, non-root users can’t bind ports below 1024).
   To specify the local port with cURL, use `curl --local-port 1-1024 http://169.254.42.42/user_data`
 - **From the instance API** at using methods described bellow.



### Delete user data

Delete the given key from a server user data.

**Usage:**

```
scw instance user-data delete <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the server |
| key | Required | Key of the user data to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Get user data

Get the content of a user data with the given key on a server.

**Usage:**

```
scw instance user-data get <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the server |
| key | Required | Key of the user data to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### List user data

List all user data keys registered on a given server.

**Usage:**

```
scw instance user-data list <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Add/Set user data

Add or update a user data with the given key on a server.

**Usage:**

```
scw instance user-data set <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the server |
| key | Required | Key of the user data to set |
| content | Required | Content of the user data |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



## Volume management commands

A volume is where you store your data inside your instance. It
appears as a block device on Linux that you can use to create
a filesystem and mount it.

We have two different types of volume (`volume_type`):
  - `l_ssd` is a local block storage: your data is downloaded on
    the hypervisor and you need to power off your instance to attach
    or detach a volume.
  - `b_ssd` is a remote block storage: your data is stored on a
    centralised cluster. You can plug and unplug a volume while
    your instance is running. As of today, `b_ssd` is only available
    for `DEV1`, `GP1` and `RENDER` offers.

Minimum and maximum volume sizes for each volume types can be queried
from the zone `/products/volumes` API endpoint. _I.e_ for:
  - `fr-par-1`  use https://api.scaleway.com/instance/v1/zones/fr-par-1/products/volumes
  - `nl-ams-1`  use https://api.scaleway.com/instance/v1/zones/nl-ams-1/products/volumes

Each types of volumes is also subject to a global quota for the sum of all the
volumes. This quota depends of the level of support and may be
changed on demand.

Be wary that when terminating an instance, if you want to keep
your block storage volume, **you must** detach it beforehand you
issue the `terminate` call.

When using multiple block devices, it's advised to mount them by
using their UUID instead of their device name. A device name is
subject to change depending on the volumes order. Block devices
UUIDs can be found in `/dev/disk/by-id/`.



### Create a volume

Create a volume.

**Usage:**

```
scw instance volume create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  |  |
| volume-type | One of: `l_ssd`, `b_ssd` |  |
| size |  |  |
| base-volume |  |  |
| base-snapshot |  |  |
| organization-id |  | Organization ID to use. If none is passed will use default organization ID from the config |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create a volume called 'my-volume'
```
scw instance volume create name=my-volume
```

Create a volume with a size of 50GB
```
scw instance volume create size=50GB
```

Create a volume of type 'l_ssd', based on volume '00112233-4455-6677-8899-aabbccddeeff'
```
scw instance volume create volume-type=l_ssd base-volume=00112233-4455-6677-8899-aabbccddeeff
```




### Delete a volume

Delete the volume with the given ID.

**Usage:**

```
scw instance volume delete <volume-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete a volume with the given ID
```
scw instance volume delete af136619-bc59-4b48-a0ed-ed7dceaad9a6
```




### Get a volume

Get details of a volume with the given ID.

**Usage:**

```
scw instance volume get <volume-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a volume with the given ID
```
scw instance volume get b70e9a0e-28b1-4542-bb9b-06d2d6debc0f
```




### List volumes

List volumes.

**Usage:**

```
scw instance volume list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-type | One of: `l_ssd`, `b_ssd` | Filter by volume type |
| name |  | Filter volume by name (for eg. "vol" will return "myvolume" but not "data") |
| organization-id |  | Filter volume by organization |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all volumes
```
scw instance volume list
```

List all block storage volumes
```
scw instance volume list volume-type=b_ssd
```

List all local storage volumes
```
scw instance volume list volume-type=l_ssd
```

List all volumes that match a name
```
scw instance volume list name=foobar
```

List all block storage volumes that match a name
```
scw instance volume list volume-type=b_ssd name=foobar
```




### Update a volume

Replace name and/or size properties of given ID volume with the given value(s). Any volume name can be changed while, for now, only `b_ssd` volume growing is supported.

**Usage:**

```
scw instance volume update <volume-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | UUID of the volume |
| name |  | The volume name |
| size |  | The volume disk size |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Change the volume name
```
scw instance volume update 11111111-1111-1111-1111-111111111111 name=my-new-name
```

Change the volume disk size (bytes)
```
scw instance volume update 11111111-1111-1111-1111-111111111111 size=60GB
```

Change the volume name and disk size
```
scw instance volume update 11111111-1111-1111-1111-111111111111 name=a-new-name size=70GB
```




## Volume type management commands

Volume types will answer with all volume types available in a given zone.
Each of these types will contains all the capabilities and constraints of the volume (min size, max size, snapshot).



### List volumes types

Get volumes technical details.

**Usage:**

```
scw instance volume-type list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all volume-types in the default zone
```
scw instance volume-type list
```

List all volume-types in fr-par-1 zone
```
scw instance volume-type list zone=fr-par-1
```




