// Code generated by go-bindata. (@generated) DO NOT EDIT.
// sources:
// 3d.flf
// 2d.flf
// quindar-tone.mp3
package asset

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _data3dFlf = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x5a\x5d\x6b\x5b\x49\x0f\xbe\xf7\xaf\xd0\x85\xe1\xb4\x70\x88\xde\xa6\x7d\x17\x0a\xc6\x04\x7a\x51\x58\x7c\xbd\x57\x03\x3a\x6e\xeb\x64\xcb\xba\x49\x49\x9a\xdd\x0d\xe4\xc7\x2f\x33\x23\x69\xa4\x39\x1f\x3e\xb6\x93\x90\xdd\xce\xd8\x39\xf3\x8c\x34\xd2\xa3\x8f\x39\xd7\xfb\xeb\xcb\xed\x12\x3e\xc2\x6f\xf0\xfe\x7f\xf0\x0e\xfe\xbf\xd8\x6f\xef\xef\x9f\xde\x7f\xbb\xb8\xde\x5f\xc3\x97\x27\xd8\xc4\x29\x7c\xde\xed\xbf\xec\xee\x6f\xe0\x4d\xfa\xf6\xe6\x6a\xfb\xf7\xc3\xc5\xd7\xbb\x1f\x6f\x17\x6f\x1e\x7e\xdd\xed\x77\xb7\xb0\xff\xfe\x65\x77\xbf\xdd\xef\x9f\xe0\xfa\xfe\xee\x07\xfc\xfe\xb8\xbd\x85\x4f\xdb\xfb\xe6\x01\x7e\x3e\x5e\x5f\x3f\xc5\xd5\xde\x2e\x7e\xfd\xb3\xdb\xfe\xb5\xfb\x16\x97\xfd\xbc\xdf\xdd\xde\xc2\xa7\x3f\xb7\x3f\x7f\xee\xf6\x7b\x58\xdd\xdc\x7c\xbd\x7a\xfc\xfe\xf8\xf5\x62\xf7\xed\x71\xbd\xf8\x63\x77\xff\xf0\xfd\xee\x16\xde\x5d\x5c\xc2\x25\x5e\x7e\xc0\x8f\x1f\x16\x0b\x58\x5e\x4d\xff\xc7\x3f\x57\x57\x0b\x20\xca\xc3\x05\x06\x08\x79\x14\x07\x21\x8d\x80\x87\xf1\x91\x00\x81\x42\x1a\x41\xc0\x40\x21\x2f\x13\x90\xd0\x2c\x58\x2f\xed\x56\xb7\x00\x14\xe2\x6a\x19\x03\x09\x91\x70\x99\x1f\x5f\xe6\xe7\x97\x79\x2d\x99\x95\x85\x1d\x4a\x6f\x12\x67\x05\x36\x7e\x49\x19\x38\x7d\x12\xb7\x11\x07\xf1\x37\x49\x15\x90\x36\xf9\xfb\x0d\xa5\x95\x30\xc4\xbf\x4b\xdf\x27\x99\x91\x30\x6f\x55\x84\xe4\xcd\x7a\x58\xe8\x4d\x8b\x62\x45\x78\x51\x44\xc0\x86\xa8\x0b\xe5\xf3\xc0\x5b\x89\x7b\x24\x82\x90\x55\x92\xb5\x9d\x37\x01\x5d\x20\x60\x35\x77\x81\x8a\xf2\x59\xfd\x05\x2c\xfe\x93\x84\x8c\xeb\x23\x20\xcb\x88\x3c\x91\x6d\xe6\x09\xcf\xd2\x84\xb2\xf8\x90\xff\x96\x01\xd2\xa4\x3a\xe1\xbe\xb0\xac\xf3\xa2\x72\x7c\x8e\x1a\x0c\x3c\x7b\xc6\x38\x7a\x96\x07\x03\x22\x44\xf9\x31\xc9\x19\xff\x34\x6c\xd6\x00\x2b\xba\x5a\xc0\x73\x56\x01\x61\xd6\x76\x40\x9e\xd4\x80\x3d\xf8\x61\x1b\x8e\x16\x95\x21\x93\x1d\x89\x71\x19\xcb\x5a\x0e\x5a\xae\xb3\xe1\x64\x0c\xf9\x53\x6c\x64\x71\x0c\xd0\x62\xe3\x7c\x45\x9c\xa5\x53\x6f\xe9\x02\xf1\x39\x75\xa1\xb2\x18\x3b\xac\xb6\xcf\x96\x11\xe2\xbf\x79\xa9\x2e\x8e\xb3\xe3\x75\x21\xee\x21\x1f\x54\x20\x3e\x96\x6a\xf1\x6a\xfb\x95\x27\x80\xba\x41\x07\x0d\x88\x0f\xac\x21\x9e\x80\x38\x40\x0b\xad\xb3\x7e\x6b\xfa\x4e\xf9\x6e\x5c\x81\xc9\x49\x24\xbd\x50\x36\x6e\xf6\xbf\xe8\x5d\x11\x20\x9e\x6f\xb2\x73\x06\x30\x04\x33\x07\x4c\x3e\xaa\xfe\xcf\x30\x51\x4d\xd1\x06\xf2\xf9\xf3\xb7\x23\x47\xe0\x86\x94\x7f\x64\xaf\xa4\x5b\x4d\xc6\x78\x78\x85\xc3\x5b\xe3\x05\xd1\x7d\x2b\x4b\x10\x15\x1f\x2d\xfe\x99\x8f\x3c\xfb\xb3\xf1\xe5\xec\xa0\x71\xd1\x3c\x98\xb2\x62\x73\x34\x42\x40\xac\x28\x14\xb6\x0f\x10\x0c\xe1\x07\x3e\x90\xa0\xec\x1f\x15\x20\x01\x20\x8d\x0f\x31\xb1\x38\x4f\xde\x75\x53\x2c\x22\x59\x99\xba\x0d\x92\x6e\x81\xed\x40\x62\x4e\x6d\x15\x7d\xb3\x18\x42\x25\x22\x2b\x6b\x61\x5b\x0a\x6c\x97\xf9\x00\x10\x01\x95\xf8\xe2\x98\x09\x57\x0e\xde\xb0\xd0\x2c\xd4\x11\x0d\x53\xd8\xa8\x86\x91\x90\x02\xad\x88\x55\x12\x03\xcf\x39\x1a\x9e\x8a\xb0\x32\x93\xa3\x4c\x31\x48\x81\xc4\xc7\x6b\x27\x9f\xa3\x61\xf6\x10\x41\x8d\x73\x63\x40\x69\xdb\x8c\x1a\x95\xdf\xb1\x78\x22\x6c\x46\x65\x61\x35\x89\x98\xa1\x61\xaa\xcf\xd5\xd8\x30\x89\x27\x24\x99\x13\xa8\x0a\x7e\xa6\x86\x45\x5a\x25\x04\x48\xcb\xe5\xc7\xb1\xc1\x46\xe2\x68\x13\x7f\xc5\xd4\x53\x78\x60\x53\x47\x5d\x3b\x46\xbf\x21\xa0\x43\xd6\x04\xd6\x5f\xad\x35\xad\x81\xe0\xc5\xac\x69\x26\x6a\x5a\xb9\x15\x96\x40\xa2\x16\x05\x15\xc4\x61\x75\xed\x5e\xf6\x30\xc4\x12\xe5\x53\x89\x86\x92\xc4\xb0\xcb\x48\x68\xd2\xb0\xd4\x7b\xee\xb8\x85\x24\xb1\x0a\x12\x42\xeb\x85\x48\x79\x01\x98\x7e\xd3\x20\x2e\xb7\x02\x58\xb1\x22\xba\xf4\x9b\x62\x74\x0c\xf7\xcf\x12\xed\x27\xe2\xb1\xd5\x83\x9a\x96\x0d\x36\x00\x26\xdc\xa8\xe0\x12\x88\x94\x8f\x26\xb5\x3a\x40\x13\x50\x27\x18\x6e\xf3\x6b\x80\x75\x25\x6e\x10\x7b\xc9\x36\x7b\x20\x3f\xca\x06\x93\xbd\x2e\xd1\x49\xe8\x38\xca\x45\x0f\x91\x8c\xe5\xb8\xf2\xa1\x12\x88\x5c\x2c\xa1\x2e\x90\xe0\xc6\x19\x04\xcd\xff\xc4\x09\x02\x27\x61\x99\xe9\xf2\x58\xb4\xd8\x09\xad\x4f\x90\x9b\xb0\x1b\x38\x52\xdd\x38\x56\x85\x94\xb1\x8b\xc7\x71\x2c\x55\x86\x33\xae\x90\x68\x76\x46\x26\xed\x12\xe9\x44\x65\x7d\x70\xc5\x86\x55\x53\xa0\xcf\xe1\xd6\x69\x54\xf1\x20\x16\x51\xcc\xf2\xd5\x51\x6d\x22\x02\x86\xd8\x4a\x69\xf4\xf2\xa8\x1b\x2b\x2b\x50\xd8\xc0\xcb\xca\x6a\x30\x0d\x62\xc1\xc3\x62\x4a\xd6\x8e\x8a\x11\x4d\xe4\x9d\x47\x48\x16\x36\x64\x25\xc3\xf6\x1c\xc9\xc0\x27\x21\x55\x23\x81\x2a\x87\x01\xe7\x30\xf0\x12\x0e\x63\xe0\x89\x6b\x7b\x61\xfc\xa4\x48\x79\xd0\x16\x6b\x71\x9a\xeb\x12\x89\xdf\x86\x1e\x4a\xda\x37\x0b\xbe\x80\x53\x09\xcd\x84\x25\x8d\xa5\x22\xa7\xaf\xec\x8d\xb6\x07\x94\xed\xc6\x33\x54\x9d\xb2\x11\x55\x75\x9b\xe2\x54\x51\x75\x90\xda\xf4\x74\x55\x97\xef\xb4\xbe\x03\x5b\x04\x1b\x7f\x95\x96\xc2\xd9\x9e\xe3\xbf\xc3\x26\x10\x9a\xbc\x24\xfd\xb8\xec\xd3\xd7\x2f\x68\x13\xa2\x50\x84\x4e\xae\x34\x57\xe8\x09\x9d\x77\x3e\xcb\x6e\xa1\x73\xe6\xdd\xbd\x88\x79\x1b\xa5\x03\x0d\xb1\xa4\xa7\x49\xcf\x93\x60\x15\x7f\x8a\x79\xc3\x08\x6d\x81\xd0\x56\x2b\xa5\xd2\xe9\xb4\x75\xba\x88\xa1\x09\x4e\x44\xab\xe1\xd4\xaa\x9b\x1f\x71\x3d\x6d\x0e\x07\xfc\x16\xb4\x91\x56\x6a\xac\xf1\x03\x86\x33\xe1\x5b\xa6\x6d\x4e\xb5\x83\x12\x0c\x54\xf9\xbe\xe6\x37\xa7\xf0\x17\x55\xe4\x69\xa9\xd3\x12\x27\x2f\x0d\x26\xdd\x77\xd9\x7e\x6d\xd0\xc7\xf2\x17\xbc\xb6\x31\x0b\xfc\xe1\xc6\x47\x95\x6f\xa0\xf2\x57\xd2\x32\x43\xa5\x2c\x72\x4e\x7c\x04\xf0\xc8\x71\xe6\xd1\x71\x78\x07\xbd\x5d\x98\xcc\x27\xed\xe4\xdf\xb2\x9b\x86\x2d\xbe\xdf\x9d\xae\x95\x61\x77\xe6\x7b\xa7\xf6\x40\xba\xd0\x99\x88\xd2\x05\x84\x75\x8e\x28\xea\xd6\x0d\x96\x98\x92\xf2\xfb\xca\xfe\x07\x08\xb6\xde\x49\xd1\x90\x36\xee\xa4\x40\xcb\x3b\x88\x28\x52\x61\x81\x14\xdb\xdd\x39\x36\xd8\xcb\x18\xb8\xa6\xd7\xc0\x2d\x75\xbd\x3e\x2c\x53\x91\x34\x95\x1c\x44\xe0\x33\x87\xda\x1e\x7b\x16\xd9\x3f\x06\x47\x00\xec\xfe\x8e\xfa\xc0\x85\x54\xeb\x0c\xe0\x48\xcf\xc6\xd3\x43\x1e\xa8\x58\xca\xb2\x9d\x96\x85\x9d\x8c\xa5\xf1\xdc\x49\xe7\xd9\xb7\xb3\x47\x3b\xa1\xb5\x40\x4c\x58\x85\x52\x60\x90\x52\x8a\x6f\x67\x6d\xce\x16\xc8\xb5\x2c\xc0\x74\x2c\x08\x85\x38\x03\x62\xac\x61\xf3\x15\x80\xbb\x5e\x1a\xba\x5d\x9a\x04\x3b\xf8\x47\xa3\x63\xc5\x4d\x9b\x28\x4d\x66\x57\xdc\x97\xda\x7e\xf4\x52\x23\xe8\xa5\x06\x9e\x73\xa9\x31\xb6\x5f\xdf\x61\x33\xd7\x54\x9b\x70\x91\xda\x87\xb9\xd7\x76\x11\x74\xbf\xbd\x2c\x66\xcc\xe4\x86\xb3\x46\xe9\xad\x25\x6b\xc8\x90\xc3\x59\x63\x7b\x52\xd6\xe8\x47\x12\xe9\xa4\x7d\x58\x7a\x87\x7a\xff\x56\x8e\x61\xbc\x2f\x61\x94\x54\xdc\xd2\xd4\x39\xbe\x1f\x51\xba\x11\xa4\xbd\x08\x8c\x23\x98\xf0\xa1\xe1\x03\xb4\xdb\xef\x82\x66\x4b\x47\x6e\x1f\x44\xe5\xc3\x5a\x88\xe9\x5c\x28\xf9\xf3\x55\x7d\xf5\x3b\x75\xdb\x34\xcf\xae\xc0\xd9\x15\x0c\x5d\x7f\x12\x91\x9e\x3e\xda\x22\x89\x72\x7c\x73\x76\xe5\x0d\xcb\x58\x16\x14\xf6\x04\x32\x57\x73\x2f\x51\x77\xea\xe7\xa6\xfc\x13\xbe\xf1\x71\x5c\x35\xa8\x0a\xb4\x8f\x0f\x9d\xb9\xe5\x4f\x65\xcf\xd0\xbf\x93\xd7\xb2\xb2\x14\x95\xa6\xc0\x12\x3f\x99\xa1\x2b\x6c\xec\x1d\xe6\x2b\x14\x8e\x26\xec\x94\xab\xe1\x48\xcc\x55\x58\xd3\xe8\x40\x7a\x5d\xc1\xe7\xaf\xda\x3b\x18\x11\x46\xb7\xa2\x1c\x50\x8a\x9a\x26\x16\x1b\x5c\x70\x94\xa4\x10\x8b\xcb\x5a\x89\x45\xdc\x79\x59\xcd\xc0\x57\x85\x83\x18\x1b\x3c\xae\xc5\x34\x78\x47\xd2\x44\x61\x39\x28\x34\xc1\x64\x3a\x60\x1e\x07\x7c\xd9\x0f\x6d\xb5\xa0\x74\x7d\x5a\x3d\x38\xc1\xdf\x8b\xe9\x0b\xcb\x89\xab\x08\x3a\x74\x15\x31\xe0\x7a\x0b\x20\x7d\x71\xa2\x6b\xf2\x7d\xaf\xee\xbc\xec\xdb\x33\xdf\x88\xe7\xfa\x63\x10\x9a\x6d\x85\x66\xe3\x66\x73\x63\x7c\xee\x31\xb8\x84\x4d\xde\x62\xc9\x4a\xb6\x3d\x59\x97\x19\x96\xc4\xd0\x96\xc2\x07\xad\xa8\x77\xd4\xe5\x7d\x12\x6b\x9e\x5a\x83\xd8\x5e\x4e\x3f\x26\x9f\x8b\x81\xf0\xac\x18\x28\x07\x50\xdd\x61\x8d\x60\xc0\xa0\xe7\x0b\x96\xc7\xab\x30\xa5\xd2\xcb\xb8\xa9\xb8\x6a\x14\xbb\x87\x3f\x04\x34\x62\x0e\xfc\xda\x11\x03\x37\xf9\x06\x71\x0d\xb0\x42\x4e\x02\x51\x7c\x1e\x8f\xb8\x13\x19\x10\x0f\x06\x8b\xdb\xd2\x15\xc3\xae\xc4\x59\xe8\xd2\xb1\xad\x41\x9c\x04\x4d\x71\xcb\xfa\x9e\xe6\x02\x50\x52\x6f\x3b\x6d\x1c\x00\xb8\x8b\x2b\x73\x6d\x35\x62\x84\x0a\x22\x8c\xdf\x48\x7f\xb4\x4d\xea\x5f\xf1\xab\x2a\x2b\x90\x82\xa4\x94\x23\x95\x6d\x0f\x7b\x8f\x8b\x7a\xb6\x5f\x39\x58\x5b\x41\x89\x76\xb3\xbb\x1e\x2e\x11\x60\x5a\xe7\x97\x78\xe4\xcd\xa0\x75\x3c\xe8\xf4\x16\x44\xa6\x82\x54\xcc\x66\x7d\x0d\xf1\x0a\xd3\xa0\xbb\x61\x83\xc0\x6f\x51\x48\x85\x43\x98\xdf\x9b\xcb\x66\x43\xc8\x95\xc0\x52\x35\xbb\x9c\x8c\xcd\x07\xe3\x36\xf8\x5c\xc4\xe7\x23\x72\x35\xe6\x2e\xda\x55\x8d\xa0\x56\x96\xd5\x85\x27\xf5\x9b\x27\xe1\xc9\xc1\xe3\x4b\xb6\x8b\xe0\x30\xfe\xab\xf6\x5e\x0f\xe2\x67\x15\x92\x3e\x59\x8a\x8e\x91\xd6\xa0\xbc\xf0\x91\xea\xf7\xf6\xe8\x76\x99\xa2\x17\x70\x87\x5d\x43\x1b\xe4\xa3\xdb\x65\x2e\xa5\xae\x51\xcd\xdb\x0e\x18\x46\x2e\x05\x4f\x40\xad\x3a\xdd\xd4\x6b\xce\xe9\x39\xaf\x68\x45\xbe\x90\x28\x6c\xe1\x5f\x66\x53\xd4\xac\xad\x0a\xf5\xbf\x00\x00\x00\xff\xff\xb2\x63\x04\xcd\x51\x2c\x00\x00")

func data3dFlfBytes() ([]byte, error) {
	return bindataRead(
		_data3dFlf,
		"3d.flf",
	)
}

func data3dFlf() (*asset, error) {
	bytes, err := data3dFlfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "3d.flf", size: 11345, mode: os.FileMode(420), modTime: time.Unix(1550435406, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _data2dFlf = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x7d\x6d\x73\xda\x48\xb6\xff\x7b\x3e\xc5\x79\x31\xf5\x0f\xd4\x3f\xb8\x8d\x6c\x63\xbb\x2a\x9b\x32\x06\xd9\xd6\x04\x83\x57\x40\x66\x93\xd1\x54\x0f\x89\x49\x4c\x0d\x81\x94\x8d\x77\x6e\xea\xea\x7e\xf7\x5b\xea\x67\x75\x9f\x96\x5a\xce\xde\xd4\xae\xc1\x18\x9d\x5f\x9f\xee\x3e\xe7\x77\x1e\x5a\x9a\x2f\x9b\x2f\xd1\xf2\x17\xe8\xc3\x09\xf4\xfa\xd0\x3b\x81\x5e\x0f\x0e\x21\x3a\x3e\xee\x1f\xb5\x66\xfb\xe5\xf6\x7e\xf9\x78\x0f\x9f\x7e\xc0\xf5\x66\xb5\xdd\xc2\xf0\x61\xf9\xfd\xfb\x6a\xb3\x81\xff\x07\xc9\x92\xfd\xba\x86\x23\x72\x7e\x04\xdd\x2e\x7c\x5a\x3e\xad\xee\x61\xb7\x85\xab\xc7\xe5\xf6\xaf\x57\x4f\x70\xf0\xb4\xfe\xda\x4a\xb6\x9f\x37\xcf\xf7\xab\x27\x48\x66\x53\x18\x2f\xf7\xeb\x6d\xb7\xd7\xfa\xb2\xfe\xba\x59\xed\xe1\x71\xb5\x59\x2d\x9f\x56\x10\x1d\xf4\x0a\x01\xbd\x08\x06\xcf\x5f\xa1\x77\x7e\x7e\xdc\xba\xdd\xdd\xaf\xbf\xac\x57\xf7\xf0\x65\xf7\x08\xe2\xeb\xd1\x41\x54\x8c\xe4\xd7\xdd\xc3\x16\x86\xbb\xbf\x97\x5b\x78\xf3\xb9\x78\xb9\xf8\xfc\x79\xbd\x39\xd8\x3d\x7e\x7d\xdb\x02\xd8\xef\x60\x79\x7f\x2f\x90\xfe\x3b\x7a\x7d\xf4\xfa\xf8\xf5\xc9\xff\xc0\xd3\xf3\xf7\xef\xbb\xc7\x3d\xb4\x17\xdb\xf5\xe7\xdd\xfd\x0a\x16\xff\xff\xb0\x77\x78\xd8\x3d\xec\x9d\x5e\x75\x0e\x5a\x77\xab\xc7\x6f\xeb\xa7\xa7\xf5\x6e\x0b\xeb\x27\x78\x58\x3d\xae\x3e\xfd\x80\xaf\xeb\x7f\xaf\xb6\x85\xc0\x6f\xc5\x60\x7e\xc0\xfe\x61\xfd\x04\x5f\x76\xdb\xfd\x6b\x58\x3e\xc1\x66\xb7\xfd\x5a\xbc\xee\x1f\x56\xad\x6f\x7c\xb4\x8f\xaf\x9e\x60\xbb\xfc\xb6\x2a\x64\x7c\xdf\x2c\x3f\xf3\xe9\x58\xc2\xe7\xdd\xb7\x6f\xab\xed\x1e\x36\xeb\xed\xea\xa0\xa5\x75\xfb\xf4\x03\xee\x96\xcf\x1b\xb8\x7c\x7e\xdc\xef\xb6\xf0\xe6\x69\xb7\x79\xde\xaf\x77\xdb\x8b\xd5\xf2\x71\xff\xb0\x59\x6f\xff\x3a\xd8\xae\xf6\x6f\xa1\x17\x91\xf3\x7e\x31\x90\x35\x9f\x4c\xd8\xae\xfe\x86\xef\xcb\xc7\xe5\xb7\xd5\x7e\xf5\xd8\x12\xba\x71\x81\x57\xc9\x75\x31\x57\xcb\xed\x7d\xf1\xf6\xb7\xf5\xf6\x00\xe0\x76\xf9\x03\x96\x9b\xa7\x1d\x7c\x5a\xc1\xd3\x66\xfd\xf5\x61\xbf\xf9\x01\xdf\xcc\x19\xfe\xb4\xda\xef\x57\x8f\xf0\xfc\xb4\x6a\xed\xbe\x30\xf1\x5f\x9e\x37\x9b\xee\xdf\xeb\xfb\xfd\x03\xf9\x6b\xf5\xb8\x25\x4f\xdf\x9e\x9f\x1e\x60\xb9\xd9\xaf\x1e\xb7\xcb\xfd\xfa\xdf\xab\xa7\xd7\xf0\xe9\x79\x0f\xf7\xab\x2f\xcb\xe7\xcd\x1e\x76\xcf\xfb\xef\xcf\xfb\x42\xf3\xc9\x74\x0e\x9f\x1f\x96\xdb\xaf\xab\xfb\x83\x16\xfc\x72\x81\xfd\xff\xa2\x05\x40\xe1\xa2\x05\x39\xe4\xfa\x27\x2d\x7e\xb6\x69\xa7\xf8\x2b\x80\xf8\x12\xfb\x5a\x1b\x72\x60\x1f\xbf\x87\xf7\xc0\xfe\xfc\x0b\x94\x5f\xe5\x05\xc5\x25\xc5\xff\xd8\xa7\x34\x87\x3c\x87\x9c\x23\x51\x80\x83\x83\xe2\x33\xf1\x0b\xfb\x6e\xce\xae\xc9\x69\x9e\xd3\x5c\x4b\x32\xc4\x51\xfe\x69\x0e\x79\xf1\x4a\x80\xb2\xe1\x65\x94\x42\xc6\xc6\x05\x40\xd8\xdf\x69\x2e\x07\x0c\x94\x72\x35\x08\xff\x13\x10\x20\x4c\x06\x01\xc2\x46\x42\x28\x51\x4a\x6a\x1c\x2a\x07\xdd\x06\x0a\x1d\x10\x57\x50\xc8\x48\xc6\x66\xa8\x4d\xdf\x02\xbc\x29\x3e\xcd\x28\xa5\x24\x23\xc6\x60\xf5\x7c\xb6\xd9\x34\xe5\x1c\xf0\x17\xe3\xa7\xc6\x11\x43\xe1\xd3\x0e\xce\x0b\x64\x34\x2b\xbe\x4a\xb9\xe6\x19\x64\x72\x02\x9c\x17\x42\x89\x9c\x74\x3e\xf6\x62\x5c\x0c\x20\x03\x31\x31\xa4\x98\x8f\x8c\x7d\x27\x23\xc6\x04\xeb\xcb\x40\xad\x9a\x5a\x32\xb5\x5e\xc6\xfa\x98\x8b\x23\x2e\xb6\x7f\x5a\x13\x60\x23\xa8\xaf\x15\xff\x38\x42\xf1\x8f\x23\x14\xfb\x28\x14\xa1\xb4\x41\xd9\x94\x8a\xaf\xc8\x85\x66\x6f\xe4\x92\xf3\x4b\x8b\xa9\x42\x10\xa8\x98\x65\xbe\xd2\x72\x15\x94\x51\x50\x31\xdd\x6c\xc5\xdd\xe1\xc9\x39\x03\x02\x72\x7e\x72\xec\x1d\x32\x7b\x54\x22\x17\x93\x20\x96\xb8\xd8\xdb\x1c\xaf\xd8\xe6\xc4\x99\xa2\xd2\xc5\x6a\x06\xa5\xce\xb9\x14\x43\xa5\x18\x76\xb1\x39\x6c\x6d\x21\x20\x54\xd5\x5b\x4f\xbe\x2b\x86\x95\x8b\x6b\x98\x51\xf9\xc6\x5d\xbc\xcd\x2d\x0d\xfc\xd0\x72\xba\x01\xb4\x29\x72\x31\xaf\xd4\xc4\xb7\xa5\xfa\xe8\x74\x97\x95\x86\xdc\xbb\xe4\x94\x54\x2d\x34\xb7\x6e\x6b\xc9\xab\x91\xd1\x5d\x62\x5e\xf2\x5a\x8d\x06\xdb\x25\xf6\xc6\x45\x37\x31\xfe\xa5\xb2\x2d\x99\xae\x43\xe8\x2d\xbd\x43\x26\x6c\xdc\x31\x6c\xc4\xd8\x6a\xcc\xce\xf2\x3b\x19\xf3\xb3\x12\x55\xeb\x27\xd7\x44\x6e\x9a\x4c\xae\x82\xf2\xc6\xc5\x64\xd3\x8e\xc3\x0e\x6a\x32\xd9\x2e\x17\x28\x85\x3a\xf4\x4f\x69\x76\xd0\x56\x86\xc7\xa6\x57\x0c\x36\x13\x9b\x4a\x9a\xbd\x36\x68\xc2\x1c\x9e\x14\x5a\xfc\x22\xad\x48\x00\xf0\x4d\xa1\x67\xc9\xb3\xa1\xf9\xce\xc8\xc1\x70\x06\x75\x1b\x5a\x38\x1f\x86\x25\x87\x0f\xd2\xbc\xe4\x5f\x33\x9f\x15\x83\x83\xe7\x38\x1f\x1c\x59\xaf\x2b\xa8\x75\x65\xce\xbb\x8c\x5c\xe7\x3f\xc0\x18\x36\x05\x35\x1a\x21\x86\xe6\x1e\x9f\x89\xe9\x2c\xc3\x09\xd3\x67\xba\xc8\xa0\xbf\xe8\x6a\xca\xfe\x2e\x22\x11\x11\x8d\x58\xc3\x16\xc4\x44\x25\x09\x9a\xb1\x41\x6e\xe2\x29\x33\x90\xdc\x20\x99\x93\x42\xa0\x7b\x97\x81\x44\x5e\x18\x20\x67\xeb\x57\xdc\xe8\x72\x38\x10\xcb\x45\x73\x73\x4b\x29\x0d\xe5\x22\x60\xef\x6a\x16\x46\xb2\x59\xce\xf9\x5a\x0c\x34\x23\x6a\xcc\xa0\x83\x35\x28\xcf\x91\x33\xc3\x99\xd2\x14\x32\x75\x7d\xa6\x67\x38\x73\xf0\x7f\x8a\x0f\xf1\xfd\x2c\xed\x07\x34\xa5\xf9\x76\x55\x20\x72\xc9\x8a\xc3\x90\xe1\x0d\x28\x9d\xbd\x17\x13\xc5\x68\x59\x30\xa3\x19\xee\xd5\x88\x96\x42\x63\x00\xd4\x18\xc2\x66\x9b\xf2\x7d\x26\x82\xbd\x4c\xbb\xde\xe2\x17\x45\x8a\x19\xbc\x07\x15\xf5\x65\x16\x31\x96\x04\x95\x65\x59\xe2\x2c\x89\x96\x50\x57\xae\x21\x5a\x0a\x55\xe2\x54\x2c\xae\x1c\xb3\x6d\x42\x6c\x44\x6a\x30\xea\xc2\xf7\x2a\xd0\xa9\x0d\xac\xa8\x0c\x64\x7c\xf1\x7f\xc9\xf4\xa4\xe5\x71\x67\x9a\xfb\xe2\xf2\xbc\xb8\x46\x4d\x98\x9a\x2a\x39\x49\x72\x7a\x32\x35\x31\xb6\x63\x90\xfb\xc4\x8d\xe3\x95\x49\x73\x84\x62\xc2\x19\xef\x67\x7c\x90\x22\x81\x28\xbf\x20\x21\x7c\xd5\x3b\x27\x0e\xb0\x82\x0c\xe0\x58\x58\xc6\xa2\xa5\x51\x91\x0d\x9a\x64\xdd\x36\x76\xe9\x6b\xd4\xdf\x6b\xcf\xe7\x44\x7c\x9a\x5d\x0f\xd0\x00\x5b\x03\x6b\xc6\x91\xb0\x9a\x59\xad\xa5\x04\xed\xf5\xa9\x1c\x5c\xf0\x80\x51\x4c\xc8\x94\x07\xf3\x61\xea\x2f\x2b\x36\x95\x5c\x2a\x7d\x9e\x43\x4d\xa1\xb3\x2a\xf6\x88\x0e\x7e\xea\x66\xd5\xa0\x08\x84\x45\x75\x94\xe9\x26\xff\x66\x6e\xc3\x5e\x65\x9c\x2a\x86\xa3\x58\x94\xc8\x1d\x6b\x0e\x49\xa0\xdb\xb4\x09\xca\xfd\x22\x6c\x69\x0f\x03\x1d\x4c\x69\x27\xb3\x09\x33\xd5\xfe\xd3\x62\x8c\xb2\xfa\x16\x49\x22\x21\x32\x34\x9e\x43\x6b\x9b\xd8\xbc\x55\x93\x4e\xd4\x20\x2b\xde\x3a\xb0\x18\xf3\x65\xfb\x86\xfb\xc9\xf2\xe6\xa6\xca\xdf\xbd\x32\xa3\x56\x85\xe5\x1a\xd4\x85\x8e\xbf\xa4\x11\xca\x1a\x0c\xdb\x98\xa5\xcd\x4d\xf5\xee\x94\x21\xaa\x69\x15\xc5\x95\x6e\xa0\x26\x47\x56\x11\x20\x56\x98\x2c\x04\x10\x07\x23\x2a\xf4\x62\xe3\xfa\x92\x88\x92\x94\x92\x20\x4b\x96\xed\x3e\x10\xea\x7b\x2b\xcc\x00\x61\xbc\x46\xfa\x3b\xde\xc0\x58\x1e\x2a\x22\x11\x22\xe8\x4e\xb2\x9d\x3d\xdb\x3c\x93\x54\xd9\x1a\x27\xb8\x37\xf0\xa6\x54\x6b\x53\x95\x28\xaf\x95\x2a\x5b\x95\x93\x27\x59\xb1\x24\xe5\x2d\xbc\x35\x7e\x67\x99\x98\x60\x39\x92\x73\x9a\x23\x92\xd9\xf0\x57\x27\x5e\x6a\xd3\x0e\x95\x8e\x89\xd0\xcc\xb2\xbf\x02\x01\x09\xf3\x90\x8b\xcd\x50\xb3\x2e\x17\x50\x17\x6b\xdf\x19\x9e\x48\x60\xc8\xe1\x04\x5a\x31\xec\x9a\x92\x49\xf8\xb0\x11\xb3\x72\x09\x50\x79\xf4\x3c\x93\x9f\xe4\xcc\xf4\x85\xd7\xb8\x68\xf5\xfa\x87\x00\x93\x69\xf7\x32\x8d\x07\xef\x60\x76\x37\x18\xc6\xfe\x12\x74\xaf\xdf\x03\x48\x26\xef\xe3\x74\x1e\x8f\x20\xfe\xd7\x70\x3c\xb8\x1d\xcc\x93\xe9\x04\x6e\x07\xe9\xbb\x30\xaa\xea\xf5\x23\x80\x61\x3c\x99\xc3\x2c\xb9\x9e\x08\xe6\xd2\x71\xa2\x0c\x1a\x3a\xe5\xa0\x01\x00\x04\xad\xf1\xb2\x71\xaf\x7f\x04\x70\x37\x5d\x4c\x46\x86\x18\xa3\x4e\xf1\x9a\xb2\xf9\xa6\x3a\x4b\x36\x52\xb9\x36\x7d\x6d\xe5\x72\x5c\xe4\x31\xc0\x70\x91\xa6\xf1\x64\xf8\x41\x48\x25\xbc\x72\xcc\xeb\xb3\xc2\x4c\xf5\x1a\x8a\x72\x45\xf1\x57\x56\xac\x20\xa5\x05\xe9\xf5\x4f\x00\x3e\xc4\x13\x39\x40\x2a\x7d\xb8\xf6\x70\x39\xfb\x2c\x2f\xbd\xc3\x82\xe4\x5e\xbf\x0f\x70\x99\x4e\xdf\xc5\x13\xb8\x1c\xa4\x96\x81\xd3\xdc\x36\x79\x66\xe0\xbd\xfe\x29\xc0\x2c\x1e\xb2\xf5\x31\x26\x09\x44\x38\xc0\xa6\x98\xc8\x00\x38\x83\x4c\x14\x8e\xb2\xc2\x5b\xb2\x59\x12\x86\xdf\xeb\x9f\x01\x8c\x92\x41\x9c\xc6\xb3\x64\x86\xef\x52\x56\x96\x92\xb1\xa8\xfb\xce\xd0\xe4\x1c\x60\x38\xbd\xfb\x90\x26\xd7\x37\xf3\xd2\xda\x51\xa3\x38\xcb\xd3\x39\x90\x4e\xb1\x88\x0a\x15\xcd\xb7\xd9\x17\x75\xb1\x89\xe6\xda\xcb\xf3\x94\x8f\x01\x9d\x1e\x02\x5c\xc5\xb7\xc9\x24\x99\xc4\x30\x4d\x47\xc9\x64\x30\x86\x64\x32\x4a\x86\x83\xf9\x34\x6d\x69\x36\x56\x96\xad\x8c\x2a\x2f\x97\xdb\x4c\xcf\xdf\x3b\xed\x01\x8c\xe3\xab\x79\xf7\x6e\x9a\x4c\xe6\xc9\xe4\x1a\x46\xd3\xc5\xe5\x38\x86\xc1\xe4\x7a\x1c\xc3\x3f\x17\xd3\x79\xc9\x22\xa4\x93\x67\x7a\xc8\x3a\xa0\xaa\x04\xaa\x5a\x60\x99\x5f\x7a\xa7\x11\xb0\xae\x90\x9a\x1f\xc0\xb2\x02\x28\xc5\x0b\x72\xb8\xd6\x84\x9f\x1e\x01\xcc\xa6\x57\x73\xb8\xf9\x70\x77\x13\x4f\x4a\x11\xb3\x29\x15\xea\x14\x3f\x06\x48\xe3\xeb\x64\x36\x8f\xd3\x78\x14\xb6\x72\x39\xf3\x7b\x62\xe5\x58\xc0\x42\xd4\xca\xe5\x34\xa7\x19\xbe\x72\x27\x00\xb7\x83\x61\x3a\x9d\x04\xf4\x1e\xb0\x77\x6a\xc8\x7d\x80\x51\x7c\x9d\xc6\xb1\x1a\xae\x8e\xfd\x94\x43\xd6\xfe\x98\x80\x47\xf5\x53\x80\xbb\xf1\x62\xd6\xbd\x4d\x26\x8b\x59\xc9\x6f\xf1\xe9\x43\x3a\x30\xb4\xd0\xcf\x19\xb7\x92\x78\x06\x30\x5b\xdc\xc5\xe9\x6c\x98\x26\x77\x73\x98\xff\x36\x2d\x95\xcb\xa0\x83\xc6\x03\x65\x7e\xed\x9d\x9e\x5b\x52\x6e\xd2\x38\x36\xe3\x0a\x2a\x8b\xbb\x56\xd8\x67\xc9\x39\x3b\x04\x18\x0c\x17\xf3\x18\x06\xc3\xc2\x33\xb7\x44\xbc\x41\xf8\xd7\xcd\x14\xd3\x48\x34\x7b\x67\x3d\x80\xdb\x64\x98\x4e\x91\x6d\x5a\x5d\x35\x3c\x50\x86\x96\x2b\x61\x11\xc0\x5d\x32\x1e\xa6\xd3\xdf\x8c\xc5\xd2\x8c\x06\x20\x6b\x6b\x6d\x29\x91\xc5\xb3\x32\xcd\x61\xfb\xc9\xf6\xe8\x67\x47\xc5\x08\x47\xa3\x71\x0c\xa3\xe9\xbc\xa5\x47\xa7\xcb\xf6\x88\x5a\x05\x0d\xc4\xa3\x64\x3c\x1e\xb4\xb4\xa5\xd8\x3f\x99\x8c\x0e\xed\xb0\x2b\x4e\xca\xeb\x30\x9d\xc4\xf2\x1b\xc4\x65\xc1\x12\x56\xbf\xd8\xea\xb3\xe1\x62\xec\xf7\x52\xd2\x49\x71\xa2\x11\x6b\x98\xfb\xf6\xc4\xd9\x29\x00\xf3\xad\x81\x0e\x4a\x15\xd3\x32\xb3\x81\xa0\x5a\x08\xb2\x89\x60\x86\x2a\x0c\xe6\x0c\xe0\xfd\x62\x7c\x3d\x48\xe1\x2a\x1d\x70\x8e\x99\x4e\x0a\xf1\x83\x74\x1e\xa7\x72\x0b\xc8\x24\xb3\x70\x05\xcc\x91\xcb\x34\x83\xb0\x8f\x44\x99\x86\x00\x29\xf6\x3c\x57\x88\x17\xfe\xcb\x8d\x2c\x85\x7a\x8e\xa3\xde\x0c\xc6\x57\x26\xa4\x46\x94\x59\x53\xce\xfb\x57\x1d\x89\xa7\x4b\x4c\x94\x94\x03\x6e\x05\x76\x7e\xe8\x82\x31\x0b\x93\x4a\xce\x54\x2d\x52\xe9\xc9\x4c\xce\xd0\x94\x99\x5e\x49\x57\x5a\xd6\xd6\xaf\xaf\x18\x84\x19\x70\xfd\x73\x11\xcf\xca\xdc\x22\x3a\x64\xa2\x69\xa3\x5a\xee\xbc\x6a\x96\x59\x79\x44\xef\x3c\x02\x18\x0f\xe6\xc9\x04\x86\x83\xbb\x64\x3e\x18\xc3\x38\x9e\xcf\xe3\x14\x06\xf0\x5b\x32\xbf\x81\xeb\x74\xf0\x3e\x6e\x99\x5d\xbf\x82\x9a\xa4\x6b\x0f\x0a\xdb\x7b\xe7\x47\xd5\x18\xcc\xcf\xc8\x48\x44\x4a\x26\x0d\x31\x8e\xab\x31\x86\x49\x3a\x5c\xdc\x5e\x8d\xe3\x7f\x31\xa1\x44\xe6\x37\x84\x66\x79\x33\xa0\x93\x6a\xa0\x79\x32\x1e\x31\x65\x8a\xcc\x48\x60\x64\x4d\x95\xe9\x57\x63\xf8\x02\xaf\x86\xf9\x54\xef\xfc\xb4\x1a\x27\x2d\x5c\xc5\xe0\x72\xfa\x3e\x2e\x71\x1b\xb4\x77\x9d\x86\x0a\x9d\xf9\x80\xb8\x64\xee\xd6\xf5\x09\x00\xd0\xfc\xc8\xcc\x46\x46\xbf\xac\xd9\x28\x43\xf6\x02\xc9\x61\x52\x85\x78\xee\x41\x1c\x8a\xfd\xa0\xbd\xf9\x0b\xda\x7f\x9d\xc2\xba\x2e\x5a\xd1\xe1\xa1\x07\x25\xf6\x59\x4f\x11\xd6\x61\x2d\x3f\x6f\x5c\x10\x1d\xf6\xaa\x31\x5c\xeb\x29\x5c\x73\x43\x0c\x9f\x17\x88\xc3\xac\x27\x1c\xc8\xe7\x0a\xe2\xa0\x9d\x1d\x8e\xe3\x73\x07\x49\x79\x61\xe4\x94\x65\x54\xf4\x02\xcb\x5d\x49\xbb\x1b\x19\x1d\xfa\xac\x3f\xb1\x16\x43\x6e\x29\x59\xfc\xab\x93\xeb\xb3\xf8\x04\x59\x00\x22\x5b\x0b\x34\xcb\x83\x84\xfb\xcc\x3c\x09\x73\x27\x0c\x80\xdb\xa6\x6a\xdb\xe4\xb2\xcd\x66\x4e\xba\xcf\xca\xe3\xf9\x8d\xca\x0b\x54\x5e\x0f\xaa\x3b\x57\x6a\x93\xeb\x72\x3f\x72\xf4\x85\xc3\xf8\x4c\x7b\x82\x78\x60\xe5\x80\xd9\x9e\x51\x1d\xd4\x83\x3f\x65\xf8\x95\x95\xbb\x00\x51\xcf\x67\xd2\xd3\x7a\x42\x0c\x2c\x45\x45\x3d\x9f\x49\x4f\xeb\x09\x31\x18\xc3\x67\xd2\xd3\x40\x42\x0c\x06\xf2\x99\xf4\xb4\x9e\x10\x83\x31\x7c\xe6\x3c\x0d\xdb\xc1\xc1\x38\x45\x9a\xb9\x18\xcf\x93\xbb\x71\x11\x6d\x97\xaa\x24\xf2\xab\x05\xf3\xf0\xe3\x84\xe2\x28\x61\xa6\x8f\x11\x32\x19\x3e\x53\x16\x63\x9d\xcd\xd3\xe9\xbb\xd8\x26\x1e\x42\x64\x50\x2a\xd3\x03\x42\x64\xdb\x8b\x20\x03\xf5\x99\xf4\x22\x80\x78\xc2\x6a\x9e\x51\xcf\x67\xce\x8b\x00\xe2\x09\xc5\xf0\xd9\xf2\xa2\x66\x97\x42\x96\x37\x02\x8a\x7c\x66\xbd\xa8\xde\x41\x0d\x0b\xc5\x51\xe4\x33\xed\x0f\x9e\x49\xa3\x6c\xd2\x2a\x1a\xe5\x4e\xe5\x2f\x8a\x7c\xa6\x3d\xbf\x99\xa6\x13\xa7\xb5\xa8\x0f\x09\xe9\x16\xa8\x51\xf0\xb5\x85\x2b\x73\x9e\xdd\x0e\xc6\x4a\xf4\xec\x66\x90\xde\xc1\xac\xf5\xc2\x92\x72\x14\x1d\xa3\x62\x2b\xb3\x8c\x46\x6d\xea\x28\x3a\xa9\x42\xc0\x5d\x6a\x43\x84\x7e\x15\x42\x88\x43\x0d\x83\x39\xad\x82\xc1\xdd\x69\x43\x45\xce\xaa\x10\x02\x9c\x69\x18\xca\x79\x15\x8a\x9d\x5b\xc8\x55\x69\xb7\x3b\xfa\x64\xe7\xab\x00\x98\xa3\x43\x1c\x26\x2e\x25\xef\x62\x73\x99\x2e\xf7\x4f\x50\x1b\xb8\x00\x30\x0e\x06\x38\xad\x00\x81\xd4\x43\x91\xdc\x8c\x02\xa0\xc1\x91\x07\x99\x4b\x1c\x45\xa8\x74\x2c\x93\x50\x51\xc7\x45\xd8\xd1\x86\xe8\x08\x37\x6a\x2c\x83\x50\xd1\x46\xb0\x6c\xdc\xb2\xbd\x99\x83\x32\x8a\x60\x00\xdc\xb0\xc3\x32\x06\x93\xfa\xe5\xe1\x35\xd1\x21\xb0\xb6\x11\x6e\xdc\xe5\x7c\x81\x8a\x22\x4a\x56\xd1\xcc\x8a\x8e\x70\xfb\xb5\x32\x04\xa3\x9a\xea\x97\x84\xdb\x69\x40\x4e\x00\xd6\xb1\xca\x52\x31\x89\x89\xc6\x8d\x33\x30\x23\x80\xb0\xd3\x71\xd1\x31\x6e\x9b\x22\x1f\x28\xc2\x28\x7e\x81\x6c\xab\x03\x2d\x3e\x92\x7d\x34\xd5\x82\x71\x69\xf6\x18\x37\x45\x2c\x03\x28\x87\x9c\xa1\xc7\x43\xa2\x63\xdc\x1c\x9b\x65\x01\x55\x9d\xdd\xe8\x18\x37\xca\x66\x39\x40\x35\x02\x6e\x9a\x2f\xc8\x00\xaa\x61\x70\x03\x6d\x16\xff\x57\x23\xe0\xc6\xd9\x3c\xfa\xaf\x46\x39\x05\x18\x25\xef\x93\x59\x39\xee\x57\x21\x92\x0a\xa5\x0b\xd9\x76\xe9\xa1\x90\x6c\xcb\xc3\xcd\xd7\xc9\x03\xca\x84\xa1\x4f\x22\x49\x9b\x86\x36\x21\x72\xd8\x76\x32\xc0\x81\x70\x63\x7e\x79\x2e\xe0\x90\xec\x09\x6e\xc8\x2f\xcf\x04\x5c\x04\xdc\xa2\x7f\x32\x0f\x70\x61\x70\xb3\xfe\xb9\x2c\xc0\x45\xc1\x4d\xdb\x97\x03\x04\x4c\x97\x75\x60\x28\x3a\xc1\x4d\x1b\xcf\x00\x1a\x1d\x4f\x8b\x4e\x70\x73\xfe\xf0\x73\x53\x64\x29\x70\xf8\x5f\x87\x3d\x6f\xf5\x54\x84\x88\xaa\xe1\x6b\x84\x6d\xda\x6c\xc3\x4a\xcf\x0c\x07\xdf\x5a\x0e\x8a\x0a\xd7\x80\x50\xa0\xa4\x41\xac\xcb\x50\x6a\x3a\x29\x97\x69\xcc\x4b\x8e\xea\x5c\x66\x96\x89\xb4\xbf\x91\x32\xf8\xd6\xb2\x40\x8c\x63\x72\xa6\x47\x09\xd6\xa5\xa6\x9b\x32\xbd\x9e\x4e\xe2\x77\x1e\xf7\x58\xab\x4c\x9b\xb6\x25\x4e\x65\xce\x86\xa1\x84\x9f\x5e\x36\x50\x7c\x15\x99\xa1\x6d\x8f\x2a\x00\xa6\x46\x04\xac\xcf\x3d\xfa\x6f\x04\x62\x30\x78\xdc\xe7\x80\xe8\x4d\xa6\xf6\x58\xdd\x79\x68\x26\xde\x57\x8e\x19\x62\x2e\x52\x9e\x3f\x07\x46\x23\x59\x53\x55\x70\x42\xc1\x91\x24\x10\xd1\x09\x49\x90\x3e\x83\x6a\x7d\x46\xd3\xb9\x91\x1f\xfe\xfe\x87\xc9\x90\x4d\xd5\xb9\xac\x52\xa7\x04\x64\xe2\x34\xd2\x66\x58\xb3\x3a\x03\xe1\x64\xb2\x4c\xda\x3c\x35\xd2\xf6\x60\x4d\x46\x95\x0b\x63\x82\x48\x8c\x46\x5a\xc4\x1e\x2d\x46\x3e\x2d\x28\x55\x81\xb5\x5b\x63\xc5\x6e\xb7\x61\x30\x57\xa8\x16\x16\x48\x21\xf8\x85\xb7\x00\x14\x20\xde\x42\xfe\x08\xad\xc3\xaa\xde\xbc\xba\xdb\x90\xd5\xb5\xc4\x3d\xda\x39\xcd\x89\xc4\xcb\x29\xda\x97\x60\x98\x38\xd3\x38\x88\xd0\xed\x76\xf3\x97\x6b\x56\xd3\xad\xab\xe2\xcd\xd0\x0e\x1a\xc3\xa9\xac\x1a\x94\x79\x93\x3a\xbc\x19\x92\x75\x33\x14\x1f\xd7\xc4\xb5\xbc\xd9\x48\x99\xca\x2a\x82\x04\xc9\xb2\x22\xba\xbc\x10\x6b\xe4\x24\x29\xb5\xba\xf8\x98\x26\xae\xf2\x69\xbe\xdb\x40\xab\xf5\xc1\xd9\xc6\x07\x74\x61\x52\x4f\x40\xd5\x85\x41\x78\xfb\x79\x5e\x7e\x0e\x57\xa5\x4d\x15\x3f\xf7\x70\xb6\x41\x51\x6c\xdf\xec\xd7\x43\xf3\x7f\xcf\xc7\x34\x71\x95\x57\x6b\xbe\x22\x38\xcb\x60\x20\xfc\xda\x2c\xb8\xc8\xc6\xc4\xfb\x18\xe6\x1a\x63\x65\x4a\x32\xec\x50\x03\x05\xb7\x85\x81\xa9\x82\xd3\x0c\x8a\x64\x46\x1a\x54\x1e\x12\x0b\xba\x07\x8a\x21\xf9\x18\xe7\xda\x0a\x68\x51\xb6\x0c\x57\x08\x67\x1c\x0b\xc4\x28\x0a\x34\xbd\x9f\xab\x00\xf1\xf6\x98\xae\x11\xa3\xa4\xbf\xff\xf1\x13\xfa\x44\x38\xd1\x60\x40\x85\x97\xf9\x09\x9d\x7c\x5c\x73\x1d\x7a\x8e\xa6\x42\xa3\x0e\xe5\xb5\x6f\x06\x84\x93\x8d\x0b\x63\xba\x81\x40\x7d\x3a\x9d\x4e\x47\xc2\xf8\xd8\xe6\x06\xd9\xdb\x2c\x6b\xe1\xc3\x27\x90\x39\x47\x56\xab\x6e\x74\x67\x58\x38\xe5\xa0\x48\xea\x7e\x51\xc8\x55\xd9\x27\xac\x52\xc9\x90\x7c\xbc\x73\x63\x45\x1e\xe6\x21\xdc\x7f\x34\xbb\x75\x9f\xe1\xe0\xa4\x83\xa1\xf0\xa0\xf0\x1f\x4d\x6f\x6d\x64\x28\x3e\xde\x49\xca\x15\x45\xc2\x3d\x69\xe8\xa3\x04\x98\xe8\xca\xb2\xb7\x2a\x55\x02\x6f\xf2\x57\xd4\xe6\x99\x30\x1f\xaf\x24\xe5\x08\x89\xa8\x7e\x6b\x83\x81\xe2\x64\x62\x49\x96\x91\x97\x44\xa8\x2b\xfb\x33\xc9\x3e\x1e\x49\x1c\x67\xd8\x78\xd0\x38\x6d\x58\x82\xf9\xd1\xe2\xca\xce\x07\x13\xe6\x63\x86\xc4\x8a\x0b\x42\x9f\x28\x61\x44\x1c\x11\x4e\x07\x8e\x64\x90\xc5\x2d\xb1\x6f\x8d\x17\x9a\x53\x2e\x54\xca\x3c\xf2\x79\xff\xc4\x75\xca\x94\x47\x64\x4d\xe6\xd6\xd3\x7c\x1c\x4d\xe7\xe3\x78\x36\x83\xa4\xa5\x42\x30\xa8\x99\xd8\x23\xd7\xa5\x27\xd7\x83\xf9\x22\x8d\x21\xf9\x55\xcc\x27\xe8\x29\xd5\x77\xb7\x83\x7e\xab\x13\xbc\xdc\xad\x47\x33\x10\xdb\x9d\x97\x21\x6a\x0a\x87\x7a\xe4\xe2\x1e\x65\x50\x77\x29\x33\xe1\x3e\x27\xfe\x2b\x1e\xa0\xa8\x08\x85\x15\x29\xf2\x0b\xf5\x04\x11\x83\x9a\x54\x58\x5f\xbe\x25\x54\x22\xe2\xae\x1c\xc7\x23\x99\xac\x87\xf0\x91\x4b\x0d\xf8\xab\x75\xd7\x35\x93\xee\x73\xdf\xef\x6c\xf6\x33\x1f\xfb\x44\xe4\x83\x4c\x5e\x81\x4c\xc1\x0f\xc4\x7d\x36\xfc\x2e\x6d\xa1\x47\xc1\xb2\x12\x08\xf7\xdf\x18\x8c\x44\x09\xb9\x11\xbc\xa3\x01\xf0\x96\xc7\xbb\xb4\xd4\x17\xd7\x77\x2e\xe7\x44\x86\xbe\xbe\xdb\xcb\x99\x54\xdf\x29\xa1\xb1\xd5\x53\x05\x91\xbd\xe5\xec\xfc\x94\xd4\xc0\x39\x0b\xe3\x09\xe0\x8f\x06\xe8\xe0\x2d\x10\xe2\x38\x2e\xdc\xca\x2e\xab\xc7\x6c\x4d\xb6\x33\xd6\xea\x51\x9b\x6b\x3a\xac\x1a\x75\x19\x46\x8a\xc6\x5e\x55\xf7\xd6\x58\xcd\x51\x8d\x0e\x22\xa7\xa1\x32\xa9\x29\x84\x65\xcd\xe7\x3d\xae\xd4\x20\x10\x44\xbe\x43\x0e\x35\x31\x90\xab\x6a\x5d\x4a\xf7\x04\x79\x96\x44\x78\xed\x5a\x85\x3c\x6d\x6f\x2f\x92\x02\x52\x38\xa5\x4f\x9c\xbb\xf9\x19\x86\xef\xa0\xd9\xd8\x0e\xc6\x34\x04\x11\xcf\x78\xc9\x09\x11\x22\x09\x3b\x42\x5f\xa9\x0b\xde\x30\x73\x50\x0c\xd6\x61\xab\x44\x08\x66\x15\xc7\xbe\xc3\xa2\x13\xcb\x92\xe5\x0d\x2b\xcd\x1f\x80\xc4\x60\xf0\xee\xd8\xc4\xad\xf7\x4b\x87\x24\x0f\x6a\x37\x08\x53\x8f\x7d\x67\xc1\x27\x98\xe9\x35\xd2\xa6\x43\x3b\x26\x10\xde\xfd\x76\x60\x2c\x07\x5b\xaf\x8f\x05\xe3\x3b\x53\x3a\xb1\x0c\x31\x23\x2f\x7d\x38\x15\x83\xc1\x29\xc2\x02\x61\xa5\x18\xae\x4b\x86\x3c\x65\xb0\x76\x6d\xf0\x38\x7f\x02\x77\x69\x3c\x8c\x47\xf1\x08\x2e\x3f\xc0\xe0\x6e\x5a\xec\xdf\xbb\x1b\xf3\xa8\xd8\x85\x7c\x6a\x18\x7f\xdf\x86\x4e\x81\x2b\x0e\xd7\x18\x41\x10\xf6\x54\x12\x09\xee\xad\x37\x4d\xae\x1b\xee\x06\x90\xf2\xb5\x53\x3e\xf6\x94\x99\x84\xec\xba\x85\x57\x12\x8d\xbb\x24\xa9\x1a\xb9\x2f\x37\x98\x56\x54\x96\xc1\x3c\x2c\x06\x22\x0b\xf7\x1f\xb3\x60\x38\x78\xa2\xf0\x9f\x46\xf1\x65\x10\x53\x2b\xd3\x01\xf9\x40\x2b\xa0\x5d\xe4\x01\x66\x15\xe7\x7d\x19\x0c\x9e\x4c\xfc\x67\x41\x4e\x6a\x6e\x4b\x90\x37\x74\x1a\x5d\x46\x7d\x96\xcf\xa9\xc9\xd7\xa2\xe1\xc9\xc6\xff\x0d\x96\x3f\x1d\x99\xca\xf6\x8c\x55\xf2\x35\x9e\x45\xc3\x69\xb2\x14\xc8\xe7\xbc\x19\xc1\xe0\x72\xd5\x9a\xb0\x8d\xd4\x39\xa2\x51\x06\x2d\x3b\x04\xf1\x60\xe1\xd2\x20\x8c\xba\x2d\xdb\x88\xa5\xea\x2d\xb1\x6a\xb8\x65\x68\x5f\xfa\x92\xda\x24\x48\xb1\xde\x5a\xc8\x13\xf1\x18\x0c\x9e\xb3\xa4\x48\xd3\x5b\x71\xa0\xf0\x1c\xc6\x5d\x70\xde\x00\xe4\xc4\x97\xb4\xa4\x0e\xfd\x35\x7d\xb2\x5f\x99\x97\x4e\xf0\xa4\xc5\x81\x29\xb3\x5f\x9d\x26\x1d\x5d\x7a\x3c\xf1\xd5\x9b\x52\x9b\xf8\x7e\x6e\x3d\x70\x4e\x4a\x11\xe2\x53\xbc\xd7\x64\x3d\x7c\xac\x33\xf3\xec\xaa\xe6\x8f\x4a\x64\x30\x38\xfd\xcc\xdc\x53\x0e\x17\x02\x2c\xe0\x69\x53\x4c\xb0\x8f\x7b\x66\x68\x65\x36\x7b\xe9\xf3\x1e\x19\x16\xce\x3f\x18\x92\xdc\x54\x84\x66\x34\x54\x13\x1f\xef\xcc\xbc\x96\xd1\x40\x0d\x23\xf5\x3b\xc1\x99\xc7\x81\x01\xdd\x9d\x83\x4a\x1d\x74\x94\xd1\xf7\xf1\xcd\xcc\x63\x13\x2f\x5b\x88\x3e\x4e\x34\x33\xd7\x26\x84\x49\x54\x8f\xdf\x10\xec\xbd\x47\x06\x5b\x03\xfb\x49\x1d\x50\x73\xbe\xd9\x58\x83\x3e\xde\xb7\x70\x61\x74\x36\xcc\x5f\x7d\x8f\x53\x33\xd6\xc0\xc7\x13\x73\x6b\x0d\x5e\xfe\xfc\x52\x06\x83\xf3\xc4\xdc\x3d\x8d\x11\x34\x7e\x43\xb0\x8f\x21\xe6\x4e\x8a\x5a\xa5\x40\x37\xef\xe6\xdd\x4a\x05\x70\x82\x70\x50\x3c\x2b\xd0\xad\xd0\xa0\xe6\x16\x38\xdd\x30\x50\x26\x46\xb2\x66\xb7\xc0\x31\x98\xca\xf3\xbb\x2f\x00\xc1\x4e\x8d\xf4\x7d\xfc\xb0\xa8\x3a\x35\x02\xb2\x4e\x1f\xae\x0c\x4e\x10\x15\x28\xfa\x29\x5a\x0d\xb4\xf1\xb1\xc5\xc2\x6e\x36\xa8\x18\x2e\xab\xbb\x39\x11\x83\xc1\x89\xe2\xe5\x20\xa8\x2e\x3e\xbe\x58\xa0\xb7\x4a\x4d\x95\x37\xaf\x79\xca\x20\xba\x3a\x38\x65\xd4\x22\xd1\xc6\x5a\x9d\xd6\xdd\x71\x69\x65\x11\xdd\x2e\x74\xbb\x7c\xd7\x11\xd2\x78\xd7\x9d\x56\x1e\x1f\xc7\x32\x16\x15\x9f\x54\x62\xa1\x9a\xf9\xb8\x65\xe1\xf6\x8f\x1a\x3f\x1b\xda\xe8\x52\x9d\xe2\xd4\x62\xa3\x18\x7e\x21\xfc\xb9\x9b\xba\x6f\x75\xea\x63\x99\xdf\xdc\x68\x88\xd7\x12\x49\x66\x3c\x5e\x13\x08\xc9\xb2\x9f\x7f\xce\x34\x1b\x09\x4e\x44\xc8\x38\x40\x0e\x03\xc4\x43\x2b\x8b\x41\xbc\xf8\x89\x9f\x0c\xdb\xc7\x55\x1f\x7c\x67\x5e\x39\x74\x01\x0c\x0d\x6e\xde\x65\x58\x38\x5f\x55\x22\x71\x15\x2b\xd7\x16\x39\xbd\x71\xea\xe3\x2f\xe4\x30\xff\xef\x7f\x00\x2f\x3c\xf3\x45\x6e\x72\x47\x32\x83\xf2\xf5\x68\x3e\xda\xf7\xbd\x11\xf9\xb4\xaa\xf0\x47\x7b\x33\x00\xbc\x3b\xf3\xd1\x49\x3c\xc0\x48\x3c\xea\x9e\xa3\xca\x04\xfb\x3a\x35\x1f\x91\xc6\x2d\xfd\xfd\x8f\xc6\x0f\x26\x67\x20\x78\x97\x06\x81\x90\xa7\xf5\x02\x9f\x04\xcb\x84\xfb\xfa\x34\x1f\xdd\x60\xfd\x65\xa3\xc7\x3b\x34\x1f\xbd\x61\x7a\xf0\xc8\x71\x3a\x1a\x4f\x27\xd7\xfc\x66\x73\x30\xff\xc3\x40\x32\x5e\x93\x2d\xab\x6e\x4d\x68\x1b\x0d\x4f\x41\x8e\x4e\x0e\x2e\x53\x4f\xf4\xc3\x5f\xf8\x85\xa3\x33\x90\xec\xce\x4e\x9b\x72\x1b\x53\xbc\xf3\x8b\xf7\x55\x5c\x7e\x0e\xe6\x9a\x32\xb3\xe2\x5f\x72\x7e\x88\x0b\x2e\xc1\x74\xe8\x9e\xb1\xa9\x17\x5d\xbc\x88\x46\x23\x28\xd1\x9b\xf1\xbc\x3e\x90\x8f\x49\x52\xd9\x51\xc5\xb8\xff\x37\x00\x00\xff\xff\x51\x0d\xcb\x5c\xc3\x6e\x00\x00")

func data2dFlfBytes() ([]byte, error) {
	return bindataRead(
		_data2dFlf,
		"2d.flf",
	)
}

func data2dFlf() (*asset, error) {
	bytes, err := data2dFlfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "2d.flf", size: 28355, mode: os.FileMode(420), modTime: time.Unix(1550434995, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataQuindarToneMp3 = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xec\x9a\x79\x5c\x53\xd7\xb6\xc7\x57\x26\x08\x61\x30\x02\x02\x02\xd5\x18\x44\x11\x21\x03\x84\x90\x44\x22\x81\x24\x08\x42\x24\x0c\x75\xa8\xd6\x26\x24\x07\x48\x21\x83\x19\x18\xf4\xaa\xb1\xb6\x8a\x56\x5b\x40\xc5\x58\xd0\x82\x28\xe2\x40\x8b\x5a\x9f\xd3\x6d\x8d\x62\x1d\x0a\x58\x54\x54\x6c\xb5\xc5\xb6\x58\xb1\xad\xca\xd5\x56\xab\x96\xbc\x4f\x12\x50\x69\x7b\xfb\xec\xbb\xbe\x0f\xca\xe3\xf7\x4f\x3c\x39\x7b\xaf\xe5\x6f\x9f\x6f\xd6\x3a\xfb\x1c\x12\x04\xe1\x18\x00\x80\x09\x1e\xe2\xd4\x84\xa9\x00\xc3\x96\x01\x4c\x17\x89\x21\x2a\xba\x40\x23\x95\xe5\x20\x7a\x52\x06\x92\xa5\x50\x71\xc9\x37\x0f\x1e\x22\x93\x14\x72\x2e\x79\x5a\x84\x88\x26\xd2\xf0\x91\x6c\x45\xfc\x5c\x2d\x92\x36\x77\x4a\xba\x6c\x6e\x8e\x8c\x2d\x27\x47\x4f\x24\x44\x15\x70\x0a\x94\x1a\x25\xa2\x97\x92\x0a\x94\xb9\x2a\x1d\xa7\x80\x4b\x96\xca\xd5\x19\x08\x47\xa5\xe3\x58\xbf\xa6\x92\x49\xb6\x21\xfa\x1c\x2e\x39\xc6\x7a\x82\x34\x5d\x24\x26\xf1\xd5\x5a\x84\x14\x41\x09\x0f\x95\xd1\xe8\x74\x12\x93\x49\xa1\x33\x22\x98\x4c\x7a\x08\x29\x8c\x46\x0f\xa3\xd2\xc2\xa8\x34\x66\x28\x9d\xc1\x89\x60\x72\xc2\x22\x49\x3d\x22\x4f\x24\x90\xa2\xb4\xf2\x4c\x4e\xaa\x20\xae\x27\x99\x56\x9e\xc9\x25\x67\xeb\xf5\x1a\x0e\x95\x9a\x9f\x9f\x4f\xc9\x0f\xa7\xa8\xb5\x59\x54\x3a\x9b\xcd\xb6\x06\x09\x0b\x0b\xd5\xca\x33\x43\x75\x85\x2a\xbd\xb4\x20\x54\xa5\x0b\xb0\x86\xb0\xc7\x10\x20\x3a\x99\x56\xa1\xd1\x2b\xd4\x2a\x92\xf5\x58\x9a\xa1\x36\xe8\xb9\x64\x32\xc1\x9a\xa9\xc7\x89\x52\xf3\x28\xb8\x4a\x47\xb1\xb9\xa2\xc8\xd4\x4a\x6a\x81\x54\x43\xa5\x53\x68\xd4\xdf\x0d\x16\x89\xfe\x7a\xb8\x52\xd9\x67\x86\x4e\x2f\xcc\xd3\xff\xf5\x0c\x5d\x7a\xa1\x06\xa1\xa6\x22\x3a\xb5\x41\x2b\x43\x84\x79\x88\x4a\x1f\xd0\x37\x44\x2a\x92\xf9\x77\x42\xa4\x22\x99\x7d\x02\xc8\x65\x8f\x66\x6b\x0c\xda\x5c\xdb\xe2\xc9\x65\x54\x24\x17\x51\x22\x2a\xbd\x8e\x4a\xa7\xd0\x7f\xef\x52\xf0\xef\x5c\x2a\xed\x09\x05\x85\x2a\xa9\x52\x21\x13\x21\x72\x85\xd4\x3e\xb7\x40\xa9\xe1\x88\x10\xbd\x54\x2e\xd5\x4b\x05\x52\x3d\xc2\x25\x87\xd1\xe8\xe1\xa1\x34\x76\x68\x18\x2d\x9d\xce\xe6\x84\xb3\x38\x8c\x88\xf1\x34\x16\x87\x46\x7b\x3c\x5e\x2d\x57\x64\x16\x3e\xe5\x68\x91\x88\x93\xa0\xd2\xe9\xa5\x2a\x19\x92\x20\xe0\x92\x0b\x94\x1a\x8a\x42\x21\xe7\x08\x23\x19\x91\x7c\x66\x98\x50\xc8\x0e\xa3\x0b\xc3\xe9\xf4\x58\x76\x58\x04\x8b\xc9\xa7\x31\xe3\x62\xe2\x62\xf8\x8c\xb8\x27\xa6\x0b\xd4\x32\x83\xd5\x71\xef\x74\xf9\xdf\x9b\x9e\xac\x55\x64\x29\x54\xd2\xdc\x3f\x0b\x13\x16\x2b\x88\x89\x65\xb1\xf8\x7c\x96\x3d\x0c\x5b\x20\xe0\x0b\x05\x71\x34\x41\x78\x8c\x20\x2e\x86\x16\x6b\x0b\x23\x97\x71\x32\xd5\x5a\xa5\x54\xcf\x25\x4b\x0d\x72\x85\x9a\xaa\xd4\x20\x59\x36\x58\x49\x51\xf6\x14\xf1\x0a\x9d\x5e\xad\x2d\xb4\x7d\x65\x27\x38\x0d\x99\x63\x3f\xb2\x1f\xe6\x2a\xec\x07\x24\x1b\x57\x1c\xa9\xcc\x8a\x36\x97\xac\x93\xe6\x21\x72\x72\x9f\x53\x8a\x3f\x59\xab\xa7\xfa\x5f\x3e\x8a\x90\x9f\x8d\xa8\xfa\x5e\x97\x08\x0e\x83\xc1\x89\x60\x3d\x71\x5d\x1e\x0d\xd6\xa9\x33\xf5\xf9\x52\x2d\x12\x93\x85\xa8\xf4\xbd\x35\x20\xc6\x20\x57\xd8\x7e\x7b\xfc\x34\x26\x29\x68\x9a\x42\x25\x57\xe7\xeb\xc6\xf5\x9d\x28\xcb\x96\xaa\xb2\x10\x39\x97\x4c\x55\xf6\xd0\x43\xa6\x3e\x43\xc7\xfc\xe7\xd9\xf1\xb3\x74\x2a\x0c\x7f\x0a\x90\xff\xc2\xa9\xed\x37\x17\xce\x78\x81\xae\xad\x90\xf1\x3c\x3b\x7e\xa6\x4e\x23\x9e\x81\xd3\x3e\xf5\xb4\xdf\xae\xad\x4c\xad\xca\x43\xb4\xfa\xdf\xbb\xd6\x48\xb5\x52\x25\xa2\x47\xb4\x3a\x2e\x39\x53\xab\x56\x92\xec\x05\x52\x9d\x95\x35\x81\x24\x53\xcb\x11\x19\x77\xcc\x1c\x83\x5a\x3f\x21\x4f\xad\xcd\x50\xe8\xec\xff\x26\xe9\xd5\xa4\x27\xea\xe8\xb3\x5c\x6f\xe6\x73\xb1\xde\x03\x67\x3d\x9f\xa6\xc9\xf6\x1b\xbf\xbd\x4e\xa3\xa8\x4f\x36\xdc\x28\xea\x1f\x5b\x72\x4f\x97\x16\x20\x5a\x45\x1e\x22\x8f\xd3\xaa\x95\x04\x7b\xc0\x54\x24\xf3\x3f\x00\xc9\x3e\x5f\xfe\x67\x77\x27\x7f\x63\xbe\xfa\x3f\xb9\x3d\xa1\x3e\xf2\x27\x10\x71\xd2\xb5\x52\x59\x8e\xee\x89\x9b\x90\x58\x69\xd6\x9f\xc2\x60\x1f\xae\xb7\x0e\x9f\x22\x55\x22\x5c\x32\xdf\x80\x88\xd5\x0a\x95\x9e\x24\x92\x6a\x73\x10\xad\x8e\xfc\xc7\x81\xd6\x3b\x55\xdb\xc0\xbe\xe7\x32\xad\xbc\xa6\xda\xee\x04\x33\x19\x0c\x3a\x8d\xf6\x6f\xf8\xfb\x43\xca\x34\x43\x86\x2c\x57\xa1\xf9\x1f\x33\x26\xa8\x92\x0d\xfa\xa7\xcc\x69\x27\xa1\xd7\xb5\x8d\x84\x3e\xcb\x62\x3f\xff\xc4\xe6\xc2\xba\x67\xa1\xf6\x6c\x5a\x26\x12\xa2\xa8\x8f\xb6\x4b\x3d\x1e\xfe\x8f\x35\x98\x64\x30\xc9\x60\x92\xc1\x24\x83\x49\x06\x93\x0c\x26\x79\xae\x92\x10\x1e\x3f\x70\x45\x54\x72\x2e\x39\x9f\x1c\x3d\x11\x06\x35\xa8\x41\x0d\x6a\x50\x83\x1a\xd4\xff\x3f\x59\x1e\xd4\x4b\x00\x1c\xee\x66\x37\x77\x44\x93\xf0\x00\x4e\x9a\x4a\x40\xf9\x95\xbc\x9a\xd2\xd6\x6d\x24\x02\x04\x36\x00\x40\x61\xa9\x53\xc2\xb9\xe0\xfa\x3b\xde\x18\x62\x49\xd9\xbf\xf2\xaa\x93\xab\x3a\x0e\xcf\xa8\x61\x70\xe3\x4e\xbd\x3f\x16\x69\x9f\xb2\x2c\x67\x66\x86\x96\x25\xbd\x42\x4f\x66\x6f\x64\x62\xc5\x67\xfd\x8b\x0f\x7f\x8a\x65\xbc\xc7\x2c\x4e\xf4\xc0\x57\x07\x49\x68\x78\x56\x89\xf3\xd0\x8a\x88\xb7\xe2\x17\x5f\x57\x3b\xcf\x1f\xde\xb0\x3f\xa3\x7a\x7a\x92\xe1\x42\x40\x51\x74\x69\x73\x87\x0b\xe5\x97\x43\x93\x82\x56\x4c\xff\x70\x01\xe9\xd4\xe5\x07\x77\x4a\x4f\x4d\x3b\x14\xa4\xbd\xfc\xe0\xe7\x71\xec\xd9\x97\xaa\x1a\x97\xde\x6c\xdd\xb9\x72\x9e\x76\x69\xe8\xd7\x87\x52\x57\xf9\xce\xd3\xb9\xcd\x8a\x5e\xb0\x79\xe5\xd9\x2f\x6b\x2d\x0d\x77\xaf\x4f\xbf\xcc\x3d\xf0\xee\xc3\xe8\x4b\x34\xdb\xe7\xa1\x7d\xd2\x03\xf3\x0c\x01\xda\xee\x2b\x4b\x3a\x7f\x6a\x5d\xd9\xf8\x60\x69\x64\xb2\x3a\xe5\xc0\x82\x2b\xcd\x67\xbf\x6c\xfd\xe0\xfd\x7d\x3a\xfd\x2f\x3f\x27\xab\xf7\xe9\x38\xb6\x8f\x05\x86\xdb\xe7\xb8\x9f\xfc\x70\xfb\x73\x6e\xda\x55\x6c\xbb\x18\x03\x21\xb1\xa3\xc9\xd5\x2e\x29\x42\x74\x91\xc0\xf1\xb3\x55\xed\x3e\xdf\x7c\x14\x1f\xf7\xa3\xf6\xaa\x07\xb8\xfe\x97\xc7\x30\xb2\xef\x2a\xa9\x59\x36\x63\xee\x86\x31\xa5\x19\xfb\x36\x44\xcd\x2f\x67\xc7\x87\xd3\xc1\x41\x7a\xb6\x73\x6f\x9b\xb9\xcd\xf4\x0d\x86\x44\x3b\x4d\xcf\x0d\xa0\xb5\x8c\x66\x14\xb1\xf4\x0e\x8b\x83\xf0\x38\x56\xfd\x46\x89\x5f\x8b\x0f\x11\x53\xb6\x28\x6f\x8c\xdf\x4f\xd1\x31\xc1\x7b\x2d\x96\xce\xa2\x76\x7a\x44\xdb\x7d\xb6\x7e\xe8\xf8\xfc\xc0\xa9\x16\x8b\xe5\x8b\xa3\x31\x5f\xe6\x05\x14\x5f\xa2\x6b\xf7\x1a\x66\x1e\xb0\x58\x2c\x77\x0f\x37\x68\x46\x6c\x11\xb5\x18\x2b\x59\x18\x4a\xf7\xab\xbf\xe5\x5b\x2c\x16\x4b\x37\xfa\x8d\x6f\x88\x9e\xde\xfe\xcb\x12\x32\x47\xd5\xde\x38\x78\xdf\x62\xf9\xda\x62\x53\x0b\x3f\xe5\x62\x6d\x6b\x73\x76\x6b\xcd\x47\xaf\xa7\xbd\x12\x31\xf9\xdc\x17\x07\x17\x9a\x0f\xd7\xcb\x5d\xfc\xdc\x50\x2b\xde\x63\xca\x4f\xef\x26\x7d\x84\xdd\x09\x90\xb0\x11\x00\x0b\x70\xea\xc7\xbb\xfe\x00\x96\x5a\xf6\x68\x09\x17\x9b\xfd\x72\x39\x67\x7c\xa9\xdf\xa9\x63\x12\x70\x5d\xbf\x58\x5c\xda\x8e\xe3\xc5\x37\x08\x68\x2b\x66\xce\xa0\xb5\xec\x9b\xdc\x34\x71\xd1\x25\x16\x0c\x23\x61\xd1\x43\xd9\x57\x97\xee\xb2\x3c\x4b\x3d\xa8\x97\x08\x80\x50\x3f\x2c\x35\x7f\xa4\xd9\x46\x5c\x3b\xa0\x1c\x18\x69\x7c\xb3\xdf\x71\x00\x08\x34\x03\x60\x9f\x69\xbe\x7e\x17\x80\xcb\xc1\xe6\x42\x80\x87\x3f\xbd\x7e\x3e\x3f\x6a\xb4\xf1\x6a\xd7\x2f\x3b\x66\x17\xcd\xff\x4c\xdf\x28\x96\x10\x40\x0a\x73\x41\xcc\xe7\x56\x8e\x70\x81\x7c\xf4\x28\x57\x37\x63\xe9\x37\x6d\xf5\x07\x1b\x9b\x2e\xcf\x07\xd8\x50\xdd\x70\x60\xb6\x78\x8f\x68\x43\xf4\x0a\xdc\xdb\xcd\xfb\x29\x95\x44\x42\xf2\x76\x08\x02\x33\x78\x49\xdc\x87\x2c\xc1\x98\x97\x64\x50\xca\x1d\xca\x63\x40\xb2\x09\x64\x66\xca\x45\xff\x9d\x3c\xcf\x45\x7b\xfb\xdb\xef\x73\xa7\x07\xf5\x92\x2d\x30\xe4\x81\xe7\x69\xcd\xf8\x2e\xf3\x08\x70\xd2\x00\xa0\x1c\x5c\xd2\x26\x99\x9d\x07\x28\x71\x96\x76\x00\xd4\xba\xba\x4a\x18\x79\x66\x9b\xeb\xa2\x99\x6b\x5c\x00\x5f\xe9\x24\x3a\x59\x56\x48\x04\x13\xda\x48\x9e\x6e\x72\x2f\xbd\xb2\x9d\x87\x59\x82\x7a\xc5\x87\x51\xb4\x9f\x84\x4f\xd6\x5b\x7b\xc1\x29\x13\x0f\x20\xfa\xe1\x6f\x26\x59\x36\xb1\xc8\x5c\xe7\x62\x02\x9c\xb1\x96\x88\x89\x23\xc8\xf4\xb9\x95\x38\x94\x39\xee\xc3\x91\x09\xbb\x78\x2e\x7b\xfa\xdb\xdc\x0b\xa0\x5e\xe2\x52\x0b\x50\x5d\xe6\x40\x3b\x71\xb8\xa0\x94\xc4\x76\xc7\x81\x4a\x5c\x8f\xda\x01\xc0\xef\x67\x3c\x80\x63\xf7\x91\x06\x11\xab\x73\x8b\xbc\x89\x73\x97\x7a\x74\x61\xde\x0a\xd7\x98\xf6\xf3\x05\xe8\x13\xc6\xad\xcb\xf9\x6b\x1a\x61\x68\xb1\x95\x38\xb7\x0a\x80\x4b\x25\x53\x5a\x7e\x1a\x9a\x3f\x8d\x58\x0f\x3e\x78\x23\xde\x88\x4e\x42\x1f\xb9\xf3\x5e\x6e\xbc\x51\x59\x23\xa0\x94\x81\xf3\x90\xfe\xb6\xf4\x62\xc8\x4e\xdc\x43\xcf\x54\x0d\x74\x99\x03\x8c\x76\xe2\x66\xa5\x4c\x32\x0f\x70\xe2\x6c\x85\x6b\x05\x80\xe5\x48\x12\x73\x76\x60\xd9\xfa\xd5\x75\x86\xc5\xe1\x7c\x10\x3b\xbb\xc3\x59\xdc\xce\x0b\xb8\x69\xe6\x7a\xef\x89\xa9\x89\x9b\x8d\x0e\xf5\xd6\xa1\x9f\x17\x59\x6b\x5c\x37\x21\x7e\xd4\xcb\xb1\xed\x4e\xe3\xf2\x67\xa4\x6a\xde\xe2\xd1\xa6\x83\xcb\xb0\xc6\xa6\x36\x13\xee\x84\x51\xf9\x9d\xa9\x2a\xd8\x28\x5f\xdc\xdf\xbe\x9e\x7f\xd9\x89\xbb\x6f\xaf\x71\x63\x7a\x6a\x1c\x31\x45\x68\xc6\x0c\x6c\xe2\x2c\x16\x33\x00\xfa\xa6\x0c\x20\x72\x4e\xf1\x96\xdd\xbb\x6e\xd4\x86\x95\x99\x70\x46\xa2\x11\x9d\xe4\x9c\xec\x7f\xa1\x08\x73\xd8\xbc\xd2\x65\x72\x70\xa9\x31\xdd\x68\x83\x73\x25\x80\xe5\xbb\x35\x85\x7e\x4e\xce\xc6\xd1\x9c\xf3\x53\x87\x93\x62\xdb\x83\x5c\x60\xb7\x43\xda\xc9\x11\xe5\xa9\x46\xef\xaa\xd5\x49\xa5\x46\xd9\xc5\xfe\xf6\xf4\x22\xa8\xb7\xab\xa6\xdc\x42\x75\x99\x03\x7a\x88\xcb\x4e\xe1\x0f\xf0\x1a\x67\xed\xa9\xde\x75\x00\x23\x2d\x21\x1b\x13\x05\xc1\x30\x74\x6d\x60\x5d\x70\x1a\x88\xdd\x3c\xc1\x03\xb5\xfa\x35\x86\x1e\x45\x13\xe3\x66\xd4\x4d\x8e\x45\x25\x4b\xac\xc4\x7d\xbc\x0e\xc0\xd2\x72\x82\xb9\xd1\x59\x1e\x0c\x8d\x7b\x1c\x13\x37\xf9\xa0\x2a\x2b\x47\x28\xc6\x38\x28\x36\x66\x8f\x46\xbd\x7e\xa8\xf4\x7a\x2a\x91\x28\xab\xe8\x6f\x5f\x2f\x80\x7a\xbb\x6a\x8b\x95\xb8\xc0\x9e\xae\xea\x93\x16\x33\xc0\x89\xeb\xe9\xab\x3b\x0a\x01\x2c\xf7\x2f\x63\xe6\xc4\x84\xdf\x3f\x35\x75\xb8\x07\x8f\xe4\x59\x5f\x83\xcb\xb9\x91\xcd\xc0\xd4\x12\x8a\xbe\x58\xfe\x8e\xf1\x8d\x8f\x34\x00\xb0\xed\x9f\x2f\x03\x3c\x90\xbf\x9b\xee\xd4\xaa\xc8\xce\x2c\x3a\x97\x29\xdb\xbc\x8a\x00\x25\xe0\x66\x8a\xd8\x71\x72\x2d\xcf\x7f\xeb\xfc\xb9\x85\x92\x6b\x8e\x01\x8e\xd1\xfd\xed\xea\xf9\x57\x6f\x57\xfd\xfc\x16\xae\xcb\x3c\xd4\x5e\xe3\x1c\x3f\x4a\xe1\x9a\xa9\x03\x88\x38\x33\x40\xf0\x8d\x66\x80\xe8\x33\x13\xb0\x8b\x35\xb7\x26\xfb\xf1\xdb\xc2\xbe\xfc\x04\x0d\xce\x34\x34\x6a\x79\x5d\xab\x19\x8b\x6e\x04\x93\x2b\x48\x8d\xdb\x69\xdb\x24\x69\x74\x92\x2b\x0d\x8f\xae\x92\xe0\xc5\xc7\x2b\x34\xa8\xe2\xd1\x00\xb0\x6e\x7b\x04\xc0\x2f\x77\x42\xb0\x89\xd7\xcf\x78\xec\x30\x93\x50\x1d\x5c\x71\xeb\x22\x1a\x0e\x2a\xc1\xd1\xe4\xb0\x5b\xb1\xb6\x38\xc8\x68\x34\xb4\x97\x25\x0f\x83\xa0\x4a\xf4\x20\x76\x7f\xa5\x5e\xe2\x92\x35\xe8\xc7\x3b\x07\x49\xda\x84\x01\x5e\xe3\x1e\x02\x00\x3a\xf7\x28\x60\x2c\xbb\xd3\x5b\x7f\xf4\xdc\x9d\xbe\xcb\xb4\x0a\x45\x34\x4a\xae\xb9\x99\x88\x1f\x6c\x7d\x57\x1c\x5a\xbb\x69\x08\x77\xd8\x50\x23\x9d\x87\xd7\xd8\x8a\x21\x02\x60\xb9\x97\x73\xe2\x52\xe9\xd7\xfc\xba\x40\x9d\x3b\xb0\x46\xe3\xb0\xe0\xeb\x3d\xfb\xf6\x90\xf6\x91\x93\xc6\xaa\x1e\xae\x2b\x19\x66\x1c\xac\x70\x4f\xa3\xc7\x35\xce\xba\x73\xe8\x21\x0e\x9b\x16\x3d\x70\x9f\xc7\xf5\xca\x06\xdd\x4e\x4f\xc0\x58\xb6\x0a\x2e\x36\x37\x51\xcf\x99\x32\x5d\x64\xa3\x2b\x3d\x97\x06\x40\xe0\xdd\x40\xec\x9a\xdc\x85\x1d\x1a\x93\xff\x0e\x60\x59\x89\x2b\x17\x03\x58\x9a\x34\xa9\x92\xaf\x46\xf9\x23\x17\xd3\xaa\xc4\x4e\xa3\x80\x87\x47\x99\x30\x1f\x8e\x5b\xd6\x36\xaa\x6a\xf7\xde\x21\x27\x57\xef\xd8\x01\xec\xfe\x36\xf5\x02\xa8\x77\xe7\x70\xca\x4a\x1c\xb9\x87\xb8\x82\x34\xee\xc0\xae\x71\xdd\x00\x80\x62\x7e\x06\x28\xcb\xcf\x8d\x37\x8f\x6c\x5c\xfa\xda\xcb\x5e\xc3\x81\x26\xc1\x7a\x41\xab\xb9\x64\x4b\x93\x89\xf7\x69\xb0\xdf\x3f\x67\xbb\x0d\x07\xad\xd1\xc9\xba\xc9\xc0\x97\xf3\x00\x2c\x27\xda\x28\x27\x2f\xc4\x3a\x7f\x55\x9e\x89\xbf\xf1\x32\x54\x01\xd6\xe4\x16\x9a\xb0\x66\xdf\x4b\x1f\x74\xee\xff\x87\x58\x8e\x3e\xbd\xf4\xfd\xfe\xf6\xf5\x22\xa8\x0f\x71\xbd\x4f\x47\x3c\x53\xa2\x07\x36\x71\x96\x9e\xed\xaa\xc7\x72\x23\x8c\xb4\xcc\x10\x5c\xc8\x60\x5f\x7c\x67\x2f\xf6\x5d\x2c\x48\x66\x61\x9a\xd0\x6b\x18\xcd\xfe\x6e\x17\x6f\xdf\xf4\xdb\xf8\x12\xac\x51\x00\x80\xf3\xc7\x33\x00\x2c\xdb\xaa\x57\x8a\x1c\xea\xb1\x23\x3f\x9e\xea\x32\x33\xc3\xe8\x13\x8c\xa9\x21\x10\x7c\xb3\x4a\xd1\xc8\x0d\xd5\xad\x4b\xf5\x6f\x62\x2e\x0c\x3e\x03\x7e\x0a\xd9\x89\xfb\xd5\x53\x7c\x0b\xfd\xf8\x9d\x43\x54\x8a\x70\xc0\x13\x67\x04\x80\xd9\xc7\x8c\xb0\xf0\xd7\x90\x8e\x5c\x54\xdd\x57\x07\xf6\xa3\x2b\xd1\x2e\x50\x19\x44\x30\xb9\x8e\xfb\x75\xcb\x74\xaf\xca\xea\xb2\x9b\x67\x88\xc6\x9c\x14\x6b\x57\x6d\x9e\x0f\x60\x69\x39\xcd\x54\xee\x3e\xfa\xfd\x6e\xe5\xbd\x44\x1d\xf0\xd0\x34\x14\x4a\x87\xc1\x1e\x8a\x78\x15\xe5\x19\x35\xfd\xe6\xe5\x51\x78\xfc\xfe\x43\xfd\xed\xea\x05\xd0\xa3\xe7\x71\x7d\x76\x0e\x03\xfe\x9d\x83\xad\xad\xae\x7f\x05\x50\x96\x13\xb0\x69\xa1\x17\xf9\xc2\x02\xaf\x72\x1f\xb4\x31\x21\x37\x86\x14\x26\x11\xcc\x69\xdf\x86\xf1\x82\xb7\x22\xe7\x77\x3a\xf1\x26\xba\x03\xc0\xe5\x1b\x26\x1e\x40\xd4\xdd\x0a\x56\x83\x03\xce\x4c\x39\xf0\xb6\xcf\x10\x54\x8a\x11\xe0\xe4\xc8\x9d\x95\x28\x5a\x0a\xee\x36\x54\x92\x69\x61\x8e\xb2\x21\xd5\x7e\x4c\x47\x54\xbd\x18\x1b\x7a\xe7\xee\x7b\x21\x30\x6b\x69\x7f\xfb\x7c\x0e\xf5\xf8\x9d\x83\x63\x97\x79\x58\xcf\xd3\x11\x5a\x4a\x82\x39\x7a\x80\x11\x67\x06\x88\xfc\x64\x15\x0f\xa2\x2d\x94\xce\x55\x95\x1d\x71\xcb\xee\x25\xe0\x55\xaa\x7b\x24\x14\x16\xbc\x87\xb0\x12\x7c\x25\xbe\x2e\x12\x31\x96\x16\x89\xe2\x3b\x48\xaf\x30\xd6\xe1\x5a\x03\xb7\xef\xf9\xd7\x59\x42\xa5\x5f\x41\x51\x51\xd1\xb2\xb7\xdc\x67\xb7\xc2\x48\x72\x6c\xdc\xd1\x2d\x02\x4a\x52\xc3\xa6\xd3\x39\xcd\xdb\xb3\xde\x58\xff\x66\x47\xc8\xfd\xf1\x1f\xee\x19\x41\x8f\x61\x85\x4e\x88\xe5\x11\xce\xfb\x66\xde\x32\x0f\x1f\xdb\xed\xd3\x16\x6f\xca\x16\xbe\xbf\xdc\xbd\x0c\xd5\x8e\x1f\xf1\x21\xcf\x1c\xff\xa6\x77\x2e\x25\x2a\x72\x44\x7e\xc8\xe4\xcd\xf5\xdd\x2f\x1d\xd9\x50\x33\x41\xef\xe7\xb7\x70\x45\xab\xf0\xf8\x8d\xc8\x6f\xfd\x8f\x6c\x18\x35\x2d\x74\xda\x7b\x15\x8d\xfe\x9b\x8b\xfd\xce\xdf\x47\xfa\x7b\xb1\x9e\x4a\xdd\xe3\x2e\xa7\xac\x2b\x16\x1f\xca\x51\x8f\x75\x58\xd4\x1e\xdf\x58\x38\x61\x66\x34\xb1\xa1\x6e\xc3\xd1\x4a\x91\x23\xf6\xad\x45\x35\x1c\x37\x4a\x11\xe3\xd0\x75\x87\x9d\xed\x79\xe6\xee\x10\xc3\xd2\x05\x67\xa1\xe1\xe8\x62\x3b\x71\xf8\x63\x41\xe9\x85\xf7\xae\xcf\x02\x3b\x71\x63\x36\x57\xcf\xf8\xfe\xb6\x6b\x6d\x0f\x71\x91\xfe\x6e\x57\xfd\xc7\xe0\x7d\x82\x82\x24\xf5\x93\x3f\x3f\xe6\x92\xe3\x56\xdd\xb5\x92\x6d\x04\x07\x34\xca\xab\x6b\xc7\x22\xde\x55\x27\x74\xd5\x2c\x9f\xad\xc4\x7f\x7c\xc6\x70\x3c\x20\x6c\x05\xc0\xa2\x7f\xe4\x55\xf1\x86\xe3\x09\x01\xa6\xcd\x12\xb1\xe9\xd8\xab\x2c\xfc\xc1\x8e\x6f\x93\x0c\x8e\xf3\x8a\xcd\x66\x74\x4b\x98\xb0\x7d\xc6\x91\x96\xf1\x45\xd7\x5f\x5b\x3b\xdf\xb1\x2d\xca\x7d\xed\x35\x47\x21\xf3\xb7\x6c\xaf\xc3\xb8\x97\x12\x02\x82\xd2\x97\x97\x14\x4d\xd9\x5e\xa8\x3d\xfd\xdb\x4f\x88\xe2\x1d\xd3\x0f\x1f\xcc\x32\xbb\x0f\x8d\x19\x1e\x55\x98\x44\xc4\xd7\x94\x94\x4d\xdd\x7a\x9e\x73\xad\xec\x03\xfd\xf1\xe9\x37\x2f\xcd\xd1\x86\x08\x2f\x78\xeb\xdd\xbb\x62\x48\xf1\xe5\x33\x33\x72\x77\xf9\xef\xba\x52\xeb\x5b\x7e\xa2\x02\xd7\xb6\xf3\x52\x61\x4d\x7d\xfd\xdb\xee\x58\xfd\x85\xb9\xd7\x16\xd0\xe7\x5f\xfc\x72\xc2\x82\x1f\xa2\x97\xaf\x97\x1d\xbc\xd3\x54\xe5\xe1\x81\xc6\x49\x3b\x89\x3b\x47\x2e\xf7\x1a\xb1\xb5\xad\x62\xb6\xb8\xe1\xc2\x3c\x6a\xc9\x27\x2b\xe8\x79\x11\x27\x8f\x9f\x5e\x12\x84\xbe\x66\x4c\xfd\xcd\xf3\xe2\xfc\x2d\xae\x69\xef\x1b\xdf\x25\xd6\xae\x91\xf1\xc3\xdc\xd3\x94\x7b\x53\x62\x93\x62\x8a\x52\x59\xc5\x5b\xc4\xe7\x12\x73\x08\x7b\xf8\x82\xdb\x0f\x2d\x89\x35\xeb\x6b\xf4\x37\xb3\x5c\xf6\xac\xf9\xe2\xc6\xd9\x3a\xcf\xd1\x65\xfa\x10\xe9\xf7\x3b\x37\xb2\x4f\xdc\x73\x32\x0d\x97\x24\x4e\x5e\x4f\x6d\xc6\xbc\xf2\x6a\x53\xe7\xaf\xa5\xb4\x8e\xa4\xc6\x9a\x2f\x1a\x87\xe6\xec\xea\x38\xa9\x1c\x3b\x36\xf1\xed\x39\x2a\xd2\xf1\x24\xfe\xbd\xbd\xc4\x4d\xe3\x76\xbc\xb1\x6c\xeb\xb9\x3c\x8f\xd5\x15\x6b\xbd\xd1\x0f\xb9\xc2\x4f\x91\x24\x85\x77\xc0\x36\xc3\x38\x25\x7b\xf5\xb4\x29\x65\x67\x85\x9f\x26\x4d\x59\x39\xcc\xa5\x69\x12\x9d\x13\x56\xbd\xf6\xcc\x25\x43\x38\xb3\x62\xd3\x77\x9d\x73\x32\xd8\x22\x8f\xcd\x57\x9a\xa6\xbc\x53\xa3\x48\x3b\x56\x72\x8e\xb3\xba\x83\x91\x4e\xf7\x99\x92\x26\xfc\xb4\xe8\x2a\x67\x75\x4a\xd5\xd8\xe2\x0e\xcf\xce\xb3\x82\x4e\x64\x0d\x27\xbb\x36\x33\x83\xfd\xce\xe6\xf4\x65\xdf\xb1\x85\xbe\x04\x83\xab\xf8\x98\x94\x2d\xf2\xa8\x91\xdd\x5b\xec\x3d\xd6\x2b\xc0\x74\x26\x65\x52\x6a\x45\xcd\xdb\x0c\xc6\x75\xdf\x25\xbb\x4e\x6c\x60\x14\x9f\x9f\xfa\xad\x69\xfd\x28\x51\xd6\x38\x36\x7f\x4b\xb0\x6f\xc8\xdc\xb8\x67\x76\xc3\xd0\xf3\xce\x21\xfb\x5c\xe1\xaf\xf3\xb2\xa7\xd8\xbb\x2a\x00\x8a\x02\x00\xa4\x01\x55\xe3\xfe\xf7\xea\xb7\x3f\x97\x1d\x90\x4a\x8f\x99\xd4\xaf\xf9\xff\x3b\x00\x00\xff\xff\xd6\x2f\xcb\x16\x21\x4a\x00\x00")

func dataQuindarToneMp3Bytes() ([]byte, error) {
	return bindataRead(
		_dataQuindarToneMp3,
		"quindar-tone.mp3",
	)
}

func dataQuindarToneMp3() (*asset, error) {
	bytes, err := dataQuindarToneMp3Bytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "quindar-tone.mp3", size: 18977, mode: os.FileMode(420), modTime: time.Unix(1379677344, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"3d.flf":           data3dFlf,
	"2d.flf":           data2dFlf,
	"quindar-tone.mp3": dataQuindarToneMp3,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"data": &bintree{nil, map[string]*bintree{
		"3d.flf":           &bintree{data3dFlf, map[string]*bintree{}},
		"2d.flf":           &bintree{data2dFlf, map[string]*bintree{}},
		"quindar-tone.mp3": &bintree{dataQuindarToneMp3, map[string]*bintree{}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
