---
title: "Zoho"
description: "Zoho WorkDrive"
---

{{< icon "fas fa-folder" >}}Zoho Workdrive
----------------------------------------

[Zoho WorkDrive](https://www.zoho.com/workdrive/) is a cloud storage solution created by [Zoho](https://zoho.com).

Here is an example of making a zoho configuration.  First run

    rclone config

This will guide you through an interactive setup process:

```
No remotes found - make a new one
n) New remote
s) Set configuration password
n/s> n
name> remote
Type of storage to configure.
Enter a string value. Press Enter for the default ("").
Choose a number from below, or type in your own value
[snip]
XX / Zoho
   \ "zoho"
[snip]
Storage> zoho
** See help for zoho backend at: https://rclone.org/zoho/ **

OAuth Client Id
Leave blank normally.
Enter a string value. Press Enter for the default ("").
client_id> 
OAuth Client Secret
Leave blank normally.
Enter a string value. Press Enter for the default ("").
client_secret> 
Edit advanced config? (y/n)
y) Yes
n) No (default)
y/n> n
Remote config
Use auto config?
 * Say Y if not sure
 * Say N if you are working on a remote or headless machine
y) Yes (default)
n) No
y/n> 
If your browser doesn't open automatically go to the following link: http://127.0.0.1:53682/auth?state=LVn0IHzxej1ZkmQw31d0wQ
Log in and authorize rclone for access
Waiting for code...
Got code
Choose a number from below, or type in your own value
 1 / MyTeam
   \ "4u28602177065ff22426787a6745dba8954eb"
Enter a Team ID> 1
Choose a number from below, or type in your own value
 1 / General
   \ "4u2869d2aa6fca04f4f2f896b6539243b85b1"
Enter a Workspace ID> 1
--------------------
[remote]
type = zoho
token = {"access_token":"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx","token_type":"Zoho-oauthtoken","refresh_token":"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx","expiry":"2020-10-12T00:54:52.370275223+02:00"}
root_folder_id = xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
--------------------
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> 
```

See the [remote setup docs](/remote_setup/) for how to set it up on a
machine with no Internet browser available.

Note that rclone runs a webserver on your local machine to collect the
token as returned from Zoho Workdrive. This only runs from the moment it
opens your browser to the moment you get back the verification code.
This is on `http://127.0.0.1:53682/` and this it may require you to
unblock it temporarily if you are running a host firewall.

Once configured you can then use `rclone` like this,

See top level directories

    rclone lsd remote:

Make a new directory

    rclone mkdir remote:directory

List the contents of a directory

    rclone ls remote:directory

Sync `/home/local/directory` to the remote path, deleting any
excess files in the path.

    rclone sync -i /home/local/directory remote:directory

Zoho paths may be as deep as required, eg `remote:directory/subdirectory`.

### Modified time ###

Modified times are currently not supported for Zoho Workdrive

### Checksums ###

No checksums are supported.

### Usage information ###

To view your current quota you can use the `rclone about remote:`
command which will display your current usage.

#### Restricted filename characters

Only control characters and invalid UTF-8 are replaced. In addition most
Unicode full-width characters are not supported at all and will be removed 
from filenames during upload.

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/zoho/zoho.go then run make backenddocs" >}}
### Standard Options

Here are the standard options specific to zoho (Zoho).

#### --zoho-region

Zoho region to connect to. You'll have to use the region you organization is registered in.

- Config:      region
- Env Var:     RCLONE_ZOHO_REGION
- Type:        string
- Default:     ""
- Examples:
    - "com"
        - United states / Global
    - "eu"
        - Europe
    - "in"
        - India
    - "com.au"
        - Australia

### Advanced Options

Here are the advanced options specific to zoho (Zoho).

#### --zoho-encoding

This sets the encoding for the backend.

See: the [encoding section in the overview](/overview/#encoding) for more info.

- Config:      encoding
- Env Var:     RCLONE_ZOHO_ENCODING
- Type:        MultiEncoder
- Default:     Del,Ctl,InvalidUtf8

{{< rem autogenerated options stop >}}
