package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"mime"
	"path"

	"github.com/pulumi/pulumi-aws/sdk/v2/go/aws/s3"
	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
)

func main() {
	pulumi.Run(func(ctx *pulumi.Context) error {
		siteBucket, err := s3.NewBucket(ctx, "siteBucket", &s3.BucketArgs{
			Website: &s3.BucketWebsiteArgs{
				IndexDocument: pulumi.String("index.html"),
			},
		})
		if err != nil {
			return err
		}
		siteDir := "www"
		files0, err := ioutil.ReadDir(siteDir)
		if err != nil {
			return err
		}
		fileNames0 := make([]string, len(files0))
		for key0, val0 := range files0 {
			fileNames0[key0] = val0.Name()
		}
		var files []*s3.BucketObject
		for key0, val0 := range fileNames0 {
			__res, err := s3.NewBucketObject(ctx, fmt.Sprintf("files-%v", key0), &s3.BucketObjectArgs{
				Bucket:      siteBucket.ID(),
				Key:         pulumi.String(val0),
				Source:      pulumi.NewFileAsset(fmt.Sprintf("%v%v%v", siteDir, "/", val0)),
				ContentType: pulumi.String(mime.TypeByExtension(path.Ext(val0))),
			})
			if err != nil {
				return err
			}
			files = append(files, __res)
		}
		_, err = s3.NewBucketPolicy(ctx, "bucketPolicy", &s3.BucketPolicyArgs{
			Bucket: siteBucket.ID(),
			Policy: siteBucket.ID().ApplyT(func(id string) (pulumi.String, error) {
				var _zero pulumi.String
				tmpJSON0, err := json.Marshal(map[string]interface{}{
					"Version": "2012-10-17",
					"Statement": []map[string]interface{}{
						map[string]interface{}{
							"Effect":    "Allow",
							"Principal": "*",
							"Action": []string{
								"s3:GetObject",
							},
							"Resource": []string{
								fmt.Sprintf("%v%v%v", "arn:aws:s3:::", id, "/*"),
							},
						},
					},
				})
				if err != nil {
					return _zero, err
				}
				json0 := string(tmpJSON0)
				return pulumi.String(json0), nil
			}).(pulumi.StringOutput),
		})
		if err != nil {
			return err
		}
		ctx.Export("bucketName", siteBucket.Bucket)
		ctx.Export("websiteUrl", siteBucket.WebsiteEndpoint)
		return nil
	})
}
