
---
title: "listConfigurations"
title_tag: "myedgeorder.listConfigurations"
meta_desc: "Documentation for the myedgeorder.listConfigurations function with examples, input properties, output properties, and supporting types."
layout: api
no_edit_this_page: true
---



<!-- WARNING: this file was generated by test. -->
<!-- Do not edit by hand unless you're certain you know what you are doing! -->

The list of configurations.
API Version: 2020-12-01-preview.




## Using listConfigurations {#using}

Two invocation forms are available. The direct form accepts plain
arguments and either blocks until the result value is available, or
returns a Promise-wrapped result. The output form accepts
Input-wrapped arguments and returns an Output-wrapped result.

{{< chooser language "typescript,python,go,csharp" / >}}


{{% choosable language nodejs %}}
<div class="highlight"
><pre class="chroma"><code class="language-typescript" data-lang="typescript"
><span class="k">function </span>listConfigurations<span class="p">(</span><span class="nx">args</span><span class="p">:</span> <span class="nx">ListConfigurationsArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p">?:</span> <span class="nx"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#InvokeOptions">InvokeOptions</a></span><span class="p">): Promise&lt;<span class="nx"><a href="#result">ListConfigurationsResult</a></span>></span
><span class="k">
function </span>listConfigurationsOutput<span class="p">(</span><span class="nx">args</span><span class="p">:</span> <span class="nx">ListConfigurationsOutputArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p">?:</span> <span class="nx"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#InvokeOptions">InvokeOptions</a></span><span class="p">): Output&lt;<span class="nx"><a href="#result">ListConfigurationsResult</a></span>></span
></code></pre></div>
{{% /choosable %}}


{{% choosable language python %}}
<div class="highlight"><pre class="chroma"><code class="language-python" data-lang="python"
><span class="k">def </span>list_configurations<span class="p">(</span><span class="nx">configuration_filters</span><span class="p">:</span> <span class="nx">Optional[Sequence[ConfigurationFilters]]</span> = None<span class="p">,</span>
                        <span class="nx">customer_subscription_details</span><span class="p">:</span> <span class="nx">Optional[CustomerSubscriptionDetails]</span> = None<span class="p">,</span>
                        <span class="nx">skip_token</span><span class="p">:</span> <span class="nx">Optional[str]</span> = None<span class="p">,</span>
                        <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.InvokeOptions">Optional[InvokeOptions]</a></span> = None<span class="p">) -&gt;</span> <span>ListConfigurationsResult</span
><span class="k">
def </span>list_configurations_output<span class="p">(</span><span class="nx">configuration_filters</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[Sequence[pulumi.Input[ConfigurationFiltersArgs]]]]</span> = None<span class="p">,</span>
                        <span class="nx">customer_subscription_details</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[CustomerSubscriptionDetailsArgs]]</span> = None<span class="p">,</span>
                        <span class="nx">skip_token</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[str]]</span> = None<span class="p">,</span>
                        <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.InvokeOptions">Optional[InvokeOptions]</a></span> = None<span class="p">) -&gt;</span> <span>Output[ListConfigurationsResult]</span
></code></pre></div>
{{% /choosable %}}


{{% choosable language go %}}
<div class="highlight"><pre class="chroma"><code class="language-go" data-lang="go"
><span class="k">func </span>ListConfigurations<span class="p">(</span><span class="nx">ctx</span><span class="p"> *</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span><span class="p">,</span> <span class="nx">args</span><span class="p"> *</span><span class="nx">ListConfigurationsArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p"> ...</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#InvokeOption">InvokeOption</a></span><span class="p">) (*<span class="nx"><a href="#result">ListConfigurationsResult</a></span>, error)</span
><span class="k">
func </span>ListConfigurationsOutput<span class="p">(</span><span class="nx">ctx</span><span class="p"> *</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span><span class="p">,</span> <span class="nx">args</span><span class="p"> *</span><span class="nx">ListConfigurationsOutputArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p"> ...</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#InvokeOption">InvokeOption</a></span><span class="p">) ListConfigurationsResultOutput</span
></code></pre></div>

&gt; Note: This function is named `ListConfigurations` in the Go SDK.

{{% /choosable %}}


{{% choosable language csharp %}}
<div class="highlight"><pre class="chroma"><code class="language-csharp" data-lang="csharp"><span class="k">public static class </span><span class="nx">ListConfigurations </span><span class="p">
{</span><span class="k">
    public static </span>Task&lt;<span class="nx"><a href="#result">ListConfigurationsResult</a></span>> <span class="p">InvokeAsync(</span><span class="nx">ListConfigurationsArgs</span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.InvokeOptions.html">InvokeOptions</a></span><span class="p">? </span><span class="nx">opts = null<span class="p">)</span><span class="k">
    public static </span>Output&lt;<span class="nx"><a href="#result">ListConfigurationsResult</a></span>> <span class="p">Invoke(</span><span class="nx">ListConfigurationsInvokeArgs</span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.InvokeOptions.html">InvokeOptions</a></span><span class="p">? </span><span class="nx">opts = null<span class="p">)</span><span class="p">
}</span></code></pre></div>
{{% /choosable %}}



The following arguments are supported:


{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="configurationfilters_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationfilters_csharp" style="color: inherit; text-decoration: inherit;">Configuration<wbr>Filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationfilters">List&lt;Configuration<wbr>Filters&gt;</a></span>
    </dt>
    <dd>{{% md %}}Holds details about product hierarchy information and filterable property.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="customersubscriptiondetails_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#customersubscriptiondetails_csharp" style="color: inherit; text-decoration: inherit;">Customer<wbr>Subscription<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd>{{% md %}}Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="skiptoken_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skiptoken_csharp" style="color: inherit; text-decoration: inherit;">Skip<wbr>Token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}$skipToken is supported on list of configurations, which provides the next page in the list of configurations.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="configurationfilters_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationfilters_go" style="color: inherit; text-decoration: inherit;">Configuration<wbr>Filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationfilters">[]Configuration<wbr>Filters</a></span>
    </dt>
    <dd>{{% md %}}Holds details about product hierarchy information and filterable property.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="customersubscriptiondetails_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#customersubscriptiondetails_go" style="color: inherit; text-decoration: inherit;">Customer<wbr>Subscription<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd>{{% md %}}Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="skiptoken_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skiptoken_go" style="color: inherit; text-decoration: inherit;">Skip<wbr>Token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}$skipToken is supported on list of configurations, which provides the next page in the list of configurations.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="configurationfilters_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationfilters_nodejs" style="color: inherit; text-decoration: inherit;">configuration<wbr>Filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationfilters">Configuration<wbr>Filters[]</a></span>
    </dt>
    <dd>{{% md %}}Holds details about product hierarchy information and filterable property.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="customersubscriptiondetails_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#customersubscriptiondetails_nodejs" style="color: inherit; text-decoration: inherit;">customer<wbr>Subscription<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd>{{% md %}}Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="skiptoken_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skiptoken_nodejs" style="color: inherit; text-decoration: inherit;">skip<wbr>Token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}$skipToken is supported on list of configurations, which provides the next page in the list of configurations.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="configuration_filters_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configuration_filters_python" style="color: inherit; text-decoration: inherit;">configuration_<wbr>filters</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationfilters">Sequence[Configuration<wbr>Filters]</a></span>
    </dt>
    <dd>{{% md %}}Holds details about product hierarchy information and filterable property.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="customer_subscription_details_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#customer_subscription_details_python" style="color: inherit; text-decoration: inherit;">customer_<wbr>subscription_<wbr>details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd>{{% md %}}Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="skip_token_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skip_token_python" style="color: inherit; text-decoration: inherit;">skip_<wbr>token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}$skipToken is supported on list of configurations, which provides the next page in the list of configurations.{{% /md %}}</dd></dl>
{{% /choosable %}}




## listConfigurations Result {#result}

The following output properties are available:



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_csharp" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">List&lt;Configuration<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}List of configurations.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="nextlink_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nextlink_csharp" style="color: inherit; text-decoration: inherit;">Next<wbr>Link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Link for the next set of configurations.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_go" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">[]Configuration<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}List of configurations.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="nextlink_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nextlink_go" style="color: inherit; text-decoration: inherit;">Next<wbr>Link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Link for the next set of configurations.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_nodejs" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">Configuration<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}List of configurations.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="nextlink_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nextlink_nodejs" style="color: inherit; text-decoration: inherit;">next<wbr>Link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Link for the next set of configurations.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_python" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">Sequence[Configuration<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}List of configurations.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="next_link_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#next_link_python" style="color: inherit; text-decoration: inherit;">next_<wbr>link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Link for the next set of configurations.{{% /md %}}</dd></dl>
{{% /choosable %}}




## Supporting Types


<h4 id="availabilityinformationresponse">Availability<wbr>Information<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilitystage_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilitystage_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Current availability stage of the product. Availability stage{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreason_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreason_csharp" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Reason why the product is disabled.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreasonmessage_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreasonmessage_csharp" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason<wbr>Message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Message for why the product is disabled.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilitystage_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilitystage_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Current availability stage of the product. Availability stage{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreason_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreason_go" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Reason why the product is disabled.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreasonmessage_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreasonmessage_go" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason<wbr>Message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Message for why the product is disabled.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilitystage_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilitystage_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Current availability stage of the product. Availability stage{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreason_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreason_nodejs" style="color: inherit; text-decoration: inherit;">disabled<wbr>Reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Reason why the product is disabled.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreasonmessage_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreasonmessage_nodejs" style="color: inherit; text-decoration: inherit;">disabled<wbr>Reason<wbr>Message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Message for why the product is disabled.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_stage_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availability_stage_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Current availability stage of the product. Availability stage{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabled_reason_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabled_reason_python" style="color: inherit; text-decoration: inherit;">disabled_<wbr>reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Reason why the product is disabled.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabled_reason_message_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabled_reason_message_python" style="color: inherit; text-decoration: inherit;">disabled_<wbr>reason_<wbr>message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Message for why the product is disabled.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="billingmeterdetailsresponse">Billing<wbr>Meter<wbr>Details<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#frequency_csharp" style="color: inherit; text-decoration: inherit;">Frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Frequency of recurrence{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterdetails_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterdetails_csharp" style="color: inherit; text-decoration: inherit;">Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Represents MeterDetails{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meteringtype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meteringtype_csharp" style="color: inherit; text-decoration: inherit;">Metering<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Metering type (eg one-time or recurrent){{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="name_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_csharp" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Billing type name{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#frequency_go" style="color: inherit; text-decoration: inherit;">Frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Frequency of recurrence{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterdetails_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterdetails_go" style="color: inherit; text-decoration: inherit;">Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Represents MeterDetails{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meteringtype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meteringtype_go" style="color: inherit; text-decoration: inherit;">Metering<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Metering type (eg one-time or recurrent){{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="name_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_go" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Billing type name{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#frequency_nodejs" style="color: inherit; text-decoration: inherit;">frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Frequency of recurrence{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterdetails_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterdetails_nodejs" style="color: inherit; text-decoration: inherit;">meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Represents MeterDetails{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meteringtype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meteringtype_nodejs" style="color: inherit; text-decoration: inherit;">metering<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Metering type (eg one-time or recurrent){{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="name_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_nodejs" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Billing type name{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#frequency_python" style="color: inherit; text-decoration: inherit;">frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Frequency of recurrence{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meter_details_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meter_details_python" style="color: inherit; text-decoration: inherit;">meter_<wbr>details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Represents MeterDetails{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="metering_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#metering_type_python" style="color: inherit; text-decoration: inherit;">metering_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents Metering type (eg one-time or recurrent){{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_python" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents Billing type name{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="configurationfilters">Configuration<wbr>Filters</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_csharp" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformation">Hierarchy<wbr>Information</a></span>
    </dt>
    <dd>{{% md %}}Product hierarchy information{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="filterableproperty_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperty_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Property</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterableproperty">List&lt;Filterable<wbr>Property&gt;</a></span>
    </dt>
    <dd>{{% md %}}Filters specific to product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_go" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformation">Hierarchy<wbr>Information</a></span>
    </dt>
    <dd>{{% md %}}Product hierarchy information{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="filterableproperty_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperty_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Property</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterableproperty">[]Filterable<wbr>Property</a></span>
    </dt>
    <dd>{{% md %}}Filters specific to product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_nodejs" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformation">Hierarchy<wbr>Information</a></span>
    </dt>
    <dd>{{% md %}}Product hierarchy information{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="filterableproperty_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperty_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Property</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterableproperty">Filterable<wbr>Property[]</a></span>
    </dt>
    <dd>{{% md %}}Filters specific to product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="hierarchy_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchy_information_python" style="color: inherit; text-decoration: inherit;">hierarchy_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformation">Hierarchy<wbr>Information</a></span>
    </dt>
    <dd>{{% md %}}Product hierarchy information{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="filterable_property_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterable_property_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>property</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterableproperty">Sequence[Filterable<wbr>Property]</a></span>
    </dt>
    <dd>{{% md %}}Filters specific to product{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="configurationresponse">Configuration<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_csharp" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_csharp" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#dimensions_csharp" style="color: inherit; text-decoration: inherit;">Dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Dimensions of the configuration{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_csharp" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List&lt;Filterable<wbr>Property<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_csharp" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List&lt;Image<wbr>Information<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="specifications_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#specifications_csharp" style="color: inherit; text-decoration: inherit;">Specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">List&lt;Specification<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}Specifications of the configuration{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_go" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_go" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#dimensions_go" style="color: inherit; text-decoration: inherit;">Dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Dimensions of the configuration{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_go" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">[]Filterable<wbr>Property<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_go" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">[]Image<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="specifications_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#specifications_go" style="color: inherit; text-decoration: inherit;">Specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">[]Specification<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Specifications of the configuration{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_nodejs" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_nodejs" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#dimensions_nodejs" style="color: inherit; text-decoration: inherit;">dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Dimensions of the configuration{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_nodejs" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Filterable<wbr>Property<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_nodejs" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Image<wbr>Information<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="specifications_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#specifications_nodejs" style="color: inherit; text-decoration: inherit;">specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">Specification<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}Specifications of the configuration{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availability_information_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="cost_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#cost_information_python" style="color: inherit; text-decoration: inherit;">cost_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_python" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#dimensions_python" style="color: inherit; text-decoration: inherit;">dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Dimensions of the configuration{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="display_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#display_name_python" style="color: inherit; text-decoration: inherit;">display_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterable_properties_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterable_properties_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Sequence[Filterable<wbr>Property<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchy_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchy_information_python" style="color: inherit; text-decoration: inherit;">hierarchy_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="image_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#image_information_python" style="color: inherit; text-decoration: inherit;">image_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Sequence[Image<wbr>Information<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="specifications_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#specifications_python" style="color: inherit; text-decoration: inherit;">specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">Sequence[Specification<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}Specifications of the configuration{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="costinformationresponse">Cost<wbr>Information<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billinginfourl_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billinginfourl_csharp" style="color: inherit; text-decoration: inherit;">Billing<wbr>Info<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Default url to display billing information{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="billingmeterdetails_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billingmeterdetails_csharp" style="color: inherit; text-decoration: inherit;">Billing<wbr>Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">List&lt;Billing<wbr>Meter<wbr>Details<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}Details on the various billing aspects for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billinginfourl_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billinginfourl_go" style="color: inherit; text-decoration: inherit;">Billing<wbr>Info<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Default url to display billing information{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="billingmeterdetails_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billingmeterdetails_go" style="color: inherit; text-decoration: inherit;">Billing<wbr>Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">[]Billing<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Details on the various billing aspects for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billinginfourl_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billinginfourl_nodejs" style="color: inherit; text-decoration: inherit;">billing<wbr>Info<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Default url to display billing information{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="billingmeterdetails_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billingmeterdetails_nodejs" style="color: inherit; text-decoration: inherit;">billing<wbr>Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">Billing<wbr>Meter<wbr>Details<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}Details on the various billing aspects for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billing_info_url_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billing_info_url_python" style="color: inherit; text-decoration: inherit;">billing_<wbr>info_<wbr>url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Default url to display billing information{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="billing_meter_details_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billing_meter_details_python" style="color: inherit; text-decoration: inherit;">billing_<wbr>meter_<wbr>details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">Sequence[Billing<wbr>Meter<wbr>Details<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}Details on the various billing aspects for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quotaid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#quotaid_csharp" style="color: inherit; text-decoration: inherit;">Quota<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Quota ID of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="locationplacementid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#locationplacementid_csharp" style="color: inherit; text-decoration: inherit;">Location<wbr>Placement<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Location placement Id of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="registeredfeatures_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#registeredfeatures_csharp" style="color: inherit; text-decoration: inherit;">Registered<wbr>Features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">List&lt;Customer<wbr>Subscription<wbr>Registered<wbr>Features&gt;</a></span>
    </dt>
    <dd>{{% md %}}List of registered feature flags for subscription{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quotaid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#quotaid_go" style="color: inherit; text-decoration: inherit;">Quota<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Quota ID of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="locationplacementid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#locationplacementid_go" style="color: inherit; text-decoration: inherit;">Location<wbr>Placement<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Location placement Id of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="registeredfeatures_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#registeredfeatures_go" style="color: inherit; text-decoration: inherit;">Registered<wbr>Features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">[]Customer<wbr>Subscription<wbr>Registered<wbr>Features</a></span>
    </dt>
    <dd>{{% md %}}List of registered feature flags for subscription{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quotaid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#quotaid_nodejs" style="color: inherit; text-decoration: inherit;">quota<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Quota ID of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="locationplacementid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#locationplacementid_nodejs" style="color: inherit; text-decoration: inherit;">location<wbr>Placement<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Location placement Id of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="registeredfeatures_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#registeredfeatures_nodejs" style="color: inherit; text-decoration: inherit;">registered<wbr>Features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">Customer<wbr>Subscription<wbr>Registered<wbr>Features[]</a></span>
    </dt>
    <dd>{{% md %}}List of registered feature flags for subscription{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quota_id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#quota_id_python" style="color: inherit; text-decoration: inherit;">quota_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Quota ID of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="location_placement_id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#location_placement_id_python" style="color: inherit; text-decoration: inherit;">location_<wbr>placement_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Location placement Id of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="registered_features_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#registered_features_python" style="color: inherit; text-decoration: inherit;">registered_<wbr>features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">Sequence[Customer<wbr>Subscription<wbr>Registered<wbr>Features]</a></span>
    </dt>
    <dd>{{% md %}}List of registered feature flags for subscription{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="customersubscriptionregisteredfeatures">Customer<wbr>Subscription<wbr>Registered<wbr>Features</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_csharp" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of subscription registered feature{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="state_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#state_csharp" style="color: inherit; text-decoration: inherit;">State</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}State of subscription registered feature{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_go" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of subscription registered feature{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="state_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#state_go" style="color: inherit; text-decoration: inherit;">State</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}State of subscription registered feature{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_nodejs" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of subscription registered feature{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="state_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#state_nodejs" style="color: inherit; text-decoration: inherit;">state</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}State of subscription registered feature{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_python" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Name of subscription registered feature{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="state_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#state_python" style="color: inherit; text-decoration: inherit;">state</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}State of subscription registered feature{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="descriptionresponse">Description<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#attributes_csharp" style="color: inherit; text-decoration: inherit;">Attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd>{{% md %}}Attributes for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="descriptiontype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#descriptiontype_csharp" style="color: inherit; text-decoration: inherit;">Description<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of description.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="keywords_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#keywords_csharp" style="color: inherit; text-decoration: inherit;">Keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd>{{% md %}}Keywords for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="links_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#links_csharp" style="color: inherit; text-decoration: inherit;">Links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">List&lt;Link<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}Links for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="longdescription_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#longdescription_csharp" style="color: inherit; text-decoration: inherit;">Long<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Long description of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="shortdescription_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#shortdescription_csharp" style="color: inherit; text-decoration: inherit;">Short<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Short description of the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#attributes_go" style="color: inherit; text-decoration: inherit;">Attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd>{{% md %}}Attributes for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="descriptiontype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#descriptiontype_go" style="color: inherit; text-decoration: inherit;">Description<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of description.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="keywords_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#keywords_go" style="color: inherit; text-decoration: inherit;">Keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd>{{% md %}}Keywords for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="links_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#links_go" style="color: inherit; text-decoration: inherit;">Links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">[]Link<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Links for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="longdescription_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#longdescription_go" style="color: inherit; text-decoration: inherit;">Long<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Long description of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="shortdescription_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#shortdescription_go" style="color: inherit; text-decoration: inherit;">Short<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Short description of the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#attributes_nodejs" style="color: inherit; text-decoration: inherit;">attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd>{{% md %}}Attributes for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="descriptiontype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#descriptiontype_nodejs" style="color: inherit; text-decoration: inherit;">description<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of description.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="keywords_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#keywords_nodejs" style="color: inherit; text-decoration: inherit;">keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd>{{% md %}}Keywords for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="links_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#links_nodejs" style="color: inherit; text-decoration: inherit;">links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">Link<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}Links for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="longdescription_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#longdescription_nodejs" style="color: inherit; text-decoration: inherit;">long<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Long description of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="shortdescription_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#shortdescription_nodejs" style="color: inherit; text-decoration: inherit;">short<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Short description of the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#attributes_python" style="color: inherit; text-decoration: inherit;">attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd>{{% md %}}Attributes for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_type_python" style="color: inherit; text-decoration: inherit;">description_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Type of description.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="keywords_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#keywords_python" style="color: inherit; text-decoration: inherit;">keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd>{{% md %}}Keywords for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="links_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#links_python" style="color: inherit; text-decoration: inherit;">links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">Sequence[Link<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}Links for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="long_description_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#long_description_python" style="color: inherit; text-decoration: inherit;">long_<wbr>description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Long description of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="short_description_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#short_description_python" style="color: inherit; text-decoration: inherit;">short_<wbr>description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Short description of the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="dimensionsresponse">Dimensions<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#depth_csharp" style="color: inherit; text-decoration: inherit;">Depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Depth of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="height_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#height_csharp" style="color: inherit; text-decoration: inherit;">Height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Height of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="length_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_csharp" style="color: inherit; text-decoration: inherit;">Length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Length of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="lengthheightunit_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#lengthheightunit_csharp" style="color: inherit; text-decoration: inherit;">Length<wbr>Height<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of length, height and width.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weight_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_csharp" style="color: inherit; text-decoration: inherit;">Weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Weight of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weightunit_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weightunit_csharp" style="color: inherit; text-decoration: inherit;">Weight<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of weight.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="width_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#width_csharp" style="color: inherit; text-decoration: inherit;">Width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Width of the device.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#depth_go" style="color: inherit; text-decoration: inherit;">Depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Depth of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="height_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#height_go" style="color: inherit; text-decoration: inherit;">Height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Height of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="length_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_go" style="color: inherit; text-decoration: inherit;">Length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Length of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="lengthheightunit_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#lengthheightunit_go" style="color: inherit; text-decoration: inherit;">Length<wbr>Height<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of length, height and width.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weight_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_go" style="color: inherit; text-decoration: inherit;">Weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Weight of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weightunit_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weightunit_go" style="color: inherit; text-decoration: inherit;">Weight<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of weight.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="width_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#width_go" style="color: inherit; text-decoration: inherit;">Width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Width of the device.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#depth_nodejs" style="color: inherit; text-decoration: inherit;">depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Depth of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="height_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#height_nodejs" style="color: inherit; text-decoration: inherit;">height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Height of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="length_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_nodejs" style="color: inherit; text-decoration: inherit;">length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Length of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="lengthheightunit_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#lengthheightunit_nodejs" style="color: inherit; text-decoration: inherit;">length<wbr>Height<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of length, height and width.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weight_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_nodejs" style="color: inherit; text-decoration: inherit;">weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Weight of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weightunit_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weightunit_nodejs" style="color: inherit; text-decoration: inherit;">weight<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of weight.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="width_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#width_nodejs" style="color: inherit; text-decoration: inherit;">width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Width of the device.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#depth_python" style="color: inherit; text-decoration: inherit;">depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Depth of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="height_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#height_python" style="color: inherit; text-decoration: inherit;">height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Height of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="length_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_python" style="color: inherit; text-decoration: inherit;">length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Length of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="length_height_unit_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_height_unit_python" style="color: inherit; text-decoration: inherit;">length_<wbr>height_<wbr>unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of length, height and width.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weight_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_python" style="color: inherit; text-decoration: inherit;">weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Weight of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weight_unit_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_unit_python" style="color: inherit; text-decoration: inherit;">weight_<wbr>unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of weight.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="width_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#width_python" style="color: inherit; text-decoration: inherit;">width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Width of the device.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="filterableproperty">Filterable<wbr>Property</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_csharp" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_csharp" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string | <a href="#supportedfiltertypes">Pulumi.<wbr>Myedgeorder.<wbr>Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_go" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_go" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string | <a href="#supportedfiltertypes">Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_nodejs" style="color: inherit; text-decoration: inherit;">supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_nodejs" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string | <a href="#supportedfiltertypes">Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supported_values_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supported_values_python" style="color: inherit; text-decoration: inherit;">supported_<wbr>values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_python" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str | <a href="#supportedfiltertypes">Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="filterablepropertyresponse">Filterable<wbr>Property<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_csharp" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_csharp" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_go" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_go" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_nodejs" style="color: inherit; text-decoration: inherit;">supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_nodejs" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supported_values_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supported_values_python" style="color: inherit; text-decoration: inherit;">supported_<wbr>values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_python" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="hierarchyinformation">Hierarchy<wbr>Information</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationname_csharp" style="color: inherit; text-decoration: inherit;">Configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productfamilyname_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlinename_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productname_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationname_go" style="color: inherit; text-decoration: inherit;">Configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productfamilyname_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlinename_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productname_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationname_nodejs" style="color: inherit; text-decoration: inherit;">configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productfamilyname_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlinename_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productname_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configuration_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configuration_name_python" style="color: inherit; text-decoration: inherit;">configuration_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="product_family_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_family_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>family_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="product_line_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_line_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>line_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="product_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationname_csharp" style="color: inherit; text-decoration: inherit;">Configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productfamilyname_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlinename_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productname_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationname_go" style="color: inherit; text-decoration: inherit;">Configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productfamilyname_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlinename_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productname_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationname_nodejs" style="color: inherit; text-decoration: inherit;">configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productfamilyname_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlinename_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productname_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configuration_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configuration_name_python" style="color: inherit; text-decoration: inherit;">configuration_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="product_family_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_family_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>family_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="product_line_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_line_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>line_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="product_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="imageinformationresponse">Image<wbr>Information<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="imagetype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imagetype_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of the image{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageurl_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageurl_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the image{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="imagetype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imagetype_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of the image{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageurl_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageurl_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the image{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="imagetype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imagetype_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of the image{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageurl_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageurl_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the image{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="image_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#image_type_python" style="color: inherit; text-decoration: inherit;">image_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Type of the image{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="image_url_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#image_url_python" style="color: inherit; text-decoration: inherit;">image_<wbr>url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Url of the image{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="linkresponse">Link<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="linktype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linktype_csharp" style="color: inherit; text-decoration: inherit;">Link<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of link{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="linkurl_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linkurl_csharp" style="color: inherit; text-decoration: inherit;">Link<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the link{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="linktype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linktype_go" style="color: inherit; text-decoration: inherit;">Link<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of link{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="linkurl_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linkurl_go" style="color: inherit; text-decoration: inherit;">Link<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the link{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="linktype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linktype_nodejs" style="color: inherit; text-decoration: inherit;">link<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of link{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="linkurl_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linkurl_nodejs" style="color: inherit; text-decoration: inherit;">link<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the link{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="link_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#link_type_python" style="color: inherit; text-decoration: inherit;">link_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Type of link{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="link_url_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#link_url_python" style="color: inherit; text-decoration: inherit;">link_<wbr>url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Url of the link{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_csharp" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterguid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterguid_csharp" style="color: inherit; text-decoration: inherit;">Meter<wbr>Guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Validation status of requested data center and transport.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_csharp" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_go" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterguid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterguid_go" style="color: inherit; text-decoration: inherit;">Meter<wbr>Guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Validation status of requested data center and transport.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_go" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_nodejs" style="color: inherit; text-decoration: inherit;">charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterguid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterguid_nodejs" style="color: inherit; text-decoration: inherit;">meter<wbr>Guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Validation status of requested data center and transport.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_nodejs" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="charging_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#charging_type_python" style="color: inherit; text-decoration: inherit;">charging_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meter_guid_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meter_guid_python" style="color: inherit; text-decoration: inherit;">meter_<wbr>guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Validation status of requested data center and transport.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_python" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_csharp" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_csharp" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="productid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productid_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Product Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="skuid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skuid_csharp" style="color: inherit; text-decoration: inherit;">Sku<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Sku Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="termid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#termid_csharp" style="color: inherit; text-decoration: inherit;">Term<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Term Id{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_go" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_go" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="productid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productid_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Product Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="skuid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skuid_go" style="color: inherit; text-decoration: inherit;">Sku<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Sku Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="termid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#termid_go" style="color: inherit; text-decoration: inherit;">Term<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Term Id{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_nodejs" style="color: inherit; text-decoration: inherit;">charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_nodejs" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="productid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productid_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Product Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="skuid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skuid_nodejs" style="color: inherit; text-decoration: inherit;">sku<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Sku Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="termid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#termid_nodejs" style="color: inherit; text-decoration: inherit;">term<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Term Id{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="charging_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#charging_type_python" style="color: inherit; text-decoration: inherit;">charging_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_python" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="product_id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_id_python" style="color: inherit; text-decoration: inherit;">product_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Product Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="sku_id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sku_id_python" style="color: inherit; text-decoration: inherit;">sku_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Sku Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="term_id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#term_id_python" style="color: inherit; text-decoration: inherit;">term_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Term Id{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="specificationresponse">Specification<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_csharp" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of the specification{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="value_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_csharp" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Value of the specification{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_go" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of the specification{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="value_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_go" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Value of the specification{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_nodejs" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of the specification{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="value_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_nodejs" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Value of the specification{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_python" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Name of the specification{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="value_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_python" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Value of the specification{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="supportedfiltertypes">Supported<wbr>Filter<wbr>Types</h4>







<h2 id="package-details">Package Details</h2>
<dl class="package-details">
	<dt>Repository</dt>
	<dd><a href=""></a></dd>
	<dt>License</dt>
	<dd></dd>
</dl>

