
---
title: "listProductFamilies"
title_tag: "myedgeorder.listProductFamilies"
meta_desc: "Documentation for the myedgeorder.listProductFamilies function with examples, input properties, output properties, and supporting types."
layout: api
no_edit_this_page: true
---



<!-- WARNING: this file was generated by test. -->
<!-- Do not edit by hand unless you're certain you know what you are doing! -->

The list of product families.
API Version: 2020-12-01-preview.




## Using listProductFamilies {#using}

Two invocation forms are available. The direct form accepts plain
arguments and either blocks until the result value is available, or
returns a Promise-wrapped result. The output form accepts
Input-wrapped arguments and returns an Output-wrapped result.

{{< chooser language "typescript,python,go,csharp" / >}}


{{% choosable language nodejs %}}
<div class="highlight"
><pre class="chroma"><code class="language-typescript" data-lang="typescript"
><span class="k">function </span>listProductFamilies<span class="p">(</span><span class="nx">args</span><span class="p">:</span> <span class="nx">ListProductFamiliesArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p">?:</span> <span class="nx"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#InvokeOptions">InvokeOptions</a></span><span class="p">): Promise&lt;<span class="nx"><a href="#result">ListProductFamiliesResult</a></span>></span
><span class="k">
function </span>listProductFamiliesOutput<span class="p">(</span><span class="nx">args</span><span class="p">:</span> <span class="nx">ListProductFamiliesOutputArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p">?:</span> <span class="nx"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#InvokeOptions">InvokeOptions</a></span><span class="p">): Output&lt;<span class="nx"><a href="#result">ListProductFamiliesResult</a></span>></span
></code></pre></div>
{{% /choosable %}}


{{% choosable language python %}}
<div class="highlight"><pre class="chroma"><code class="language-python" data-lang="python"
><span class="k">def </span>list_product_families<span class="p">(</span><span class="nx">customer_subscription_details</span><span class="p">:</span> <span class="nx">Optional[CustomerSubscriptionDetails]</span> = None<span class="p">,</span>
                          <span class="nx">expand</span><span class="p">:</span> <span class="nx">Optional[str]</span> = None<span class="p">,</span>
                          <span class="nx">filterable_properties</span><span class="p">:</span> <span class="nx">Optional[Mapping[str, Sequence[FilterableProperty]]]</span> = None<span class="p">,</span>
                          <span class="nx">skip_token</span><span class="p">:</span> <span class="nx">Optional[str]</span> = None<span class="p">,</span>
                          <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.InvokeOptions">Optional[InvokeOptions]</a></span> = None<span class="p">) -&gt;</span> <span>ListProductFamiliesResult</span
><span class="k">
def </span>list_product_families_output<span class="p">(</span><span class="nx">customer_subscription_details</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[CustomerSubscriptionDetailsArgs]]</span> = None<span class="p">,</span>
                          <span class="nx">expand</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[str]]</span> = None<span class="p">,</span>
                          <span class="nx">filterable_properties</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[FilterablePropertyArgs]]]]]]</span> = None<span class="p">,</span>
                          <span class="nx">skip_token</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[str]]</span> = None<span class="p">,</span>
                          <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.InvokeOptions">Optional[InvokeOptions]</a></span> = None<span class="p">) -&gt;</span> <span>Output[ListProductFamiliesResult]</span
></code></pre></div>
{{% /choosable %}}


{{% choosable language go %}}
<div class="highlight"><pre class="chroma"><code class="language-go" data-lang="go"
><span class="k">func </span>ListProductFamilies<span class="p">(</span><span class="nx">ctx</span><span class="p"> *</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span><span class="p">,</span> <span class="nx">args</span><span class="p"> *</span><span class="nx">ListProductFamiliesArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p"> ...</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#InvokeOption">InvokeOption</a></span><span class="p">) (*<span class="nx"><a href="#result">ListProductFamiliesResult</a></span>, error)</span
><span class="k">
func </span>ListProductFamiliesOutput<span class="p">(</span><span class="nx">ctx</span><span class="p"> *</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span><span class="p">,</span> <span class="nx">args</span><span class="p"> *</span><span class="nx">ListProductFamiliesOutputArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p"> ...</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#InvokeOption">InvokeOption</a></span><span class="p">) ListProductFamiliesResultOutput</span
></code></pre></div>

&gt; Note: This function is named `ListProductFamilies` in the Go SDK.

{{% /choosable %}}


{{% choosable language csharp %}}
<div class="highlight"><pre class="chroma"><code class="language-csharp" data-lang="csharp"><span class="k">public static class </span><span class="nx">ListProductFamilies </span><span class="p">
{</span><span class="k">
    public static </span>Task&lt;<span class="nx"><a href="#result">ListProductFamiliesResult</a></span>> <span class="p">InvokeAsync(</span><span class="nx">ListProductFamiliesArgs</span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.InvokeOptions.html">InvokeOptions</a></span><span class="p">? </span><span class="nx">opts = null<span class="p">)</span><span class="k">
    public static </span>Output&lt;<span class="nx"><a href="#result">ListProductFamiliesResult</a></span>> <span class="p">Invoke(</span><span class="nx">ListProductFamiliesInvokeArgs</span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.InvokeOptions.html">InvokeOptions</a></span><span class="p">? </span><span class="nx">opts = null<span class="p">)</span><span class="p">
}</span></code></pre></div>
{{% /choosable %}}



The following arguments are supported:


{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="filterableproperties_csharp">
<a href="#filterableproperties_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Dictionary&lt;string, Immutable<wbr>Array&lt;Filterable<wbr>Property&gt;&gt;</span>
    </dt>
    <dd>{{% md %}}Dictionary of filterable properties on product family.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="customersubscriptiondetails_csharp">
<a href="#customersubscriptiondetails_csharp" style="color: inherit; text-decoration: inherit;">Customer<wbr>Subscription<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd>{{% md %}}Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="expand_csharp">
<a href="#expand_csharp" style="color: inherit; text-decoration: inherit;">Expand</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}$expand is supported on configurations parameter for product, which provides details on the configurations for the product.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="skiptoken_csharp">
<a href="#skiptoken_csharp" style="color: inherit; text-decoration: inherit;">Skip<wbr>Token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}$skipToken is supported on list of product families, which provides the next page in the list of product families.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="filterableproperties_go">
<a href="#filterableproperties_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">map[string][]Filterable<wbr>Property</span>
    </dt>
    <dd>{{% md %}}Dictionary of filterable properties on product family.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="customersubscriptiondetails_go">
<a href="#customersubscriptiondetails_go" style="color: inherit; text-decoration: inherit;">Customer<wbr>Subscription<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd>{{% md %}}Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="expand_go">
<a href="#expand_go" style="color: inherit; text-decoration: inherit;">Expand</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}$expand is supported on configurations parameter for product, which provides details on the configurations for the product.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="skiptoken_go">
<a href="#skiptoken_go" style="color: inherit; text-decoration: inherit;">Skip<wbr>Token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}$skipToken is supported on list of product families, which provides the next page in the list of product families.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="filterableproperties_nodejs">
<a href="#filterableproperties_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">{[key: string]: Filterable<wbr>Property[]}</span>
    </dt>
    <dd>{{% md %}}Dictionary of filterable properties on product family.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="customersubscriptiondetails_nodejs">
<a href="#customersubscriptiondetails_nodejs" style="color: inherit; text-decoration: inherit;">customer<wbr>Subscription<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd>{{% md %}}Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="expand_nodejs">
<a href="#expand_nodejs" style="color: inherit; text-decoration: inherit;">expand</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}$expand is supported on configurations parameter for product, which provides details on the configurations for the product.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="skiptoken_nodejs">
<a href="#skiptoken_nodejs" style="color: inherit; text-decoration: inherit;">skip<wbr>Token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}$skipToken is supported on list of product families, which provides the next page in the list of product families.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="filterable_properties_python">
<a href="#filterable_properties_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Mapping[str, Sequence[Filterable<wbr>Property]]</span>
    </dt>
    <dd>{{% md %}}Dictionary of filterable properties on product family.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="customer_subscription_details_python">
<a href="#customer_subscription_details_python" style="color: inherit; text-decoration: inherit;">customer_<wbr>subscription_<wbr>details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd>{{% md %}}Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="expand_python">
<a href="#expand_python" style="color: inherit; text-decoration: inherit;">expand</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}$expand is supported on configurations parameter for product, which provides details on the configurations for the product.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="skip_token_python">
<a href="#skip_token_python" style="color: inherit; text-decoration: inherit;">skip_<wbr>token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}$skipToken is supported on list of product families, which provides the next page in the list of product families.{{% /md %}}</dd></dl>
{{% /choosable %}}




## listProductFamilies Result {#result}

The following output properties are available:



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_csharp">
<a href="#value_csharp" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productfamilyresponse">List&lt;Product<wbr>Family<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}List of product families.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="nextlink_csharp">
<a href="#nextlink_csharp" style="color: inherit; text-decoration: inherit;">Next<wbr>Link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Link for the next set of product families.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_go">
<a href="#value_go" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productfamilyresponse">[]Product<wbr>Family<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}List of product families.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="nextlink_go">
<a href="#nextlink_go" style="color: inherit; text-decoration: inherit;">Next<wbr>Link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Link for the next set of product families.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_nodejs">
<a href="#value_nodejs" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productfamilyresponse">Product<wbr>Family<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}List of product families.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="nextlink_nodejs">
<a href="#nextlink_nodejs" style="color: inherit; text-decoration: inherit;">next<wbr>Link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Link for the next set of product families.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_python">
<a href="#value_python" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productfamilyresponse">Sequence[Product<wbr>Family<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}List of product families.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="next_link_python">
<a href="#next_link_python" style="color: inherit; text-decoration: inherit;">next_<wbr>link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Link for the next set of product families.{{% /md %}}</dd></dl>
{{% /choosable %}}




## Supporting Types


<h4 id="availabilityinformationresponse">Availability<wbr>Information<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilitystage_csharp">
<a href="#availabilitystage_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Current availability stage of the product. Availability stage{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreason_csharp">
<a href="#disabledreason_csharp" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Reason why the product is disabled.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreasonmessage_csharp">
<a href="#disabledreasonmessage_csharp" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason<wbr>Message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Message for why the product is disabled.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilitystage_go">
<a href="#availabilitystage_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Current availability stage of the product. Availability stage{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreason_go">
<a href="#disabledreason_go" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Reason why the product is disabled.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreasonmessage_go">
<a href="#disabledreasonmessage_go" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason<wbr>Message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Message for why the product is disabled.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilitystage_nodejs">
<a href="#availabilitystage_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Current availability stage of the product. Availability stage{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreason_nodejs">
<a href="#disabledreason_nodejs" style="color: inherit; text-decoration: inherit;">disabled<wbr>Reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Reason why the product is disabled.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabledreasonmessage_nodejs">
<a href="#disabledreasonmessage_nodejs" style="color: inherit; text-decoration: inherit;">disabled<wbr>Reason<wbr>Message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Message for why the product is disabled.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_stage_python">
<a href="#availability_stage_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Current availability stage of the product. Availability stage{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabled_reason_python">
<a href="#disabled_reason_python" style="color: inherit; text-decoration: inherit;">disabled_<wbr>reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Reason why the product is disabled.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="disabled_reason_message_python">
<a href="#disabled_reason_message_python" style="color: inherit; text-decoration: inherit;">disabled_<wbr>reason_<wbr>message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Message for why the product is disabled.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="billingmeterdetailsresponse">Billing<wbr>Meter<wbr>Details<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_csharp">
<a href="#frequency_csharp" style="color: inherit; text-decoration: inherit;">Frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Frequency of recurrence{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterdetails_csharp">
<a href="#meterdetails_csharp" style="color: inherit; text-decoration: inherit;">Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Represents MeterDetails{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meteringtype_csharp">
<a href="#meteringtype_csharp" style="color: inherit; text-decoration: inherit;">Metering<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Metering type (eg one-time or recurrent){{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="name_csharp">
<a href="#name_csharp" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Billing type name{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_go">
<a href="#frequency_go" style="color: inherit; text-decoration: inherit;">Frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Frequency of recurrence{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterdetails_go">
<a href="#meterdetails_go" style="color: inherit; text-decoration: inherit;">Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Represents MeterDetails{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meteringtype_go">
<a href="#meteringtype_go" style="color: inherit; text-decoration: inherit;">Metering<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Metering type (eg one-time or recurrent){{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="name_go">
<a href="#name_go" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Billing type name{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_nodejs">
<a href="#frequency_nodejs" style="color: inherit; text-decoration: inherit;">frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Frequency of recurrence{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterdetails_nodejs">
<a href="#meterdetails_nodejs" style="color: inherit; text-decoration: inherit;">meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Represents MeterDetails{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meteringtype_nodejs">
<a href="#meteringtype_nodejs" style="color: inherit; text-decoration: inherit;">metering<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Metering type (eg one-time or recurrent){{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="name_nodejs">
<a href="#name_nodejs" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents Billing type name{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_python">
<a href="#frequency_python" style="color: inherit; text-decoration: inherit;">frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Frequency of recurrence{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meter_details_python">
<a href="#meter_details_python" style="color: inherit; text-decoration: inherit;">meter_<wbr>details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Represents MeterDetails{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="metering_type_python">
<a href="#metering_type_python" style="color: inherit; text-decoration: inherit;">metering_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents Metering type (eg one-time or recurrent){{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="name_python">
<a href="#name_python" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents Billing type name{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="configurationresponse">Configuration<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_csharp">
<a href="#availabilityinformation_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_csharp">
<a href="#costinformation_csharp" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_csharp">
<a href="#description_csharp" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_csharp">
<a href="#dimensions_csharp" style="color: inherit; text-decoration: inherit;">Dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Dimensions of the configuration{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_csharp">
<a href="#displayname_csharp" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_csharp">
<a href="#filterableproperties_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List&lt;Filterable<wbr>Property<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_csharp">
<a href="#hierarchyinformation_csharp" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_csharp">
<a href="#imageinformation_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List&lt;Image<wbr>Information<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="specifications_csharp">
<a href="#specifications_csharp" style="color: inherit; text-decoration: inherit;">Specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">List&lt;Specification<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}Specifications of the configuration{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_go">
<a href="#availabilityinformation_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_go">
<a href="#costinformation_go" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_go">
<a href="#description_go" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_go">
<a href="#dimensions_go" style="color: inherit; text-decoration: inherit;">Dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Dimensions of the configuration{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_go">
<a href="#displayname_go" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_go">
<a href="#filterableproperties_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">[]Filterable<wbr>Property<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_go">
<a href="#hierarchyinformation_go" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_go">
<a href="#imageinformation_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">[]Image<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="specifications_go">
<a href="#specifications_go" style="color: inherit; text-decoration: inherit;">Specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">[]Specification<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Specifications of the configuration{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_nodejs">
<a href="#availabilityinformation_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_nodejs">
<a href="#costinformation_nodejs" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_nodejs">
<a href="#description_nodejs" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_nodejs">
<a href="#dimensions_nodejs" style="color: inherit; text-decoration: inherit;">dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Dimensions of the configuration{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_nodejs">
<a href="#displayname_nodejs" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_nodejs">
<a href="#filterableproperties_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Filterable<wbr>Property<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_nodejs">
<a href="#hierarchyinformation_nodejs" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_nodejs">
<a href="#imageinformation_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Image<wbr>Information<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="specifications_nodejs">
<a href="#specifications_nodejs" style="color: inherit; text-decoration: inherit;">specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">Specification<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}Specifications of the configuration{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_information_python">
<a href="#availability_information_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="cost_information_python">
<a href="#cost_information_python" style="color: inherit; text-decoration: inherit;">cost_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_python">
<a href="#description_python" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_python">
<a href="#dimensions_python" style="color: inherit; text-decoration: inherit;">dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Dimensions of the configuration{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="display_name_python">
<a href="#display_name_python" style="color: inherit; text-decoration: inherit;">display_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterable_properties_python">
<a href="#filterable_properties_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Sequence[Filterable<wbr>Property<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchy_information_python">
<a href="#hierarchy_information_python" style="color: inherit; text-decoration: inherit;">hierarchy_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="image_information_python">
<a href="#image_information_python" style="color: inherit; text-decoration: inherit;">image_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Sequence[Image<wbr>Information<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="specifications_python">
<a href="#specifications_python" style="color: inherit; text-decoration: inherit;">specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">Sequence[Specification<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}Specifications of the configuration{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="costinformationresponse">Cost<wbr>Information<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billinginfourl_csharp">
<a href="#billinginfourl_csharp" style="color: inherit; text-decoration: inherit;">Billing<wbr>Info<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Default url to display billing information{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="billingmeterdetails_csharp">
<a href="#billingmeterdetails_csharp" style="color: inherit; text-decoration: inherit;">Billing<wbr>Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">List&lt;Billing<wbr>Meter<wbr>Details<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}Details on the various billing aspects for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billinginfourl_go">
<a href="#billinginfourl_go" style="color: inherit; text-decoration: inherit;">Billing<wbr>Info<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Default url to display billing information{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="billingmeterdetails_go">
<a href="#billingmeterdetails_go" style="color: inherit; text-decoration: inherit;">Billing<wbr>Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">[]Billing<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Details on the various billing aspects for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billinginfourl_nodejs">
<a href="#billinginfourl_nodejs" style="color: inherit; text-decoration: inherit;">billing<wbr>Info<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Default url to display billing information{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="billingmeterdetails_nodejs">
<a href="#billingmeterdetails_nodejs" style="color: inherit; text-decoration: inherit;">billing<wbr>Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">Billing<wbr>Meter<wbr>Details<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}Details on the various billing aspects for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billing_info_url_python">
<a href="#billing_info_url_python" style="color: inherit; text-decoration: inherit;">billing_<wbr>info_<wbr>url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Default url to display billing information{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="billing_meter_details_python">
<a href="#billing_meter_details_python" style="color: inherit; text-decoration: inherit;">billing_<wbr>meter_<wbr>details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">Sequence[Billing<wbr>Meter<wbr>Details<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}Details on the various billing aspects for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quotaid_csharp">
<a href="#quotaid_csharp" style="color: inherit; text-decoration: inherit;">Quota<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Quota ID of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="locationplacementid_csharp">
<a href="#locationplacementid_csharp" style="color: inherit; text-decoration: inherit;">Location<wbr>Placement<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Location placement Id of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="registeredfeatures_csharp">
<a href="#registeredfeatures_csharp" style="color: inherit; text-decoration: inherit;">Registered<wbr>Features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">List&lt;Customer<wbr>Subscription<wbr>Registered<wbr>Features&gt;</a></span>
    </dt>
    <dd>{{% md %}}List of registered feature flags for subscription{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quotaid_go">
<a href="#quotaid_go" style="color: inherit; text-decoration: inherit;">Quota<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Quota ID of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="locationplacementid_go">
<a href="#locationplacementid_go" style="color: inherit; text-decoration: inherit;">Location<wbr>Placement<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Location placement Id of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="registeredfeatures_go">
<a href="#registeredfeatures_go" style="color: inherit; text-decoration: inherit;">Registered<wbr>Features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">[]Customer<wbr>Subscription<wbr>Registered<wbr>Features</a></span>
    </dt>
    <dd>{{% md %}}List of registered feature flags for subscription{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quotaid_nodejs">
<a href="#quotaid_nodejs" style="color: inherit; text-decoration: inherit;">quota<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Quota ID of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="locationplacementid_nodejs">
<a href="#locationplacementid_nodejs" style="color: inherit; text-decoration: inherit;">location<wbr>Placement<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Location placement Id of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="registeredfeatures_nodejs">
<a href="#registeredfeatures_nodejs" style="color: inherit; text-decoration: inherit;">registered<wbr>Features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">Customer<wbr>Subscription<wbr>Registered<wbr>Features[]</a></span>
    </dt>
    <dd>{{% md %}}List of registered feature flags for subscription{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quota_id_python">
<a href="#quota_id_python" style="color: inherit; text-decoration: inherit;">quota_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Quota ID of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="location_placement_id_python">
<a href="#location_placement_id_python" style="color: inherit; text-decoration: inherit;">location_<wbr>placement_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Location placement Id of a subscription{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="registered_features_python">
<a href="#registered_features_python" style="color: inherit; text-decoration: inherit;">registered_<wbr>features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">Sequence[Customer<wbr>Subscription<wbr>Registered<wbr>Features]</a></span>
    </dt>
    <dd>{{% md %}}List of registered feature flags for subscription{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="customersubscriptionregisteredfeatures">Customer<wbr>Subscription<wbr>Registered<wbr>Features</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_csharp">
<a href="#name_csharp" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of subscription registered feature{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="state_csharp">
<a href="#state_csharp" style="color: inherit; text-decoration: inherit;">State</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}State of subscription registered feature{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_go">
<a href="#name_go" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of subscription registered feature{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="state_go">
<a href="#state_go" style="color: inherit; text-decoration: inherit;">State</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}State of subscription registered feature{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_nodejs">
<a href="#name_nodejs" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of subscription registered feature{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="state_nodejs">
<a href="#state_nodejs" style="color: inherit; text-decoration: inherit;">state</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}State of subscription registered feature{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_python">
<a href="#name_python" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Name of subscription registered feature{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="state_python">
<a href="#state_python" style="color: inherit; text-decoration: inherit;">state</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}State of subscription registered feature{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="descriptionresponse">Description<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_csharp">
<a href="#attributes_csharp" style="color: inherit; text-decoration: inherit;">Attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd>{{% md %}}Attributes for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="descriptiontype_csharp">
<a href="#descriptiontype_csharp" style="color: inherit; text-decoration: inherit;">Description<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of description.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="keywords_csharp">
<a href="#keywords_csharp" style="color: inherit; text-decoration: inherit;">Keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd>{{% md %}}Keywords for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="links_csharp">
<a href="#links_csharp" style="color: inherit; text-decoration: inherit;">Links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">List&lt;Link<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}Links for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="longdescription_csharp">
<a href="#longdescription_csharp" style="color: inherit; text-decoration: inherit;">Long<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Long description of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="shortdescription_csharp">
<a href="#shortdescription_csharp" style="color: inherit; text-decoration: inherit;">Short<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Short description of the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_go">
<a href="#attributes_go" style="color: inherit; text-decoration: inherit;">Attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd>{{% md %}}Attributes for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="descriptiontype_go">
<a href="#descriptiontype_go" style="color: inherit; text-decoration: inherit;">Description<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of description.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="keywords_go">
<a href="#keywords_go" style="color: inherit; text-decoration: inherit;">Keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd>{{% md %}}Keywords for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="links_go">
<a href="#links_go" style="color: inherit; text-decoration: inherit;">Links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">[]Link<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Links for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="longdescription_go">
<a href="#longdescription_go" style="color: inherit; text-decoration: inherit;">Long<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Long description of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="shortdescription_go">
<a href="#shortdescription_go" style="color: inherit; text-decoration: inherit;">Short<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Short description of the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_nodejs">
<a href="#attributes_nodejs" style="color: inherit; text-decoration: inherit;">attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd>{{% md %}}Attributes for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="descriptiontype_nodejs">
<a href="#descriptiontype_nodejs" style="color: inherit; text-decoration: inherit;">description<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of description.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="keywords_nodejs">
<a href="#keywords_nodejs" style="color: inherit; text-decoration: inherit;">keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd>{{% md %}}Keywords for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="links_nodejs">
<a href="#links_nodejs" style="color: inherit; text-decoration: inherit;">links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">Link<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}Links for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="longdescription_nodejs">
<a href="#longdescription_nodejs" style="color: inherit; text-decoration: inherit;">long<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Long description of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="shortdescription_nodejs">
<a href="#shortdescription_nodejs" style="color: inherit; text-decoration: inherit;">short<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Short description of the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_python">
<a href="#attributes_python" style="color: inherit; text-decoration: inherit;">attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd>{{% md %}}Attributes for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_type_python">
<a href="#description_type_python" style="color: inherit; text-decoration: inherit;">description_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Type of description.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="keywords_python">
<a href="#keywords_python" style="color: inherit; text-decoration: inherit;">keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd>{{% md %}}Keywords for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="links_python">
<a href="#links_python" style="color: inherit; text-decoration: inherit;">links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">Sequence[Link<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}Links for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="long_description_python">
<a href="#long_description_python" style="color: inherit; text-decoration: inherit;">long_<wbr>description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Long description of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="short_description_python">
<a href="#short_description_python" style="color: inherit; text-decoration: inherit;">short_<wbr>description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Short description of the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="dimensionsresponse">Dimensions<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_csharp">
<a href="#depth_csharp" style="color: inherit; text-decoration: inherit;">Depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Depth of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="height_csharp">
<a href="#height_csharp" style="color: inherit; text-decoration: inherit;">Height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Height of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="length_csharp">
<a href="#length_csharp" style="color: inherit; text-decoration: inherit;">Length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Length of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="lengthheightunit_csharp">
<a href="#lengthheightunit_csharp" style="color: inherit; text-decoration: inherit;">Length<wbr>Height<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of length, height and width.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weight_csharp">
<a href="#weight_csharp" style="color: inherit; text-decoration: inherit;">Weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Weight of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weightunit_csharp">
<a href="#weightunit_csharp" style="color: inherit; text-decoration: inherit;">Weight<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of weight.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="width_csharp">
<a href="#width_csharp" style="color: inherit; text-decoration: inherit;">Width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Width of the device.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_go">
<a href="#depth_go" style="color: inherit; text-decoration: inherit;">Depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Depth of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="height_go">
<a href="#height_go" style="color: inherit; text-decoration: inherit;">Height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Height of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="length_go">
<a href="#length_go" style="color: inherit; text-decoration: inherit;">Length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Length of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="lengthheightunit_go">
<a href="#lengthheightunit_go" style="color: inherit; text-decoration: inherit;">Length<wbr>Height<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of length, height and width.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weight_go">
<a href="#weight_go" style="color: inherit; text-decoration: inherit;">Weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Weight of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weightunit_go">
<a href="#weightunit_go" style="color: inherit; text-decoration: inherit;">Weight<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of weight.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="width_go">
<a href="#width_go" style="color: inherit; text-decoration: inherit;">Width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Width of the device.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_nodejs">
<a href="#depth_nodejs" style="color: inherit; text-decoration: inherit;">depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Depth of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="height_nodejs">
<a href="#height_nodejs" style="color: inherit; text-decoration: inherit;">height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Height of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="length_nodejs">
<a href="#length_nodejs" style="color: inherit; text-decoration: inherit;">length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Length of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="lengthheightunit_nodejs">
<a href="#lengthheightunit_nodejs" style="color: inherit; text-decoration: inherit;">length<wbr>Height<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of length, height and width.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weight_nodejs">
<a href="#weight_nodejs" style="color: inherit; text-decoration: inherit;">weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Weight of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weightunit_nodejs">
<a href="#weightunit_nodejs" style="color: inherit; text-decoration: inherit;">weight<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of weight.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="width_nodejs">
<a href="#width_nodejs" style="color: inherit; text-decoration: inherit;">width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Width of the device.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_python">
<a href="#depth_python" style="color: inherit; text-decoration: inherit;">depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Depth of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="height_python">
<a href="#height_python" style="color: inherit; text-decoration: inherit;">height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Height of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="length_python">
<a href="#length_python" style="color: inherit; text-decoration: inherit;">length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Length of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="length_height_unit_python">
<a href="#length_height_unit_python" style="color: inherit; text-decoration: inherit;">length_<wbr>height_<wbr>unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of length, height and width.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weight_python">
<a href="#weight_python" style="color: inherit; text-decoration: inherit;">weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Weight of the device.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="weight_unit_python">
<a href="#weight_unit_python" style="color: inherit; text-decoration: inherit;">weight_<wbr>unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Unit for the dimensions of weight.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="width_python">
<a href="#width_python" style="color: inherit; text-decoration: inherit;">width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Width of the device.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="filterableproperty">Filterable<wbr>Property</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_csharp">
<a href="#supportedvalues_csharp" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_csharp">
<a href="#type_csharp" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string | <a href="#supportedfiltertypes">Pulumi.<wbr>Myedgeorder.<wbr>Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_go">
<a href="#supportedvalues_go" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_go">
<a href="#type_go" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string | <a href="#supportedfiltertypes">Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_nodejs">
<a href="#supportedvalues_nodejs" style="color: inherit; text-decoration: inherit;">supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_nodejs">
<a href="#type_nodejs" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string | <a href="#supportedfiltertypes">Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supported_values_python">
<a href="#supported_values_python" style="color: inherit; text-decoration: inherit;">supported_<wbr>values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_python">
<a href="#type_python" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str | <a href="#supportedfiltertypes">Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="filterablepropertyresponse">Filterable<wbr>Property<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_csharp">
<a href="#supportedvalues_csharp" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_csharp">
<a href="#type_csharp" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_go">
<a href="#supportedvalues_go" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_go">
<a href="#type_go" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_nodejs">
<a href="#supportedvalues_nodejs" style="color: inherit; text-decoration: inherit;">supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_nodejs">
<a href="#type_nodejs" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supported_values_python">
<a href="#supported_values_python" style="color: inherit; text-decoration: inherit;">supported_<wbr>values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd>{{% md %}}Values to be filtered.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="type_python">
<a href="#type_python" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Type of product filter.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_csharp">
<a href="#configurationname_csharp" style="color: inherit; text-decoration: inherit;">Configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_csharp">
<a href="#productfamilyname_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_csharp">
<a href="#productlinename_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_csharp">
<a href="#productname_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_go">
<a href="#configurationname_go" style="color: inherit; text-decoration: inherit;">Configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_go">
<a href="#productfamilyname_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_go">
<a href="#productlinename_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_go">
<a href="#productname_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_nodejs">
<a href="#configurationname_nodejs" style="color: inherit; text-decoration: inherit;">configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_nodejs">
<a href="#productfamilyname_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_nodejs">
<a href="#productlinename_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_nodejs">
<a href="#productname_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configuration_name_python">
<a href="#configuration_name_python" style="color: inherit; text-decoration: inherit;">configuration_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents configuration name that uniquely identifies configuration{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="product_family_name_python">
<a href="#product_family_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>family_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents product family name that uniquely identifies product family{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="product_line_name_python">
<a href="#product_line_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>line_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents product line name that uniquely identifies product line{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="product_name_python">
<a href="#product_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Represents product name that uniquely identifies product{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="imageinformationresponse">Image<wbr>Information<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="imagetype_csharp">
<a href="#imagetype_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of the image{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageurl_csharp">
<a href="#imageurl_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the image{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="imagetype_go">
<a href="#imagetype_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of the image{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageurl_go">
<a href="#imageurl_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the image{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="imagetype_nodejs">
<a href="#imagetype_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of the image{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageurl_nodejs">
<a href="#imageurl_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the image{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="image_type_python">
<a href="#image_type_python" style="color: inherit; text-decoration: inherit;">image_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Type of the image{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="image_url_python">
<a href="#image_url_python" style="color: inherit; text-decoration: inherit;">image_<wbr>url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Url of the image{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="linkresponse">Link<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="linktype_csharp">
<a href="#linktype_csharp" style="color: inherit; text-decoration: inherit;">Link<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of link{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="linkurl_csharp">
<a href="#linkurl_csharp" style="color: inherit; text-decoration: inherit;">Link<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the link{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="linktype_go">
<a href="#linktype_go" style="color: inherit; text-decoration: inherit;">Link<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of link{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="linkurl_go">
<a href="#linkurl_go" style="color: inherit; text-decoration: inherit;">Link<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the link{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="linktype_nodejs">
<a href="#linktype_nodejs" style="color: inherit; text-decoration: inherit;">link<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Type of link{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="linkurl_nodejs">
<a href="#linkurl_nodejs" style="color: inherit; text-decoration: inherit;">link<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Url of the link{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="link_type_python">
<a href="#link_type_python" style="color: inherit; text-decoration: inherit;">link_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Type of link{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="link_url_python">
<a href="#link_url_python" style="color: inherit; text-decoration: inherit;">link_<wbr>url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Url of the link{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_csharp">
<a href="#chargingtype_csharp" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterguid_csharp">
<a href="#meterguid_csharp" style="color: inherit; text-decoration: inherit;">Meter<wbr>Guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Validation status of requested data center and transport.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_csharp">
<a href="#multiplier_csharp" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_go">
<a href="#chargingtype_go" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterguid_go">
<a href="#meterguid_go" style="color: inherit; text-decoration: inherit;">Meter<wbr>Guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Validation status of requested data center and transport.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_go">
<a href="#multiplier_go" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_nodejs">
<a href="#chargingtype_nodejs" style="color: inherit; text-decoration: inherit;">charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meterguid_nodejs">
<a href="#meterguid_nodejs" style="color: inherit; text-decoration: inherit;">meter<wbr>Guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Validation status of requested data center and transport.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_nodejs">
<a href="#multiplier_nodejs" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="charging_type_python">
<a href="#charging_type_python" style="color: inherit; text-decoration: inherit;">charging_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="meter_guid_python">
<a href="#meter_guid_python" style="color: inherit; text-decoration: inherit;">meter_<wbr>guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Validation status of requested data center and transport.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_python">
<a href="#multiplier_python" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="productfamilyresponse">Product<wbr>Family<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_csharp">
<a href="#availabilityinformation_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_csharp">
<a href="#costinformation_csharp" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_csharp">
<a href="#description_csharp" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_csharp">
<a href="#displayname_csharp" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_csharp">
<a href="#filterableproperties_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List&lt;Filterable<wbr>Property<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_csharp">
<a href="#hierarchyinformation_csharp" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_csharp">
<a href="#imageinformation_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List&lt;Image<wbr>Information<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="productlines_csharp">
<a href="#productlines_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Lines</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productlineresponse">List&lt;Product<wbr>Line<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}List of product lines supported in the product family{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_go">
<a href="#availabilityinformation_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_go">
<a href="#costinformation_go" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_go">
<a href="#description_go" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_go">
<a href="#displayname_go" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_go">
<a href="#filterableproperties_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">[]Filterable<wbr>Property<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_go">
<a href="#hierarchyinformation_go" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_go">
<a href="#imageinformation_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">[]Image<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="productlines_go">
<a href="#productlines_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Lines</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productlineresponse">[]Product<wbr>Line<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}List of product lines supported in the product family{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_nodejs">
<a href="#availabilityinformation_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_nodejs">
<a href="#costinformation_nodejs" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_nodejs">
<a href="#description_nodejs" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_nodejs">
<a href="#displayname_nodejs" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_nodejs">
<a href="#filterableproperties_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Filterable<wbr>Property<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_nodejs">
<a href="#hierarchyinformation_nodejs" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_nodejs">
<a href="#imageinformation_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Image<wbr>Information<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="productlines_nodejs">
<a href="#productlines_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Lines</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productlineresponse">Product<wbr>Line<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}List of product lines supported in the product family{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_information_python">
<a href="#availability_information_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="cost_information_python">
<a href="#cost_information_python" style="color: inherit; text-decoration: inherit;">cost_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_python">
<a href="#description_python" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="display_name_python">
<a href="#display_name_python" style="color: inherit; text-decoration: inherit;">display_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterable_properties_python">
<a href="#filterable_properties_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Sequence[Filterable<wbr>Property<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchy_information_python">
<a href="#hierarchy_information_python" style="color: inherit; text-decoration: inherit;">hierarchy_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="image_information_python">
<a href="#image_information_python" style="color: inherit; text-decoration: inherit;">image_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Sequence[Image<wbr>Information<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="product_lines_python">
<a href="#product_lines_python" style="color: inherit; text-decoration: inherit;">product_<wbr>lines</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productlineresponse">Sequence[Product<wbr>Line<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}List of product lines supported in the product family{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="productlineresponse">Product<wbr>Line<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_csharp">
<a href="#availabilityinformation_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_csharp">
<a href="#costinformation_csharp" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_csharp">
<a href="#description_csharp" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_csharp">
<a href="#displayname_csharp" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_csharp">
<a href="#filterableproperties_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List&lt;Filterable<wbr>Property<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_csharp">
<a href="#hierarchyinformation_csharp" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_csharp">
<a href="#imageinformation_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List&lt;Image<wbr>Information<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="products_csharp">
<a href="#products_csharp" style="color: inherit; text-decoration: inherit;">Products</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productresponse">List&lt;Product<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}List of products in the product line{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_go">
<a href="#availabilityinformation_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_go">
<a href="#costinformation_go" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_go">
<a href="#description_go" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_go">
<a href="#displayname_go" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_go">
<a href="#filterableproperties_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">[]Filterable<wbr>Property<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_go">
<a href="#hierarchyinformation_go" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_go">
<a href="#imageinformation_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">[]Image<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="products_go">
<a href="#products_go" style="color: inherit; text-decoration: inherit;">Products</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productresponse">[]Product<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}List of products in the product line{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_nodejs">
<a href="#availabilityinformation_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_nodejs">
<a href="#costinformation_nodejs" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_nodejs">
<a href="#description_nodejs" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_nodejs">
<a href="#displayname_nodejs" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_nodejs">
<a href="#filterableproperties_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Filterable<wbr>Property<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_nodejs">
<a href="#hierarchyinformation_nodejs" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_nodejs">
<a href="#imageinformation_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Image<wbr>Information<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="products_nodejs">
<a href="#products_nodejs" style="color: inherit; text-decoration: inherit;">products</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productresponse">Product<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}List of products in the product line{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_information_python">
<a href="#availability_information_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="cost_information_python">
<a href="#cost_information_python" style="color: inherit; text-decoration: inherit;">cost_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_python">
<a href="#description_python" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="display_name_python">
<a href="#display_name_python" style="color: inherit; text-decoration: inherit;">display_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterable_properties_python">
<a href="#filterable_properties_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Sequence[Filterable<wbr>Property<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchy_information_python">
<a href="#hierarchy_information_python" style="color: inherit; text-decoration: inherit;">hierarchy_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="image_information_python">
<a href="#image_information_python" style="color: inherit; text-decoration: inherit;">image_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Sequence[Image<wbr>Information<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="products_python">
<a href="#products_python" style="color: inherit; text-decoration: inherit;">products</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productresponse">Sequence[Product<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}List of products in the product line{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="productresponse">Product<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_csharp">
<a href="#availabilityinformation_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="configurations_csharp">
<a href="#configurations_csharp" style="color: inherit; text-decoration: inherit;">Configurations</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">List&lt;Configuration<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}List of configurations for the product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_csharp">
<a href="#costinformation_csharp" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_csharp">
<a href="#description_csharp" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_csharp">
<a href="#displayname_csharp" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_csharp">
<a href="#filterableproperties_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List&lt;Filterable<wbr>Property<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_csharp">
<a href="#hierarchyinformation_csharp" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_csharp">
<a href="#imageinformation_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List&lt;Image<wbr>Information<wbr>Response&gt;</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_go">
<a href="#availabilityinformation_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="configurations_go">
<a href="#configurations_go" style="color: inherit; text-decoration: inherit;">Configurations</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">[]Configuration<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}List of configurations for the product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_go">
<a href="#costinformation_go" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_go">
<a href="#description_go" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_go">
<a href="#displayname_go" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_go">
<a href="#filterableproperties_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">[]Filterable<wbr>Property<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_go">
<a href="#hierarchyinformation_go" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_go">
<a href="#imageinformation_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">[]Image<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_nodejs">
<a href="#availabilityinformation_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="configurations_nodejs">
<a href="#configurations_nodejs" style="color: inherit; text-decoration: inherit;">configurations</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">Configuration<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}List of configurations for the product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_nodejs">
<a href="#costinformation_nodejs" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_nodejs">
<a href="#description_nodejs" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="displayname_nodejs">
<a href="#displayname_nodejs" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_nodejs">
<a href="#filterableproperties_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Filterable<wbr>Property<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_nodejs">
<a href="#hierarchyinformation_nodejs" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_nodejs">
<a href="#imageinformation_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Image<wbr>Information<wbr>Response[]</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_information_python">
<a href="#availability_information_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Availability information of the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="configurations_python">
<a href="#configurations_python" style="color: inherit; text-decoration: inherit;">configurations</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">Sequence[Configuration<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}List of configurations for the product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="cost_information_python">
<a href="#cost_information_python" style="color: inherit; text-decoration: inherit;">cost_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Cost information for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="description_python">
<a href="#description_python" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Description related to the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="display_name_python">
<a href="#display_name_python" style="color: inherit; text-decoration: inherit;">display_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Display Name for the product system.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="filterable_properties_python">
<a href="#filterable_properties_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Sequence[Filterable<wbr>Property<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}list of filters supported for a product{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="hierarchy_information_python">
<a href="#hierarchy_information_python" style="color: inherit; text-decoration: inherit;">hierarchy_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}Hierarchy information of a product.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="image_information_python">
<a href="#image_information_python" style="color: inherit; text-decoration: inherit;">image_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Sequence[Image<wbr>Information<wbr>Response]</a></span>
    </dt>
    <dd>{{% md %}}Image information for the product system.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_csharp">
<a href="#chargingtype_csharp" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_csharp">
<a href="#multiplier_csharp" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="productid_csharp">
<a href="#productid_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Product Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="skuid_csharp">
<a href="#skuid_csharp" style="color: inherit; text-decoration: inherit;">Sku<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Sku Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="termid_csharp">
<a href="#termid_csharp" style="color: inherit; text-decoration: inherit;">Term<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Term Id{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_go">
<a href="#chargingtype_go" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_go">
<a href="#multiplier_go" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="productid_go">
<a href="#productid_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Product Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="skuid_go">
<a href="#skuid_go" style="color: inherit; text-decoration: inherit;">Sku<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Sku Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="termid_go">
<a href="#termid_go" style="color: inherit; text-decoration: inherit;">Term<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Term Id{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_nodejs">
<a href="#chargingtype_nodejs" style="color: inherit; text-decoration: inherit;">charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_nodejs">
<a href="#multiplier_nodejs" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="productid_nodejs">
<a href="#productid_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Product Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="skuid_nodejs">
<a href="#skuid_nodejs" style="color: inherit; text-decoration: inherit;">sku<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Sku Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="termid_nodejs">
<a href="#termid_nodejs" style="color: inherit; text-decoration: inherit;">term<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Term Id{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="charging_type_python">
<a href="#charging_type_python" style="color: inherit; text-decoration: inherit;">charging_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Charging type.{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_python">
<a href="#multiplier_python" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd>{{% md %}}Billing unit applicable for Pav2 billing{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="product_id_python">
<a href="#product_id_python" style="color: inherit; text-decoration: inherit;">product_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Product Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="sku_id_python">
<a href="#sku_id_python" style="color: inherit; text-decoration: inherit;">sku_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Sku Id{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="term_id_python">
<a href="#term_id_python" style="color: inherit; text-decoration: inherit;">term_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Term Id{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="specificationresponse">Specification<wbr>Response</h4>



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_csharp">
<a href="#name_csharp" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of the specification{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="value_csharp">
<a href="#value_csharp" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Value of the specification{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_go">
<a href="#name_go" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of the specification{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="value_go">
<a href="#value_go" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Value of the specification{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_nodejs">
<a href="#name_nodejs" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Name of the specification{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="value_nodejs">
<a href="#value_nodejs" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Value of the specification{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_python">
<a href="#name_python" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Name of the specification{{% /md %}}</dd><dt class="property-required"
            title="Required">
        <span id="value_python">
<a href="#value_python" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Value of the specification{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="supportedfiltertypes">Supported<wbr>Filter<wbr>Types</h4>







<h2 id="package-details">Package Details</h2>
<dl class="package-details">
	<dt>Repository</dt>
	<dd><a href=""></a></dd>
	<dt>License</dt>
	<dd></dd>
</dl>

