
---
title: "Nursery"
title_tag: "plant.tree/v1.Nursery"
meta_desc: "Documentation for the plant.tree/v1.Nursery resource with examples, input properties, output properties, lookup functions, and supporting types."
layout: api
no_edit_this_page: true
---



<!-- WARNING: this file was generated by test. -->
<!-- Do not edit by hand unless you're certain you know what you are doing! -->




## Create a Nursery Resource {#create}
{{< chooser language "typescript,python,go,csharp" / >}}


{{% choosable language nodejs %}}
<div class="highlight"><pre class="chroma"><code class="language-typescript" data-lang="typescript"><span class="k">new </span><span class="nx">Nursery</span><span class="p">(</span><span class="nx">name</span><span class="p">:</span> <span class="nx">string</span><span class="p">,</span> <span class="nx">args</span><span class="p">:</span> <span class="nx"><a href="#inputs">NurseryArgs</a></span><span class="p">,</span> <span class="nx">opts</span><span class="p">?:</span> <span class="nx"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#CustomResourceOptions">CustomResourceOptions</a></span><span class="p">);</span></code></pre></div>
{{% /choosable %}}

{{% choosable language python %}}
<div class="highlight"><pre class="chroma"><code class="language-python" data-lang="python"><span class=nd>@overload</span>
<span class="k">def </span><span class="nx">Nursery</span><span class="p">(</span><span class="nx">resource_name</span><span class="p">:</span> <span class="nx">str</span><span class="p">,</span>
            <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.ResourceOptions">Optional[ResourceOptions]</a></span> = None<span class="p">,</span>
            <span class="nx">sizes</span><span class="p">:</span> <span class="nx">Optional[Mapping[str, TreeSize]]</span> = None<span class="p">,</span>
            <span class="nx">varieties</span><span class="p">:</span> <span class="nx">Optional[Sequence[RubberTreeVariety]]</span> = None<span class="p">)</span>
<span class=nd>@overload</span>
<span class="k">def </span><span class="nx">Nursery</span><span class="p">(</span><span class="nx">resource_name</span><span class="p">:</span> <span class="nx">str</span><span class="p">,</span>
            <span class="nx">args</span><span class="p">:</span> <span class="nx"><a href="#inputs">NurseryArgs</a></span><span class="p">,</span>
            <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.ResourceOptions">Optional[ResourceOptions]</a></span> = None<span class="p">)</span></code></pre></div>
{{% /choosable %}}

{{% choosable language go %}}
<div class="highlight"><pre class="chroma"><code class="language-go" data-lang="go"><span class="k">func </span><span class="nx">NewNursery</span><span class="p">(</span><span class="nx">ctx</span><span class="p"> *</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span><span class="p">,</span> <span class="nx">name</span><span class="p"> </span><span class="nx">string</span><span class="p">,</span> <span class="nx">args</span><span class="p"> </span><span class="nx"><a href="#inputs">NurseryArgs</a></span><span class="p">,</span> <span class="nx">opts</span><span class="p"> ...</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#ResourceOption">ResourceOption</a></span><span class="p">) (*<span class="nx">Nursery</span>, error)</span></code></pre></div>
{{% /choosable %}}

{{% choosable language csharp %}}
<div class="highlight"><pre class="chroma"><code class="language-csharp" data-lang="csharp"><span class="k">public </span><span class="nx">Nursery</span><span class="p">(</span><span class="nx">string</span><span class="p"> </span><span class="nx">name<span class="p">,</span> <span class="nx"><a href="#inputs">NurseryArgs</a></span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.CustomResourceOptions.html">CustomResourceOptions</a></span><span class="p">? </span><span class="nx">opts = null<span class="p">)</span></code></pre></div>
{{% /choosable %}}

{{% choosable language nodejs %}}

<dl class="resources-properties"><dt
        class="property-required" title="Required">
        <span>name</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-required" title="Required">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">NurseryArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#CustomResourceOptions">CustomResourceOptions</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

{{% /choosable %}}

{{% choosable language python %}}

<dl class="resources-properties"><dt
        class="property-required" title="Required">
        <span>resource_name</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-required" title="Required">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">NurseryArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="/docs/reference/pkg/python/pulumi/#pulumi.ResourceOptions">ResourceOptions</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

{{% /choosable %}}

{{% choosable language go %}}

<dl class="resources-properties"><dt
        class="property-optional" title="Optional">
        <span>ctx</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span>
    </dt>
    <dd>Context object for the current deployment.</dd><dt
        class="property-required" title="Required">
        <span>name</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-required" title="Required">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">NurseryArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#ResourceOption">ResourceOption</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

{{% /choosable %}}

{{% choosable language csharp %}}

<dl class="resources-properties"><dt
        class="property-required" title="Required">
        <span>name</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-required" title="Required">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">NurseryArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.CustomResourceOptions.html">CustomResourceOptions</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

{{% /choosable %}}

## Nursery Resource Properties {#properties}

To learn more about resource properties and how to use them, see [Inputs and Outputs]({{< relref "/docs/intro/concepts/inputs-outputs" >}}) in the Architecture and Concepts docs.

### Inputs

The Nursery resource accepts the following [input]({{< relref "/docs/intro/concepts/inputs-outputs" >}}) properties:



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="varieties_csharp">
<a href="#varieties_csharp" style="color: inherit; text-decoration: inherit;">Varieties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#rubbertreevariety">List&lt;Pulumi.<wbr>Plant.<wbr>Tree.<wbr>V1.<wbr>Rubber<wbr>Tree<wbr>Variety&gt;</a></span>
    </dt>
    <dd>{{% md %}}The varieties available{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="sizes_csharp">
<a href="#sizes_csharp" style="color: inherit; text-decoration: inherit;">Sizes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Dictionary&lt;string, Pulumi.<wbr>Plant.<wbr>Tree.<wbr>V1.<wbr>Tree<wbr>Size&gt;</span>
    </dt>
    <dd>{{% md %}}The sizes of trees available{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="varieties_go">
<a href="#varieties_go" style="color: inherit; text-decoration: inherit;">Varieties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#rubbertreevariety">[]Rubber<wbr>Tree<wbr>Variety</a></span>
    </dt>
    <dd>{{% md %}}The varieties available{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="sizes_go">
<a href="#sizes_go" style="color: inherit; text-decoration: inherit;">Sizes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">map[string]Tree<wbr>Size</span>
    </dt>
    <dd>{{% md %}}The sizes of trees available{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="varieties_nodejs">
<a href="#varieties_nodejs" style="color: inherit; text-decoration: inherit;">varieties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#rubbertreevariety">Rubber<wbr>Tree<wbr>Variety[]</a></span>
    </dt>
    <dd>{{% md %}}The varieties available{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="sizes_nodejs">
<a href="#sizes_nodejs" style="color: inherit; text-decoration: inherit;">sizes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">{[key: string]: Tree<wbr>Size}</span>
    </dt>
    <dd>{{% md %}}The sizes of trees available{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="varieties_python">
<a href="#varieties_python" style="color: inherit; text-decoration: inherit;">varieties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#rubbertreevariety">Sequence[Rubber<wbr>Tree<wbr>Variety]</a></span>
    </dt>
    <dd>{{% md %}}The varieties available{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="sizes_python">
<a href="#sizes_python" style="color: inherit; text-decoration: inherit;">sizes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Mapping[str, Tree<wbr>Size]</span>
    </dt>
    <dd>{{% md %}}The sizes of trees available{{% /md %}}</dd></dl>
{{% /choosable %}}


### Outputs

All [input](#inputs) properties are implicitly available as output properties. Additionally, the Nursery resource produces the following output properties:



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_csharp">
<a href="#id_csharp" style="color: inherit; text-decoration: inherit;">Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}The provider-assigned unique ID for this managed resource.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_go">
<a href="#id_go" style="color: inherit; text-decoration: inherit;">Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}The provider-assigned unique ID for this managed resource.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_nodejs">
<a href="#id_nodejs" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}The provider-assigned unique ID for this managed resource.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_python">
<a href="#id_python" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}The provider-assigned unique ID for this managed resource.{{% /md %}}</dd></dl>
{{% /choosable %}}







## Supporting Types



<h4 id="rubbertreevariety">Rubber<wbr>Tree<wbr>Variety</h4>

{{% choosable language csharp %}}
<dl class="tabular"><dt>Burgundy</dt>
    <dd>Burgundy{{% md %}}A burgundy rubber tree.{{% /md %}}</dd><dt>Ruby</dt>
    <dd>Ruby{{% md %}}A ruby rubber tree.{{% /md %}}</dd><dt>Tineke</dt>
    <dd>Tineke{{% md %}}A tineke rubber tree.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="tabular"><dt>Rubber<wbr>Tree<wbr>Variety<wbr>Burgundy</dt>
    <dd>Burgundy{{% md %}}A burgundy rubber tree.{{% /md %}}</dd><dt>Rubber<wbr>Tree<wbr>Variety<wbr>Ruby</dt>
    <dd>Ruby{{% md %}}A ruby rubber tree.{{% /md %}}</dd><dt>Rubber<wbr>Tree<wbr>Variety<wbr>Tineke</dt>
    <dd>Tineke{{% md %}}A tineke rubber tree.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="tabular"><dt>Burgundy</dt>
    <dd>Burgundy{{% md %}}A burgundy rubber tree.{{% /md %}}</dd><dt>Ruby</dt>
    <dd>Ruby{{% md %}}A ruby rubber tree.{{% /md %}}</dd><dt>Tineke</dt>
    <dd>Tineke{{% md %}}A tineke rubber tree.{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="tabular"><dt>BURGUNDY</dt>
    <dd>Burgundy{{% md %}}A burgundy rubber tree.{{% /md %}}</dd><dt>RUBY</dt>
    <dd>Ruby{{% md %}}A ruby rubber tree.{{% /md %}}</dd><dt>TINEKE</dt>
    <dd>Tineke{{% md %}}A tineke rubber tree.{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="treesize">Tree<wbr>Size</h4>

{{% choosable language csharp %}}
<dl class="tabular"><dt>Small</dt>
    <dd>small</dd><dt>Medium</dt>
    <dd>medium</dd><dt>Large</dt>
    <dd>large</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="tabular"><dt>Tree<wbr>Size<wbr>Small</dt>
    <dd>small</dd><dt>Tree<wbr>Size<wbr>Medium</dt>
    <dd>medium</dd><dt>Tree<wbr>Size<wbr>Large</dt>
    <dd>large</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="tabular"><dt>Small</dt>
    <dd>small</dd><dt>Medium</dt>
    <dd>medium</dd><dt>Large</dt>
    <dd>large</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="tabular"><dt>SMALL</dt>
    <dd>small</dd><dt>MEDIUM</dt>
    <dd>medium</dd><dt>LARGE</dt>
    <dd>large</dd></dl>
{{% /choosable %}}


<h2 id="package-details">Package Details</h2>
<dl class="package-details">
	<dt>Repository</dt>
	<dd><a href=""></a></dd>
	<dt>License</dt>
	<dd></dd>
</dl>

