// Code generated by protoc-gen-go. DO NOT EDIT.
// source: engine.proto

package pulumirpc

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// LogSeverity is the severity level of a log message.  Errors are fatal; all others are informational.
type LogSeverity int32

const (
	LogSeverity_DEBUG   LogSeverity = 0
	LogSeverity_INFO    LogSeverity = 1
	LogSeverity_WARNING LogSeverity = 2
	LogSeverity_ERROR   LogSeverity = 3
)

var LogSeverity_name = map[int32]string{
	0: "DEBUG",
	1: "INFO",
	2: "WARNING",
	3: "ERROR",
}

var LogSeverity_value = map[string]int32{
	"DEBUG":   0,
	"INFO":    1,
	"WARNING": 2,
	"ERROR":   3,
}

func (x LogSeverity) String() string {
	return proto.EnumName(LogSeverity_name, int32(x))
}

func (LogSeverity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_770b178c3aab763f, []int{0}
}

type LogRequest struct {
	// the logging level of this message.
	Severity LogSeverity `protobuf:"varint,1,opt,name=severity,proto3,enum=pulumirpc.LogSeverity" json:"severity,omitempty"`
	// the contents of the logged message.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// the (optional) resource urn this log is associated with.
	Urn string `protobuf:"bytes,3,opt,name=urn,proto3" json:"urn,omitempty"`
	// the (optional) stream id that a stream of log messages can be associated with. This allows
	// clients to not have to buffer a large set of log messages that they all want to be
	// conceptually connected.  Instead the messages can be sent as chunks (with the same stream id)
	// and the end display can show the messages as they arrive, while still stitching them together
	// into one total log message.
	//
	// 0/not-given means: do not associate with any stream.
	StreamId int32 `protobuf:"varint,4,opt,name=streamId,proto3" json:"streamId,omitempty"`
	// Optional value indicating whether this is a status message.
	Ephemeral            bool     `protobuf:"varint,5,opt,name=ephemeral,proto3" json:"ephemeral,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogRequest) Reset()         { *m = LogRequest{} }
func (m *LogRequest) String() string { return proto.CompactTextString(m) }
func (*LogRequest) ProtoMessage()    {}
func (*LogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_770b178c3aab763f, []int{0}
}

func (m *LogRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogRequest.Unmarshal(m, b)
}
func (m *LogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogRequest.Marshal(b, m, deterministic)
}
func (m *LogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogRequest.Merge(m, src)
}
func (m *LogRequest) XXX_Size() int {
	return xxx_messageInfo_LogRequest.Size(m)
}
func (m *LogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LogRequest proto.InternalMessageInfo

func (m *LogRequest) GetSeverity() LogSeverity {
	if m != nil {
		return m.Severity
	}
	return LogSeverity_DEBUG
}

func (m *LogRequest) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *LogRequest) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

func (m *LogRequest) GetStreamId() int32 {
	if m != nil {
		return m.StreamId
	}
	return 0
}

func (m *LogRequest) GetEphemeral() bool {
	if m != nil {
		return m.Ephemeral
	}
	return false
}

type GetRootResourceRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRootResourceRequest) Reset()         { *m = GetRootResourceRequest{} }
func (m *GetRootResourceRequest) String() string { return proto.CompactTextString(m) }
func (*GetRootResourceRequest) ProtoMessage()    {}
func (*GetRootResourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_770b178c3aab763f, []int{1}
}

func (m *GetRootResourceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRootResourceRequest.Unmarshal(m, b)
}
func (m *GetRootResourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRootResourceRequest.Marshal(b, m, deterministic)
}
func (m *GetRootResourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRootResourceRequest.Merge(m, src)
}
func (m *GetRootResourceRequest) XXX_Size() int {
	return xxx_messageInfo_GetRootResourceRequest.Size(m)
}
func (m *GetRootResourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRootResourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRootResourceRequest proto.InternalMessageInfo

type GetRootResourceResponse struct {
	// the URN of the root resource, or the empty string if one was not set.
	Urn                  string   `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRootResourceResponse) Reset()         { *m = GetRootResourceResponse{} }
func (m *GetRootResourceResponse) String() string { return proto.CompactTextString(m) }
func (*GetRootResourceResponse) ProtoMessage()    {}
func (*GetRootResourceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_770b178c3aab763f, []int{2}
}

func (m *GetRootResourceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRootResourceResponse.Unmarshal(m, b)
}
func (m *GetRootResourceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRootResourceResponse.Marshal(b, m, deterministic)
}
func (m *GetRootResourceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRootResourceResponse.Merge(m, src)
}
func (m *GetRootResourceResponse) XXX_Size() int {
	return xxx_messageInfo_GetRootResourceResponse.Size(m)
}
func (m *GetRootResourceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRootResourceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetRootResourceResponse proto.InternalMessageInfo

func (m *GetRootResourceResponse) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

type SetRootResourceRequest struct {
	// the URN of the root resource, or the empty string.
	Urn                  string   `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetRootResourceRequest) Reset()         { *m = SetRootResourceRequest{} }
func (m *SetRootResourceRequest) String() string { return proto.CompactTextString(m) }
func (*SetRootResourceRequest) ProtoMessage()    {}
func (*SetRootResourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_770b178c3aab763f, []int{3}
}

func (m *SetRootResourceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetRootResourceRequest.Unmarshal(m, b)
}
func (m *SetRootResourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetRootResourceRequest.Marshal(b, m, deterministic)
}
func (m *SetRootResourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetRootResourceRequest.Merge(m, src)
}
func (m *SetRootResourceRequest) XXX_Size() int {
	return xxx_messageInfo_SetRootResourceRequest.Size(m)
}
func (m *SetRootResourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetRootResourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetRootResourceRequest proto.InternalMessageInfo

func (m *SetRootResourceRequest) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

type SetRootResourceResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetRootResourceResponse) Reset()         { *m = SetRootResourceResponse{} }
func (m *SetRootResourceResponse) String() string { return proto.CompactTextString(m) }
func (*SetRootResourceResponse) ProtoMessage()    {}
func (*SetRootResourceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_770b178c3aab763f, []int{4}
}

func (m *SetRootResourceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetRootResourceResponse.Unmarshal(m, b)
}
func (m *SetRootResourceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetRootResourceResponse.Marshal(b, m, deterministic)
}
func (m *SetRootResourceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetRootResourceResponse.Merge(m, src)
}
func (m *SetRootResourceResponse) XXX_Size() int {
	return xxx_messageInfo_SetRootResourceResponse.Size(m)
}
func (m *SetRootResourceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SetRootResourceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SetRootResourceResponse proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("pulumirpc.LogSeverity", LogSeverity_name, LogSeverity_value)
	proto.RegisterType((*LogRequest)(nil), "pulumirpc.LogRequest")
	proto.RegisterType((*GetRootResourceRequest)(nil), "pulumirpc.GetRootResourceRequest")
	proto.RegisterType((*GetRootResourceResponse)(nil), "pulumirpc.GetRootResourceResponse")
	proto.RegisterType((*SetRootResourceRequest)(nil), "pulumirpc.SetRootResourceRequest")
	proto.RegisterType((*SetRootResourceResponse)(nil), "pulumirpc.SetRootResourceResponse")
}

func init() { proto.RegisterFile("engine.proto", fileDescriptor_770b178c3aab763f) }

var fileDescriptor_770b178c3aab763f = []byte{
	// 356 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x91, 0x4f, 0x4b, 0xeb, 0x40,
	0x14, 0xc5, 0x3b, 0x4d, 0xff, 0x24, 0xb7, 0x8f, 0xf7, 0xc2, 0xc0, 0x4b, 0xf3, 0xf2, 0x5c, 0xc4,
	0xac, 0x42, 0x85, 0x14, 0x2a, 0xb8, 0x70, 0xa7, 0x18, 0x4b, 0xa1, 0xb4, 0x30, 0x41, 0x04, 0x77,
	0x6d, 0xbd, 0xc6, 0x42, 0x93, 0x89, 0x99, 0x89, 0xd0, 0x2f, 0xe4, 0x67, 0x74, 0x29, 0x4d, 0xda,
	0x58, 0x35, 0xd6, 0xdd, 0xcc, 0xbd, 0x87, 0x1f, 0xe7, 0x9e, 0x03, 0xbf, 0x30, 0x0e, 0x97, 0x31,
	0x7a, 0x49, 0xca, 0x25, 0xa7, 0x5a, 0x92, 0xad, 0xb2, 0x68, 0x99, 0x26, 0x0b, 0xeb, 0x7f, 0xc8,
	0x79, 0xb8, 0xc2, 0x7e, 0xbe, 0x98, 0x67, 0x0f, 0x7d, 0x8c, 0x12, 0xb9, 0x2e, 0x74, 0xce, 0x0b,
	0x01, 0x18, 0xf3, 0x90, 0xe1, 0x53, 0x86, 0x42, 0xd2, 0x01, 0xa8, 0x02, 0x9f, 0x31, 0x5d, 0xca,
	0xb5, 0x49, 0x6c, 0xe2, 0xfe, 0x1e, 0x18, 0x5e, 0x49, 0xf2, 0xc6, 0x3c, 0x0c, 0xb6, 0x5b, 0x56,
	0xea, 0xa8, 0x09, 0xed, 0x08, 0x85, 0x98, 0x85, 0x68, 0xd6, 0x6d, 0xe2, 0x6a, 0x6c, 0xf7, 0xa5,
	0x3a, 0x28, 0x59, 0x1a, 0x9b, 0x4a, 0x3e, 0xdd, 0x3c, 0xa9, 0x05, 0xaa, 0x90, 0x29, 0xce, 0xa2,
	0xd1, 0xbd, 0xd9, 0xb0, 0x89, 0xdb, 0x64, 0xe5, 0x9f, 0x1e, 0x81, 0x86, 0xc9, 0x23, 0x46, 0x98,
	0xce, 0x56, 0x66, 0xd3, 0x26, 0xae, 0xca, 0xde, 0x07, 0x8e, 0x09, 0xc6, 0x10, 0x25, 0xe3, 0x5c,
	0x32, 0x14, 0x3c, 0x4b, 0x17, 0xb8, 0xf5, 0xec, 0x9c, 0x40, 0xf7, 0xcb, 0x46, 0x24, 0x3c, 0x16,
	0xa5, 0x01, 0x52, 0x1a, 0x70, 0x7a, 0x60, 0x04, 0x95, 0x98, 0x0a, 0xed, 0x3f, 0xe8, 0x06, 0xd5,
	0xe0, 0xde, 0x39, 0x74, 0xf6, 0xc2, 0xa0, 0x1a, 0x34, 0xaf, 0xfc, 0xcb, 0x9b, 0xa1, 0x5e, 0xa3,
	0x2a, 0x34, 0x46, 0x93, 0xeb, 0xa9, 0x4e, 0x68, 0x07, 0xda, 0xb7, 0x17, 0x6c, 0x32, 0x9a, 0x0c,
	0xf5, 0xfa, 0x46, 0xe1, 0x33, 0x36, 0x65, 0xba, 0x32, 0x78, 0x25, 0xd0, 0xf2, 0xf3, 0xae, 0xe8,
	0x19, 0x28, 0x63, 0x1e, 0xd2, 0xbf, 0x1f, 0x33, 0xde, 0x3a, 0xb2, 0x0c, 0xaf, 0x68, 0xce, 0xdb,
	0x35, 0xe7, 0xf9, 0x9b, 0xe6, 0x9c, 0x1a, 0xbd, 0x83, 0x3f, 0x9f, 0x4e, 0xa6, 0xc7, 0x7b, 0x8c,
	0xea, 0xa0, 0x2c, 0xe7, 0x90, 0xa4, 0x38, 0xac, 0x60, 0x07, 0x07, 0xd8, 0xc1, 0xcf, 0xec, 0xe0,
	0x3b, 0xf6, 0xbc, 0x95, 0x5f, 0x72, 0xfa, 0x16, 0x00, 0x00, 0xff, 0xff, 0x26, 0x3e, 0xcf, 0xd2,
	0xac, 0x02, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EngineClient is the client API for Engine service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EngineClient interface {
	// Log logs a global message in the engine, including errors and warnings.
	Log(ctx context.Context, in *LogRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// GetRootResource gets the URN of the root resource, the resource that should be the root of all
	// otherwise-unparented resources.
	GetRootResource(ctx context.Context, in *GetRootResourceRequest, opts ...grpc.CallOption) (*GetRootResourceResponse, error)
	// SetRootResource sets the URN of the root resource.
	SetRootResource(ctx context.Context, in *SetRootResourceRequest, opts ...grpc.CallOption) (*SetRootResourceResponse, error)
}

type engineClient struct {
	cc grpc.ClientConnInterface
}

func NewEngineClient(cc grpc.ClientConnInterface) EngineClient {
	return &engineClient{cc}
}

func (c *engineClient) Log(ctx context.Context, in *LogRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/pulumirpc.Engine/Log", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *engineClient) GetRootResource(ctx context.Context, in *GetRootResourceRequest, opts ...grpc.CallOption) (*GetRootResourceResponse, error) {
	out := new(GetRootResourceResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.Engine/GetRootResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *engineClient) SetRootResource(ctx context.Context, in *SetRootResourceRequest, opts ...grpc.CallOption) (*SetRootResourceResponse, error) {
	out := new(SetRootResourceResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.Engine/SetRootResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EngineServer is the server API for Engine service.
type EngineServer interface {
	// Log logs a global message in the engine, including errors and warnings.
	Log(context.Context, *LogRequest) (*empty.Empty, error)
	// GetRootResource gets the URN of the root resource, the resource that should be the root of all
	// otherwise-unparented resources.
	GetRootResource(context.Context, *GetRootResourceRequest) (*GetRootResourceResponse, error)
	// SetRootResource sets the URN of the root resource.
	SetRootResource(context.Context, *SetRootResourceRequest) (*SetRootResourceResponse, error)
}

// UnimplementedEngineServer can be embedded to have forward compatible implementations.
type UnimplementedEngineServer struct {
}

func (*UnimplementedEngineServer) Log(ctx context.Context, req *LogRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Log not implemented")
}
func (*UnimplementedEngineServer) GetRootResource(ctx context.Context, req *GetRootResourceRequest) (*GetRootResourceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRootResource not implemented")
}
func (*UnimplementedEngineServer) SetRootResource(ctx context.Context, req *SetRootResourceRequest) (*SetRootResourceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetRootResource not implemented")
}

func RegisterEngineServer(s *grpc.Server, srv EngineServer) {
	s.RegisterService(&_Engine_serviceDesc, srv)
}

func _Engine_Log_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EngineServer).Log(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.Engine/Log",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EngineServer).Log(ctx, req.(*LogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Engine_GetRootResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRootResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EngineServer).GetRootResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.Engine/GetRootResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EngineServer).GetRootResource(ctx, req.(*GetRootResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Engine_SetRootResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetRootResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EngineServer).SetRootResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.Engine/SetRootResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EngineServer).SetRootResource(ctx, req.(*SetRootResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Engine_serviceDesc = grpc.ServiceDesc{
	ServiceName: "pulumirpc.Engine",
	HandlerType: (*EngineServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Log",
			Handler:    _Engine_Log_Handler,
		},
		{
			MethodName: "GetRootResource",
			Handler:    _Engine_GetRootResource_Handler,
		},
		{
			MethodName: "SetRootResource",
			Handler:    _Engine_SetRootResource_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "engine.proto",
}
