// Copyright 2016-2021, Pulumi Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import * as assert from "assert";
import { asyncTest } from "./util";

import * as internals from "../provider/internals";

describe("provider", () => {
    it("parses arguments generated by --logflow", asyncTest(async () => {
        const parsedArgs = internals.parseArgs(["--logtostderr", "-v=9", "--tracing", "127.0.0.1:6007", "127.0.0.1:12345"]);
        if (parsedArgs !== undefined) {
            assert.strictEqual("127.0.0.1:12345", parsedArgs.engineAddress);
        } else {
            assert.fail("failed to parse");
        }
    }));
});
