package gen

import (
	"fmt"

	"github.com/hashicorp/hcl/v2"
	"github.com/hashicorp/hcl/v2/hclsyntax"
	"github.com/pulumi/pulumi/pkg/v2/codegen/hcl2/model"
	"github.com/pulumi/pulumi/pkg/v2/codegen/hcl2/syntax"
)

type splatTemp struct {
	Name  string
	Value *model.SplatExpression
}

func (st *splatTemp) Type() model.Type {
	return st.Value.Type()
}

func (st *splatTemp) Traverse(traverser hcl.Traverser) (model.Traversable, hcl.Diagnostics) {
	return st.Type().Traverse(traverser)
}

func (st *splatTemp) SyntaxNode() hclsyntax.Node {
	return syntax.None
}

type splatSpiller struct {
	temps []*splatTemp
	count int
}

func (ss *splatSpiller) spillExpression(x model.Expression) (model.Expression, hcl.Diagnostics) {
	var temp *splatTemp
	switch x := x.(type) {
	case *model.SplatExpression:
		temp = &splatTemp{
			Name:  fmt.Sprintf("splat%d", ss.count),
			Value: x,
		}
		ss.temps = append(ss.temps, temp)
		ss.count++
	default:
		return x, nil
	}
	return &model.ScopeTraversalExpression{
		RootName:  temp.Name,
		Traversal: hcl.Traversal{hcl.TraverseRoot{Name: ""}},
		Parts:     []model.Traversable{temp},
	}, nil
}

func (g *generator) rewriteSplat(
	x model.Expression,
	spiller *splatSpiller,
) (model.Expression, []*splatTemp, hcl.Diagnostics) {
	spiller.temps = nil
	x, diags := model.VisitExpression(x, spiller.spillExpression, nil)

	return x, spiller.temps, diags

}
