package mapcidr

import (
	"math/big"
	"net"
	"testing"

	"github.com/projectdiscovery/sliceutil"
	"github.com/stretchr/testify/require"
)

func TestCountIPsInCIDRs(t *testing.T) {
	errorMsg := "unexpected result"
	_, net1, _ := net.ParseCIDR("15.181.232.0/21")
	_, net2, _ := net.ParseCIDR("15.181.232.0/21")
	require.Equal(t, CountIPsInCIDRs(true, true, net1, net2), big.NewInt(4096), errorMsg)
	require.Equal(t, CountIPsInCIDRs(false, false, net1, net2), big.NewInt(4092), errorMsg)
	require.Equal(t, CountIPsInCIDRs(true, false, net1, net2), big.NewInt(4094), errorMsg)
	require.Equal(t, CountIPsInCIDRs(false, true, net1, net2), big.NewInt(4094), errorMsg)
}

func TestIpEncodings(t *testing.T) {
	ip := "127.0.0.1"
	res := AlterIP(ip, []string{"1"}, 0, false)
	require.Equal(t, []string{"127.0.0.1"}, res)
	res = AlterIP(ip, []string{"2"}, 0, false)
	require.Equal(t, []string{"127.1"}, res)
	res = AlterIP(ip, []string{"3"}, 0, false)
	require.Equal(t, []string{"0177.0.0.01"}, res)
	res = AlterIP(ip, []string{"4"}, 0, false)
	require.True(t, sliceutil.ContainsItems(res, []string{"0x7f.0x0.0x0.0x1", "0x7f000001"}))
	res = AlterIP(ip, []string{"5"}, 0, false)
	require.Equal(t, []string{"281472812449793"}, res)
	res = AlterIP(ip, []string{"6"}, 0, false)
	require.Equal(t, []string{"111111111111111101111111000000000000000000000001"}, res)
	res = AlterIP(ip, []string{"7"}, 0, false)
	require.Equal(t, []string{"0x7f.0.0.0x1"}, res)
	res = AlterIP("2001:0db8:85a3:0000:0000:8a2e:0370:7334", []string{"8"}, 0, false)
	require.Equal(t, []string{"2001:db8:85a3::8a2e:370:7334"}, res)
	res = AlterIP(ip, []string{"9"}, 0, false)
	require.Equal(t, []string{"%31%32%37%2E%30%2E%30%2E%31"}, res)
	res = AlterIP(ip, []string{"10"}, 5, true)
	require.Equal(t, []string{"127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.00.1", "127.0.00.1", "127.0.00.01", "127.0.00.001", "127.0.00.0001", "127.0.000.1", "127.0.000.1", "127.0.000.01", "127.0.000.001", "127.0.000.0001", "127.0.0000.1", "127.0.0000.1", "127.0.0000.01", "127.0.0000.001", "127.0.0000.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.00.1", "127.0.00.1", "127.0.00.01", "127.0.00.001", "127.0.00.0001", "127.0.000.1", "127.0.000.1", "127.0.000.01", "127.0.000.001", "127.0.000.0001", "127.0.0000.1", "127.0.0000.1", "127.0.0000.01", "127.0.0000.001", "127.0.0000.0001", "127.00.0.1", "127.00.0.1", "127.00.0.01", "127.00.0.001", "127.00.0.0001", "127.00.0.1", "127.00.0.1", "127.00.0.01", "127.00.0.001", "127.00.0.0001", "127.00.00.1", "127.00.00.1", "127.00.00.01", "127.00.00.001", "127.00.00.0001", "127.00.000.1", "127.00.000.1", "127.00.000.01", "127.00.000.001", "127.00.000.0001", "127.00.0000.1", "127.00.0000.1", "127.00.0000.01", "127.00.0000.001", "127.00.0000.0001", "127.000.0.1", "127.000.0.1", "127.000.0.01", "127.000.0.001", "127.000.0.0001", "127.000.0.1", "127.000.0.1", "127.000.0.01", "127.000.0.001", "127.000.0.0001", "127.000.00.1", "127.000.00.1", "127.000.00.01", "127.000.00.001", "127.000.00.0001", "127.000.000.1", "127.000.000.1", "127.000.000.01", "127.000.000.001", "127.000.000.0001", "127.000.0000.1", "127.000.0000.1", "127.000.0000.01", "127.000.0000.001", "127.000.0000.0001", "127.0000.0.1", "127.0000.0.1", "127.0000.0.01", "127.0000.0.001", "127.0000.0.0001", "127.0000.0.1", "127.0000.0.1", "127.0000.0.01", "127.0000.0.001", "127.0000.0.0001", "127.0000.00.1", "127.0000.00.1", "127.0000.00.01", "127.0000.00.001", "127.0000.00.0001", "127.0000.000.1", "127.0000.000.1", "127.0000.000.01", "127.0000.000.001", "127.0000.000.0001", "127.0000.0000.1", "127.0000.0000.1", "127.0000.0000.01", "127.0000.0000.001", "127.0000.0000.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.00.1", "127.0.00.1", "127.0.00.01", "127.0.00.001", "127.0.00.0001", "127.0.000.1", "127.0.000.1", "127.0.000.01", "127.0.000.001", "127.0.000.0001", "127.0.0000.1", "127.0.0000.1", "127.0.0000.01", "127.0.0000.001", "127.0.0000.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.00.1", "127.0.00.1", "127.0.00.01", "127.0.00.001", "127.0.00.0001", "127.0.000.1", "127.0.000.1", "127.0.000.01", "127.0.000.001", "127.0.000.0001", "127.0.0000.1", "127.0.0000.1", "127.0.0000.01", "127.0.0000.001", "127.0.0000.0001", "127.00.0.1", "127.00.0.1", "127.00.0.01", "127.00.0.001", "127.00.0.0001", "127.00.0.1", "127.00.0.1", "127.00.0.01", "127.00.0.001", "127.00.0.0001", "127.00.00.1", "127.00.00.1", "127.00.00.01", "127.00.00.001", "127.00.00.0001", "127.00.000.1", "127.00.000.1", "127.00.000.01", "127.00.000.001", "127.00.000.0001", "127.00.0000.1", "127.00.0000.1", "127.00.0000.01", "127.00.0000.001", "127.00.0000.0001", "127.000.0.1", "127.000.0.1", "127.000.0.01", "127.000.0.001", "127.000.0.0001", "127.000.0.1", "127.000.0.1", "127.000.0.01", "127.000.0.001", "127.000.0.0001", "127.000.00.1", "127.000.00.1", "127.000.00.01", "127.000.00.001", "127.000.00.0001", "127.000.000.1", "127.000.000.1", "127.000.000.01", "127.000.000.001", "127.000.000.0001", "127.000.0000.1", "127.000.0000.1", "127.000.0000.01", "127.000.0000.001", "127.000.0000.0001", "127.0000.0.1", "127.0000.0.1", "127.0000.0.01", "127.0000.0.001", "127.0000.0.0001", "127.0000.0.1", "127.0000.0.1", "127.0000.0.01", "127.0000.0.001", "127.0000.0.0001", "127.0000.00.1", "127.0000.00.1", "127.0000.00.01", "127.0000.00.001", "127.0000.00.0001", "127.0000.000.1", "127.0000.000.1", "127.0000.000.01", "127.0000.000.001", "127.0000.000.0001", "127.0000.0000.1", "127.0000.0000.1", "127.0000.0000.01", "127.0000.0000.001", "127.0000.0000.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.00.1", "127.0.00.1", "127.0.00.01", "127.0.00.001", "127.0.00.0001", "127.0.000.1", "127.0.000.1", "127.0.000.01", "127.0.000.001", "127.0.000.0001", "127.0.0000.1", "127.0.0000.1", "127.0.0000.01", "127.0.0000.001", "127.0.0000.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.00.1", "127.0.00.1", "127.0.00.01", "127.0.00.001", "127.0.00.0001", "127.0.000.1", "127.0.000.1", "127.0.000.01", "127.0.000.001", "127.0.000.0001", "127.0.0000.1", "127.0.0000.1", "127.0.0000.01", "127.0.0000.001", "127.0.0000.0001", "127.00.0.1", "127.00.0.1", "127.00.0.01", "127.00.0.001", "127.00.0.0001", "127.00.0.1", "127.00.0.1", "127.00.0.01", "127.00.0.001", "127.00.0.0001", "127.00.00.1", "127.00.00.1", "127.00.00.01", "127.00.00.001", "127.00.00.0001", "127.00.000.1", "127.00.000.1", "127.00.000.01", "127.00.000.001", "127.00.000.0001", "127.00.0000.1", "127.00.0000.1", "127.00.0000.01", "127.00.0000.001", "127.00.0000.0001", "127.000.0.1", "127.000.0.1", "127.000.0.01", "127.000.0.001", "127.000.0.0001", "127.000.0.1", "127.000.0.1", "127.000.0.01", "127.000.0.001", "127.000.0.0001", "127.000.00.1", "127.000.00.1", "127.000.00.01", "127.000.00.001", "127.000.00.0001", "127.000.000.1", "127.000.000.1", "127.000.000.01", "127.000.000.001", "127.000.000.0001", "127.000.0000.1", "127.000.0000.1", "127.000.0000.01", "127.000.0000.001", "127.000.0000.0001", "127.0000.0.1", "127.0000.0.1", "127.0000.0.01", "127.0000.0.001", "127.0000.0.0001", "127.0000.0.1", "127.0000.0.1", "127.0000.0.01", "127.0000.0.001", "127.0000.0.0001", "127.0000.00.1", "127.0000.00.1", "127.0000.00.01", "127.0000.00.001", "127.0000.00.0001", "127.0000.000.1", "127.0000.000.1", "127.0000.000.01", "127.0000.000.001", "127.0000.000.0001", "127.0000.0000.1", "127.0000.0000.1", "127.0000.0000.01", "127.0000.0000.001", "127.0000.0000.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.00.1", "127.0.00.1", "127.0.00.01", "127.0.00.001", "127.0.00.0001", "127.0.000.1", "127.0.000.1", "127.0.000.01", "127.0.000.001", "127.0.000.0001", "127.0.0000.1", "127.0.0000.1", "127.0.0000.01", "127.0.0000.001", "127.0.0000.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.0.1", "127.0.0.1", "127.0.0.01", "127.0.0.001", "127.0.0.0001", "127.0.00.1", "127.0.00.1", "127.0.00.01", "127.0.00.001", "127.0.00.0001", "127.0.000.1", "127.0.000.1", "127.0.000.01", "127.0.000.001", "127.0.000.0001", "127.0.0000.1", "127.0.0000.1", "127.0.0000.01", "127.0.0000.001", "127.0.0000.0001", "127.00.0.1", "127.00.0.1", "127.00.0.01", "127.00.0.001", "127.00.0.0001", "127.00.0.1", "127.00.0.1", "127.00.0.01", "127.00.0.001", "127.00.0.0001", "127.00.00.1", "127.00.00.1", "127.00.00.01", "127.00.00.001", "127.00.00.0001", "127.00.000.1", "127.00.000.1", "127.00.000.01", "127.00.000.001", "127.00.000.0001", "127.00.0000.1", "127.00.0000.1", "127.00.0000.01", "127.00.0000.001", "127.00.0000.0001", "127.000.0.1", "127.000.0.1", "127.000.0.01", "127.000.0.001", "127.000.0.0001", "127.000.0.1", "127.000.0.1", "127.000.0.01", "127.000.0.001", "127.000.0.0001", "127.000.00.1", "127.000.00.1", "127.000.00.01", "127.000.00.001", "127.000.00.0001", "127.000.000.1", "127.000.000.1", "127.000.000.01", "127.000.000.001", "127.000.000.0001", "127.000.0000.1", "127.000.0000.1", "127.000.0000.01", "127.000.0000.001", "127.000.0000.0001", "127.0000.0.1", "127.0000.0.1", "127.0000.0.01", "127.0000.0.001", "127.0000.0.0001", "127.0000.0.1", "127.0000.0.1", "127.0000.0.01", "127.0000.0.001", "127.0000.0.0001", "127.0000.00.1", "127.0000.00.1", "127.0000.00.01", "127.0000.00.001", "127.0000.00.0001", "127.0000.000.1", "127.0000.000.1", "127.0000.000.01", "127.0000.000.001", "127.0000.000.0001", "127.0000.0000.1", "127.0000.0000.1", "127.0000.0000.01", "127.0000.0000.001", "127.0000.0000.0001", "0127.0.0.1", "0127.0.0.1", "0127.0.0.01", "0127.0.0.001", "0127.0.0.0001", "0127.0.0.1", "0127.0.0.1", "0127.0.0.01", "0127.0.0.001", "0127.0.0.0001", "0127.0.00.1", "0127.0.00.1", "0127.0.00.01", "0127.0.00.001", "0127.0.00.0001", "0127.0.000.1", "0127.0.000.1", "0127.0.000.01", "0127.0.000.001", "0127.0.000.0001", "0127.0.0000.1", "0127.0.0000.1", "0127.0.0000.01", "0127.0.0000.001", "0127.0.0000.0001", "0127.0.0.1", "0127.0.0.1", "0127.0.0.01", "0127.0.0.001", "0127.0.0.0001", "0127.0.0.1", "0127.0.0.1", "0127.0.0.01", "0127.0.0.001", "0127.0.0.0001", "0127.0.00.1", "0127.0.00.1", "0127.0.00.01", "0127.0.00.001", "0127.0.00.0001", "0127.0.000.1", "0127.0.000.1", "0127.0.000.01", "0127.0.000.001", "0127.0.000.0001", "0127.0.0000.1", "0127.0.0000.1", "0127.0.0000.01", "0127.0.0000.001", "0127.0.0000.0001", "0127.00.0.1", "0127.00.0.1", "0127.00.0.01", "0127.00.0.001", "0127.00.0.0001", "0127.00.0.1", "0127.00.0.1", "0127.00.0.01", "0127.00.0.001", "0127.00.0.0001", "0127.00.00.1", "0127.00.00.1", "0127.00.00.01", "0127.00.00.001", "0127.00.00.0001", "0127.00.000.1", "0127.00.000.1", "0127.00.000.01", "0127.00.000.001", "0127.00.000.0001", "0127.00.0000.1", "0127.00.0000.1", "0127.00.0000.01", "0127.00.0000.001", "0127.00.0000.0001", "0127.000.0.1", "0127.000.0.1", "0127.000.0.01", "0127.000.0.001", "0127.000.0.0001", "0127.000.0.1", "0127.000.0.1", "0127.000.0.01", "0127.000.0.001", "0127.000.0.0001", "0127.000.00.1", "0127.000.00.1", "0127.000.00.01", "0127.000.00.001", "0127.000.00.0001", "0127.000.000.1", "0127.000.000.1", "0127.000.000.01", "0127.000.000.001", "0127.000.000.0001", "0127.000.0000.1", "0127.000.0000.1", "0127.000.0000.01", "0127.000.0000.001", "0127.000.0000.0001", "0127.0000.0.1", "0127.0000.0.1", "0127.0000.0.01", "0127.0000.0.001", "0127.0000.0.0001", "0127.0000.0.1", "0127.0000.0.1", "0127.0000.0.01", "0127.0000.0.001", "0127.0000.0.0001", "0127.0000.00.1", "0127.0000.00.1", "0127.0000.00.01", "0127.0000.00.001", "0127.0000.00.0001", "0127.0000.000.1", "0127.0000.000.1", "0127.0000.000.01", "0127.0000.000.001", "0127.0000.000.0001", "0127.0000.0000.1", "0127.0000.0000.1", "0127.0000.0000.01", "0127.0000.0000.001", "0127.0000.0000.0001"}, res)
	res = AlterIP("127.0.1.0", []string{"11"}, 0, false)
	require.Equal(t, []string{"127.0.256"}, res)
}
