#!/usr/bin/env bash

#
# DO NOT EDIT THIS FILE
#
# It is automatically copied from https://github.com/pion/.goassets repository.
#
# If you want to update the shared CI config, send a PR to
# https://github.com/pion/.goassets instead of this repository.
#

set -e

SCRIPT_PATH=$( cd "$(dirname "${BASH_SOURCE[0]}")" ; pwd -P )

if [ -f ${SCRIPT_PATH}/.ci.conf ]
then
  . ${SCRIPT_PATH}/.ci.conf
fi

#
# DO NOT EDIT THIS
#
EXCLUDED_CONTRIBUTORS+=('John R. Bradley' 'renovate[bot]' 'Renovate Bot' 'Pion Bot')
# If you want to exclude a name from all repositories, send a PR to
# https://github.com/pion/.goassets instead of this repository.
# If you want to exclude a name only from this repository,
# add EXCLUDED_CONTRIBUTORS=('name') to .github/.ci.conf

MISSING_CONTRIBUTORS=()

shouldBeIncluded () {
	for i in "${EXCLUDED_CONTRIBUTORS[@]}"
	do
		if [ "$i" == "$1" ] ; then
			return 1
		fi
	done
	return 0
}


IFS=$'\n' #Only split on newline
for contributor in $(git log --format='%aN' | sort -u)
do
	if shouldBeIncluded $contributor; then
		if ! grep -q "$contributor" "$SCRIPT_PATH/../README.md"; then
			MISSING_CONTRIBUTORS+=("$contributor")
		fi
	fi
done
unset IFS

if [ ${#MISSING_CONTRIBUTORS[@]} -ne 0 ]; then
    echo "Please add the following contributors to the README"
    for i in "${MISSING_CONTRIBUTORS[@]}"
    do
	    echo "$i"
    done
    exit 1
fi
