// Code generated by sdkgen. DO NOT EDIT.

//nolint
package mysql

import (
	"context"

	"google.golang.org/grpc"

	mysql "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mysql/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// DatabaseServiceClient is a mysql.DatabaseServiceClient with
// lazy GRPC connection initialization.
type DatabaseServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements mysql.DatabaseServiceClient
func (c *DatabaseServiceClient) Create(ctx context.Context, in *mysql.CreateDatabaseRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return mysql.NewDatabaseServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements mysql.DatabaseServiceClient
func (c *DatabaseServiceClient) Delete(ctx context.Context, in *mysql.DeleteDatabaseRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return mysql.NewDatabaseServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements mysql.DatabaseServiceClient
func (c *DatabaseServiceClient) Get(ctx context.Context, in *mysql.GetDatabaseRequest, opts ...grpc.CallOption) (*mysql.Database, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return mysql.NewDatabaseServiceClient(conn).Get(ctx, in, opts...)
}

// List implements mysql.DatabaseServiceClient
func (c *DatabaseServiceClient) List(ctx context.Context, in *mysql.ListDatabasesRequest, opts ...grpc.CallOption) (*mysql.ListDatabasesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return mysql.NewDatabaseServiceClient(conn).List(ctx, in, opts...)
}

type DatabaseIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *DatabaseServiceClient
	request *mysql.ListDatabasesRequest

	items []*mysql.Database
}

func (c *DatabaseServiceClient) DatabaseIterator(ctx context.Context, clusterId string, opts ...grpc.CallOption) *DatabaseIterator {
	return &DatabaseIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &mysql.ListDatabasesRequest{
			ClusterId: clusterId,
			PageSize:  1000,
		},
	}
}

func (it *DatabaseIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Databases
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DatabaseIterator) Value() *mysql.Database {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DatabaseIterator) Error() error {
	return it.err
}
