// Code generated by sdkgen. DO NOT EDIT.

//nolint
package clickhouse

import (
	"context"

	"google.golang.org/grpc"

	clickhouse "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/clickhouse/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// DatabaseServiceClient is a clickhouse.DatabaseServiceClient with
// lazy GRPC connection initialization.
type DatabaseServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements clickhouse.DatabaseServiceClient
func (c *DatabaseServiceClient) Create(ctx context.Context, in *clickhouse.CreateDatabaseRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return clickhouse.NewDatabaseServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements clickhouse.DatabaseServiceClient
func (c *DatabaseServiceClient) Delete(ctx context.Context, in *clickhouse.DeleteDatabaseRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return clickhouse.NewDatabaseServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements clickhouse.DatabaseServiceClient
func (c *DatabaseServiceClient) Get(ctx context.Context, in *clickhouse.GetDatabaseRequest, opts ...grpc.CallOption) (*clickhouse.Database, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return clickhouse.NewDatabaseServiceClient(conn).Get(ctx, in, opts...)
}

// List implements clickhouse.DatabaseServiceClient
func (c *DatabaseServiceClient) List(ctx context.Context, in *clickhouse.ListDatabasesRequest, opts ...grpc.CallOption) (*clickhouse.ListDatabasesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return clickhouse.NewDatabaseServiceClient(conn).List(ctx, in, opts...)
}

type DatabaseIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *DatabaseServiceClient
	request *clickhouse.ListDatabasesRequest

	items []*clickhouse.Database
}

func (c *DatabaseServiceClient) DatabaseIterator(ctx context.Context, clusterId string, opts ...grpc.CallOption) *DatabaseIterator {
	return &DatabaseIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &clickhouse.ListDatabasesRequest{
			ClusterId: clusterId,
			PageSize:  1000,
		},
	}
}

func (it *DatabaseIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Databases
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DatabaseIterator) Value() *clickhouse.Database {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DatabaseIterator) Error() error {
	return it.err
}
