// Code generated by sdkgen. DO NOT EDIT.

//nolint
package containerregistry

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	containerregistry "github.com/yandex-cloud/go-genproto/yandex/cloud/containerregistry/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// RegistryServiceClient is a containerregistry.RegistryServiceClient with
// lazy GRPC connection initialization.
type RegistryServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) Create(ctx context.Context, in *containerregistry.CreateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) Delete(ctx context.Context, in *containerregistry.DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) Get(ctx context.Context, in *containerregistry.GetRegistryRequest, opts ...grpc.CallOption) (*containerregistry.Registry, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).Get(ctx, in, opts...)
}

// List implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) List(ctx context.Context, in *containerregistry.ListRegistriesRequest, opts ...grpc.CallOption) (*containerregistry.ListRegistriesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).List(ctx, in, opts...)
}

type RegistryIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *RegistryServiceClient
	request *containerregistry.ListRegistriesRequest

	items []*containerregistry.Registry
}

func (c *RegistryServiceClient) RegistryIterator(ctx context.Context, folderId string, opts ...grpc.CallOption) *RegistryIterator {
	return &RegistryIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &containerregistry.ListRegistriesRequest{
			FolderId: folderId,
			PageSize: 1000,
		},
	}
}

func (it *RegistryIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Registries
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RegistryIterator) Value() *containerregistry.Registry {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RegistryIterator) Error() error {
	return it.err
}

// ListAccessBindings implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type RegistryAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *RegistryServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *RegistryServiceClient) RegistryAccessBindingsIterator(ctx context.Context, resourceId string, opts ...grpc.CallOption) *RegistryAccessBindingsIterator {
	return &RegistryAccessBindingsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &access.ListAccessBindingsRequest{
			ResourceId: resourceId,
			PageSize:   1000,
		},
	}
}

func (it *RegistryAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RegistryAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RegistryAccessBindingsIterator) Error() error {
	return it.err
}

// SetAccessBindings implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// Update implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) Update(ctx context.Context, in *containerregistry.UpdateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements containerregistry.RegistryServiceClient
func (c *RegistryServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRegistryServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}
