// Code is generated by ucloud-model, DO NOT EDIT IT.

package uhost

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// UHost API Schema

// CopyCustomImageRequest is request schema for CopyCustomImage action
type CopyCustomImageRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 源镜像Id, 参见 DescribeImage
	SourceImageId *string `required:"true"`

	// 目标镜像描述
	TargetImageDescription *string `required:"false"`

	// 目标镜像名称
	TargetImageName *string `required:"false"`

	// 目标项目Id, 参见 GetProjectList
	TargetProjectId *string `required:"true"`

	// 目标地域，不跨地域不用填
	TargetRegion *string `required:"false"`
}

// CopyCustomImageResponse is response schema for CopyCustomImage action
type CopyCustomImageResponse struct {
	response.CommonBase

	// 目标镜像Id
	TargetImageId string
}

// NewCopyCustomImageRequest will create request of CopyCustomImage action.
func (c *UHostClient) NewCopyCustomImageRequest() *CopyCustomImageRequest {
	req := &CopyCustomImageRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CopyCustomImage

复制自制镜像
*/
func (c *UHostClient) CopyCustomImage(req *CopyCustomImageRequest) (*CopyCustomImageResponse, error) {
	var err error
	var res CopyCustomImageResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CopyCustomImage", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CreateCustomImageRequest is request schema for CreateCustomImage action
type CreateCustomImageRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 镜像描述
	ImageDescription *string `required:"false"`

	// 镜像名称
	ImageName *string `required:"true"`

	// UHost实例ID 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// CreateCustomImageResponse is response schema for CreateCustomImage action
type CreateCustomImageResponse struct {
	response.CommonBase

	// 镜像Id
	ImageId string
}

// NewCreateCustomImageRequest will create request of CreateCustomImage action.
func (c *UHostClient) NewCreateCustomImageRequest() *CreateCustomImageRequest {
	req := &CreateCustomImageRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateCustomImage

从指定UHost实例，生成自定义镜像。
*/
func (c *UHostClient) CreateCustomImage(req *CreateCustomImageRequest) (*CreateCustomImageResponse, error) {
	var err error
	var res CreateCustomImageResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateCustomImage", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CreateIsolationGroupRequest is request schema for CreateIsolationGroup action
type CreateIsolationGroupRequest struct {
	request.CommonBase

	// [公共参数] 项目id
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 硬件隔离组名称。请遵照[[api:uhost-api:specification|字段规范]]设定隔离组名称。
	GroupName *string `required:"true"`

	// 备注。请遵照[[api:uhost-api:specification|字段规范]]设定隔离组备注。
	Remark *string `required:"false"`
}

// CreateIsolationGroupResponse is response schema for CreateIsolationGroup action
type CreateIsolationGroupResponse struct {
	response.CommonBase

	// 硬件隔离组id
	GroupId string
}

// NewCreateIsolationGroupRequest will create request of CreateIsolationGroup action.
func (c *UHostClient) NewCreateIsolationGroupRequest() *CreateIsolationGroupRequest {
	req := &CreateIsolationGroupRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateIsolationGroup

创建硬件隔离组，组内机器严格隔离在不同宿主机上。
*/
func (c *UHostClient) CreateIsolationGroup(req *CreateIsolationGroupRequest) (*CreateIsolationGroupResponse, error) {
	var err error
	var res CreateIsolationGroupResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateIsolationGroup", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

/*
CreateUHostInstanceParamNetworkInterfaceEIPGlobalSSH is request schema for complex param
*/
type CreateUHostInstanceParamNetworkInterfaceEIPGlobalSSH struct {

	// 填写支持SSH访问IP的地区名称，如“洛杉矶”，“新加坡”，“香港”，“东京”，“华盛顿”，“法兰克福”。Area和AreaCode两者必填其中之一。
	Area *string `required:"false"`

	// GlobalSSH的地区编码，格式为区域航空港国际通用代码。Area和AreaCode两者必填其中之一。
	AreaCode *string `required:"false"`

	// SSH端口，1-65535且不能使用80，443端口
	Port *int `required:"false"`
}

/*
CreateUHostInstanceParamNetworkInterfaceEIP is request schema for complex param
*/
type CreateUHostInstanceParamNetworkInterfaceEIP struct {

	// 【若绑定EIP，此参数必填】弹性IP的外网带宽, 单位为Mbps. 共享带宽模式必须指定0M带宽, 非共享带宽模式必须指定非0Mbps带宽. 各地域非共享带宽的带宽范围如下： 流量计费[1-300]，带宽计费[1-800]
	Bandwidth *int `required:"false"`

	// 当前EIP代金券id。请通过DescribeCoupon接口查询，或登录用户中心查看。
	CouponId *string `required:"false"`

	//
	GlobalSSH *CreateUHostInstanceParamNetworkInterfaceEIPGlobalSSH `required:"false"`

	// 【若绑定EIP，此参数必填】弹性IP的线路。枚举值: 国际: International BGP: Bgp 各地域允许的线路参数如下: cn-sh1: Bgp cn-sh2: Bgp cn-gd: Bgp cn-bj1: Bgp cn-bj2: Bgp hk: International us-ca: International th-bkk: International kr-seoul:International us-ws:International ge-fra:International sg:International tw-kh:International.其他海外线路均为 International
	OperatorName *string `required:"false"`

	// 弹性IP的计费模式. 枚举值: "Traffic", 流量计费; "Bandwidth", 带宽计费; "ShareBandwidth",共享带宽模式. "Free":免费带宽模式.默认为 "Bandwidth".
	PayMode *string `required:"false"`

	// 绑定的共享带宽Id，仅当PayMode为ShareBandwidth时有效
	ShareBandwidthId *string `required:"false"`
}

/*
UHostDisk is request schema for complex param
*/
type UHostDisk struct {

	// 磁盘备份方案。枚举值：\\ > NONE，无备份 \\ > DATAARK，数据方舟 \\ 当前磁盘支持的备份模式参考 [[api:uhost-api:disk_type|磁盘类型]]
	BackupType *string `required:"false"`

	// 云盘代金券id。不适用于系统盘/本地盘。请通过DescribeCoupon接口查询，或登录用户中心查看
	CouponId *string `required:"false"`

	// 【功能仅部分可用区开放，详询技术支持】磁盘是否加密。加密：true, 不加密: false加密必须传入对应的的KmsKeyId
	Encrypted *bool `required:"false"`

	// 是否是系统盘。枚举值：\\ > True，是系统盘 \\ > False，是数据盘（默认）。Disks数组中有且只能有一块盘是系统盘。
	IsBoot *string `required:"true"`

	// 【功能仅部分可用区开放，详询技术支持】kms key id。选择加密盘时必填。
	KmsKeyId *string `required:"false"`

	// 磁盘大小，单位GB，必须是10GB的整数倍。请参考[[api:uhost-api:disk_type|磁盘类型]]。
	Size *int `required:"true"`

	// 磁盘类型。请参考[[api:uhost-api:disk_type|磁盘类型]]。
	Type *string `required:"true"`
}

/*
CreateUHostInstanceParamNetworkInterface is request schema for complex param
*/
type CreateUHostInstanceParamNetworkInterface struct {

	//
	EIP *CreateUHostInstanceParamNetworkInterfaceEIP `required:"false"`
}

// CreateUHostInstanceRequest is request schema for CreateUHostInstance action
type CreateUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"true"`

	// 告警模板id，如果传了告警模板id，且告警模板id正确，则绑定告警模板。绑定告警模板失败只会在后台有日志，不会影响创建主机流程，也不会在前端报错。
	AlarmTemplateId *int `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	BootDiskSpace *int `required:"false" deprecated:"true"`

	// 虚拟CPU核数。可选参数：1-64（具体机型与CPU的对应关系参照控制台）。默认值: 4。
	CPU *int `required:"false"`

	// 计费模式。枚举值为： \\ > Year，按年付费； \\ > Month，按月付费；\\ > Dynamic，按小时预付费 \\ > Postpay，按小时后付费（支持关机不收费，目前仅部分可用区支持，请联系您的客户经理） \\ 默认为月付
	ChargeType *string `required:"false"`

	// 主机代金券ID。请通过DescribeCoupon接口查询，或登录用户中心查看
	CouponId *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	DiskSpace *int `required:"false" deprecated:"true"`

	//
	Disks []UHostDisk `required:"false"`

	// GPU卡核心数。仅GPU机型支持此字段（可选范围与MachineType+GpuType相关）
	GPU *int `required:"false"`

	// GPU类型，枚举值["K80", "P40", "V100"]，MachineType为G时必填
	GpuType *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	HostType *string `required:"false" deprecated:"true"`

	// 热升级特性。True为开启，False为未开启，默认False。
	HotplugFeature *bool `required:"false"`

	// 镜像ID。 请通过 [DescribeImage](describe_image.html)获取
	ImageId *string `required:"true"`

	// 【该字段已废弃，请谨慎使用】
	InstallAgent *string `required:"false" deprecated:"true"`

	// 硬件隔离组id。可通过DescribeIsolationGroup获取。
	IsolationGroup *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	KeyPair *string `required:"false" deprecated:"true"`

	// 主机登陆模式。密码（默认选项）: Password。
	LoginMode *string `required:"true"`

	// 云主机机型（V2.0），在本字段和字段UHostType中，仅需要其中1个字段即可；当填写了MachineType时，必须填写MinimalCpuPlatform字段。枚举值["N", "C", "G", "O"]。参考[[api:uhost-api:uhost_type|云主机机型说明]]。
	MachineType *string `required:"false"`

	// 本次最大创建主机数量，取值范围是[1,100]，默认值为1。
	MaxCount *int `required:"false"`

	// 内存大小。单位：MB。范围 ：[1024, 262144]，取值为1024的倍数（可选范围参考控制台）。默认值：8192
	Memory *int `required:"false"`

	// 最低cpu平台，枚举值["Intel/Auto", "Intel/IvyBridge", "Intel/Haswell", "Intel/Broadwell", "Intel/Skylake", "Intel/Cascadelake"。
	MinimalCpuPlatform *string `required:"false"`

	// UHost实例名称。默认：UHost。请遵照[[api:uhost-api:specification|字段规范]]设定实例名称。
	Name *string `required:"false"`

	// 网络增强特性。枚举值：Normal（默认），不开启;  Super，开启网络增强1.0； Ultra，开启网络增强2.0（仅支持部分可用区，请参考控制台）
	NetCapability *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	NetworkId *string `required:"false" deprecated:"true"`

	//
	NetworkInterface []CreateUHostInstanceParamNetworkInterface `required:"false"`

	// UHost密码。请遵照[[api:uhost-api:specification|字段规范]]设定密码。密码需使用base64进行编码，举例如下：# echo -n Password1 | base64UGFzc3dvcmQx。
	Password *string `required:"true"`

	// 【数组】创建云主机时指定内网IP。若不传值，则随机分配当前子网下的IP。调用方式举例：PrivateIp.0=x.x.x.x。当前只支持一个内网IP。
	PrivateIp []string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	PrivateMac *string `required:"false" deprecated:"true"`

	// 购买时长。默认:值 1。按小时购买（Dynamic/Postpay）时无需此参数。 月付时，此参数传0，代表购买至月末。
	Quantity *int `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	ResourceType *int `required:"false" deprecated:"true"`

	// 防火墙ID，默认：Web推荐防火墙。如何查询SecurityGroupId请参见 [DescribeFirewall](../unet-api/describe_firewall.html)。
	SecurityGroupId *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	StorageType *string `required:"false" deprecated:"true"`

	// 子网 ID。默认为当前地域的默认子网。
	SubnetId *string `required:"false"`

	// 业务组。默认：Default（Default即为未分组）。请遵照[[api:uhost-api:specification|字段规范]]设定业务组。
	Tag *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	TimemachineFeature *string `required:"false" deprecated:"true"`

	// 【建议后续不再使用】云主机机型（V1.0），在本字段和字段MachineType中，仅需要其中1个字段即可。参考[[api:uhost-api:uhost_type|云主机机型说明]]。
	UHostType *string `required:"false"`

	// 【即将支持】用户自定义数据。当镜像支持Cloud-init Feature时可填写此字段。注意：1、总数据量大小不超多16K；2、使用base64编码
	UserData *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	UserDataScript *string `required:"false" deprecated:"true"`

	// VPC ID。默认为当前地域的默认VPC。
	VPCId *string `required:"false"`
}

// CreateUHostInstanceResponse is response schema for CreateUHostInstance action
type CreateUHostInstanceResponse struct {
	response.CommonBase

	// 【批量创建不会返回】IP信息
	IPs []string

	// UHost实例Id集合
	UHostIds []string
}

// NewCreateUHostInstanceRequest will create request of CreateUHostInstance action.
func (c *UHostClient) NewCreateUHostInstanceRequest() *CreateUHostInstanceRequest {
	req := &CreateUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateUHostInstance

创建UHost实例。
*/
func (c *UHostClient) CreateUHostInstance(req *CreateUHostInstanceRequest) (*CreateUHostInstanceResponse, error) {
	var err error
	var res CreateUHostInstanceResponse

	reqCopier := *req

	reqCopier.Password = request.ToBase64Query(reqCopier.Password)

	err = c.Client.InvokeAction("CreateUHostInstance", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteIsolationGroupRequest is request schema for DeleteIsolationGroup action
type DeleteIsolationGroupRequest struct {
	request.CommonBase

	// [公共参数] 项目id
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 硬件隔离组id
	GroupId *string `required:"true"`
}

// DeleteIsolationGroupResponse is response schema for DeleteIsolationGroup action
type DeleteIsolationGroupResponse struct {
	response.CommonBase

	// 硬件隔离组id
	GroupId string
}

// NewDeleteIsolationGroupRequest will create request of DeleteIsolationGroup action.
func (c *UHostClient) NewDeleteIsolationGroupRequest() *DeleteIsolationGroupRequest {
	req := &DeleteIsolationGroupRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteIsolationGroup

删除硬件隔离组。
*/
func (c *UHostClient) DeleteIsolationGroup(req *DeleteIsolationGroupRequest) (*DeleteIsolationGroupResponse, error) {
	var err error
	var res DeleteIsolationGroupResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteIsolationGroup", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeImageRequest is request schema for DescribeImage action
type DescribeImageRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 镜像Id
	ImageId *string `required:"false"`

	// 镜像类型。标准镜像：Base，镜像市场：Business， 自定义镜像：Custom，默认返回所有类型
	ImageType *string `required:"false"`

	// 返回数据长度，默认为20
	Limit *int `required:"false"`

	// 列表起始位置偏移量，默认为0
	Offset *int `required:"false"`

	// 操作系统类型：Linux， Windows 默认返回所有类型
	OsType *string `required:"false"`

	// 是否返回价格：1返回，0不返回；默认不返回
	PriceSet *int `required:"false"`
}

// DescribeImageResponse is response schema for DescribeImage action
type DescribeImageResponse struct {
	response.CommonBase

	// 镜像列表详见 UHostImageSet
	ImageSet []UHostImageSet

	// 满足条件的镜像总数
	TotalCount int
}

// NewDescribeImageRequest will create request of DescribeImage action.
func (c *UHostClient) NewDescribeImageRequest() *DescribeImageRequest {
	req := &DescribeImageRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeImage

获取指定数据中心镜像列表，用户可通过指定操作系统类型，镜像Id进行过滤。
*/
func (c *UHostClient) DescribeImage(req *DescribeImageRequest) (*DescribeImageResponse, error) {
	var err error
	var res DescribeImageResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeImage", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeIsolationGroupRequest is request schema for DescribeIsolationGroup action
type DescribeIsolationGroupRequest struct {
	request.CommonBase

	// [公共参数] 项目id
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 待查的硬件隔离组id
	GroupId *string `required:"false"`

	// 返回数据长度，默认为20，最大100
	Limit *int `required:"false"`

	// 列表起始位置偏移量，默认为0
	Offset *int `required:"false"`
}

// DescribeIsolationGroupResponse is response schema for DescribeIsolationGroup action
type DescribeIsolationGroupResponse struct {
	response.CommonBase

	// 硬件隔离组集合。参见数据结构IsolationGroup。
	IsolationGroupSet []IsolationGroup
}

// NewDescribeIsolationGroupRequest will create request of DescribeIsolationGroup action.
func (c *UHostClient) NewDescribeIsolationGroupRequest() *DescribeIsolationGroupRequest {
	req := &DescribeIsolationGroupRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeIsolationGroup

查询硬件隔离组列表。
*/
func (c *UHostClient) DescribeIsolationGroup(req *DescribeIsolationGroupRequest) (*DescribeIsolationGroupResponse, error) {
	var err error
	var res DescribeIsolationGroupResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeIsolationGroup", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeUHostInstanceRequest is request schema for DescribeUHostInstance action
type DescribeUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"true"`

	// 硬件隔离组id。通过硬件隔离组筛选主机。
	IsolationGroup *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	LifeCycle *int `required:"false" deprecated:"true"`

	// 返回数据长度，默认为20，最大100
	Limit *int `required:"false"`

	// 列表起始位置偏移量，默认为0
	Offset *int `required:"false"`

	// 子网id。通过子网筛选主机。北京一地域无效。
	SubnetId *string `required:"false"`

	// 要查询的业务组名称
	Tag *string `required:"false"`

	// 要挂载的云盘id，过滤返回能被UDiskId挂载的云主机。目前主要针对rssd云盘使用
	UDiskIdForAttachment *string `required:"false"`

	// 【数组】UHost主机的资源ID，例如UHostIds.0代表希望获取信息 的主机1，UHostIds.1代表主机2。 如果不传入，则返回当前Region 所有符合条件的UHost实例。
	UHostIds []string `required:"false"`

	// vpc id。通过VPC筛选主机。北京一地域无效。
	VPCId *string `required:"false"`
}

// DescribeUHostInstanceResponse is response schema for DescribeUHostInstance action
type DescribeUHostInstanceResponse struct {
	response.CommonBase

	// UHostInstance总数
	TotalCount int

	// 云主机实例列表，每项参数可见下面 UHostInstanceSet
	UHostSet []UHostInstanceSet
}

// NewDescribeUHostInstanceRequest will create request of DescribeUHostInstance action.
func (c *UHostClient) NewDescribeUHostInstanceRequest() *DescribeUHostInstanceRequest {
	req := &DescribeUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeUHostInstance

获取主机或主机列表信息，并可根据数据中心，主机ID等参数进行过滤。
*/
func (c *UHostClient) DescribeUHostInstance(req *DescribeUHostInstanceRequest) (*DescribeUHostInstanceResponse, error) {
	var err error
	var res DescribeUHostInstanceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeUHostInstance", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeUHostTagsRequest is request schema for DescribeUHostTags action
type DescribeUHostTagsRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

}

// DescribeUHostTagsResponse is response schema for DescribeUHostTags action
type DescribeUHostTagsResponse struct {
	response.CommonBase

	// 业务组集合见 UHostTagSet
	TagSet []UHostTagSet

	// 已有主机的业务组总数
	TotalCount int
}

// NewDescribeUHostTagsRequest will create request of DescribeUHostTags action.
func (c *UHostClient) NewDescribeUHostTagsRequest() *DescribeUHostTagsRequest {
	req := &DescribeUHostTagsRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeUHostTags

获取指定数据中心的业务组列表。
*/
func (c *UHostClient) DescribeUHostTags(req *DescribeUHostTagsRequest) (*DescribeUHostTagsResponse, error) {
	var err error
	var res DescribeUHostTagsResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeUHostTags", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// GetAttachedDiskUpgradePriceRequest is request schema for GetAttachedDiskUpgradePrice action
type GetAttachedDiskUpgradePriceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 磁盘备份方案。枚举值：\\ > NONE，无备份 \\ > DATAARK，数据方舟 \\ 当前磁盘支持的备份模式参考 [[api:uhost-api:disk_type|磁盘类型]]。默认值为当前的备份模式。
	BackupMode *string `required:"false"`

	// 磁盘ID。参见 [DescribeUHostInstance](describe_uhost_instance.html)返回值中的DiskSet。
	DiskId *string `required:"true"`

	// 磁盘大小，单位GB，步长为10。取值范围需大于当前磁盘大小，最大值请参考[[api:uhost-api:disk_type|磁盘类型]]。
	DiskSpace *int `required:"true"`

	// UHost实例ID。 参见 [DescribeUHostInstance](describe_uhost_instance.html)。
	UHostId *string `required:"true"`
}

// GetAttachedDiskUpgradePriceResponse is response schema for GetAttachedDiskUpgradePrice action
type GetAttachedDiskUpgradePriceResponse struct {
	response.CommonBase

	// 升级差价。精度为小数点后2位。
	Price float64
}

// NewGetAttachedDiskUpgradePriceRequest will create request of GetAttachedDiskUpgradePrice action.
func (c *UHostClient) NewGetAttachedDiskUpgradePriceRequest() *GetAttachedDiskUpgradePriceRequest {
	req := &GetAttachedDiskUpgradePriceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: GetAttachedDiskUpgradePrice

获取挂载磁盘的升级价格
*/
func (c *UHostClient) GetAttachedDiskUpgradePrice(req *GetAttachedDiskUpgradePriceRequest) (*GetAttachedDiskUpgradePriceResponse, error) {
	var err error
	var res GetAttachedDiskUpgradePriceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("GetAttachedDiskUpgradePrice", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

/*
getUHostInstancePriceParamDisks is request schema for complex param
*/
type getUHostInstancePriceParamDisks struct {

	// 磁盘备份方案。枚举值：\\ > NONE，无备份 \\ > DATAARK，数据方舟 \\ 当前磁盘支持的备份模式参考 [[api:uhost-api:disk_type|磁盘类型]]
	BackupType *string `required:"false"`

	// 是否是系统盘。枚举值：\\ > True，是系统盘 \\ > False，是数据盘（默认）。Disks数组中有且只能有一块盘是系统盘。
	IsBoot *string `required:"true"`

	// 磁盘大小，单位GB。请参考[[api:uhost-api:disk_type|磁盘类型]]。
	Size *int `required:"true"`

	// 磁盘类型。请参考[[api:uhost-api:disk_type|磁盘类型]]。
	Type *string `required:"true"`
}

// GetUHostInstancePriceRequest is request schema for GetUHostInstancePrice action
type GetUHostInstancePriceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// CPU核数。可选参数：1-64。可选范围参照控制台。默认值: 4
	CPU *int `required:"true"`

	// 计费模式。枚举值为： \\ > Year，按年付费； \\ > Month，按月付费；\\ > Dynamic，按小时付费 \\ 默认为月付。
	ChargeType *string `required:"false"`

	// 购买台数，范围[1,5]
	Count *int `required:"true"`

	// 取值"Intel" "Amd"，默认值“Intel”
	CpuPlatform *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	DiskSpace *int `required:"false" deprecated:"true"`

	//
	Disks []UHostDisk `required:"false"`

	// GPU卡核心数。仅GPU机型支持此字段。
	GPU *int `required:"false"`

	// GPU类型，枚举值["K80", "P40", "V100"]
	GpuType *string `required:"false"`

	// 镜像Id，可通过 [DescribeImage](describe_image.html) 获取镜像ID， 如果镜像ID不传，系统盘大小必传
	ImageId *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	LifeCycle *int `required:"false" deprecated:"true"`

	// 云主机机型（V2版本概念）。枚举值["N", "C", "G", "O"]。参考[[api:uhost-api:uhost_type|云主机机型说明]]。
	MachineType *string `required:"false"`

	// 内存大小。单位：MB。范围 ：[1024, 262144]，取值为1024的倍数（可选范围参照好控制台）。默认值：8192
	Memory *int `required:"true"`

	// 网络增强。枚举值：Normal，不开启; Super，开启网络增强1.0。 默认值为Normal。
	NetCapability *string `required:"false"`

	// 购买时长。默认: 1。按小时购买(Dynamic)时无需此参数。 月付时，此参数传0，代表了购买至月末。
	Quantity *int `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	StorageType *string `required:"false" deprecated:"true"`

	// 【该字段已废弃，请谨慎使用】
	TimemachineFeature *string `required:"false" deprecated:"true"`

	// 【待废弃】云主机机型（V1版本概念）。参考[[api:uhost-api:uhost_type|云主机机型说明]]。
	UHostType *string `required:"false"`
}

// GetUHostInstancePriceResponse is response schema for GetUHostInstancePrice action
type GetUHostInstancePriceResponse struct {
	response.CommonBase

	// 价格列表 UHostPriceSet
	PriceSet []UHostPriceSet
}

// NewGetUHostInstancePriceRequest will create request of GetUHostInstancePrice action.
func (c *UHostClient) NewGetUHostInstancePriceRequest() *GetUHostInstancePriceRequest {
	req := &GetUHostInstancePriceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: GetUHostInstancePrice

根据UHost实例配置，获取UHost实例的价格。
*/
func (c *UHostClient) GetUHostInstancePrice(req *GetUHostInstancePriceRequest) (*GetUHostInstancePriceResponse, error) {
	var err error
	var res GetUHostInstancePriceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("GetUHostInstancePrice", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// GetUHostInstanceVncInfoRequest is request schema for GetUHostInstanceVncInfo action
type GetUHostInstanceVncInfoRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// UHost实例ID 参见 [DescribeUHostInstance](./describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// GetUHostInstanceVncInfoResponse is response schema for GetUHostInstanceVncInfo action
type GetUHostInstanceVncInfoResponse struct {
	response.CommonBase

	// UHost实例ID
	UhostId string

	// Vnc登录IP
	VncIP string

	// Vnc 登录密码
	VncPassword string

	// Vnc登录端口
	VncPort int
}

// NewGetUHostInstanceVncInfoRequest will create request of GetUHostInstanceVncInfo action.
func (c *UHostClient) NewGetUHostInstanceVncInfoRequest() *GetUHostInstanceVncInfoRequest {
	req := &GetUHostInstanceVncInfoRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: GetUHostInstanceVncInfo

获取指定UHost实例的管理VNC配置详细信息。
*/
func (c *UHostClient) GetUHostInstanceVncInfo(req *GetUHostInstanceVncInfoRequest) (*GetUHostInstanceVncInfoResponse, error) {
	var err error
	var res GetUHostInstanceVncInfoResponse

	reqCopier := *req

	err = c.Client.InvokeAction("GetUHostInstanceVncInfo", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// GetUHostUpgradePriceRequest is request schema for GetUHostUpgradePrice action
type GetUHostUpgradePriceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	BootDiskSpace *int `required:"false" deprecated:"true"`

	// 虚拟CPU核数。可选参数：1-64（可选范围参考控制台）。默认值为当前实例的CPU核数。
	CPU *int `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	DiskSpace *int `required:"false" deprecated:"true"`

	// 【该字段已废弃，请谨慎使用】
	HostType *string `required:"false" deprecated:"true"`

	// 内存大小。单位：MB。范围 ：[1024, 262144]，取值为1024的倍数（可选范围参考控制台）。默认值为当前实例的内存大小。
	Memory *int `required:"false"`

	// 网卡升降级（1，表示升级，2表示降级，0表示不变）
	NetCapValue *int `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	TimemachineFeature *string `required:"false" deprecated:"true"`

	// UHost实例ID。 参见 [DescribeUHostInstance](describe_uhost_instance.html)。
	UHostId *string `required:"true"`
}

// GetUHostUpgradePriceResponse is response schema for GetUHostUpgradePrice action
type GetUHostUpgradePriceResponse struct {
	response.CommonBase

	// 规格调整差价。精确到小数点后2位。
	Price float64
}

// NewGetUHostUpgradePriceRequest will create request of GetUHostUpgradePrice action.
func (c *UHostClient) NewGetUHostUpgradePriceRequest() *GetUHostUpgradePriceRequest {
	req := &GetUHostUpgradePriceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: GetUHostUpgradePrice

获取UHost实例升级配置的价格。可选配置范围请参考[[api:uhost-api:uhost_type|云主机机型说明]]。
*/
func (c *UHostClient) GetUHostUpgradePrice(req *GetUHostUpgradePriceRequest) (*GetUHostUpgradePriceResponse, error) {
	var err error
	var res GetUHostUpgradePriceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("GetUHostUpgradePrice", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ImportCustomImageRequest is request schema for ImportCustomImage action
type ImportCustomImageRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 是否授权。必须填true
	Auth *bool `required:"true"`

	// 镜像格式，可选RAW、VHD、VMDK、qcow2
	Format *string `required:"true"`

	// 镜像描述
	ImageDescription *string `required:"false"`

	// 镜像名称
	ImageName *string `required:"true"`

	// 操作系统详细版本，请参考控制台的镜像版本；OsType为Other时，输入参数为Other
	OsName *string `required:"true"`

	// 操作系统平台，比如CentOS、Ubuntu、Windows、RedHat等，请参考控制台的镜像版本；若导入控制台上没有的操作系统，参数为Other
	OsType *string `required:"true"`

	// UFile私有空间地址
	UFileUrl *string `required:"true"`
}

// ImportCustomImageResponse is response schema for ImportCustomImage action
type ImportCustomImageResponse struct {
	response.CommonBase

	// 镜像Id
	ImageId string
}

// NewImportCustomImageRequest will create request of ImportCustomImage action.
func (c *UHostClient) NewImportCustomImageRequest() *ImportCustomImageRequest {
	req := &ImportCustomImageRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: ImportCustomImage

把UFile的镜像文件导入到UHost，生成自定义镜像
*/
func (c *UHostClient) ImportCustomImage(req *ImportCustomImageRequest) (*ImportCustomImageResponse, error) {
	var err error
	var res ImportCustomImageResponse

	reqCopier := *req

	err = c.Client.InvokeAction("ImportCustomImage", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// LeaveIsolationGroupRequest is request schema for LeaveIsolationGroup action
type LeaveIsolationGroupRequest struct {
	request.CommonBase

	// [公共参数] 项目id
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区信息
	// Zone *string `required:"false"`

	// 硬件隔离组id
	GroupId *string `required:"true"`

	// 主机id
	UHostId *string `required:"true"`
}

// LeaveIsolationGroupResponse is response schema for LeaveIsolationGroup action
type LeaveIsolationGroupResponse struct {
	response.CommonBase

	// 主机id
	UHostId string
}

// NewLeaveIsolationGroupRequest will create request of LeaveIsolationGroup action.
func (c *UHostClient) NewLeaveIsolationGroupRequest() *LeaveIsolationGroupRequest {
	req := &LeaveIsolationGroupRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: LeaveIsolationGroup

移除硬件隔离组中的主机
*/
func (c *UHostClient) LeaveIsolationGroup(req *LeaveIsolationGroupRequest) (*LeaveIsolationGroupResponse, error) {
	var err error
	var res LeaveIsolationGroupResponse

	reqCopier := *req

	err = c.Client.InvokeAction("LeaveIsolationGroup", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ModifyUHostIPRequest is request schema for ModifyUHostIP action
type ModifyUHostIPRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写时为默认项目。请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"true"`

	// 需要修改为的 IP 地址。新的IP地址和旧IP地址必须属于统一子网，且和主机内部的配置文件一致。
	PresentIpAddress *string `required:"true"`

	// 所需修改的原 IP 地址 ，当云主机只有一个IP地址时，此参数不必填写。
	PreviousIpAddress *string `required:"false"`

	// 指定云主机 ID。
	UHostId *string `required:"true"`
}

// ModifyUHostIPResponse is response schema for ModifyUHostIP action
type ModifyUHostIPResponse struct {
	response.CommonBase

	// 输出错误的信息
	Message string

	// 目标云主机 ID
	UHostId string
}

// NewModifyUHostIPRequest will create request of ModifyUHostIP action.
func (c *UHostClient) NewModifyUHostIPRequest() *ModifyUHostIPRequest {
	req := &ModifyUHostIPRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: ModifyUHostIP

修改云主机内网 IP 地址
*/
func (c *UHostClient) ModifyUHostIP(req *ModifyUHostIPRequest) (*ModifyUHostIPResponse, error) {
	var err error
	var res ModifyUHostIPResponse

	reqCopier := *req

	err = c.Client.InvokeAction("ModifyUHostIP", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ModifyUHostInstanceNameRequest is request schema for ModifyUHostInstanceName action
type ModifyUHostInstanceNameRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// UHost实例名称
	Name *string `required:"false"`

	// UHost实例ID 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// ModifyUHostInstanceNameResponse is response schema for ModifyUHostInstanceName action
type ModifyUHostInstanceNameResponse struct {
	response.CommonBase

	// UHost实例ID
	UhostId string
}

// NewModifyUHostInstanceNameRequest will create request of ModifyUHostInstanceName action.
func (c *UHostClient) NewModifyUHostInstanceNameRequest() *ModifyUHostInstanceNameRequest {
	req := &ModifyUHostInstanceNameRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: ModifyUHostInstanceName

修改指定UHost实例名称，需要给出数据中心，UHostId，及新的实例名称。
*/
func (c *UHostClient) ModifyUHostInstanceName(req *ModifyUHostInstanceNameRequest) (*ModifyUHostInstanceNameResponse, error) {
	var err error
	var res ModifyUHostInstanceNameResponse

	reqCopier := *req

	err = c.Client.InvokeAction("ModifyUHostInstanceName", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ModifyUHostInstanceRemarkRequest is request schema for ModifyUHostInstanceRemark action
type ModifyUHostInstanceRemarkRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 备注
	Remark *string `required:"false"`

	// UHost实例ID 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// ModifyUHostInstanceRemarkResponse is response schema for ModifyUHostInstanceRemark action
type ModifyUHostInstanceRemarkResponse struct {
	response.CommonBase

	// UHost实例ID
	UhostId string
}

// NewModifyUHostInstanceRemarkRequest will create request of ModifyUHostInstanceRemark action.
func (c *UHostClient) NewModifyUHostInstanceRemarkRequest() *ModifyUHostInstanceRemarkRequest {
	req := &ModifyUHostInstanceRemarkRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: ModifyUHostInstanceRemark

修改指定UHost实例备注信息。
*/
func (c *UHostClient) ModifyUHostInstanceRemark(req *ModifyUHostInstanceRemarkRequest) (*ModifyUHostInstanceRemarkResponse, error) {
	var err error
	var res ModifyUHostInstanceRemarkResponse

	reqCopier := *req

	err = c.Client.InvokeAction("ModifyUHostInstanceRemark", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ModifyUHostInstanceTagRequest is request schema for ModifyUHostInstanceTag action
type ModifyUHostInstanceTagRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 业务组名称
	Tag *string `required:"false"`

	// UHost实例ID 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// ModifyUHostInstanceTagResponse is response schema for ModifyUHostInstanceTag action
type ModifyUHostInstanceTagResponse struct {
	response.CommonBase

	// UHost实例ID
	UhostId string
}

// NewModifyUHostInstanceTagRequest will create request of ModifyUHostInstanceTag action.
func (c *UHostClient) NewModifyUHostInstanceTagRequest() *ModifyUHostInstanceTagRequest {
	req := &ModifyUHostInstanceTagRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: ModifyUHostInstanceTag

修改指定UHost实例业务组标识。
*/
func (c *UHostClient) ModifyUHostInstanceTag(req *ModifyUHostInstanceTagRequest) (*ModifyUHostInstanceTagResponse, error) {
	var err error
	var res ModifyUHostInstanceTagResponse

	reqCopier := *req

	err = c.Client.InvokeAction("ModifyUHostInstanceTag", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// PoweroffUHostInstanceRequest is request schema for PoweroffUHostInstance action
type PoweroffUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// UHost实例ID 参见 [DescribeUHostInstance](./describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// PoweroffUHostInstanceResponse is response schema for PoweroffUHostInstance action
type PoweroffUHostInstanceResponse struct {
	response.CommonBase

	// UHost的实例ID
	UhostId string
}

// NewPoweroffUHostInstanceRequest will create request of PoweroffUHostInstance action.
func (c *UHostClient) NewPoweroffUHostInstanceRequest() *PoweroffUHostInstanceRequest {
	req := &PoweroffUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: PoweroffUHostInstance

直接关闭UHost实例电源，无需等待实例正常关闭。
*/
func (c *UHostClient) PoweroffUHostInstance(req *PoweroffUHostInstanceRequest) (*PoweroffUHostInstanceResponse, error) {
	var err error
	var res PoweroffUHostInstanceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("PoweroffUHostInstance", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// RebootUHostInstanceRequest is request schema for RebootUHostInstance action
type RebootUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 加密盘密码
	DiskPassword *string `required:"false"`

	// UHost实例ID 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// RebootUHostInstanceResponse is response schema for RebootUHostInstance action
type RebootUHostInstanceResponse struct {
	response.CommonBase

	// UHost实例ID
	UhostId string
}

// NewRebootUHostInstanceRequest will create request of RebootUHostInstance action.
func (c *UHostClient) NewRebootUHostInstanceRequest() *RebootUHostInstanceRequest {
	req := &RebootUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: RebootUHostInstance

重新启动UHost实例，需要指定数据中心及UHostID两个参数的值。
*/
func (c *UHostClient) RebootUHostInstance(req *RebootUHostInstanceRequest) (*RebootUHostInstanceResponse, error) {
	var err error
	var res RebootUHostInstanceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("RebootUHostInstance", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ReinstallUHostInstanceRequest is request schema for ReinstallUHostInstance action
type ReinstallUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	BootDiskSpace *int `required:"false" deprecated:"true"`

	// 针对非私有子网主机，可自定义DNS。n可为0-2
	DNSServers []string `required:"false"`

	// 镜像Id，默认使用原镜像 参见 [DescribeImage](describe_image.html)
	ImageId *string `required:"false"`

	// 如果创建UHost实例时LoginMode为Password，则必须填写，如果LoginMode为KeyPair，不需要填写 （密码格式使用BASE64编码；LoginMode不可变更）
	Password *string `required:"false"`

	// 是否保留数据盘，保留：Yes，不报留：No， 默认：Yes
	ReserveDisk *string `required:"false"`

	// 云灾备指明191
	ResourceType *int `required:"false"`

	// UHost实例资源ID 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// ReinstallUHostInstanceResponse is response schema for ReinstallUHostInstance action
type ReinstallUHostInstanceResponse struct {
	response.CommonBase

	// UHost实例资源ID
	UhostId string
}

// NewReinstallUHostInstanceRequest will create request of ReinstallUHostInstance action.
func (c *UHostClient) NewReinstallUHostInstanceRequest() *ReinstallUHostInstanceRequest {
	req := &ReinstallUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: ReinstallUHostInstance

重新安装指定UHost实例的操作系统
*/
func (c *UHostClient) ReinstallUHostInstance(req *ReinstallUHostInstanceRequest) (*ReinstallUHostInstanceResponse, error) {
	var err error
	var res ReinstallUHostInstanceResponse

	reqCopier := *req

	reqCopier.Password = request.ToBase64Query(reqCopier.Password)

	err = c.Client.InvokeAction("ReinstallUHostInstance", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ResetUHostInstancePasswordRequest is request schema for ResetUHostInstancePassword action
type ResetUHostInstancePasswordRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// UHost新密码（密码格式使用BASE64编码）
	Password *string `required:"true"`

	// UHost实例ID
	UHostId *string `required:"true"`
}

// ResetUHostInstancePasswordResponse is response schema for ResetUHostInstancePassword action
type ResetUHostInstancePasswordResponse struct {
	response.CommonBase

	// UHost实例ID
	UhostId string
}

// NewResetUHostInstancePasswordRequest will create request of ResetUHostInstancePassword action.
func (c *UHostClient) NewResetUHostInstancePasswordRequest() *ResetUHostInstancePasswordRequest {
	req := &ResetUHostInstancePasswordRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: ResetUHostInstancePassword

重置UHost实例的管理员密码。
*/
func (c *UHostClient) ResetUHostInstancePassword(req *ResetUHostInstancePasswordRequest) (*ResetUHostInstancePasswordResponse, error) {
	var err error
	var res ResetUHostInstancePasswordResponse

	reqCopier := *req

	reqCopier.Password = request.ToBase64Query(reqCopier.Password)

	err = c.Client.InvokeAction("ResetUHostInstancePassword", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ResizeAttachedDiskRequest is request schema for ResizeAttachedDisk action
type ResizeAttachedDiskRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"true"`

	// 磁盘ID。参见 [DescribeUHostInstance](describe_uhost_instance.html)返回值中的DiskSet。
	DiskId *string `required:"true"`

	// 磁盘大小，单位GB，步长为10。取值范围需大于当前磁盘大小，最大值请参考[[api:uhost-api:disk_type|磁盘类型]]。
	DiskSpace *int `required:"true"`

	// 【该字段已废弃，请谨慎使用】
	DryRun *bool `required:"false" deprecated:"true"`

	// UHost实例ID。 参见 [DescribeUHostInstance](describe_uhost_instance.html)。
	UHostId *string `required:"true"`
}

// ResizeAttachedDiskResponse is response schema for ResizeAttachedDisk action
type ResizeAttachedDiskResponse struct {
	response.CommonBase

	// 改配成功的磁盘id
	DiskId string

	// 【该字段已废弃，请谨慎使用】
	NeedRestart bool `deprecated:"true"`
}

// NewResizeAttachedDiskRequest will create request of ResizeAttachedDisk action.
func (c *UHostClient) NewResizeAttachedDiskRequest() *ResizeAttachedDiskRequest {
	req := &ResizeAttachedDiskRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: ResizeAttachedDisk

修改挂载的磁盘大小，包含系统盘和数据盘
*/
func (c *UHostClient) ResizeAttachedDisk(req *ResizeAttachedDiskRequest) (*ResizeAttachedDiskResponse, error) {
	var err error
	var res ResizeAttachedDiskResponse

	reqCopier := *req

	err = c.Client.InvokeAction("ResizeAttachedDisk", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ResizeUHostInstanceRequest is request schema for ResizeUHostInstance action
type ResizeUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 系统盘大小，单位：GB，范围[20,100]，步长：10，系统盘不支持缩容，因此不允许输入比当前实例系统盘小的值
	BootDiskSpace *int `required:"false"`

	// 虚拟CPU核数，单位：个，范围：[1,16]，最小值为1，其他值是2的倍数，默认值为当前实例的CPU核数（*windows CPU>=2）
	CPU *int `required:"false"`

	// 数据盘大小，单位：GB，范围[10,1000]； SSD机型，单位：GB，范围[100,500]；步长：10，默认值为当前实例的数据盘大小，数据盘不支持缩容，因此不允许输入比当前实例数据盘大小的值
	DiskSpace *int `required:"false"`

	// 内存大小，单位：MB，范围[2048,65536]，步长：2048，默认值为当前实例的内存大小（BGP-C数据中心最小支持1024，限Linux系统）
	Memory *int `required:"false"`

	// 网卡升降级（1，表示升级，2表示降级，0表示不变）
	NetCapValue *int `required:"false"`

	// UHost实例ID 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// ResizeUHostInstanceResponse is response schema for ResizeUHostInstance action
type ResizeUHostInstanceResponse struct {
	response.CommonBase

	// UHost实例ID
	UhostId string
}

// NewResizeUHostInstanceRequest will create request of ResizeUHostInstance action.
func (c *UHostClient) NewResizeUHostInstanceRequest() *ResizeUHostInstanceRequest {
	req := &ResizeUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: ResizeUHostInstance

修改指定UHost实例的资源配置，如CPU核心数，内存容量大小，磁盘空间大小,网络增强等。
*/
func (c *UHostClient) ResizeUHostInstance(req *ResizeUHostInstanceRequest) (*ResizeUHostInstanceResponse, error) {
	var err error
	var res ResizeUHostInstanceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("ResizeUHostInstance", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// StartUHostInstanceRequest is request schema for StartUHostInstance action
type StartUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 加密盘密码
	DiskPassword *string `required:"false"`

	// UHost实例ID 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// StartUHostInstanceResponse is response schema for StartUHostInstance action
type StartUHostInstanceResponse struct {
	response.CommonBase

	// UHost实例ID
	UhostId string
}

// NewStartUHostInstanceRequest will create request of StartUHostInstance action.
func (c *UHostClient) NewStartUHostInstanceRequest() *StartUHostInstanceRequest {
	req := &StartUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: StartUHostInstance

启动处于关闭状态的UHost实例，需要指定数据中心及UHostID两个参数的值。
*/
func (c *UHostClient) StartUHostInstance(req *StartUHostInstanceRequest) (*StartUHostInstanceResponse, error) {
	var err error
	var res StartUHostInstanceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("StartUHostInstance", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// StopUHostInstanceRequest is request schema for StopUHostInstance action
type StopUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// UHost实例ID 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// StopUHostInstanceResponse is response schema for StopUHostInstance action
type StopUHostInstanceResponse struct {
	response.CommonBase

	// UHost实例ID
	UhostId string
}

// NewStopUHostInstanceRequest will create request of StopUHostInstance action.
func (c *UHostClient) NewStopUHostInstanceRequest() *StopUHostInstanceRequest {
	req := &StopUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: StopUHostInstance

指停止处于运行状态的UHost实例，需指定数据中心及UhostID。
*/
func (c *UHostClient) StopUHostInstance(req *StopUHostInstanceRequest) (*StopUHostInstanceResponse, error) {
	var err error
	var res StopUHostInstanceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("StopUHostInstance", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// TerminateCustomImageRequest is request schema for TerminateCustomImage action
type TerminateCustomImageRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 自制镜像ID 参见 [DescribeImage](describe_image.html)
	ImageId *string `required:"true"`
}

// TerminateCustomImageResponse is response schema for TerminateCustomImage action
type TerminateCustomImageResponse struct {
	response.CommonBase

	// 自制镜像Id
	ImageId string
}

// NewTerminateCustomImageRequest will create request of TerminateCustomImage action.
func (c *UHostClient) NewTerminateCustomImageRequest() *TerminateCustomImageRequest {
	req := &TerminateCustomImageRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: TerminateCustomImage

删除用户自定义镜像
*/
func (c *UHostClient) TerminateCustomImage(req *TerminateCustomImageRequest) (*TerminateCustomImageResponse, error) {
	var err error
	var res TerminateCustomImageResponse

	reqCopier := *req

	err = c.Client.InvokeAction("TerminateCustomImage", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// TerminateUHostInstanceRequest is request schema for TerminateUHostInstance action
type TerminateUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	Destroy *int `required:"false" deprecated:"true"`

	// 删除主机时是否释放绑定的EIP。默认为False。
	ReleaseEIP *bool `required:"false"`

	// 删除主机时是否同时删除挂载的数据盘。默认为False。
	ReleaseUDisk *bool `required:"false"`

	// UHost资源Id 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`
}

// TerminateUHostInstanceResponse is response schema for TerminateUHostInstance action
type TerminateUHostInstanceResponse struct {
	response.CommonBase

	// 用于判断主机删除时是否进入回收站。放入回收站:"Yes", 彻底删除：“No”。
	InRecycle string

	// UHost 实例 Id
	UHostId string
}

// NewTerminateUHostInstanceRequest will create request of TerminateUHostInstance action.
func (c *UHostClient) NewTerminateUHostInstanceRequest() *TerminateUHostInstanceRequest {
	req := &TerminateUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: TerminateUHostInstance

删除指定数据中心的UHost实例。
*/
func (c *UHostClient) TerminateUHostInstance(req *TerminateUHostInstanceRequest) (*TerminateUHostInstanceResponse, error) {
	var err error
	var res TerminateUHostInstanceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("TerminateUHostInstance", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// UpgradeToArkUHostInstanceRequest is request schema for UpgradeToArkUHostInstance action
type UpgradeToArkUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"true"`

	// 代金券ID 请参考DescribeCoupon接口
	CouponId *string `required:"false"`

	// UHost主机的资源ID，例如UHostIds.0代表希望升级的主机1，UHostIds.1代表主机2。
	UHostIds []string `required:"true"`
}

// UpgradeToArkUHostInstanceResponse is response schema for UpgradeToArkUHostInstance action
type UpgradeToArkUHostInstanceResponse struct {
	response.CommonBase

	// UHost主机的资源ID数组
	UHostSet []string
}

// NewUpgradeToArkUHostInstanceRequest will create request of UpgradeToArkUHostInstance action.
func (c *UHostClient) NewUpgradeToArkUHostInstanceRequest() *UpgradeToArkUHostInstanceRequest {
	req := &UpgradeToArkUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: UpgradeToArkUHostInstance

普通升级为方舟机型
*/
func (c *UHostClient) UpgradeToArkUHostInstance(req *UpgradeToArkUHostInstanceRequest) (*UpgradeToArkUHostInstanceResponse, error) {
	var err error
	var res UpgradeToArkUHostInstanceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpgradeToArkUHostInstance", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
