// Code is generated by ucloud-model, DO NOT EDIT IT.

package ufile

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud"
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// UpdateBucketRequest is request schema for UpdateBucket action
type UpdateBucketRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// 待修改Bucket的名称
	BucketName *string `required:"true"`

	// Bucket访问类型;public或private
	Type *string `required:"true"`
}

// UpdateBucketResponse is response schema for UpdateBucket action
type UpdateBucketResponse struct {
	response.CommonBase

	// Bucket的ID
	BucketId string

	// Bucket的名称
	BucketName string
}

// NewUpdateBucketRequest will create request of UpdateBucket action.
func (c *UFileClient) NewUpdateBucketRequest() *UpdateBucketRequest {
	req := &UpdateBucketRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// UpdateBucket - 更改Bucket的属性
func (c *UFileClient) UpdateBucket(req *UpdateBucketRequest) (*UpdateBucketResponse, error) {
	var err error
	var res UpdateBucketResponse

	reqCopier := *req
	reqCopier.Region = ucloud.String("")

	err = c.Client.InvokeAction("UpdateBucket", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
