// Copyright (c) 2018 Yandex LLC. All rights reserved.
// Author: Dmitry Novikov <novikoff@yandex-team.ru>

package sdkresolvers

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1"
	ycsdk "github.com/yandex-cloud/go-sdk"
)

type serviceAccountResolver struct {
	BaseNameResolver
}

func ServiceAccountResolver(name string, opts ...ResolveOption) ycsdk.Resolver {
	return &serviceAccountResolver{
		BaseNameResolver: NewBaseNameResolver(name, "service account", opts...),
	}
}

func (r *serviceAccountResolver) Run(ctx context.Context, sdk *ycsdk.SDK, opts ...grpc.CallOption) error {
	err := r.ensureFolderID()
	if err != nil {
		return err
	}

	resp, err := sdk.IAM().ServiceAccount().List(ctx, &iam.ListServiceAccountsRequest{
		FolderId: r.FolderID(),
		Filter:   CreateResolverFilter("name", r.Name),
		PageSize: DefaultResolverPageSize,
	}, opts...)
	return r.findName(resp.GetServiceAccounts(), err)
}
