// Code generated by sdkgen. DO NOT EDIT.

//nolint
package vpc

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	vpc "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1"
)

//revive:disable

// RouteTableServiceClient is a vpc.RouteTableServiceClient with
// lazy GRPC connection initialization.
type RouteTableServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) Create(ctx context.Context, in *vpc.CreateRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) Delete(ctx context.Context, in *vpc.DeleteRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) Get(ctx context.Context, in *vpc.GetRouteTableRequest, opts ...grpc.CallOption) (*vpc.RouteTable, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).Get(ctx, in, opts...)
}

// List implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) List(ctx context.Context, in *vpc.ListRouteTablesRequest, opts ...grpc.CallOption) (*vpc.ListRouteTablesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).List(ctx, in, opts...)
}

type RouteTableIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *RouteTableServiceClient
	request *vpc.ListRouteTablesRequest

	items []*vpc.RouteTable
}

func (c *RouteTableServiceClient) RouteTableIterator(ctx context.Context, folderId string, opts ...grpc.CallOption) *RouteTableIterator {
	return &RouteTableIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &vpc.ListRouteTablesRequest{
			FolderId: folderId,
			PageSize: 1000,
		},
	}
}

func (it *RouteTableIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.RouteTables
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RouteTableIterator) Value() *vpc.RouteTable {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RouteTableIterator) Error() error {
	return it.err
}

// ListOperations implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) ListOperations(ctx context.Context, in *vpc.ListRouteTableOperationsRequest, opts ...grpc.CallOption) (*vpc.ListRouteTableOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).ListOperations(ctx, in, opts...)
}

type RouteTableOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *RouteTableServiceClient
	request *vpc.ListRouteTableOperationsRequest

	items []*operation.Operation
}

func (c *RouteTableServiceClient) RouteTableOperationsIterator(ctx context.Context, routeTableId string, opts ...grpc.CallOption) *RouteTableOperationsIterator {
	return &RouteTableOperationsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &vpc.ListRouteTableOperationsRequest{
			RouteTableId: routeTableId,
			PageSize:     1000,
		},
	}
}

func (it *RouteTableOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RouteTableOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RouteTableOperationsIterator) Error() error {
	return it.err
}

// Move implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) Move(ctx context.Context, in *vpc.MoveRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).Move(ctx, in, opts...)
}

// Update implements vpc.RouteTableServiceClient
func (c *RouteTableServiceClient) Update(ctx context.Context, in *vpc.UpdateRouteTableRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewRouteTableServiceClient(conn).Update(ctx, in, opts...)
}
