// Code is generated by ucloud-model, DO NOT EDIT IT.

package ufile

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// DescribeUFileTokenRequest is request schema for DescribeUFileToken action
type DescribeUFileTokenRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"false"`

	// 0表示显示部分token信息；不传递和其他情况表示显示全部token信息
	Display *int `required:"false"`

	// 令牌ID，只返回指定ID信息，否则拉取所有令牌
	TokenId *string `required:"false"`
}

// DescribeUFileTokenResponse is response schema for DescribeUFileToken action
type DescribeUFileTokenResponse struct {
	response.CommonBase

	// 操作名称
	Action string

	// 令牌描述信息
	DataSet []UFileTokenSet

	// 返回码
	RetCode int
}

// NewDescribeUFileTokenRequest will create request of DescribeUFileToken action.
func (c *UFileClient) NewDescribeUFileTokenRequest() *DescribeUFileTokenRequest {
	req := &DescribeUFileTokenRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// DescribeUFileToken - 获取令牌信息
func (c *UFileClient) DescribeUFileToken(req *DescribeUFileTokenRequest) (*DescribeUFileTokenResponse, error) {
	var err error
	var res DescribeUFileTokenResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeUFileToken", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
