/*
 * 3DS OUTSCALE API
 *
 * Welcome to the 3DS OUTSCALE's API documentation.<br /><br />  The 3DS OUTSCALE API enables you to manage your resources in the 3DS OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the 3DS OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the 3DS OUTSCALE API. You can find a list of the differences [here](https://wiki.outscale.net/display/EN/3DS+OUTSCALE+APIs+Reference).<br /><br />  You can also manage your resources using the [Cockpit](https://wiki.outscale.net/display/EN/About+Cockpit) web interface.
 *
 * API version: 1.2
 * Contact: support@outscale.com
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package osc
// SecurityGroup Information about the security group.
type SecurityGroup struct {
	// The account ID of a user that has been granted permission.
	AccountId string `json:"AccountId,omitempty"`
	// The description of the security group.
	Description string `json:"Description,omitempty"`
	// The inbound rules associated with the security group.
	InboundRules []SecurityGroupRule `json:"InboundRules,omitempty"`
	// The ID of the Net for the security group.
	NetId string `json:"NetId,omitempty"`
	// The outbound rules associated with the security group.
	OutboundRules []SecurityGroupRule `json:"OutboundRules,omitempty"`
	// The ID of the security group.
	SecurityGroupId string `json:"SecurityGroupId,omitempty"`
	// (Public Cloud only) The name of the security group.
	SecurityGroupName string `json:"SecurityGroupName,omitempty"`
	// One or more tags associated with the security group.
	Tags []ResourceTag `json:"Tags,omitempty"`
}
