/*
 * 3DS OUTSCALE API
 *
 * Welcome to the 3DS OUTSCALE's API documentation.<br /><br />  The 3DS OUTSCALE API enables you to manage your resources in the 3DS OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the 3DS OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the 3DS OUTSCALE API. You can find a list of the differences [here](https://wiki.outscale.net/display/EN/3DS+OUTSCALE+APIs+Reference).<br /><br />  You can also manage your resources using the [Cockpit](https://wiki.outscale.net/display/EN/About+Cockpit) web interface.
 *
 * API version: 1.2
 * Contact: support@outscale.com
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package osc
// FiltersSnapshot One or more filters.
type FiltersSnapshot struct {
	// The account aliases of the owners of the snapshots.
	AccountAliases []string `json:"AccountAliases,omitempty"`
	// The account IDs of the owners of the snapshots.
	AccountIds []string `json:"AccountIds,omitempty"`
	// The descriptions of the snapshots.
	Descriptions []string `json:"Descriptions,omitempty"`
	// The account IDs of one or more users who have permissions to create volumes.
	PermissionsToCreateVolumeAccountIds []string `json:"PermissionsToCreateVolumeAccountIds,omitempty"`
	// If `true`, lists all public volumes. If `false`, lists all private volumes.
	PermissionsToCreateVolumeGlobalPermission bool `json:"PermissionsToCreateVolumeGlobalPermission,omitempty"`
	// The progresses of the snapshots, as a percentage.
	Progresses []int32 `json:"Progresses,omitempty"`
	// The IDs of the snapshots.
	SnapshotIds []string `json:"SnapshotIds,omitempty"`
	// The states of the snapshots (`in-queue` \\| `completed` \\| `error`).
	States []string `json:"States,omitempty"`
	// The keys of the tags associated with the snapshots.
	TagKeys []string `json:"TagKeys,omitempty"`
	// The values of the tags associated with the snapshots.
	TagValues []string `json:"TagValues,omitempty"`
	// The key/value combination of the tags associated with the snapshots, in the following format: \"Filters\":{\"Tags\":[\"TAGKEY=TAGVALUE\"]}.
	Tags []string `json:"Tags,omitempty"`
	// The IDs of the volumes used to create the snapshots.
	VolumeIds []string `json:"VolumeIds,omitempty"`
	// The sizes of the volumes used to create the snapshots, in gibibytes (GiB).
	VolumeSizes []int32 `json:"VolumeSizes,omitempty"`
}
