---
title: v1.31.0
weight: 998969000
---

## Updating an Ansible Operator to use the updated Ansible 2.15.0 image

1. Update the `FROM` directive in the `Dockerfile` to have a version tag > `v1.30.0`
2. Evaluate your dependency requirements. The change to Ansible 2.15.0 also included removal of some pre-installed Python modules. You may need to update your `Dockerfile` to `pip install` modules required by your operator.

_See [#6483](https://github.com/operator-framework/operator-sdk/pull/6483) for more details._

## Upgrading an Ansible Operator project to match the latest `ansible/v1` plugin changes

1. In the `requirements.yml` file:
    - Remove the `community.kubernetes` collection entry
    - Update the version of the `operator_sdk.util` collection entry to `v0.5.0`
2. In the `molecule/kind/molecule.yml` and `molecule/default/molecule.yml` files:
    - Remove all instances of the `lint` field. For an example of the diff, see: https://github.com/operator-framework/operator-sdk/pull/6483/files#diff-f159b0d7ec17de90f5b5c297ce997254e6ea4001269167be25615c45c489539e

_See [#6483](https://github.com/operator-framework/operator-sdk/pull/6483) for more details._

## Migrating away from the `quay.io/operator-framework/ansible-operator-2.11-preview` base image

1. Update the `FROM` directive in the `Dockerfile` to use the base image `quay.io/operator-framework/ansible-operator:vX.Y.Z` where `vX.Y.Z` is > `v1.30.0`

_See [#6483](https://github.com/operator-framework/operator-sdk/pull/6483) for more details._

## Require `watch` on `secrets`

The operator now requires the watch operation on secrets.
When using a custom ServiceAccount for deployment, the following additional role is now required:
```
rules:
  - apiGroups:
      - ""
    resources:
      - secrets
    verbs:
      - watch
```

_See [#6354](https://github.com/operator-framework/operator-sdk/pull/6354) for more details._
