---
title: v1.25.0
weight: 998975000
---

## Kubebuilder bump brought changes that modified the `Makefile` scaffolding and also `multiarch` changes are also included.

1. Makefile content is updated as shown below.

    ```sh
        `KUBEBUILDER_ASSETS="$(shell $(ENVTEST) use $(ENVTEST_K8S_VERSION) --bin-dir $(LOCALBIN) -p path)" go test ./... -coverprofile cover.out`,
    ```

2. Add support for building binary in multiple platforms.

    Add the below content to the Makefile.

    ```sh
    # PLATFORMS defines the target platforms for  the manager image be build to provide support to multiple
    # architectures. (i.e. make docker-buildx IMG=myregistry/mypoperator:0.0.1). To use this option you need to:
    # - able to use docker buildx . More info: https://docs.docker.com/build/buildx/
    # - have enable BuildKit, More info: https://docs.docker.com/develop/develop-images/build_enhancements/
    # - be able to push the image for your registry (i.e. if you do not inform a valid value via IMG=<myregistry/image:<tag>> than the export will fail)
    # To properly provided solutions that supports more than one platform you should use this option.
    PLATFORMS ?= linux/arm64,linux/amd64,linux/s390x,linux/ppc64le
    .PHONY: docker-buildx
    docker-buildx: test ## Build and push docker image for the manager for cross-platform support
        # copy existing Dockerfile and insert --platform=${BUILDPLATFORM} into Dockerfile.cross, and preserve the original Dockerfile
        sed -e '1 s/\(^FROM\)/FROM --platform=\$$\{BUILDPLATFORM\}/; t' -e ' 1,// s//FROM --platform=\$$\{BUILDPLATFORM\}/' Dockerfile > Dockerfile.cross
        - docker buildx create --name project-v3-builder
        docker buildx use project-v3-builder
        - docker buildx build --push --platform=$(PLATFORMS) --tag ${IMG} -f Dockerfile.cross
        - docker buildx rm project-v3-builder
        rm Dockerfile.cross
    ```

3. (go/v3) Bump dependencies in go.mod file

    ```go
        go 1.19   

      	github.com/onsi/ginkgo/v2 v2.1.4
        github.com/onsi/gomega v1.19.0
        github.com/prometheus/client_golang v1.12.2
        k8s.io/api v0.25.0
        k8s.io/apimachinery v0.25.0
        k8s.io/client-go v0.25.0
        sigs.k8s.io/controller-runtime v0.13.0
    ```

4. (go/v3) Update `controller-tools` from `0.9.2` to `0.10.0`. 

   In the `Makefile` file, replace `CONTROLLER_TOOLS_VERSION ?= v0.9.2` with `CONTROLLER_TOOLS_VERSION ?= v0.10.0`

_See [#6047](https://github.com/operator-framework/operator-sdk/pull/6047) for more details._

## For multi-arch build support, add docker-buildx target to project Makefile

In the project `Makefile` below the `docker-push` target add the new `docker-buildx`
target.

```sh
# PLATFORMS defines the target platforms for  the manager image be build to provide support to multiple
# architectures. (i.e. make docker-buildx IMG=myregistry/mypoperator:0.0.1). To use this option you need to:
# - able to use docker buildx . More info: https://docs.docker.com/build/buildx/
# - have enable BuildKit, More info: https://docs.docker.com/develop/develop-images/build_enhancements/
# - be able to push the image for your registry (i.e. if you do not inform a valid value via IMG=<myregistry/image:<tag>> than the export will fail)
# To properly provided solutions that supports more than one platform you should use this option.
PLATFORMS ?= linux/arm64,linux/amd64,linux/s390x,linux/ppc64le
.PHONY: docker-buildx
docker-buildx: test ## Build and push docker image for the manager for cross-platform support
	# copy existing Dockerfile and insert --platform=${BUILDPLATFORM} into Dockerfile.cross, and preserve the original Dockerfile
	sed -e '1 s/\(^FROM\)/FROM --platform=\$$\{BUILDPLATFORM\}/; t' -e ' 1,// s//FROM --platform=\$$\{BUILDPLATFORM\}/' Dockerfile > Dockerfile.cross
	- docker buildx create --name project-v3-builder
	docker buildx use project-v3-builder
	- docker buildx build --push --platform=$(PLATFORMS) --tag ${IMG} -f Dockerfile.cross
	- docker buildx rm project-v3-builder
	rm Dockerfile.cross
```

_See [#6093](https://github.com/operator-framework/operator-sdk/pull/6093) for more details._
