---
title: v1.23.0
weight: 998977000
---

## For Hybrid Helm (hybrid.helm/v1-alpha) language based operators - Bump Dockerfile Go version to 1.18

In the `Dockerfile`, replace the line `FROM golang:1.17 as builder` with `FROM golang:1.18 as builder`

_See [#5772](https://github.com/operator-framework/operator-sdk/pull/5772) for more details._

## (go/v3) Fix Makefile targets to not download binaries when they are found already

Update the Makefile targets by adding `test -s $(LOCALBIN)/<binary-name> ||` before the instruction to download them, see:

```sh
KUSTOMIZE_INSTALL_SCRIPT ?= "https://raw.githubusercontent.com/kubernetes-sigs/kustomize/master/hack/install_kustomize.sh"
.PHONY: kustomize
kustomize: $(KUSTOMIZE) ## Download kustomize locally if necessary.
$(KUSTOMIZE): $(LOCALBIN)
	test -s $(LOCALBIN)/kustomize || { curl -s $(KUSTOMIZE_INSTALL_SCRIPT) | bash -s -- $(subst v,,$(KUSTOMIZE_VERSION)) $(LOCALBIN); }

.PHONY: controller-gen
controller-gen: $(CONTROLLER_GEN) ## Download controller-gen locally if necessary.
$(CONTROLLER_GEN): $(LOCALBIN)
	test -s $(LOCALBIN)/controller-gen || GOBIN=$(LOCALBIN) go install sigs.k8s.io/controller-tools/cmd/controller-gen@$(CONTROLLER_TOOLS_VERSION)

.PHONY: envtest
envtest: $(ENVTEST) ## Download envtest-setup locally if necessary.
$(ENVTEST): $(LOCALBIN)
	test -s $(LOCALBIN)/setup-envtest || GOBIN=$(LOCALBIN) go install sigs.k8s.io/controller-runtime/tools/setup-envtest@latest
```

_See [#5965](https://github.com/operator-framework/operator-sdk/pull/5965) for more details._

## (go/v3) Update `controller-tools` from `0.9.0` to `0.9.2`.

In the `Makefile` file, replace `CONTROLLER_TOOLS_VERSION ?= v0.9.0` with `CONTROLLER_TOOLS_VERSION ?= v0.9.2`

_See [#5965](https://github.com/operator-framework/operator-sdk/pull/5965) for more details._

## (go/v3) Update `controller-runtime` from `v0.12.1` to `v0.12.2` and Kubernetes dependencies from `v0.24.0` to `v0.24.2`.

In the `go.mod` file, ensure the following dependencies versions and run `go mod tidy`:

```go
k8s.io/api v0.24.2
k8s.io/apimachinery v0.24.2
k8s.io/client-go v0.24.2
sigs.k8s.io/controller-runtime v0.12.2
```

_See [#5965](https://github.com/operator-framework/operator-sdk/pull/5965) for more details._

## Upgrade kube proxy image `gcr.io/kubebuilder/kube-rbac-proxy` from `v0.11.0` to `v0.13.0`

In the `config/default/manager_auth_proxy_patch.yaml` file, replace `gcr.io/kubebuilder/kube-rbac-proxy:0.11.0` with `gcr.io/kubebuilder/kube-rbac-proxy:0.13.0`

_See [#5903](https://github.com/operator-framework/operator-sdk/pull/5903) and [#5965](https://github.com/operator-framework/operator-sdk/pull/5965) for more details._


## (ansible/v1,helm/v1) Upgrade kustomize versions from `v3.8.7` to `v4.5.5`

Upgrade kustomize versions from `v3.8.7` to `v4.5.5`

**WARNING** If your project has customizations using kustomize you might be impacted by them. See its [Release Notes](https://github.com/kubernetes-sigs/kustomize/releases/tag/kustomize%2Fv4.0.0). (Note all changes are covered by its docs)
- Update the kustomize version in your Makefile: ensure that the value used for `KUSTOMIZE_VERSION` is `v4.5.5`

- In the `config/default/kustomization.yaml` file:
   a) Replace:
   ```yaml
   #commonLabels:
   #  someName: someValue
   ```

   With:
   ```yaml
   #labels:
   #- includeSelectors: true
   #  pairs:
   #    someName: someValue
   ```

   b) Replace: `bases:` With: `resources:`

**(Valid Only for Ansible Projects)**
- In the molecule/default, replace `--load_restrictor none .` with `--load-restrictor LoadRestrictionsNone`

_See [#5965](https://github.com/operator-framework/operator-sdk/pull/5965) for more details._
