---
title: v1.22.0
weight: 998978000
---

## For Ansible-based language operators, upgrade `community.kubernetes` from `1.2.1` to `2.0.1`.

**IMPORTANT** The `community.kubernetes` collection is being renamed to `kubernetes.core`. As of version 2.0.0, the collection has been replaced by deprecated redirects for all content to kubernetes.core. If you are using FQCNs starting with `community.kubernetes`, please update them to `kubernetes.core`.
Ensure that you check the [community.kubernetes changelog](https://github.com/ansible-collections/community.kubernetes/blob/main/CHANGELOG.rst) to verify if your Operator code must be updated and it is affected by the MAJOR changes.

In the `requirements.yml` file:

Replace:

```yaml
collections:
  - name: community.kubernetes
    version: "1.2.1"
```

With:

```yaml
collections:
  - name: community.kubernetes
    version: "2.0.1"
```

_See [#5846](https://github.com/operator-framework/operator-sdk/pull/5846) for more details._

## For Ansible-based language operators, upgrade `kubernetes.core` from `2.2.0` to `2.3.1`.

Ensure that you check the [kubernetes.core changelog](https://github.com/ansible-collections/kubernetes.core/blob/main/CHANGELOG.rst) to verify if your Operator code must be updated and it is affected by the MAJOR changes.

In the `requirements.yml` file:

Replace:

```yaml
collections:
  ...
  - name: kubernetes.core
    version: "2.2.0"
```

With:

```yaml
collections:
  ...
  - name: kubernetes.core
    version: "2.3.1"
```

_See [#5846](https://github.com/operator-framework/operator-sdk/pull/5846) for more details._

## For Ansible-based language operators, upgrade `cloud.common` from `2.2.0` to `2.2.1`.

In the `requirements.yml` file:

Replace:

```ymal
collections:
  ...
  - name: cloud.common
    version: "2.1.0"
```

With:

```ymal
collections:
  ...
  - name: cloud.common
    version: "2.1.1"
```

_See [#5846](https://github.com/operator-framework/operator-sdk/pull/5846) for more details._

## Go (go/v3) and Helm Hybrid (hybrid.helm/v1-alpha) language based operators - Upgrade Kubernetes dependencies from `1.23` to `1.24` and controller-gen from `v0.8.0` to `v0.9.0`

To update your project to support Kubernetes 1.24:

1. In `go.mod`:

- Replace `k8s.io/api v0.23.5` with `k8s.io/api v0.24.0`
- Replace `k8s.io/apimachinery v0.23.5` with  `k8s.io/apimachinery v0.24.0`
- Replace `k8s.io/client-go v0.23.5` with `k8s.io/client-go v0.24.0`
- Replace `sigs.k8s.io/controller-runtime v0.11.2` with `sigs.k8s.io/controller-runtime v0.12.1`
- Hybrid Helm (hybrid) only: Replace `github.com/operator-framework/helm-operator-plugins v0.0.11` with `github.com/operator-framework/helm-operator-plugins v0.0.12-0.20220608155702-d3967d2ae2ac`

2. Run `go mod tidy` to ensure all dependencies are upgraded

3. In `Makefile`:
- Replace `CONTROLLER_TOOLS_VERSION ?= 0.8.0` with `CONTROLLER_TOOLS_VERSION ?= 0.9.0`
- Replace `ENVTEST_K8S_VERSION = 1.23` with `ENVTEST_K8S_VERSION = 1.24`

4. Run `make` to run all make targets

_See [#5843](https://github.com/operator-framework/operator-sdk/pull/5843) for more details._

## Go (go/v3) and Hybrid Helm (hybrid.helm/v1-alpha) language based operators - Add support for Go 1.18

To update your project to use Go 1.18:

1. In the `go.mod` file:

- Replace `go 1.17` with `go 1.18`   

2. Run `go mod tidy` to ensure all dependencies are upgraded

_See [#5843](https://github.com/operator-framework/operator-sdk/pull/5843) for more details._

## For Go (go/v3, go/v2), Ansible (ansible/v1), Helm (helm/v1), and Helm Hybrid (hybrid.helm/v1-alpha) language based operators - Bump OPM version from `v1.19.1` to `v1.23.0` [More info](https://github.com/operator-framework/operator-registry/releases)

To update your project to use OPM `v1.23.0`:

1. In the `Makefile`:

- Replace `curl -sSLo $(OPM) https://github.com/operator-framework/operator-registry/releases/download/v1.19.1/$${OS}-$${ARCH}-opm` with `curl -sSLo $(OPM) https://github.com/operator-framework/operator-registry/releases/download/v1.23.0/$${OS}-$${ARCH}-opm`   

2. Run `make opm`

_See [#5843](https://github.com/operator-framework/operator-sdk/pull/5843) for more details._
