---
title: v1.18.0
weight: 998982000
---

## Bumped java-operator-plugins to v0.2.0

Additions:

    - chore: bump go 1.17, k8s 1.23, and kubebuilder 3.3
    - chore(deps): update to Quarkus SDK extension 3.0.2 and Quarkus 2.6.3
    - chore(deps): update to use Quarkus JOSDK extension 3.0.1
    - Remove useless file
    - chore: bump k8s 1.22.2 and kubebuilder 3.2
    - exposed exnpoints for micrometer metrics
    - modified the Quarkus operator SDK version and tutorial too
    - chore: bump fabric8 5.8.0 & quarkus 2.4.0
    - modified the doc file and removed file after generation
    - release: fix release script to understand release branches

Bug Fixes:

    - Fix for wrongly generated file name

_See [#5542](https://github.com/operator-framework/operator-sdk/pull/5542) for more details._

## Support image digests instead of tags

Add following variables to your project's `Makefile` below the `BUNDLE_IMG ?=`.

```
# BUNDLE_GEN_FLAGS are the flags passed to the operator-sdk generate bundle command
BUNDLE_GEN_FLAGS ?= -q --overwrite --version $(VERSION) $(BUNDLE_METADATA_OPTS)

# USE_IMAGE_DIGESTS defines if images are resolved via tags or digests
# You can enable this value if you would like to use SHA Based Digests
# To enable set flag to true
USE_IMAGE_DIGESTS ?= false
ifeq ($(USE_IMAGE_DIGESTS), true)
    BUNDLE_GEN_FLAGS += --use-image-digests
endif
```

Using the YAML string '|' operator means that newlines in this string will
Then in the `bundle` target we want to replace the flags passed to
`generate bundle` with a reference to the `BUNDLE_GEN_FLAGS` above.

The `generate bundle` line should look like this

```
$(KUSTOMIZE) build config/manifests | operator-sdk generate bundle $(BUNDLE_GEN_FLAGS)
```

For reference the *PREVIOUS* version looked as follows

```
$(KUSTOMIZE) build config/manifests | operator-sdk generate bundle -q --overwrite --version $(VERSION) $(BUNDLE_METADATA_OPTS)
```

_See [#5567](https://github.com/operator-framework/operator-sdk/pull/5567) for more details._

## Add requirement cloud.common for Ansible-based operators

Add the following line in `requirements.go` when using operator ansible sdk:
```
- name: cloud.common
  version: "2.1.0"
```

_See [#5505](https://github.com/operator-framework/operator-sdk/pull/5505) for more details._
