---
title: v1.11.0
weight: 998989000
---

## (optional) Add local Ansible Roles path to Env in `make run`

If you would like to run your operator locally using `make run`, modify the `run` target in the `Makefile` to: `ANSIBLE_ROLES_PATH="$(ANSIBLE_ROLES_PATH):$(shell pwd)/roles" $(ANSIBLE_OPERATOR) run`

_See [#5118](https://github.com/operator-framework/operator-sdk/pull/5118) for more details._

## (go/v3) Export `KUBEBUILDER_ASSETS` in `Makefile`

In `go/v3` projects, after installing `setup-envtest` binary, the path to `KUBEBUILDER_ASSETS` needs to be exported. In `Makefile`, add the following:

  ```diff
    +# ENVTEST_K8S_VERSION refers to the version of kubebuilder assets to be downloaded by envtest binary.
    +ENVTEST_K8S_VERSION = 1.21

    test: manifests generate fmt vet envtest ## Run tests.
    - go test ./... -coverprofile cover.out
    + KUBEBUILDER_ASSETS="$(shell $(ENVTEST) use $(ENVTEST_K8S_VERSION) -p path)" go test ./... -coverprofile cover.out
  ```

_See [#4863](https://github.com/operator-framework/operator-sdk/pull/4863) for more details._

## (go/v3, ansible/v1, helm/v1) Add `containerPort` protocol field in manifests.

In `go/v3`, `ansible/v1`, `helm/v1` projects, specify the `containerPort` protocol in the following files: - `config/default/manager_auth_proxy_patch.yaml` - `config/rbac/auth_proxy_service.yaml`
```diff
  ports:
 - containerPort: 8443
 + protocol: TCP
   name: https
```
Additionally, in `go/v3` projects, add the `containerPort` protocol to `config/webhook/service.yaml`:
```diff
   ports:
    - port: 443
    + protocol: TCP
      targetPort: 9443
```

_See [#4863](https://github.com/operator-framework/operator-sdk/pull/4863) for more details._

## (go/v3, ansible/v1, helm/v1) Increase resource limits for controller manager.

In `go/v3`, `ansible/v1`, `helm/v1` projects, increase the `cpu` and `memory` resource limits to `200m` and `100Mi` respectively in `config/manager/manager.yaml`.
```diff
  resources:
   limits:
    - cpu: 100m
    - memory: 30Mi
    + cpu: 200m
    + memory: 100Mi
```

_See [#4863](https://github.com/operator-framework/operator-sdk/pull/4863) for more details._
