## v1.38.0

### Changes

- For Go-based, Helm-based and Ansible-based operators this release moves to Kubernetes 1.30 API's and Kubebuilder v4 Scaffolding, specifically utilizing the v4.1.1 version. The update to Kubebuiler results in some scaffolding changes which more information can be found below: - Discontinue usage of [kube-rbac-proxy](https://github.com/brancz/kube-rbac-proxy) in the default scaffolding of new projects. For further information, see: [Action Required: Ensure that you no longer use gcr.io/kubebuilder images](https://github.com/kubernetes-sigs/kubebuilder/discussions/3907) - The `go/v2` or `go/v3` layouts have been removed, you must upgrade to `go/v4` to be compatible with this release and future updates. To know how to upgrade,check the [migration documentation](https://book.kubebuilder.io/migration/v3vsv4). - Re-introduces authn/authz protection for the metrics endpoint using [`WithAuthenticationAndAuthorization`](https://github.com/kubernetes-sigs/controller-runtime/blob/v0.18.4/pkg/metrics/filters/filters.go#L35)  provided by controller-runtime instead of kube-rbac-proxy; which usage was [discontinued in the project](https://github.com/kubernetes-sigs/kubebuilder/discussions/3907).  Please, ensure that you no longer use the image `gcr.io/kubebuilder/kube-rbac-proxy`. Images provided under `gcr.io/kubebuilder/` will be unavailable from **March 18, 2025**. To learn more about any of the metrics changes please look at the Kubebuilder book [metrics](https://book.kubebuilder.io/reference/metrics) page.
For `Helm-based` and `Ansible-based` operators, a new flag called `metrics-require-rbac` was introduced into the runtime/binary, to control adding  [`WithAuthenticationAndAuthorization`](https://github.com/kubernetes-sigs/controller-runtime/blob/v0.18.4/pkg/metrics/filters/filters.go#L35) to `Metrics.FilterProvider` of controller-runtime. This was done to ensure forwards and backwards compatibility of the binary and images with any scaffolded content. ([#6862](https://github.com/operator-framework/operator-sdk/pull/6862))

### Bug Fixes

- An additional condition is included for matching `apiVersion` of example CRs with CRD `version` when searching for the CRD in the CSV.  Previously, The `olm-spec-descriptors` scorecard test failed when multiple versions of CRD is included in the CSV.  The CR specified in `alm-examples` annotations are validated only against the first matched CRD (by name), which is incorrect.  This ensures the correct CRD version is selected for validations. ([#6784](https://github.com/operator-framework/operator-sdk/pull/6784))
- Fix naive YAML split in `run bundle` command. ([#6829](https://github.com/operator-framework/operator-sdk/pull/6829))
