package bitmap

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestRMask(t *testing.T) {

	ta := require.New(t)

	cases := []struct {
		want string
	}{
		{"1111111111111111111111111111111111111111111111111111111111111111"},
		{"1111111111111111111111111111111111111111111111111111111111111110"},
		{"1111111111111111111111111111111111111111111111111111111111111100"},
		{"1111111111111111111111111111111111111111111111111111111111111000"},
		{"1111111111111111111111111111111111111111111111111111111111110000"},
		{"1111111111111111111111111111111111111111111111111111111111100000"},
		{"1111111111111111111111111111111111111111111111111111111111000000"},
		{"1111111111111111111111111111111111111111111111111111111110000000"},
		{"1111111111111111111111111111111111111111111111111111111100000000"},
		{"1111111111111111111111111111111111111111111111111111111000000000"},
		{"1111111111111111111111111111111111111111111111111111110000000000"},
		{"1111111111111111111111111111111111111111111111111111100000000000"},
		{"1111111111111111111111111111111111111111111111111111000000000000"},
		{"1111111111111111111111111111111111111111111111111110000000000000"},
		{"1111111111111111111111111111111111111111111111111100000000000000"},
		{"1111111111111111111111111111111111111111111111111000000000000000"},
		{"1111111111111111111111111111111111111111111111110000000000000000"},
		{"1111111111111111111111111111111111111111111111100000000000000000"},
		{"1111111111111111111111111111111111111111111111000000000000000000"},
		{"1111111111111111111111111111111111111111111110000000000000000000"},
		{"1111111111111111111111111111111111111111111100000000000000000000"},
		{"1111111111111111111111111111111111111111111000000000000000000000"},
		{"1111111111111111111111111111111111111111110000000000000000000000"},
		{"1111111111111111111111111111111111111111100000000000000000000000"},
		{"1111111111111111111111111111111111111111000000000000000000000000"},
		{"1111111111111111111111111111111111111110000000000000000000000000"},
		{"1111111111111111111111111111111111111100000000000000000000000000"},
		{"1111111111111111111111111111111111111000000000000000000000000000"},
		{"1111111111111111111111111111111111110000000000000000000000000000"},
		{"1111111111111111111111111111111111100000000000000000000000000000"},
		{"1111111111111111111111111111111111000000000000000000000000000000"},
		{"1111111111111111111111111111111110000000000000000000000000000000"},
		{"1111111111111111111111111111111100000000000000000000000000000000"},
		{"1111111111111111111111111111111000000000000000000000000000000000"},
		{"1111111111111111111111111111110000000000000000000000000000000000"},
		{"1111111111111111111111111111100000000000000000000000000000000000"},
		{"1111111111111111111111111111000000000000000000000000000000000000"},
		{"1111111111111111111111111110000000000000000000000000000000000000"},
		{"1111111111111111111111111100000000000000000000000000000000000000"},
		{"1111111111111111111111111000000000000000000000000000000000000000"},
		{"1111111111111111111111110000000000000000000000000000000000000000"},
		{"1111111111111111111111100000000000000000000000000000000000000000"},
		{"1111111111111111111111000000000000000000000000000000000000000000"},
		{"1111111111111111111110000000000000000000000000000000000000000000"},
		{"1111111111111111111100000000000000000000000000000000000000000000"},
		{"1111111111111111111000000000000000000000000000000000000000000000"},
		{"1111111111111111110000000000000000000000000000000000000000000000"},
		{"1111111111111111100000000000000000000000000000000000000000000000"},
		{"1111111111111111000000000000000000000000000000000000000000000000"},
		{"1111111111111110000000000000000000000000000000000000000000000000"},
		{"1111111111111100000000000000000000000000000000000000000000000000"},
		{"1111111111111000000000000000000000000000000000000000000000000000"},
		{"1111111111110000000000000000000000000000000000000000000000000000"},
		{"1111111111100000000000000000000000000000000000000000000000000000"},
		{"1111111111000000000000000000000000000000000000000000000000000000"},
		{"1111111110000000000000000000000000000000000000000000000000000000"},
		{"1111111100000000000000000000000000000000000000000000000000000000"},
		{"1111111000000000000000000000000000000000000000000000000000000000"},
		{"1111110000000000000000000000000000000000000000000000000000000000"},
		{"1111100000000000000000000000000000000000000000000000000000000000"},
		{"1111000000000000000000000000000000000000000000000000000000000000"},
		{"1110000000000000000000000000000000000000000000000000000000000000"},
		{"1100000000000000000000000000000000000000000000000000000000000000"},
		{"1000000000000000000000000000000000000000000000000000000000000000"},
		{"0000000000000000000000000000000000000000000000000000000000000000"},
	}

	for i, c := range cases {
		got := fmt.Sprintf("%064b", RMask[i])
		ta.Equal(c.want, got, "%d-th: case: %+v", i+1, c)

		// RMaskUpto[i-1] == RMask[i]
		if i > 0 {
			got := fmt.Sprintf("%064b", RMaskUpto[i-1])
			ta.Equal(c.want, got, "%d-th: case: %+v", i+1, c)
		}
	}
}

func TestMask(t *testing.T) {

	ta := require.New(t)

	cases := []struct {
		want string
	}{
		{"0000000000000000000000000000000000000000000000000000000000000000"},
		{"0000000000000000000000000000000000000000000000000000000000000001"},
		{"0000000000000000000000000000000000000000000000000000000000000011"},
		{"0000000000000000000000000000000000000000000000000000000000000111"},
		{"0000000000000000000000000000000000000000000000000000000000001111"},
		{"0000000000000000000000000000000000000000000000000000000000011111"},
		{"0000000000000000000000000000000000000000000000000000000000111111"},
		{"0000000000000000000000000000000000000000000000000000000001111111"},
		{"0000000000000000000000000000000000000000000000000000000011111111"},
		{"0000000000000000000000000000000000000000000000000000000111111111"},
		{"0000000000000000000000000000000000000000000000000000001111111111"},
		{"0000000000000000000000000000000000000000000000000000011111111111"},
		{"0000000000000000000000000000000000000000000000000000111111111111"},
		{"0000000000000000000000000000000000000000000000000001111111111111"},
		{"0000000000000000000000000000000000000000000000000011111111111111"},
		{"0000000000000000000000000000000000000000000000000111111111111111"},
		{"0000000000000000000000000000000000000000000000001111111111111111"},
		{"0000000000000000000000000000000000000000000000011111111111111111"},
		{"0000000000000000000000000000000000000000000000111111111111111111"},
		{"0000000000000000000000000000000000000000000001111111111111111111"},
		{"0000000000000000000000000000000000000000000011111111111111111111"},
		{"0000000000000000000000000000000000000000000111111111111111111111"},
		{"0000000000000000000000000000000000000000001111111111111111111111"},
		{"0000000000000000000000000000000000000000011111111111111111111111"},
		{"0000000000000000000000000000000000000000111111111111111111111111"},
		{"0000000000000000000000000000000000000001111111111111111111111111"},
		{"0000000000000000000000000000000000000011111111111111111111111111"},
		{"0000000000000000000000000000000000000111111111111111111111111111"},
		{"0000000000000000000000000000000000001111111111111111111111111111"},
		{"0000000000000000000000000000000000011111111111111111111111111111"},
		{"0000000000000000000000000000000000111111111111111111111111111111"},
		{"0000000000000000000000000000000001111111111111111111111111111111"},
		{"0000000000000000000000000000000011111111111111111111111111111111"},
		{"0000000000000000000000000000000111111111111111111111111111111111"},
		{"0000000000000000000000000000001111111111111111111111111111111111"},
		{"0000000000000000000000000000011111111111111111111111111111111111"},
		{"0000000000000000000000000000111111111111111111111111111111111111"},
		{"0000000000000000000000000001111111111111111111111111111111111111"},
		{"0000000000000000000000000011111111111111111111111111111111111111"},
		{"0000000000000000000000000111111111111111111111111111111111111111"},
		{"0000000000000000000000001111111111111111111111111111111111111111"},
		{"0000000000000000000000011111111111111111111111111111111111111111"},
		{"0000000000000000000000111111111111111111111111111111111111111111"},
		{"0000000000000000000001111111111111111111111111111111111111111111"},
		{"0000000000000000000011111111111111111111111111111111111111111111"},
		{"0000000000000000000111111111111111111111111111111111111111111111"},
		{"0000000000000000001111111111111111111111111111111111111111111111"},
		{"0000000000000000011111111111111111111111111111111111111111111111"},
		{"0000000000000000111111111111111111111111111111111111111111111111"},
		{"0000000000000001111111111111111111111111111111111111111111111111"},
		{"0000000000000011111111111111111111111111111111111111111111111111"},
		{"0000000000000111111111111111111111111111111111111111111111111111"},
		{"0000000000001111111111111111111111111111111111111111111111111111"},
		{"0000000000011111111111111111111111111111111111111111111111111111"},
		{"0000000000111111111111111111111111111111111111111111111111111111"},
		{"0000000001111111111111111111111111111111111111111111111111111111"},
		{"0000000011111111111111111111111111111111111111111111111111111111"},
		{"0000000111111111111111111111111111111111111111111111111111111111"},
		{"0000001111111111111111111111111111111111111111111111111111111111"},
		{"0000011111111111111111111111111111111111111111111111111111111111"},
		{"0000111111111111111111111111111111111111111111111111111111111111"},
		{"0001111111111111111111111111111111111111111111111111111111111111"},
		{"0011111111111111111111111111111111111111111111111111111111111111"},
		{"0111111111111111111111111111111111111111111111111111111111111111"},
		{"1111111111111111111111111111111111111111111111111111111111111111"},
	}

	for i, c := range cases {
		got := fmt.Sprintf("%064b", Mask[i])
		ta.Equal(c.want, got, "%d-th: case: %+v", i+1, c)

		// MaskUpto[i-1] == Mask[i]
		if i > 0 {
			got := fmt.Sprintf("%064b", MaskUpto[i-1])
			ta.Equal(c.want, got, "%d-th: case: %+v", i+1, c)
		}
	}
}

func TestBit(t *testing.T) {

	ta := require.New(t)

	cases := []struct {
		want string
	}{
		{"0000000000000000000000000000000000000000000000000000000000000001"},
		{"0000000000000000000000000000000000000000000000000000000000000010"},
		{"0000000000000000000000000000000000000000000000000000000000000100"},
		{"0000000000000000000000000000000000000000000000000000000000001000"},
		{"0000000000000000000000000000000000000000000000000000000000010000"},
		{"0000000000000000000000000000000000000000000000000000000000100000"},
		{"0000000000000000000000000000000000000000000000000000000001000000"},
		{"0000000000000000000000000000000000000000000000000000000010000000"},
		{"0000000000000000000000000000000000000000000000000000000100000000"},
		{"0000000000000000000000000000000000000000000000000000001000000000"},
		{"0000000000000000000000000000000000000000000000000000010000000000"},
		{"0000000000000000000000000000000000000000000000000000100000000000"},
		{"0000000000000000000000000000000000000000000000000001000000000000"},
		{"0000000000000000000000000000000000000000000000000010000000000000"},
		{"0000000000000000000000000000000000000000000000000100000000000000"},
		{"0000000000000000000000000000000000000000000000001000000000000000"},
		{"0000000000000000000000000000000000000000000000010000000000000000"},
		{"0000000000000000000000000000000000000000000000100000000000000000"},
		{"0000000000000000000000000000000000000000000001000000000000000000"},
		{"0000000000000000000000000000000000000000000010000000000000000000"},
		{"0000000000000000000000000000000000000000000100000000000000000000"},
		{"0000000000000000000000000000000000000000001000000000000000000000"},
		{"0000000000000000000000000000000000000000010000000000000000000000"},
		{"0000000000000000000000000000000000000000100000000000000000000000"},
		{"0000000000000000000000000000000000000001000000000000000000000000"},
		{"0000000000000000000000000000000000000010000000000000000000000000"},
		{"0000000000000000000000000000000000000100000000000000000000000000"},
		{"0000000000000000000000000000000000001000000000000000000000000000"},
		{"0000000000000000000000000000000000010000000000000000000000000000"},
		{"0000000000000000000000000000000000100000000000000000000000000000"},
		{"0000000000000000000000000000000001000000000000000000000000000000"},
		{"0000000000000000000000000000000010000000000000000000000000000000"},
		{"0000000000000000000000000000000100000000000000000000000000000000"},
		{"0000000000000000000000000000001000000000000000000000000000000000"},
		{"0000000000000000000000000000010000000000000000000000000000000000"},
		{"0000000000000000000000000000100000000000000000000000000000000000"},
		{"0000000000000000000000000001000000000000000000000000000000000000"},
		{"0000000000000000000000000010000000000000000000000000000000000000"},
		{"0000000000000000000000000100000000000000000000000000000000000000"},
		{"0000000000000000000000001000000000000000000000000000000000000000"},
		{"0000000000000000000000010000000000000000000000000000000000000000"},
		{"0000000000000000000000100000000000000000000000000000000000000000"},
		{"0000000000000000000001000000000000000000000000000000000000000000"},
		{"0000000000000000000010000000000000000000000000000000000000000000"},
		{"0000000000000000000100000000000000000000000000000000000000000000"},
		{"0000000000000000001000000000000000000000000000000000000000000000"},
		{"0000000000000000010000000000000000000000000000000000000000000000"},
		{"0000000000000000100000000000000000000000000000000000000000000000"},
		{"0000000000000001000000000000000000000000000000000000000000000000"},
		{"0000000000000010000000000000000000000000000000000000000000000000"},
		{"0000000000000100000000000000000000000000000000000000000000000000"},
		{"0000000000001000000000000000000000000000000000000000000000000000"},
		{"0000000000010000000000000000000000000000000000000000000000000000"},
		{"0000000000100000000000000000000000000000000000000000000000000000"},
		{"0000000001000000000000000000000000000000000000000000000000000000"},
		{"0000000010000000000000000000000000000000000000000000000000000000"},
		{"0000000100000000000000000000000000000000000000000000000000000000"},
		{"0000001000000000000000000000000000000000000000000000000000000000"},
		{"0000010000000000000000000000000000000000000000000000000000000000"},
		{"0000100000000000000000000000000000000000000000000000000000000000"},
		{"0001000000000000000000000000000000000000000000000000000000000000"},
		{"0010000000000000000000000000000000000000000000000000000000000000"},
		{"0100000000000000000000000000000000000000000000000000000000000000"},
		{"1000000000000000000000000000000000000000000000000000000000000000"},
	}

	for i, c := range cases {
		got := fmt.Sprintf("%064b", Bit[i])
		ta.Equal(c.want, got, "%d-th: case: %+v", i+1, c)
	}
}
