# Beego Server Instrumentation Example

An HTTP client connects to a Beego server. They both generate span information to `stdout`.
These instructions expect you have [docker-compose](https://docs.docker.com/compose/) installed.

Bring up the `beego-server` and `http-client` services to run the example:
```sh
docker-compose up -d
```

The `http-client` service sends just one HTTP request to `beego-server` and then exits. View the span generated by `beego-server` in the logs:
```sh
docker-compose logs beego-server
```

You can also visit a webpage hosted by the Beego app by navigating to `http://localhost:7777` in your browser. 
Two spans are created this time, one for the HTTP request, and another for rendering the template HTML. You can view the spans the same way as above.

Shut down the services when you are finished with the example:
```sh
docker-compose down
```
