// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/openshift/api/user/v1"
	userv1 "github.com/openshift/client-go/user/applyconfigurations/user/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeGroups implements GroupInterface
type FakeGroups struct {
	Fake *FakeUserV1
}

var groupsResource = v1.SchemeGroupVersion.WithResource("groups")

var groupsKind = v1.SchemeGroupVersion.WithKind("Group")

// Get takes name of the group, and returns the corresponding group object, and an error if there is any.
func (c *FakeGroups) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Group, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(groupsResource, name), &v1.Group{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Group), err
}

// List takes label and field selectors, and returns the list of Groups that match those selectors.
func (c *FakeGroups) List(ctx context.Context, opts metav1.ListOptions) (result *v1.GroupList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(groupsResource, groupsKind, opts), &v1.GroupList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.GroupList{ListMeta: obj.(*v1.GroupList).ListMeta}
	for _, item := range obj.(*v1.GroupList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested groups.
func (c *FakeGroups) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(groupsResource, opts))
}

// Create takes the representation of a group and creates it.  Returns the server's representation of the group, and an error, if there is any.
func (c *FakeGroups) Create(ctx context.Context, group *v1.Group, opts metav1.CreateOptions) (result *v1.Group, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(groupsResource, group), &v1.Group{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Group), err
}

// Update takes the representation of a group and updates it. Returns the server's representation of the group, and an error, if there is any.
func (c *FakeGroups) Update(ctx context.Context, group *v1.Group, opts metav1.UpdateOptions) (result *v1.Group, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(groupsResource, group), &v1.Group{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Group), err
}

// Delete takes name of the group and deletes it. Returns an error if one occurs.
func (c *FakeGroups) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(groupsResource, name, opts), &v1.Group{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeGroups) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(groupsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1.GroupList{})
	return err
}

// Patch applies the patch and returns the patched group.
func (c *FakeGroups) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Group, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(groupsResource, name, pt, data, subresources...), &v1.Group{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Group), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied group.
func (c *FakeGroups) Apply(ctx context.Context, group *userv1.GroupApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Group, err error) {
	if group == nil {
		return nil, fmt.Errorf("group provided to Apply must not be nil")
	}
	data, err := json.Marshal(group)
	if err != nil {
		return nil, err
	}
	name := group.Name
	if name == nil {
		return nil, fmt.Errorf("group.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(groupsResource, *name, types.ApplyPatchType, data), &v1.Group{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Group), err
}
