// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	userv1 "github.com/openshift/api/user/v1"
	internal "github.com/openshift/client-go/user/applyconfigurations/internal"
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
	v1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// IdentityApplyConfiguration represents an declarative configuration of the Identity type for use
// with apply.
type IdentityApplyConfiguration struct {
	v1.TypeMetaApplyConfiguration    `json:",inline"`
	*v1.ObjectMetaApplyConfiguration `json:"metadata,omitempty"`
	ProviderName                     *string                 `json:"providerName,omitempty"`
	ProviderUserName                 *string                 `json:"providerUserName,omitempty"`
	User                             *corev1.ObjectReference `json:"user,omitempty"`
	Extra                            map[string]string       `json:"extra,omitempty"`
}

// Identity constructs an declarative configuration of the Identity type for use with
// apply.
func Identity(name string) *IdentityApplyConfiguration {
	b := &IdentityApplyConfiguration{}
	b.WithName(name)
	b.WithKind("Identity")
	b.WithAPIVersion("user.openshift.io/v1")
	return b
}

// ExtractIdentity extracts the applied configuration owned by fieldManager from
// identity. If no managedFields are found in identity for fieldManager, a
// IdentityApplyConfiguration is returned with only the Name, Namespace (if applicable),
// APIVersion and Kind populated. It is possible that no managed fields were found for because other
// field managers have taken ownership of all the fields previously owned by fieldManager, or because
// the fieldManager never owned fields any fields.
// identity must be a unmodified Identity API object that was retrieved from the Kubernetes API.
// ExtractIdentity provides a way to perform a extract/modify-in-place/apply workflow.
// Note that an extracted apply configuration will contain fewer fields than what the fieldManager previously
// applied if another fieldManager has updated or force applied any of the previously applied fields.
// Experimental!
func ExtractIdentity(identity *userv1.Identity, fieldManager string) (*IdentityApplyConfiguration, error) {
	return extractIdentity(identity, fieldManager, "")
}

// ExtractIdentityStatus is the same as ExtractIdentity except
// that it extracts the status subresource applied configuration.
// Experimental!
func ExtractIdentityStatus(identity *userv1.Identity, fieldManager string) (*IdentityApplyConfiguration, error) {
	return extractIdentity(identity, fieldManager, "status")
}

func extractIdentity(identity *userv1.Identity, fieldManager string, subresource string) (*IdentityApplyConfiguration, error) {
	b := &IdentityApplyConfiguration{}
	err := managedfields.ExtractInto(identity, internal.Parser().Type("com.github.openshift.api.user.v1.Identity"), fieldManager, b, subresource)
	if err != nil {
		return nil, err
	}
	b.WithName(identity.Name)

	b.WithKind("Identity")
	b.WithAPIVersion("user.openshift.io/v1")
	return b, nil
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithKind(value string) *IdentityApplyConfiguration {
	b.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithAPIVersion(value string) *IdentityApplyConfiguration {
	b.APIVersion = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithName(value string) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Name = &value
	return b
}

// WithGenerateName sets the GenerateName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GenerateName field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithGenerateName(value string) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.GenerateName = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithNamespace(value string) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Namespace = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithUID(value types.UID) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.UID = &value
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithResourceVersion(value string) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ResourceVersion = &value
	return b
}

// WithGeneration sets the Generation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Generation field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithGeneration(value int64) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Generation = &value
	return b
}

// WithCreationTimestamp sets the CreationTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CreationTimestamp field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithCreationTimestamp(value metav1.Time) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.CreationTimestamp = &value
	return b
}

// WithDeletionTimestamp sets the DeletionTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionTimestamp field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithDeletionTimestamp(value metav1.Time) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.DeletionTimestamp = &value
	return b
}

// WithDeletionGracePeriodSeconds sets the DeletionGracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionGracePeriodSeconds field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithDeletionGracePeriodSeconds(value int64) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.DeletionGracePeriodSeconds = &value
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *IdentityApplyConfiguration) WithLabels(entries map[string]string) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.Labels == nil && len(entries) > 0 {
		b.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Labels[k] = v
	}
	return b
}

// WithAnnotations puts the entries into the Annotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Annotations field,
// overwriting an existing map entries in Annotations field with the same key.
func (b *IdentityApplyConfiguration) WithAnnotations(entries map[string]string) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.Annotations == nil && len(entries) > 0 {
		b.Annotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Annotations[k] = v
	}
	return b
}

// WithOwnerReferences adds the given value to the OwnerReferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OwnerReferences field.
func (b *IdentityApplyConfiguration) WithOwnerReferences(values ...*v1.OwnerReferenceApplyConfiguration) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithOwnerReferences")
		}
		b.OwnerReferences = append(b.OwnerReferences, *values[i])
	}
	return b
}

// WithFinalizers adds the given value to the Finalizers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Finalizers field.
func (b *IdentityApplyConfiguration) WithFinalizers(values ...string) *IdentityApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		b.Finalizers = append(b.Finalizers, values[i])
	}
	return b
}

func (b *IdentityApplyConfiguration) ensureObjectMetaApplyConfigurationExists() {
	if b.ObjectMetaApplyConfiguration == nil {
		b.ObjectMetaApplyConfiguration = &v1.ObjectMetaApplyConfiguration{}
	}
}

// WithProviderName sets the ProviderName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProviderName field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithProviderName(value string) *IdentityApplyConfiguration {
	b.ProviderName = &value
	return b
}

// WithProviderUserName sets the ProviderUserName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProviderUserName field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithProviderUserName(value string) *IdentityApplyConfiguration {
	b.ProviderUserName = &value
	return b
}

// WithUser sets the User field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the User field is set to the value of the last call.
func (b *IdentityApplyConfiguration) WithUser(value corev1.ObjectReference) *IdentityApplyConfiguration {
	b.User = &value
	return b
}

// WithExtra puts the entries into the Extra field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Extra field,
// overwriting an existing map entries in Extra field with the same key.
func (b *IdentityApplyConfiguration) WithExtra(entries map[string]string) *IdentityApplyConfiguration {
	if b.Extra == nil && len(entries) > 0 {
		b.Extra = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Extra[k] = v
	}
	return b
}
