// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1alpha1 "github.com/openshift/api/operator/v1alpha1"
	operatorv1alpha1 "github.com/openshift/client-go/operator/applyconfigurations/operator/v1alpha1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// OLMsGetter has a method to return a OLMInterface.
// A group's client should implement this interface.
type OLMsGetter interface {
	OLMs() OLMInterface
}

// OLMInterface has methods to work with OLM resources.
type OLMInterface interface {
	Create(ctx context.Context, oLM *v1alpha1.OLM, opts v1.CreateOptions) (*v1alpha1.OLM, error)
	Update(ctx context.Context, oLM *v1alpha1.OLM, opts v1.UpdateOptions) (*v1alpha1.OLM, error)
	UpdateStatus(ctx context.Context, oLM *v1alpha1.OLM, opts v1.UpdateOptions) (*v1alpha1.OLM, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.OLM, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.OLMList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.OLM, err error)
	Apply(ctx context.Context, oLM *operatorv1alpha1.OLMApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.OLM, err error)
	ApplyStatus(ctx context.Context, oLM *operatorv1alpha1.OLMApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.OLM, err error)
	OLMExpansion
}

// oLMs implements OLMInterface
type oLMs struct {
	client rest.Interface
}

// newOLMs returns a OLMs
func newOLMs(c *OperatorV1alpha1Client) *oLMs {
	return &oLMs{
		client: c.RESTClient(),
	}
}

// Get takes name of the oLM, and returns the corresponding oLM object, and an error if there is any.
func (c *oLMs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.OLM, err error) {
	result = &v1alpha1.OLM{}
	err = c.client.Get().
		Resource("olms").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of OLMs that match those selectors.
func (c *oLMs) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.OLMList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.OLMList{}
	err = c.client.Get().
		Resource("olms").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested oLMs.
func (c *oLMs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("olms").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a oLM and creates it.  Returns the server's representation of the oLM, and an error, if there is any.
func (c *oLMs) Create(ctx context.Context, oLM *v1alpha1.OLM, opts v1.CreateOptions) (result *v1alpha1.OLM, err error) {
	result = &v1alpha1.OLM{}
	err = c.client.Post().
		Resource("olms").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(oLM).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a oLM and updates it. Returns the server's representation of the oLM, and an error, if there is any.
func (c *oLMs) Update(ctx context.Context, oLM *v1alpha1.OLM, opts v1.UpdateOptions) (result *v1alpha1.OLM, err error) {
	result = &v1alpha1.OLM{}
	err = c.client.Put().
		Resource("olms").
		Name(oLM.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(oLM).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *oLMs) UpdateStatus(ctx context.Context, oLM *v1alpha1.OLM, opts v1.UpdateOptions) (result *v1alpha1.OLM, err error) {
	result = &v1alpha1.OLM{}
	err = c.client.Put().
		Resource("olms").
		Name(oLM.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(oLM).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the oLM and deletes it. Returns an error if one occurs.
func (c *oLMs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("olms").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *oLMs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("olms").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched oLM.
func (c *oLMs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.OLM, err error) {
	result = &v1alpha1.OLM{}
	err = c.client.Patch(pt).
		Resource("olms").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied oLM.
func (c *oLMs) Apply(ctx context.Context, oLM *operatorv1alpha1.OLMApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.OLM, err error) {
	if oLM == nil {
		return nil, fmt.Errorf("oLM provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(oLM)
	if err != nil {
		return nil, err
	}
	name := oLM.Name
	if name == nil {
		return nil, fmt.Errorf("oLM.Name must be provided to Apply")
	}
	result = &v1alpha1.OLM{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("olms").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *oLMs) ApplyStatus(ctx context.Context, oLM *operatorv1alpha1.OLMApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.OLM, err error) {
	if oLM == nil {
		return nil, fmt.Errorf("oLM provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(oLM)
	if err != nil {
		return nil, err
	}

	name := oLM.Name
	if name == nil {
		return nil, fmt.Errorf("oLM.Name must be provided to Apply")
	}

	result = &v1alpha1.OLM{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("olms").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
