// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "github.com/openshift/api/operator/v1"
	operatorv1 "github.com/openshift/client-go/operator/applyconfigurations/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// StoragesGetter has a method to return a StorageInterface.
// A group's client should implement this interface.
type StoragesGetter interface {
	Storages() StorageInterface
}

// StorageInterface has methods to work with Storage resources.
type StorageInterface interface {
	Create(ctx context.Context, storage *v1.Storage, opts metav1.CreateOptions) (*v1.Storage, error)
	Update(ctx context.Context, storage *v1.Storage, opts metav1.UpdateOptions) (*v1.Storage, error)
	UpdateStatus(ctx context.Context, storage *v1.Storage, opts metav1.UpdateOptions) (*v1.Storage, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.Storage, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.StorageList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Storage, err error)
	Apply(ctx context.Context, storage *operatorv1.StorageApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Storage, err error)
	ApplyStatus(ctx context.Context, storage *operatorv1.StorageApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Storage, err error)
	StorageExpansion
}

// storages implements StorageInterface
type storages struct {
	client rest.Interface
}

// newStorages returns a Storages
func newStorages(c *OperatorV1Client) *storages {
	return &storages{
		client: c.RESTClient(),
	}
}

// Get takes name of the storage, and returns the corresponding storage object, and an error if there is any.
func (c *storages) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Storage, err error) {
	result = &v1.Storage{}
	err = c.client.Get().
		Resource("storages").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Storages that match those selectors.
func (c *storages) List(ctx context.Context, opts metav1.ListOptions) (result *v1.StorageList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.StorageList{}
	err = c.client.Get().
		Resource("storages").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested storages.
func (c *storages) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("storages").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a storage and creates it.  Returns the server's representation of the storage, and an error, if there is any.
func (c *storages) Create(ctx context.Context, storage *v1.Storage, opts metav1.CreateOptions) (result *v1.Storage, err error) {
	result = &v1.Storage{}
	err = c.client.Post().
		Resource("storages").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(storage).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a storage and updates it. Returns the server's representation of the storage, and an error, if there is any.
func (c *storages) Update(ctx context.Context, storage *v1.Storage, opts metav1.UpdateOptions) (result *v1.Storage, err error) {
	result = &v1.Storage{}
	err = c.client.Put().
		Resource("storages").
		Name(storage.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(storage).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *storages) UpdateStatus(ctx context.Context, storage *v1.Storage, opts metav1.UpdateOptions) (result *v1.Storage, err error) {
	result = &v1.Storage{}
	err = c.client.Put().
		Resource("storages").
		Name(storage.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(storage).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the storage and deletes it. Returns an error if one occurs.
func (c *storages) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("storages").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *storages) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("storages").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched storage.
func (c *storages) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Storage, err error) {
	result = &v1.Storage{}
	err = c.client.Patch(pt).
		Resource("storages").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied storage.
func (c *storages) Apply(ctx context.Context, storage *operatorv1.StorageApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Storage, err error) {
	if storage == nil {
		return nil, fmt.Errorf("storage provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(storage)
	if err != nil {
		return nil, err
	}
	name := storage.Name
	if name == nil {
		return nil, fmt.Errorf("storage.Name must be provided to Apply")
	}
	result = &v1.Storage{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("storages").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *storages) ApplyStatus(ctx context.Context, storage *operatorv1.StorageApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Storage, err error) {
	if storage == nil {
		return nil, fmt.Errorf("storage provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(storage)
	if err != nil {
		return nil, err
	}

	name := storage.Name
	if name == nil {
		return nil, fmt.Errorf("storage.Name must be provided to Apply")
	}

	result = &v1.Storage{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("storages").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
