// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "github.com/openshift/api/operator/v1"
	operatorv1 "github.com/openshift/client-go/operator/applyconfigurations/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CSISnapshotControllersGetter has a method to return a CSISnapshotControllerInterface.
// A group's client should implement this interface.
type CSISnapshotControllersGetter interface {
	CSISnapshotControllers() CSISnapshotControllerInterface
}

// CSISnapshotControllerInterface has methods to work with CSISnapshotController resources.
type CSISnapshotControllerInterface interface {
	Create(ctx context.Context, cSISnapshotController *v1.CSISnapshotController, opts metav1.CreateOptions) (*v1.CSISnapshotController, error)
	Update(ctx context.Context, cSISnapshotController *v1.CSISnapshotController, opts metav1.UpdateOptions) (*v1.CSISnapshotController, error)
	UpdateStatus(ctx context.Context, cSISnapshotController *v1.CSISnapshotController, opts metav1.UpdateOptions) (*v1.CSISnapshotController, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.CSISnapshotController, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.CSISnapshotControllerList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.CSISnapshotController, err error)
	Apply(ctx context.Context, cSISnapshotController *operatorv1.CSISnapshotControllerApplyConfiguration, opts metav1.ApplyOptions) (result *v1.CSISnapshotController, err error)
	ApplyStatus(ctx context.Context, cSISnapshotController *operatorv1.CSISnapshotControllerApplyConfiguration, opts metav1.ApplyOptions) (result *v1.CSISnapshotController, err error)
	CSISnapshotControllerExpansion
}

// cSISnapshotControllers implements CSISnapshotControllerInterface
type cSISnapshotControllers struct {
	client rest.Interface
}

// newCSISnapshotControllers returns a CSISnapshotControllers
func newCSISnapshotControllers(c *OperatorV1Client) *cSISnapshotControllers {
	return &cSISnapshotControllers{
		client: c.RESTClient(),
	}
}

// Get takes name of the cSISnapshotController, and returns the corresponding cSISnapshotController object, and an error if there is any.
func (c *cSISnapshotControllers) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.CSISnapshotController, err error) {
	result = &v1.CSISnapshotController{}
	err = c.client.Get().
		Resource("csisnapshotcontrollers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CSISnapshotControllers that match those selectors.
func (c *cSISnapshotControllers) List(ctx context.Context, opts metav1.ListOptions) (result *v1.CSISnapshotControllerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.CSISnapshotControllerList{}
	err = c.client.Get().
		Resource("csisnapshotcontrollers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested cSISnapshotControllers.
func (c *cSISnapshotControllers) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("csisnapshotcontrollers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a cSISnapshotController and creates it.  Returns the server's representation of the cSISnapshotController, and an error, if there is any.
func (c *cSISnapshotControllers) Create(ctx context.Context, cSISnapshotController *v1.CSISnapshotController, opts metav1.CreateOptions) (result *v1.CSISnapshotController, err error) {
	result = &v1.CSISnapshotController{}
	err = c.client.Post().
		Resource("csisnapshotcontrollers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(cSISnapshotController).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a cSISnapshotController and updates it. Returns the server's representation of the cSISnapshotController, and an error, if there is any.
func (c *cSISnapshotControllers) Update(ctx context.Context, cSISnapshotController *v1.CSISnapshotController, opts metav1.UpdateOptions) (result *v1.CSISnapshotController, err error) {
	result = &v1.CSISnapshotController{}
	err = c.client.Put().
		Resource("csisnapshotcontrollers").
		Name(cSISnapshotController.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(cSISnapshotController).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *cSISnapshotControllers) UpdateStatus(ctx context.Context, cSISnapshotController *v1.CSISnapshotController, opts metav1.UpdateOptions) (result *v1.CSISnapshotController, err error) {
	result = &v1.CSISnapshotController{}
	err = c.client.Put().
		Resource("csisnapshotcontrollers").
		Name(cSISnapshotController.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(cSISnapshotController).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the cSISnapshotController and deletes it. Returns an error if one occurs.
func (c *cSISnapshotControllers) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("csisnapshotcontrollers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *cSISnapshotControllers) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("csisnapshotcontrollers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched cSISnapshotController.
func (c *cSISnapshotControllers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.CSISnapshotController, err error) {
	result = &v1.CSISnapshotController{}
	err = c.client.Patch(pt).
		Resource("csisnapshotcontrollers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied cSISnapshotController.
func (c *cSISnapshotControllers) Apply(ctx context.Context, cSISnapshotController *operatorv1.CSISnapshotControllerApplyConfiguration, opts metav1.ApplyOptions) (result *v1.CSISnapshotController, err error) {
	if cSISnapshotController == nil {
		return nil, fmt.Errorf("cSISnapshotController provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(cSISnapshotController)
	if err != nil {
		return nil, err
	}
	name := cSISnapshotController.Name
	if name == nil {
		return nil, fmt.Errorf("cSISnapshotController.Name must be provided to Apply")
	}
	result = &v1.CSISnapshotController{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("csisnapshotcontrollers").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *cSISnapshotControllers) ApplyStatus(ctx context.Context, cSISnapshotController *operatorv1.CSISnapshotControllerApplyConfiguration, opts metav1.ApplyOptions) (result *v1.CSISnapshotController, err error) {
	if cSISnapshotController == nil {
		return nil, fmt.Errorf("cSISnapshotController provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(cSISnapshotController)
	if err != nil {
		return nil, err
	}

	name := cSISnapshotController.Name
	if name == nil {
		return nil, fmt.Errorf("cSISnapshotController.Name must be provided to Apply")
	}

	result = &v1.CSISnapshotController{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("csisnapshotcontrollers").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
