// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "github.com/openshift/api/oauth/v1"
	oauthv1 "github.com/openshift/client-go/oauth/applyconfigurations/oauth/v1"
	scheme "github.com/openshift/client-go/oauth/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// OAuthClientAuthorizationsGetter has a method to return a OAuthClientAuthorizationInterface.
// A group's client should implement this interface.
type OAuthClientAuthorizationsGetter interface {
	OAuthClientAuthorizations() OAuthClientAuthorizationInterface
}

// OAuthClientAuthorizationInterface has methods to work with OAuthClientAuthorization resources.
type OAuthClientAuthorizationInterface interface {
	Create(ctx context.Context, oAuthClientAuthorization *v1.OAuthClientAuthorization, opts metav1.CreateOptions) (*v1.OAuthClientAuthorization, error)
	Update(ctx context.Context, oAuthClientAuthorization *v1.OAuthClientAuthorization, opts metav1.UpdateOptions) (*v1.OAuthClientAuthorization, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.OAuthClientAuthorization, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.OAuthClientAuthorizationList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.OAuthClientAuthorization, err error)
	Apply(ctx context.Context, oAuthClientAuthorization *oauthv1.OAuthClientAuthorizationApplyConfiguration, opts metav1.ApplyOptions) (result *v1.OAuthClientAuthorization, err error)
	OAuthClientAuthorizationExpansion
}

// oAuthClientAuthorizations implements OAuthClientAuthorizationInterface
type oAuthClientAuthorizations struct {
	client rest.Interface
}

// newOAuthClientAuthorizations returns a OAuthClientAuthorizations
func newOAuthClientAuthorizations(c *OauthV1Client) *oAuthClientAuthorizations {
	return &oAuthClientAuthorizations{
		client: c.RESTClient(),
	}
}

// Get takes name of the oAuthClientAuthorization, and returns the corresponding oAuthClientAuthorization object, and an error if there is any.
func (c *oAuthClientAuthorizations) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.OAuthClientAuthorization, err error) {
	result = &v1.OAuthClientAuthorization{}
	err = c.client.Get().
		Resource("oauthclientauthorizations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of OAuthClientAuthorizations that match those selectors.
func (c *oAuthClientAuthorizations) List(ctx context.Context, opts metav1.ListOptions) (result *v1.OAuthClientAuthorizationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.OAuthClientAuthorizationList{}
	err = c.client.Get().
		Resource("oauthclientauthorizations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested oAuthClientAuthorizations.
func (c *oAuthClientAuthorizations) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("oauthclientauthorizations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a oAuthClientAuthorization and creates it.  Returns the server's representation of the oAuthClientAuthorization, and an error, if there is any.
func (c *oAuthClientAuthorizations) Create(ctx context.Context, oAuthClientAuthorization *v1.OAuthClientAuthorization, opts metav1.CreateOptions) (result *v1.OAuthClientAuthorization, err error) {
	result = &v1.OAuthClientAuthorization{}
	err = c.client.Post().
		Resource("oauthclientauthorizations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(oAuthClientAuthorization).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a oAuthClientAuthorization and updates it. Returns the server's representation of the oAuthClientAuthorization, and an error, if there is any.
func (c *oAuthClientAuthorizations) Update(ctx context.Context, oAuthClientAuthorization *v1.OAuthClientAuthorization, opts metav1.UpdateOptions) (result *v1.OAuthClientAuthorization, err error) {
	result = &v1.OAuthClientAuthorization{}
	err = c.client.Put().
		Resource("oauthclientauthorizations").
		Name(oAuthClientAuthorization.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(oAuthClientAuthorization).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the oAuthClientAuthorization and deletes it. Returns an error if one occurs.
func (c *oAuthClientAuthorizations) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("oauthclientauthorizations").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *oAuthClientAuthorizations) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("oauthclientauthorizations").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched oAuthClientAuthorization.
func (c *oAuthClientAuthorizations) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.OAuthClientAuthorization, err error) {
	result = &v1.OAuthClientAuthorization{}
	err = c.client.Patch(pt).
		Resource("oauthclientauthorizations").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied oAuthClientAuthorization.
func (c *oAuthClientAuthorizations) Apply(ctx context.Context, oAuthClientAuthorization *oauthv1.OAuthClientAuthorizationApplyConfiguration, opts metav1.ApplyOptions) (result *v1.OAuthClientAuthorization, err error) {
	if oAuthClientAuthorization == nil {
		return nil, fmt.Errorf("oAuthClientAuthorization provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(oAuthClientAuthorization)
	if err != nil {
		return nil, err
	}
	name := oAuthClientAuthorization.Name
	if name == nil {
		return nil, fmt.Errorf("oAuthClientAuthorization.Name must be provided to Apply")
	}
	result = &v1.OAuthClientAuthorization{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("oauthclientauthorizations").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
