// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/openshift/api/config/v1"
	configv1 "github.com/openshift/client-go/config/applyconfigurations/config/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeBuilds implements BuildInterface
type FakeBuilds struct {
	Fake *FakeConfigV1
}

var buildsResource = v1.SchemeGroupVersion.WithResource("builds")

var buildsKind = v1.SchemeGroupVersion.WithKind("Build")

// Get takes name of the build, and returns the corresponding build object, and an error if there is any.
func (c *FakeBuilds) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Build, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(buildsResource, name), &v1.Build{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Build), err
}

// List takes label and field selectors, and returns the list of Builds that match those selectors.
func (c *FakeBuilds) List(ctx context.Context, opts metav1.ListOptions) (result *v1.BuildList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(buildsResource, buildsKind, opts), &v1.BuildList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.BuildList{ListMeta: obj.(*v1.BuildList).ListMeta}
	for _, item := range obj.(*v1.BuildList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested builds.
func (c *FakeBuilds) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(buildsResource, opts))
}

// Create takes the representation of a build and creates it.  Returns the server's representation of the build, and an error, if there is any.
func (c *FakeBuilds) Create(ctx context.Context, build *v1.Build, opts metav1.CreateOptions) (result *v1.Build, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(buildsResource, build), &v1.Build{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Build), err
}

// Update takes the representation of a build and updates it. Returns the server's representation of the build, and an error, if there is any.
func (c *FakeBuilds) Update(ctx context.Context, build *v1.Build, opts metav1.UpdateOptions) (result *v1.Build, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(buildsResource, build), &v1.Build{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Build), err
}

// Delete takes name of the build and deletes it. Returns an error if one occurs.
func (c *FakeBuilds) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(buildsResource, name, opts), &v1.Build{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeBuilds) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(buildsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1.BuildList{})
	return err
}

// Patch applies the patch and returns the patched build.
func (c *FakeBuilds) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Build, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(buildsResource, name, pt, data, subresources...), &v1.Build{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Build), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied build.
func (c *FakeBuilds) Apply(ctx context.Context, build *configv1.BuildApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Build, err error) {
	if build == nil {
		return nil, fmt.Errorf("build provided to Apply must not be nil")
	}
	data, err := json.Marshal(build)
	if err != nil {
		return nil, err
	}
	name := build.Name
	if name == nil {
		return nil, fmt.Errorf("build.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(buildsResource, *name, types.ApplyPatchType, data), &v1.Build{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.Build), err
}
