---
id: alpha-config
title: Alpha Configuration
---

:::warning
This page contains documentation for alpha features.
We reserve the right to make breaking changes to the features detailed within this page with no notice.

Options described in this page may be changed, removed, renamed or moved without prior warning.
Please beware of this before you use alpha configuration options.
:::

This page details a set of **alpha** configuration options in a new format.
Going forward we are intending to add structured configuration in YAML format to
replace the existing TOML based configuration file and flags.

Below is a reference for the structure of the configuration, with
[AlphaOptions](#alphaoptions) as the root of the configuration.

When using alpha configuration, your config file will look something like below:

```yaml
upstreams:
  - id: ...
    ...
injectRequestHeaders:
  - name: ...
    ...
injectResponseHeaders:
  - name: ...
    ...
```

Please browse the [reference](#configuration-reference) below for the structure
of the new configuration format.

## Using Alpha Configuration

To use the new **alpha** configuration, generate a YAML file based on the format
described in the [reference](#configuration-reference) below.

Provide the path to this file using the `--alpha-config` flag.

:::note
When using the `--alpha-config` flag, some options are no longer available.
See [removed options](#removed-options) below for more information.
:::

### Converting configuration to the new structure

Before adding the new `--alpha-config` option, start OAuth2 Proxy using the
`convert-config-to-alpha` flag to convert existing configuration to the new format.

```bash
oauth2-proxy --convert-config-to-alpha --config ./path/to/existing/config.cfg
```

This will convert any options supported by the new format to YAML and print the
new configuration to `STDOUT`.

Copy this to a new file, remove any options from your existing configuration
noted in [removed options](#removed-options) and then start OAuth2 Proxy using
the new config.

```bash
oauth2-proxy --alpha-config ./path/to/new/config.yaml --config ./path/to/existing/config.cfg
```

## Removed options

The following flags/options and their respective environment variables are no
longer available when using alpha configuration:

<!-- Legacy Upstream FlagSet -->
- `flush-interval`/`flush_interval`
- `pass-host-header`/`pass_host_header`
- `proxy-websockets`/`proxy_websockets`
- `ssl-upstream-insecure-skip-verify`/`ssl_upstream_insecure_skip_verify`
- `upstream`/`upstreams`

<!-- Legacy Headers FlagSet -->
- `pass-basic-auth`/`pass_basic_auth`
- `pass-access-token`/`pass_access_token`
- `pass-user-headers`/`pass_user_headers`
- `pass-authorization-header`/`pass_authorization_header`
- `set-basic-auth`/`set_basic_auth`
- `set-xauthrequest`/`set_xauthrequest`
- `set-authorization-header`/`set_authorization_header`
- `prefer-email-to-user`/`prefer_email_to_user`
- `basic-auth-password`/`basic_auth_password`
- `skip-auth-strip-headers`/`skip_auth_strip_headers`

<!-- Legacy provider FlagSet -->
- `client-id`/`client_id`
- `client-secret`/`client_secret`, and `client-secret-file`/`client_secret_file`
- `provider`
- `provider-display-name`/`provider_display_name`
- `provider-ca-file`/`provider_ca_files`
- `login-url`/`login_url`
- `redeem-url`/`redeem_url`
- `profile-url`/`profile_url`
- `resource`
- `validate-url`/`validate_url`
- `scope`
- `prompt`
- `approval-prompt`/`approval_prompt`
- `acr-values`/`acr_values`
- `user-id-claim`/`user_id_claim`
- `allowed-group`/`allowed_groups`
- `allowed-role`/`allowed_roles`
- `jwt-key`/`jwt_key`
- `jwt-key-file`/`jwt_key_file`
- `pubjwk-url`/`pubjwk_url`

and all provider-specific options, i.e. any option whose name includes `oidc`,
`azure`, `bitbucket`, `github`, `gitlab`, `google` or `keycloak`.  Attempting to
use any of these options via flags or via config when `--alpha-config` is
set will result in an error.

:::important
You must remove these options before starting OAuth2 Proxy with `--alpha-config`
:::

## Configuration Reference
<!--- THIS FILE IS AUTOGENERATED!!! DO NOT EDIT!!! -->

### ADFSOptions

(**Appears on:** [Provider](#provider))



| Field | Type | Description |
| ----- | ---- | ----------- |
| `skipScope` | _bool_ | Skip adding the scope parameter in login request<br/>Default value is 'false' |

### AlphaOptions

AlphaOptions contains alpha structured configuration options.
Usage of these options allows users to access alpha features that are not
available as part of the primary configuration structure for OAuth2 Proxy.

:::warning
The options within this structure are considered alpha.
They may change between releases without notice.
:::

| Field | Type | Description |
| ----- | ---- | ----------- |
| `upstreamConfig` | _[UpstreamConfig](#upstreamconfig)_ | UpstreamConfig is used to configure upstream servers.<br/>Once a user is authenticated, requests to the server will be proxied to<br/>these upstream servers based on the path mappings defined in this list. |
| `injectRequestHeaders` | _[[]Header](#header)_ | InjectRequestHeaders is used to configure headers that should be added<br/>to requests to upstream servers.<br/>Headers may source values from either the authenticated user's session<br/>or from a static secret value. |
| `injectResponseHeaders` | _[[]Header](#header)_ | InjectResponseHeaders is used to configure headers that should be added<br/>to responses from the proxy.<br/>This is typically used when using the proxy as an external authentication<br/>provider in conjunction with another proxy such as NGINX and its<br/>auth_request module.<br/>Headers may source values from either the authenticated user's session<br/>or from a static secret value. |
| `server` | _[Server](#server)_ | Server is used to configure the HTTP(S) server for the proxy application.<br/>You may choose to run both HTTP and HTTPS servers simultaneously.<br/>This can be done by setting the BindAddress and the SecureBindAddress simultaneously.<br/>To use the secure server you must configure a TLS certificate and key. |
| `metricsServer` | _[Server](#server)_ | MetricsServer is used to configure the HTTP(S) server for metrics.<br/>You may choose to run both HTTP and HTTPS servers simultaneously.<br/>This can be done by setting the BindAddress and the SecureBindAddress simultaneously.<br/>To use the secure server you must configure a TLS certificate and key. |
| `providers` | _[Providers](#providers)_ | Providers is used to configure multiple providers. |

### AzureOptions

(**Appears on:** [Provider](#provider))



| Field | Type | Description |
| ----- | ---- | ----------- |
| `tenant` | _string_ | Tenant directs to a tenant-specific or common (tenant-independent) endpoint<br/>Default value is 'common' |
| `graphGroupField` | _string_ | GraphGroupField configures the group field to be used when building the groups list from Microsoft Graph<br/>Default value is 'id' |

### BitbucketOptions

(**Appears on:** [Provider](#provider))



| Field | Type | Description |
| ----- | ---- | ----------- |
| `team` | _string_ | Team sets restrict logins to members of this team |
| `repository` | _string_ | Repository sets restrict logins to user with access to this repository |

### ClaimSource

(**Appears on:** [HeaderValue](#headervalue))

ClaimSource allows loading a header value from a claim within the session

| Field | Type | Description |
| ----- | ---- | ----------- |
| `claim` | _string_ | Claim is the name of the claim in the session that the value should be<br/>loaded from. |
| `prefix` | _string_ | Prefix is an optional prefix that will be prepended to the value of the<br/>claim if it is non-empty. |
| `basicAuthPassword` | _[SecretSource](#secretsource)_ | BasicAuthPassword converts this claim into a basic auth header.<br/>Note the value of claim will become the basic auth username and the<br/>basicAuthPassword will be used as the password value. |

### Duration
#### (`string` alias)

(**Appears on:** [Upstream](#upstream))

Duration is as string representation of a period of time.
A duration string is a is a possibly signed sequence of decimal numbers,
each with optional fraction and a unit suffix, such as "300ms", "-1.5h" or "2h45m".
Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".


### GitHubOptions

(**Appears on:** [Provider](#provider))



| Field | Type | Description |
| ----- | ---- | ----------- |
| `org` | _string_ | Org sets restrict logins to members of this organisation |
| `team` | _string_ | Team sets restrict logins to members of this team |
| `repo` | _string_ | Repo sets restrict logins to collaborators of this repository |
| `token` | _string_ | Token is the token to use when verifying repository collaborators<br/>it must have push access to the repository |
| `users` | _[]string_ | Users allows users with these usernames to login<br/>even if they do not belong to the specified org and team or collaborators |

### GitLabOptions

(**Appears on:** [Provider](#provider))



| Field | Type | Description |
| ----- | ---- | ----------- |
| `group` | _[]string_ | Group sets restrict logins to members of this group |
| `projects` | _[]string_ | Projects restricts logins to members of any of these projects |

### GoogleOptions

(**Appears on:** [Provider](#provider))



| Field | Type | Description |
| ----- | ---- | ----------- |
| `group` | _[]string_ | Groups sets restrict logins to members of this google group |
| `adminEmail` | _string_ | AdminEmail is the google admin to impersonate for api calls |
| `serviceAccountJson` | _string_ | ServiceAccountJSON is the path to the service account json credentials |
| `useApplicationDefaultCredentials` | _bool_ | UseApplicationDefaultCredentials is a boolean whether to use Application Default Credentials instead of a ServiceAccountJSON |

### Header

(**Appears on:** [AlphaOptions](#alphaoptions))

Header represents an individual header that will be added to a request or
response header.

| Field | Type | Description |
| ----- | ---- | ----------- |
| `name` | _string_ | Name is the header name to be used for this set of values.<br/>Names should be unique within a list of Headers. |
| `preserveRequestValue` | _bool_ | PreserveRequestValue determines whether any values for this header<br/>should be preserved for the request to the upstream server.<br/>This option only applies to injected request headers.<br/>Defaults to false (headers that match this header will be stripped). |
| `values` | _[[]HeaderValue](#headervalue)_ | Values contains the desired values for this header |

### HeaderValue

(**Appears on:** [Header](#header))

HeaderValue represents a single header value and the sources that can
make up the header value

| Field | Type | Description |
| ----- | ---- | ----------- |
| `value` | _[]byte_ | Value expects a base64 encoded string value. |
| `fromEnv` | _string_ | FromEnv expects the name of an environment variable. |
| `fromFile` | _string_ | FromFile expects a path to a file containing the secret value. |
| `claim` | _string_ | Claim is the name of the claim in the session that the value should be<br/>loaded from. |
| `prefix` | _string_ | Prefix is an optional prefix that will be prepended to the value of the<br/>claim if it is non-empty. |
| `basicAuthPassword` | _[SecretSource](#secretsource)_ | BasicAuthPassword converts this claim into a basic auth header.<br/>Note the value of claim will become the basic auth username and the<br/>basicAuthPassword will be used as the password value. |

### KeycloakOptions

(**Appears on:** [Provider](#provider))



| Field | Type | Description |
| ----- | ---- | ----------- |
| `groups` | _[]string_ | Group enables to restrict login to members of indicated group |
| `roles` | _[]string_ | Role enables to restrict login to users with role (only available when using the keycloak-oidc provider) |

### LoginGovOptions

(**Appears on:** [Provider](#provider))



| Field | Type | Description |
| ----- | ---- | ----------- |
| `jwtKey` | _string_ | JWTKey is a private key in PEM format used to sign JWT, |
| `jwtKeyFile` | _string_ | JWTKeyFile is a path to the private key file in PEM format used to sign the JWT |
| `pubjwkURL` | _string_ | PubJWKURL is the JWK pubkey access endpoint |

### LoginURLParameter

(**Appears on:** [Provider](#provider))

LoginURLParameter is the configuration for a single query parameter that
can be passed through from the `/oauth2/start` endpoint to the IdP login
URL.  The "default" option specifies the default value or values (if any)
that will be passed to the IdP for this parameter, and "allow" is a list
of options for ways in which this parameter can be set or overridden via
the query string to `/oauth2/start`.
If _only_ a default is specified and no "allow" then the parameter is
effectively fixed - the default value will always be used and anything
passed to the start URL will be ignored.  If _only_ "allow" is specified
but no default then the parameter will only be passed on to the IdP if
the caller provides it, and no value will be sent otherwise.

Examples:

# A parameter whose value is fixed

```
name: organization
default:
- myorg
```

A parameter that is not passed by default, but may be set to one of a
fixed set of values

```
name: prompt
allow:
- value: login
- value: consent
- value: select_account
```

A parameter that is passed by default but may be overridden by one of
a fixed set of values

```
name: prompt
default: ["login"]
allow:
- value: consent
- value: select_account
```

A parameter that may be overridden, but only by values that match a
regular expression.  For example to restrict `login_hint` to email
addresses in your organization's domain:

```
name: login_hint
allow:
- pattern: '^[^@]*@example\.com$'
# this allows at most one "@" sign, and requires "example.com" domain.
```

Note that the YAML rules around exactly which characters are allowed
and/or require escaping in different types of string literals are
convoluted.  For regular expressions the single quoted form is simplest
as backslash is not considered to be an escape character.  Alternatively
use the "chomped block" format `|-`:

```
  - pattern: |-
    ^[^@]*@example\.com$

```

The hyphen is important, a `|` block would have a trailing newline
character.

| Field | Type | Description |
| ----- | ---- | ----------- |
| `name` | _string_ | Name specifies the name of the query parameter. |
| `default` | _[]string_ |  _(Optional)_ Default specifies a default value or values that will be<br/>passed to the IdP if not overridden. |
| `allow` | _[[]URLParameterRule](#urlparameterrule)_ |  _(Optional)_ Allow specifies rules about how the default (if any) may be<br/>overridden via the query string to `/oauth2/start`.  Only<br/>values that match one or more of the allow rules will be<br/>forwarded to the IdP. |

### OIDCOptions

(**Appears on:** [Provider](#provider))



| Field | Type | Description |
| ----- | ---- | ----------- |
| `issuerURL` | _string_ | IssuerURL is the OpenID Connect issuer URL<br/>eg: https://accounts.google.com |
| `insecureAllowUnverifiedEmail` | _bool_ | InsecureAllowUnverifiedEmail prevents failures if an email address in an id_token is not verified<br/>default set to 'false' |
| `insecureSkipIssuerVerification` | _bool_ | InsecureSkipIssuerVerification skips verification of ID token issuers. When false, ID Token Issuers must match the OIDC discovery URL<br/>default set to 'false' |
| `insecureSkipNonce` | _bool_ | InsecureSkipNonce skips verifying the ID Token's nonce claim that must match<br/>the random nonce sent in the initial OAuth flow. Otherwise, the nonce is checked<br/>after the initial OAuth redeem & subsequent token refreshes.<br/>default set to 'true'<br/>Warning: In a future release, this will change to 'false' by default for enhanced security. |
| `skipDiscovery` | _bool_ | SkipDiscovery allows to skip OIDC discovery and use manually supplied Endpoints<br/>default set to 'false' |
| `jwksURL` | _string_ | JwksURL is the OpenID Connect JWKS URL<br/>eg: https://www.googleapis.com/oauth2/v3/certs |
| `emailClaim` | _string_ | EmailClaim indicates which claim contains the user email,<br/>default set to 'email' |
| `groupsClaim` | _string_ | GroupsClaim indicates which claim contains the user groups<br/>default set to 'groups' |
| `userIDClaim` | _string_ | UserIDClaim indicates which claim contains the user ID<br/>default set to 'email' |
| `audienceClaims` | _[]string_ | AudienceClaim allows to define any claim that is verified against the client id<br/>By default `aud` claim is used for verification. |
| `extraAudiences` | _[]string_ | ExtraAudiences is a list of additional audiences that are allowed<br/>to pass verification in addition to the client id. |

### Provider

(**Appears on:** [Providers](#providers))

Provider holds all configuration for a single provider

| Field | Type | Description |
| ----- | ---- | ----------- |
| `clientID` | _string_ | ClientID is the OAuth Client ID that is defined in the provider<br/>This value is required for all providers. |
| `clientSecret` | _string_ | ClientSecret is the OAuth Client Secret that is defined in the provider<br/>This value is required for all providers. |
| `clientSecretFile` | _string_ | ClientSecretFile is the name of the file<br/>containing the OAuth Client Secret, it will be used if ClientSecret is not set. |
| `keycloakConfig` | _[KeycloakOptions](#keycloakoptions)_ | KeycloakConfig holds all configurations for Keycloak provider. |
| `azureConfig` | _[AzureOptions](#azureoptions)_ | AzureConfig holds all configurations for Azure provider. |
| `ADFSConfig` | _[ADFSOptions](#adfsoptions)_ | ADFSConfig holds all configurations for ADFS provider. |
| `bitbucketConfig` | _[BitbucketOptions](#bitbucketoptions)_ | BitbucketConfig holds all configurations for Bitbucket provider. |
| `githubConfig` | _[GitHubOptions](#githuboptions)_ | GitHubConfig holds all configurations for GitHubC provider. |
| `gitlabConfig` | _[GitLabOptions](#gitlaboptions)_ | GitLabConfig holds all configurations for GitLab provider. |
| `googleConfig` | _[GoogleOptions](#googleoptions)_ | GoogleConfig holds all configurations for Google provider. |
| `oidcConfig` | _[OIDCOptions](#oidcoptions)_ | OIDCConfig holds all configurations for OIDC provider<br/>or providers utilize OIDC configurations. |
| `loginGovConfig` | _[LoginGovOptions](#logingovoptions)_ | LoginGovConfig holds all configurations for LoginGov provider. |
| `id` | _string_ | ID should be a unique identifier for the provider.<br/>This value is required for all providers. |
| `provider` | _[ProviderType](#providertype)_ | Type is the OAuth provider<br/>must be set from the supported providers group,<br/>otherwise 'Google' is set as default |
| `name` | _string_ | Name is the providers display name<br/>if set, it will be shown to the users in the login page. |
| `caFiles` | _[]string_ | CAFiles is a list of paths to CA certificates that should be used when connecting to the provider.<br/>If not specified, the default Go trust sources are used instead |
| `loginURL` | _string_ | LoginURL is the authentication endpoint |
| `loginURLParameters` | _[[]LoginURLParameter](#loginurlparameter)_ | LoginURLParameters defines the parameters that can be passed from the start URL to the IdP login URL |
| `redeemURL` | _string_ | RedeemURL is the token redemption endpoint |
| `profileURL` | _string_ | ProfileURL is the profile access endpoint |
| `resource` | _string_ | ProtectedResource is the resource that is protected (Azure AD and ADFS only) |
| `validateURL` | _string_ | ValidateURL is the access token validation endpoint |
| `scope` | _string_ | Scope is the OAuth scope specification |
| `allowedGroups` | _[]string_ | AllowedGroups is a list of restrict logins to members of this group |
| `code_challenge_method` | _string_ | The code challenge method |

### ProviderType
#### (`string` alias)

(**Appears on:** [Provider](#provider))

ProviderType is used to enumerate the different provider type options
Valid options are: adfs, azure, bitbucket, digitalocean facebook, github,
gitlab, google, keycloak, keycloak-oidc, linkedin, login.gov, nextcloud
and oidc.


### Providers

#### ([[]Provider](#provider) alias)

(**Appears on:** [AlphaOptions](#alphaoptions))

Providers is a collection of definitions for providers.


### SecretSource

(**Appears on:** [ClaimSource](#claimsource), [HeaderValue](#headervalue), [TLS](#tls))

SecretSource references an individual secret value.
Only one source within the struct should be defined at any time.

| Field | Type | Description |
| ----- | ---- | ----------- |
| `value` | _[]byte_ | Value expects a base64 encoded string value. |
| `fromEnv` | _string_ | FromEnv expects the name of an environment variable. |
| `fromFile` | _string_ | FromFile expects a path to a file containing the secret value. |

### Server

(**Appears on:** [AlphaOptions](#alphaoptions))

Server represents the configuration for an HTTP(S) server

| Field | Type | Description |
| ----- | ---- | ----------- |
| `BindAddress` | _string_ | BindAddress is the address on which to serve traffic.<br/>Leave blank or set to "-" to disable. |
| `SecureBindAddress` | _string_ | SecureBindAddress is the address on which to serve secure traffic.<br/>Leave blank or set to "-" to disable. |
| `TLS` | _[TLS](#tls)_ | TLS contains the information for loading the certificate and key for the<br/>secure traffic and further configuration for the TLS server. |

### TLS

(**Appears on:** [Server](#server))

TLS contains the information for loading a TLS certificate and key
as well as an optional minimal TLS version that is acceptable.

| Field | Type | Description |
| ----- | ---- | ----------- |
| `Key` | _[SecretSource](#secretsource)_ | Key is the TLS key data to use.<br/>Typically this will come from a file. |
| `Cert` | _[SecretSource](#secretsource)_ | Cert is the TLS certificate data to use.<br/>Typically this will come from a file. |
| `MinVersion` | _string_ | MinVersion is the minimal TLS version that is acceptable.<br/>E.g. Set to "TLS1.3" to select TLS version 1.3 |
| `CipherSuites` | _[]string_ | CipherSuites is a list of TLS cipher suites that are allowed.<br/>E.g.:<br/>- TLS_RSA_WITH_RC4_128_SHA<br/>- TLS_RSA_WITH_AES_256_GCM_SHA384<br/>If not specified, the default Go safe cipher list is used.<br/>List of valid cipher suites can be found in the [crypto/tls documentation](https://pkg.go.dev/crypto/tls#pkg-constants). |

### URLParameterRule

(**Appears on:** [LoginURLParameter](#loginurlparameter))

URLParameterRule represents a rule by which query parameters
passed to the `/oauth2/start` endpoint are checked to determine whether
they are valid overrides for the given parameter passed to the IdP's
login URL.  Either Value or Pattern should be supplied, not both.

| Field | Type | Description |
| ----- | ---- | ----------- |
| `value` | _string_ | A Value rule matches just this specific value |
| `pattern` | _string_ | A Pattern rule gives a regular expression that must be matched by<br/>some substring of the value.  The expression is _not_ automatically<br/>anchored to the start and end of the value, if you _want_ to restrict<br/>the whole parameter value you must anchor it yourself with `^` and `$`. |

### Upstream

(**Appears on:** [UpstreamConfig](#upstreamconfig))

Upstream represents the configuration for an upstream server.
Requests will be proxied to this upstream if the path matches the request path.

| Field | Type | Description |
| ----- | ---- | ----------- |
| `id` | _string_ | ID should be a unique identifier for the upstream.<br/>This value is required for all upstreams. |
| `path` | _string_ | Path is used to map requests to the upstream server.<br/>The closest match will take precedence and all Paths must be unique.<br/>Path can also take a pattern when used with RewriteTarget.<br/>Path segments can be captured and matched using regular experessions.<br/>Eg:<br/>- `^/foo$`: Match only the explicit path `/foo`<br/>- `^/bar/$`: Match any path prefixed with `/bar/`<br/>- `^/baz/(.*)$`: Match any path prefixed with `/baz` and capture the remaining path for use with RewriteTarget |
| `rewriteTarget` | _string_ | RewriteTarget allows users to rewrite the request path before it is sent to<br/>the upstream server.<br/>Use the Path to capture segments for reuse within the rewrite target.<br/>Eg: With a Path of `^/baz/(.*)`, a RewriteTarget of `/foo/$1` would rewrite<br/>the request `/baz/abc/123` to `/foo/abc/123` before proxying to the<br/>upstream server. |
| `uri` | _string_ | The URI of the upstream server. This may be an HTTP(S) server of a File<br/>based URL. It may include a path, in which case all requests will be served<br/>under that path.<br/>Eg:<br/>- http://localhost:8080<br/>- https://service.localhost<br/>- https://service.localhost/path<br/>- file://host/path<br/>If the URI's path is "/base" and the incoming request was for "/dir",<br/>the upstream request will be for "/base/dir". |
| `insecureSkipTLSVerify` | _bool_ | InsecureSkipTLSVerify will skip TLS verification of upstream HTTPS hosts.<br/>This option is insecure and will allow potential Man-In-The-Middle attacks<br/>betweem OAuth2 Proxy and the usptream server.<br/>Defaults to false. |
| `static` | _bool_ | Static will make all requests to this upstream have a static response.<br/>The response will have a body of "Authenticated" and a response code<br/>matching StaticCode.<br/>If StaticCode is not set, the response will return a 200 response. |
| `staticCode` | _int_ | StaticCode determines the response code for the Static response.<br/>This option can only be used with Static enabled. |
| `flushInterval` | _[Duration](#duration)_ | FlushInterval is the period between flushing the response buffer when<br/>streaming response from the upstream.<br/>Defaults to 1 second. |
| `passHostHeader` | _bool_ | PassHostHeader determines whether the request host header should be proxied<br/>to the upstream server.<br/>Defaults to true. |
| `proxyWebSockets` | _bool_ | ProxyWebSockets enables proxying of websockets to upstream servers<br/>Defaults to true. |
| `timeout` | _[Duration](#duration)_ | Timeout is the maximum duration the server will wait for a response from the upstream server.<br/>Defaults to 30 seconds. |

### UpstreamConfig

(**Appears on:** [AlphaOptions](#alphaoptions))

UpstreamConfig is a collection of definitions for upstream servers.

| Field | Type | Description |
| ----- | ---- | ----------- |
| `proxyRawPath` | _bool_ | ProxyRawPath will pass the raw url path to upstream allowing for url's<br/>like: "/%2F/" which would otherwise be redirected to "/" |
| `upstreams` | _[[]Upstream](#upstream)_ | Upstreams represents the configuration for the upstream servers.<br/>Requests will be proxied to this upstream if the path matches the request path. |
