---
id: alpha-config
title: Alpha Configuration
---

:::warning
This page contains documentation for alpha features.
We reserve the right to make breaking changes to the features detailed within this page with no notice.

Options described in this page may be changed, removed, renamed or moved without prior warning.
Please beware of this before you use alpha configuration options.
:::

This page details a set of **alpha** configuration options in a new format.
Going forward we are intending to add structured configuration in YAML format to
replace the existing TOML based configuration file and flags.

Below is a reference for the structure of the configuration, with
[AlphaOptions](#alphaoptions) as the root of the configuration.

When using alpha configuration, your config file will look something like below:

```yaml
upstreams:
  - id: ...
    ...
injectRequestHeaders:
  - name: ...
    ...
injectResponseHeaders:
  - name: ...
    ...
```

Please browse the [reference](#configuration-reference) below for the structure
of the new configuration format.

## Using Alpha Configuration

To use the new **alpha** configuration, generate a YAML file based on the format
described in the [reference](#configuration-reference) below.

Provide the path to this file using the `--alpha-config` flag.

:::note
When using the `--alpha-config` flag, some options are no longer available.
See [removed options](#removed-options) below for more information.
:::

### Converting configuration to the new structure

Before adding the new `--alpha-config` option, start OAuth2 Proxy using the
`convert-config-to-alpha` flag to convert existing configuration to the new format.

```bash
oauth2-proxy --convert-config-to-alpha --config ./path/to/existing/config.cfg
```

This will convert any options supported by the new format to YAML and print the
new configuration to `STDOUT`.

Copy this to a new file, remove any options from your existing configuration
noted in [removed options](#removed-options) and then start OAuth2 Proxy using
the new config.

```bash
oauth2-proxy --alpha-config ./path/to/new/config.yaml --config ./path/to/existing/config.cfg
```

## Removed options

The following flags/options and their respective environment variables are no
longer available when using alpha configuration:

<!-- Legacy Upstream FlagSet -->
- `flush-interval`/`flush_interval`
- `pass-host-header`/`pass_host_header`
- `proxy-websockets`/`proxy_websockets`
- `ssl-upstream-insecure-skip-verify`/`ssl_upstream_insecure_skip_verify`
- `upstream`/`upstreams`

<!-- Legacy Headers FlagSet -->
- `pass-basic-auth`/`pass_basic_auth`
- `pass-access-token`/`pass_access_token`
- `pass-user-headers`/`pass_user_headers`
- `pass-authorization-header`/`pass_authorization_header`
- `set-basic-auth`/`set_basic_auth`
- `set-xauthrequest`/`set_xauthrequest`
- `set-authorization-header`/`set_authorization_header`
- `prefer-email-to-user`/`prefer_email_to_user`
- `basic-auth-password`/`basic_auth_password`
- `skip-auth-strip-headers`/`skip_auth_strip_headers`

Attempting to use these options via flags or via config when `--alpha-config`
set will result in an error.

:::important
You must remove these options before starting OAuth2 Proxy with `--alpha-config`
:::

## Configuration Reference
<!--- THIS FILE IS AUTOGENERATED!!! DO NOT EDIT!!! -->

### AlphaOptions

AlphaOptions contains alpha structured configuration options.
Usage of these options allows users to access alpha features that are not
available as part of the primary configuration structure for OAuth2 Proxy.

:::warning
The options within this structure are considered alpha.
They may change between releases without notice.
:::

| Field | Type | Description |
| ----- | ---- | ----------- |
| `upstreams` | _[Upstreams](#upstreams)_ | Upstreams is used to configure upstream servers.<br/>Once a user is authenticated, requests to the server will be proxied to<br/>these upstream servers based on the path mappings defined in this list. |
| `injectRequestHeaders` | _[[]Header](#header)_ | InjectRequestHeaders is used to configure headers that should be added<br/>to requests to upstream servers.<br/>Headers may source values from either the authenticated user's session<br/>or from a static secret value. |
| `injectResponseHeaders` | _[[]Header](#header)_ | InjectResponseHeaders is used to configure headers that should be added<br/>to responses from the proxy.<br/>This is typically used when using the proxy as an external authentication<br/>provider in conjunction with another proxy such as NGINX and its<br/>auth_request module.<br/>Headers may source values from either the authenticated user's session<br/>or from a static secret value. |
| `server` | _[Server](#server)_ | Server is used to configure the HTTP(S) server for the proxy application.<br/>You may choose to run both HTTP and HTTPS servers simultaneously.<br/>This can be done by setting the BindAddress and the SecureBindAddress simultaneously.<br/>To use the secure server you must configure a TLS certificate and key. |
| `metricsServer` | _[Server](#server)_ | MetricsServer is used to configure the HTTP(S) server for metrics.<br/>You may choose to run both HTTP and HTTPS servers simultaneously.<br/>This can be done by setting the BindAddress and the SecureBindAddress simultaneously.<br/>To use the secure server you must configure a TLS certificate and key. |

### ClaimSource

(**Appears on:** [HeaderValue](#headervalue))

ClaimSource allows loading a header value from a claim within the session

| Field | Type | Description |
| ----- | ---- | ----------- |
| `claim` | _string_ | Claim is the name of the claim in the session that the value should be<br/>loaded from. |
| `prefix` | _string_ | Prefix is an optional prefix that will be prepended to the value of the<br/>claim if it is non-empty. |
| `basicAuthPassword` | _[SecretSource](#secretsource)_ | BasicAuthPassword converts this claim into a basic auth header.<br/>Note the value of claim will become the basic auth username and the<br/>basicAuthPassword will be used as the password value. |

### Duration
#### (`string` alias)

(**Appears on:** [Upstream](#upstream))

Duration is as string representation of a period of time.
A duration string is a is a possibly signed sequence of decimal numbers,
each with optional fraction and a unit suffix, such as "300ms", "-1.5h" or "2h45m".
Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".


### Header

(**Appears on:** [AlphaOptions](#alphaoptions))

Header represents an individual header that will be added to a request or
response header.

| Field | Type | Description |
| ----- | ---- | ----------- |
| `name` | _string_ | Name is the header name to be used for this set of values.<br/>Names should be unique within a list of Headers. |
| `preserveRequestValue` | _bool_ | PreserveRequestValue determines whether any values for this header<br/>should be preserved for the request to the upstream server.<br/>This option only takes effet on injected request headers.<br/>Defaults to false (headers that match this header will be stripped). |
| `values` | _[[]HeaderValue](#headervalue)_ | Values contains the desired values for this header |

### HeaderValue

(**Appears on:** [Header](#header))

HeaderValue represents a single header value and the sources that can
make up the header value

| Field | Type | Description |
| ----- | ---- | ----------- |
| `value` | _[]byte_ | Value expects a base64 encoded string value. |
| `fromEnv` | _string_ | FromEnv expects the name of an environment variable. |
| `fromFile` | _string_ | FromFile expects a path to a file containing the secret value. |
| `claim` | _string_ | Claim is the name of the claim in the session that the value should be<br/>loaded from. |
| `prefix` | _string_ | Prefix is an optional prefix that will be prepended to the value of the<br/>claim if it is non-empty. |
| `basicAuthPassword` | _[SecretSource](#secretsource)_ | BasicAuthPassword converts this claim into a basic auth header.<br/>Note the value of claim will become the basic auth username and the<br/>basicAuthPassword will be used as the password value. |

### SecretSource

(**Appears on:** [ClaimSource](#claimsource), [HeaderValue](#headervalue), [TLS](#tls))

SecretSource references an individual secret value.
Only one source within the struct should be defined at any time.

| Field | Type | Description |
| ----- | ---- | ----------- |
| `value` | _[]byte_ | Value expects a base64 encoded string value. |
| `fromEnv` | _string_ | FromEnv expects the name of an environment variable. |
| `fromFile` | _string_ | FromFile expects a path to a file containing the secret value. |

### Server

(**Appears on:** [AlphaOptions](#alphaoptions))

Server represents the configuration for an HTTP(S) server

| Field | Type | Description |
| ----- | ---- | ----------- |
| `BindAddress` | _string_ | BindAddress is the the address on which to serve traffic.<br/>Leave blank or set to "-" to disable. |
| `SecureBindAddress` | _string_ | SecureBindAddress is the the address on which to serve secure traffic.<br/>Leave blank or set to "-" to disable. |
| `TLS` | _[TLS](#tls)_ | TLS contains the information for loading the certificate and key for the<br/>secure traffic. |

### TLS

(**Appears on:** [Server](#server))

TLS contains the information for loading a TLS certifcate and key.

| Field | Type | Description |
| ----- | ---- | ----------- |
| `Key` | _[SecretSource](#secretsource)_ | Key is the the TLS key data to use.<br/>Typically this will come from a file. |
| `Cert` | _[SecretSource](#secretsource)_ | Cert is the TLS certificate data to use.<br/>Typically this will come from a file. |

### Upstream

(**Appears on:** [Upstreams](#upstreams))

Upstream represents the configuration for an upstream server.
Requests will be proxied to this upstream if the path matches the request path.

| Field | Type | Description |
| ----- | ---- | ----------- |
| `id` | _string_ | ID should be a unique identifier for the upstream.<br/>This value is required for all upstreams. |
| `path` | _string_ | Path is used to map requests to the upstream server.<br/>The closest match will take precedence and all Paths must be unique. |
| `uri` | _string_ | The URI of the upstream server. This may be an HTTP(S) server of a File<br/>based URL. It may include a path, in which case all requests will be served<br/>under that path.<br/>Eg:<br/>- http://localhost:8080<br/>- https://service.localhost<br/>- https://service.localhost/path<br/>- file://host/path<br/>If the URI's path is "/base" and the incoming request was for "/dir",<br/>the upstream request will be for "/base/dir". |
| `insecureSkipTLSVerify` | _bool_ | InsecureSkipTLSVerify will skip TLS verification of upstream HTTPS hosts.<br/>This option is insecure and will allow potential Man-In-The-Middle attacks<br/>betweem OAuth2 Proxy and the usptream server.<br/>Defaults to false. |
| `static` | _bool_ | Static will make all requests to this upstream have a static response.<br/>The response will have a body of "Authenticated" and a response code<br/>matching StaticCode.<br/>If StaticCode is not set, the response will return a 200 response. |
| `staticCode` | _int_ | StaticCode determines the response code for the Static response.<br/>This option can only be used with Static enabled. |
| `flushInterval` | _[Duration](#duration)_ | FlushInterval is the period between flushing the response buffer when<br/>streaming response from the upstream.<br/>Defaults to 1 second. |
| `passHostHeader` | _bool_ | PassHostHeader determines whether the request host header should be proxied<br/>to the upstream server.<br/>Defaults to true. |
| `proxyWebSockets` | _bool_ | ProxyWebSockets enables proxying of websockets to upstream servers<br/>Defaults to true. |

### Upstreams

#### ([[]Upstream](#upstream) alias)

(**Appears on:** [AlphaOptions](#alphaoptions))

Upstreams is a collection of definitions for upstream servers.

