# Integrations

## Description

Murex is highly customizable, as every good shell should be. However the Murex
community believe that extendability and support for customizations are no
substitute for good defaults.
    
Murex aims to provide you with the best support for your wider command line
needs, in its "out-of-the-box" configuration.

So with that goal in mind, the following configurations come pre-installed with
Murex's base install.

## Included Integrations

> Please note that this is not an exhaustive list of all integrations
> precompiled into Murex. A full breakdown can be viewed under `/integrations`
> in the project source directory ([view in Github](https://github.com/lmorg/murex/tree/master/integrations)).

* [ChatGPT](../integrations/chatgpt.md):
    How to enable ChatGPT hints
* [Cheat.sh](../integrations/cheatsh.md):
    Cheatsheets provided by cheat.sh
* [Kitty Integrations](../integrations/kitty.md):
    Get more out of Kitty terminal emulator
* [Makefiles / `make`](../integrations/make.md):
    `make` integrations
* [Man Pages (POSIX)](../integrations/man-pages.md):
    Linux/UNIX `man` page integrations
* [Spellcheck](../integrations/spellcheck.md):
    How to enable inline spellchecking
* [Terminology Integrations](../integrations/terminology.md):
    Get more out of Terminology terminal emulator
* [`direnv` Integrations](../integrations/direnv.md):
    Directory specific environmental variables
* [`yarn` Integrations](../integrations/yarn.md):
    Working with `yarn` and `package.json`
* [iTerm2 Integrations](../integrations/iterm2.md):
    Get more out of iTerm2 terminal emulator
