# v5.1

This release brings new operators and a builtin, all for managing null types. There is also a substantial revamp to readline's responsiveness.

## Breaking Changes

None.

## Deprecation Warnings

Please read out [compatibility commitment](https://murex.rocks/compatibility.html) to understand how features are deprecated.

* the `?` pipe will be deprecated to make way for a the ternary operator. You can achieve the same result with `<err> <!out>`, eg `command <err> <!out> parameters... | next-command ...`

## Features

Features marked as **EXPERIMENTAL** are provided without assurances of future breaking changes.

* new operator: `null-coalescing`, returns the left-most non-null value ([read more](https://murex.rocks/parser/null-coalescing.html))

* new operator: `elvis` returns the left-most non-falsy value ([read more](https://murex.rocks/parser/elvis.html))

* new builtin: `is-null` checks if a variable is undefined or null ([read more](https://murex.rocks/commands/is-null.html))

* new autocomplete: `signal`

* error message for `$1` variables, for when insufficient parameters passed, has been improved

* website: minor stylesheet updates, plus some new images added

## Bug Fixes

* readline: buffered screen writes to reduce rendering glitches and improve overall responsiveness ([issue #744](https://github.com/lmorg/murex/issues/744))

* autocomplete: `gping` autocomplete updated to support `--color` flag

## Special Thanks

Special thank yous for this release goes to the following contributors:

* [tsmish](https://github.com/tsmish) for helping to debug some of readline's rendering glitches

You rock!

<hr>

Published: 09.10.2023 at 22:13

## See Also

* [Debugging Mode (`debug`)](../commands/debug.md):
  Debugging information

<hr/>

This document was generated from [gen/changelog/v5.1_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v5.1_doc.yaml).