# v2.3 - Change Log

This release includes significant changes to the interactive terminal

This release brings some major improvements to the discoverability of commands
and their parameters in the interactive terminal.

### User Facing Changes:

* New builtin: `method`. This is used to help turn some commands into a
  "method", similar in concept to object orientated development where the tab-
  completer will return a list of other commands that are compatible with the
  formers output data types. It's purely an autocompletion tool and has no
  effect in shell scripts.

* Autocompletion suggestions will differ based on what pipes are used. The idea
  behind this is to improve the discoverability of commands. All tokens can
  still be used to pipeline to any command type (like before). This rule only
  affects autocomplete suggestions in the interactive prompt.

      - `|` will show all available aliases, functions, builtins and external
        commands, as usual

      - `->` will default to showing only compatible commands defined in `method`
        (see above), however if no methods are found then `->` will fall back to
        suggesting all available aliases, functions, builtins and external commands,
        like `|`.
    
      The idea here is for `->` to surface commands that are commonly
      expected to be pipelined together but without forcing the user to pause and
      remember which token exposes what commands. While `|` is still available for
      familiarity

* Autocompletion de-duplication now places hyphen-prefixed flags at the end of
  the results when sorting. This helps bring more relevant flags forward, with
  hyphen-prefixed flags still visible when users press `-`

* External commands return a error message if the exit status is non-zero
  ([issue #299](https://github.com/lmorg/murex/issues/299))
  
      <pre><code>» exec: false
      Error in `exec` (1,1): exit status 1</code></pre>

* `Index()` (`[`) now returns a different data type from the root object if the
  element is a string, integer, float64, boolean or nil ([issue #316](https://github.com/lmorg/murex/issues/316))

* `runtime` was missing a few flags for reporting supported data types against
  the newer APIs

* Generic types (`*` / `generic`) to include two spaces between columns when
  marshalled

* Syntax highlighter colour tweaks -- no longer using background highlighting
  because that looks weird and unreadable on some terminal colour schemes

* Bug fixes to the fast parser

* Bug fixes to readline merged from `v2.2.1200` ([issue #362](https://github.com/lmorg/murex/issues/362))

### Non-User Facing / Maintenance Changes

* `hcl` and `bson` types now use `ReadArray` templates so their behavior should
  mimic JSON and YAML

* Fast parser is now aware of which pipe token (eg `|`, `->`, `=>`, `?`) is used

* Unit test concurrency fix

* New tests written for the fast parser

* Refactored code around hint text and completions to allow for a potential new
  UI feature to be built in the future

* Updated documentation

<hr>

Published: 26.09.2021 at 11:33

## See Also

* [Arrow Pipe (`->`) Token](../parser/pipe-arrow.md):
  Pipes STDOUT from the left hand command to STDIN of the right hand command
* [POSIX Pipe (`|`) Token](../parser/pipe-posix.md):
  Pipes STDOUT from the left hand command to STDIN of the right hand command
* [`method`](../commands/method.md):
  Define a methods supported data-types
* [`runtime`](../commands/runtime.md):
  Returns runtime information on the internal state of Murex