package docs

func init() {

	Definition["get-type"] = "# `get-type` - Command Reference\n\n> Returns the data-type of a variable or pipe\n\n## Description\n\n`get-type` returns the Murex data-type of a variable or pipe without\nreading the data from it.\n\n## Usage\n\n    get-type: \\$variable -> <stdout>\n    \n    get-type: stdin -> <stdout>\n    \n    get-type: pipe -> <stdout>\n\n## Examples\n\nGet the data-type of a variable\n\n    » set: json example={[1,2,3]}\n    » get-type: \\$example\n    json\n    \n> Please note that you will need to escape the dollar sign. If you don't\n> the value of the variable will be passed to `get-type` rather than the\n> name.\n\nGet the data-type of a functions STDIN\n\n    » function: example { get-type stdin }\n    » tout: json {[1,2,3]} -> example\n    json\n    \nGet the data-type of a Murex named pipe\n\n    » pipe: example\n    » tout: <example> json {[1,2,3]}\n    » get-type: example\n    » !pipe: example\n    json\n\n## See Also\n\n* [Reserved Variables](../user-guide/reserved-vars.md):\n  Special variables reserved by Murex\n* [Variable and Config Scoping](../user-guide/scoping.md):\n  How scoping works within Murex\n* [`debug`](../commands/debug.md):\n  Debugging information\n* [`function`](../commands/function.md):\n  Define a function block\n* [`pipe`](../commands/pipe.md):\n  Manage Murex named pipes\n* [`runtime`](../commands/runtime.md):\n  Returns runtime information on the internal state of Murex\n* [`set`](../commands/set.md):\n  Define a local variable and set it's value\n* [`tout`](../commands/tout.md):\n  Print a string to the STDOUT and set it's data-type"

}
