package docs

func init() {

	Definition["swivel-table"] = "# Murex Shell Docs\n\n## Command Reference: `swivel-table`\n\n> Rotates a table by 90 degrees\n\n## Description\n\n`swivel-table` rotates a table by 90 degrees so the _x_ axis becomes the _y_.\n\n## Usage\n\n    <stdin> -> swivel-table -> <stdout>\n\n## Examples\n\n    » ps: aux -> head: -n5\n    USER       PID %CPU %MEM    VSZ   RSS TTY      STAT START   TIME COMMAND\n    root         1  0.0  0.1 233996  8736 ?        Ss   Feb19   0:02 /sbin/init\n    root         2  0.0  0.0      0     0 ?        S    Feb19   0:00 [kthreadd]\n    root         4  0.0  0.0      0     0 ?        I<   Feb19   0:00 [kworker/0:0H]\n    root         6  0.0  0.0      0     0 ?        I<   Feb19   0:00 [mm_percpu_wq]\n    \nThat data swivelled would look like the following:\n\n    » ps: aux -> head: -n5 -> swivel-table\n    0       USER    root    root    root    root\n    1       PID     1       2       4       6\n    2       %CPU    0.0     0.0     0.0     0.0\n    3       %MEM    0.1     0.0     0.0     0.0\n    4       VSZ     233996  0       0       0\n    5       RSS     8736    0       0       0\n    6       TTY     ?       ?       ?       ?\n    7       STAT    Ss      S       I<      I<\n    8       START   Feb19   Feb19   Feb19   Feb19\n    9       TIME    0:02    0:00    0:00    0:00\n    10      COMMAND /sbin/init      [kthreadd]      [kworker/0:0H]  [mm_percpu_wq]\n    \nPlease note that column one is numbered because by default Murex couldn't\nguess whether the first line of generic output is a title or data. However if we\nformat that as a CSV, which by default does have a title row (configurable via\n`config`), then you would see titles as column one:\n\n    » ps: aux -> head: -n5 -> format: csv\n    \"USER\",\"PID\",\"%CPU\",\"%MEM\",\"VSZ\",\"RSS\",\"TTY\",\"STAT\",\"START\",\"TIME\",\"COMMAND\"\n    \"root\",\"1\",\"0.0\",\"0.1\",\"233996\",\"8736\",\"?\",\"Ss\",\"Feb19\",\"0:02\",\"/sbin/init\"\n    \"root\",\"2\",\"0.0\",\"0.0\",\"0\",\"0\",\"?\",\"S\",\"Feb19\",\"0:00\",\"[kthreadd]\"\n    \"root\",\"4\",\"0.0\",\"0.0\",\"0\",\"0\",\"?\",\"I<\",\"Feb19\",\"0:00\",\"[kworker/0:0H]\"\n    \"root\",\"6\",\"0.0\",\"0.0\",\"0\",\"0\",\"?\",\"I<\",\"Feb19\",\"0:00\",\"[mm_percpu_wq]\"\n    \n    » ps: aux -> head: -n5 -> format: csv -> swivel-table\n    \"USER\",\"root\",\"root\",\"root\",\"root\"\n    \"PID\",\"1\",\"2\",\"4\",\"6\"\n    \"%CPU\",\"0.0\",\"0.0\",\"0.0\",\"0.0\"\n    \"%MEM\",\"0.1\",\"0.0\",\"0.0\",\"0.0\"\n    \"VSZ\",\"233996\",\"0\",\"0\",\"0\"\n    \"RSS\",\"8736\",\"0\",\"0\",\"0\"\n    \"TTY\",\"?\",\"?\",\"?\",\"?\"\n    \"STAT\",\"Ss\",\"S\",\"I<\",\"I<\"\n    \"START\",\"Feb19\",\"Feb19\",\"Feb19\",\"Feb19\"\n    \"TIME\",\"0:02\",\"0:00\",\"0:00\",\"0:00\"\n    \"COMMAND\",\"/sbin/init\",\"[kthreadd]\",\"[kworker/0:0H]\",\"[mm_percpu_wq]\"\n\n## See Also\n\n* [commands/`[[` (element)](../commands/element.md):\n  Outputs an element from a nested structure\n* [commands/`[` (index)](../commands/index.md):\n  Outputs an element from an array, map or table\n* [commands/`alter`](../commands/alter.md):\n  Change a value within a structured data-type and pass that change along the pipeline without altering the original source input\n* [commands/`append`](../commands/append.md):\n  Add data to the end of an array\n* [commands/`cast`](../commands/cast.md):\n  Alters the data type of the previous function without altering it's output\n* [commands/`format`](../commands/format.md):\n  Reformat one data-type into another data-type\n* [commands/`prepend` ](../commands/prepend.md):\n  Add data to the start of an array\n* [commands/`swivel-datatype`](../commands/swivel-datatype.md):\n  Converts tabulated data into a map of values for serialised data-types such as JSON and YAML"

}
